use crate::*;
use crate::syntax::block::Item;
use crate::syntax::block::constructors::*;

pub fn push_let(body: &mut Vec<Item>, name: Item, expr: Item) {
    body.push(item(seq!["let ", name, " = ", expr, ";"]))
}

pub fn push_let_mut(body: &mut Vec<Item>, name: Item, expr: Item) {
    body.push(item(seq!["let mut ", name, " = ", expr, ";"]))
}
