#ifndef NTT_H
#define NTT_H

#include <stdint.h>

#include "NTT_params.h"

extern void PQCLEAN_SABER_AARCH64_asm_ntt_SIMD_top(uint32_t *des, const uint32_t *table, const uint32_t *_constants);
extern void PQCLEAN_SABER_AARCH64_asm_ntt_SIMD_bot(uint32_t *des, const uint32_t *table, const uint32_t *_constants);
extern void PQCLEAN_SABER_AARCH64_asm_intt_SIMD_top(uint32_t *des, const uint32_t *table, const uint32_t *_constants);
extern void PQCLEAN_SABER_AARCH64_asm_intt_SIMD_bot(uint32_t *des, const uint32_t *table, const uint32_t *_constants, const uint32_t *_inv_twist_const);
extern void PQCLEAN_SABER_AARCH64_asm_asymmetric_mul(uint32_t *src1, const uint32_t *src2, const uint32_t *src2_asymmetric, const uint32_t *_constants);
extern void PQCLEAN_SABER_AARCH64_asm_point_mul_extended(uint32_t *des, const uint32_t *src1, const uint32_t *src2_extended, const uint32_t *_constants);

#define NTT(in) { \
        PQCLEAN_SABER_AARCH64_asm_ntt_SIMD_top(in, streamlined_CT_negacyclic_table_Q1_extended, constants); \
        PQCLEAN_SABER_AARCH64_asm_ntt_SIMD_bot(in, streamlined_CT_negacyclic_table_Q1_extended, constants); \
    }

#define NTT_heavy(in_asymmetric, in) { \
        NTT(in); \
        PQCLEAN_SABER_AARCH64_asm_point_mul_extended(in_asymmetric, in, pre_asymmetric_table_Q1_extended, constants); \
    }

#define iNTT(in) { \
        PQCLEAN_SABER_AARCH64_asm_intt_SIMD_top(in, streamlined_inv_CT_table_Q1_extended, constants); \
        PQCLEAN_SABER_AARCH64_asm_intt_SIMD_bot(in, streamlined_inv_CT_table_Q1_extended, constants, inv_twist_table_all_Q1_extended); \
    }

static const uint32_t constants[16] = {
    Q1, Q1prime2
};

static const uint32_t streamlined_CT_negacyclic_table_Q1_extended[(NTT_N + (1 << 0) + (1 << 3)) << 1] = {
    0, 0, -119635792, -1424544, 1027317558, 12232619, -496739340, -5914844, -253524894, -3018807, 9103545, 108399, 42771771, 509298, 283911363, 3380629, 0, 0, -66089826, -786954, -259955382, -3095377, -643539471, -7662843, -332278086, -3956548, 703146656, 8372606, -881793531, -10499815, 304160806, 3621746, 0, 0, 34506365, 410879, 663387313, 7899178, -615166382, -7324995, 242706356, 2889987, -1016509854, -12103928, -410776309, -4891253, -1039822114, -12381515, 0, 0, 770061100, 9169379, 176271869, 2098929, 377015451, 4489251, -777437559, -9257213, 185186875, 2205083, -476967921, -5679419, 111859832, 1331953, 0, 0, 267484771, 3185032, -241571930, -2876479, -116066229, -1382040, 605105697, 7205199, 246868243, 2939544, -801225576, -9540465, -29401110, -350089, 0, 0, 461101573, 5490493, -659878385, -7857396, -813049292, -9681254, -610503208, -7269469, 754028719, 8978476, -513464823, -6114000, 974898460, 11608447, 0, 0, -65601052, -781134, 122588677, 1459705, 406381289, 4838920, -584016855, -6954087, 1066347183, 12697358, -347834458, -4141783, -592155281, -7050994, 0, 0, 242486240, 2887366, 1001287142, 11922666, 375772353, 4474449, 752256115, 8957369, 322396534, 3838885, 525597088, 6258463, -971930207, -11573103, 0, 0, -983711428, -11713386, 6721989, 80041, -138847220, -1653301, 687033653, 8180743, -438460075, -5220893, 714691721, 8510077, -689918177, -8215090, 0, 0
};

static const uint32_t pre_asymmetric_table_Q1_extended[NTT_N << 3] = {
    -332278086, -3956548, -332278086, -3956548, -332278086, -3956548, -332278086, -3956548, 332278086, 3956548, 332278086, 3956548, 332278086, 3956548, 332278086, 3956548, 703146656, 8372606, 703146656, 8372606, 703146656, 8372606, 703146656, 8372606, -703146656, -8372606, -703146656, -8372606, -703146656, -8372606, -703146656, -8372606, -881793531, -10499815, -881793531, -10499815, -881793531, -10499815, -881793531, -10499815, 881793531, 10499815, 881793531, 10499815, 881793531, 10499815, 881793531, 10499815, 304160806, 3621746, 304160806, 3621746, 304160806, 3621746, 304160806, 3621746, -304160806, -3621746, -304160806, -3621746, -304160806, -3621746, -304160806, -3621746, 242706356, 2889987, 242706356, 2889987, 242706356, 2889987, 242706356, 2889987, -242706356, -2889987, -242706356, -2889987, -242706356, -2889987, -242706356, -2889987, -1016509854, -12103928, -1016509854, -12103928, -1016509854, -12103928, -1016509854, -12103928, 1016509854, 12103928, 1016509854, 12103928, 1016509854, 12103928, 1016509854, 12103928, -410776309, -4891253, -410776309, -4891253, -410776309, -4891253, -410776309, -4891253, 410776309, 4891253, 410776309, 4891253, 410776309, 4891253, 410776309, 4891253, -1039822114, -12381515, -1039822114, -12381515, -1039822114, -12381515, -1039822114, -12381515, 1039822114, 12381515, 1039822114, 12381515, 1039822114, 12381515, 1039822114, 12381515, -777437559, -9257213, -777437559, -9257213, -777437559, -9257213, -777437559, -9257213, 777437559, 9257213, 777437559, 9257213, 777437559, 9257213, 777437559, 9257213, 185186875, 2205083, 185186875, 2205083, 185186875, 2205083, 185186875, 2205083, -185186875, -2205083, -185186875, -2205083, -185186875, -2205083, -185186875, -2205083, -476967921, -5679419, -476967921, -5679419, -476967921, -5679419, -476967921, -5679419, 476967921, 5679419, 476967921, 5679419, 476967921, 5679419, 476967921, 5679419, 111859832, 1331953, 111859832, 1331953, 111859832, 1331953, 111859832, 1331953, -111859832, -1331953, -111859832, -1331953, -111859832, -1331953, -111859832, -1331953, 605105697, 7205199, 605105697, 7205199, 605105697, 7205199, 605105697, 7205199, -605105697, -7205199, -605105697, -7205199, -605105697, -7205199, -605105697, -7205199, 246868243, 2939544, 246868243, 2939544, 246868243, 2939544, 246868243, 2939544, -246868243, -2939544, -246868243, -2939544, -246868243, -2939544, -246868243, -2939544, -801225576, -9540465, -801225576, -9540465, -801225576, -9540465, -801225576, -9540465, 801225576, 9540465, 801225576, 9540465, 801225576, 9540465, 801225576, 9540465, -29401110, -350089, -29401110, -350089, -29401110, -350089, -29401110, -350089, 29401110, 350089, 29401110, 350089, 29401110, 350089, 29401110, 350089, -610503208, -7269469, -610503208, -7269469, -610503208, -7269469, -610503208, -7269469, 610503208, 7269469, 610503208, 7269469, 610503208, 7269469, 610503208, 7269469, 754028719, 8978476, 754028719, 8978476, 754028719, 8978476, 754028719, 8978476, -754028719, -8978476, -754028719, -8978476, -754028719, -8978476, -754028719, -8978476, -513464823, -6114000, -513464823, -6114000, -513464823, -6114000, -513464823, -6114000, 513464823, 6114000, 513464823, 6114000, 513464823, 6114000, 513464823, 6114000, 974898460, 11608447, 974898460, 11608447, 974898460, 11608447, 974898460, 11608447, -974898460, -11608447, -974898460, -11608447, -974898460, -11608447, -974898460, -11608447, -584016855, -6954087, -584016855, -6954087, -584016855, -6954087, -584016855, -6954087, 584016855, 6954087, 584016855, 6954087, 584016855, 6954087, 584016855, 6954087, 1066347183, 12697358, 1066347183, 12697358, 1066347183, 12697358, 1066347183, 12697358, -1066347183, -12697358, -1066347183, -12697358, -1066347183, -12697358, -1066347183, -12697358, -347834458, -4141783, -347834458, -4141783, -347834458, -4141783, -347834458, -4141783, 347834458, 4141783, 347834458, 4141783, 347834458, 4141783, 347834458, 4141783, -592155281, -7050994, -592155281, -7050994, -592155281, -7050994, -592155281, -7050994, 592155281, 7050994, 592155281, 7050994, 592155281, 7050994, 592155281, 7050994, 752256115, 8957369, 752256115, 8957369, 752256115, 8957369, 752256115, 8957369, -752256115, -8957369, -752256115, -8957369, -752256115, -8957369, -752256115, -8957369, 322396534, 3838885, 322396534, 3838885, 322396534, 3838885, 322396534, 3838885, -322396534, -3838885, -322396534, -3838885, -322396534, -3838885, -322396534, -3838885, 525597088, 6258463, 525597088, 6258463, 525597088, 6258463, 525597088, 6258463, -525597088, -6258463, -525597088, -6258463, -525597088, -6258463, -525597088, -6258463, -971930207, -11573103, -971930207, -11573103, -971930207, -11573103, -971930207, -11573103, 971930207, 11573103, 971930207, 11573103, 971930207, 11573103, 971930207, 11573103, 687033653, 8180743, 687033653, 8180743, 687033653, 8180743, 687033653, 8180743, -687033653, -8180743, -687033653, -8180743, -687033653, -8180743, -687033653, -8180743, -438460075, -5220893, -438460075, -5220893, -438460075, -5220893, -438460075, -5220893, 438460075, 5220893, 438460075, 5220893, 438460075, 5220893, 438460075, 5220893, 714691721, 8510077, 714691721, 8510077, 714691721, 8510077, 714691721, 8510077, -714691721, -8510077, -714691721, -8510077, -714691721, -8510077, -714691721, -8510077, -689918177, -8215090, -689918177, -8215090, -689918177, -8215090, -689918177, -8215090, 689918177, 8215090, 689918177, 8215090, 689918177, 8215090, 689918177, 8215090
    };

static const uint32_t streamlined_inv_CT_table_Q1_extended[(NTT_N + (1 << 0) + (1 << 3)) << 1] = {
    0, 0, 84, 1, 84, 1, 119635792, 1424544, 84, 1, 496739340, 5914844, 119635792, 1424544, -1027317558, -12232619, 0, 0, 84, 1, 84, 1, 119635792, 1424544, 84, 1, 496739340, 5914844, 119635792, 1424544, -1027317558, -12232619, 0, 0, -283911363, -3380629, 983711428, 11713386, -242486240, -2887366, 138847220, 1653301, -375772353, -4474449, -6721989, -80041, -1001287142, -11922666, 0, 0, 496739340, 5914844, -283911363, -3380629, -42771771, -509298, 983711428, 11713386, 65601052, 781134, -242486240, -2887366, -461101573, -5490493, 0, 0, -9103545, -108399, -267484771, -3185032, -770061100, -9169379, 116066229, 1382040, -377015451, -4489251, 241571930, 2876479, -176271869, -2098929, 0, 0, 119635792, 1424544, 496739340, 5914844, -1027317558, -12232619, -283911363, -3380629, -9103545, -108399, -42771771, -509298, 253524894, 3018807, 0, 0, -42771771, -509298, 65601052, 781134, -461101573, -5490493, -406381289, -4838920, 813049292, 9681254, -122588677, -1459705, 659878385, 7857396, 0, 0, -1027317558, -12232619, -9103545, -108399, 253524894, 3018807, -267484771, -3185032, -34506365, -410879, -770061100, -9169379, 66089826, 786954, 0, 0, 253524894, 3018807, -34506365, -410879, 66089826, 786954, 615166382, 7324995, 643539471, 7662843, -663387313, -7899178, 259955382, 3095377, 0, 0
};

static const uint32_t inv_twist_table_all_Q1_extended[ARRAY_N << 1] = {
    -806526676, -9603587, -806526676, -9603587, -806526676, -9603587, -806526676, -9603587, 48233192, 574329, 48233192, 574329, 48233192, 574329, 48233192, 574329, -781310380, -9303328, -781310380, -9303328, -781310380, -9303328, -781310380, -9303328, -672564090, -8008449, -672564090, -8008449, -672564090, -8008449, -672564090, -8008449, 246168339, 2931210, 246168339, 2931210, 246168339, 2931210, 246168339, 2931210, -1029960130, -12264085, -1029960130, -12264085, -1029960130, -12264085, -1029960130, -12264085, -740184653, -8813630, -740184653, -8813630, -740184653, -8813630, -740184653, -8813630, 161300767, 1920663, 161300767, 1920663, 161300767, 1920663, 161300767, 1920663, -174979977, -2083546, -174979977, -2083546, -174979977, -2083546, -174979977, -2083546, -95582308, -1138131, -95582308, -1138131, -95582308, -1138131, -95582308, -1138131, -605914106, -7214825, -605914106, -7214825, -605914106, -7214825, -605914106, -7214825, 553452597, 6590148, 553452597, 6590148, 553452597, 6590148, 553452597, 6590148, -224497251, -2673165, -224497251, -2673165, -224497251, -2673165, -224497251, -2673165, 276485019, 3292201, 276485019, 3292201, 276485019, 3292201, 276485019, 3292201, 953978590, 11359347, 953978590, 11359347, 953978590, 11359347, 953978590, 11359347, -411604874, -4901119, -411604874, -4901119, -411604874, -4901119, -411604874, -4901119, 833204424, 9921248, 833204424, 9921248, 833204424, 9921248, 833204424, 9921248, 753488464, 8972043, 753488464, 8972043, 753488464, 8972043, 753488464, 8972043, -38469886, -458074, -38469886, -458074, -38469886, -458074, -38469886, -458074, 852175664, 10147145, 852175664, 10147145, 852175664, 10147145, 852175664, 10147145, -278415257, -3315185, -278415257, -3315185, -278415257, -3315185, -278415257, -3315185, -1014095461, -12075179, -1014095461, -12075179, -1014095461, -12075179, -1014095461, -12075179, 307793104, 3664997, 307793104, 3664997, 307793104, 3664997, 307793104, 3664997, -130967039, -1559469, -130967039, -1559469, -130967039, -1559469, -130967039, -1559469, 478387802, 5696326, 478387802, 5696326, 478387802, 5696326, 478387802, 5696326, 692860396, 8250124, 692860396, 8250124, 692860396, 8250124, 692860396, 8250124, 803792144, 9571026, 803792144, 9571026, 803792144, 9571026, 803792144, 9571026, 352456397, 4196818, 352456397, 4196818, 352456397, 4196818, 352456397, 4196818, 230047357, 2739252, 230047357, 2739252, 230047357, 2739252, 230047357, 2739252, -1026754544, -12225915, -1026754544, -12225915, -1026754544, -12225915, -1026754544, -12225915, 992128925, 11813616, 992128925, 11813616, 992128925, 11813616, 992128925, 11813616, -29941449, -356523, -29941449, -356523, -29941449, -356523, -29941449, -356523, -1068560020, -12723707, -1068560020, -12723707, -1068560020, -12723707, -1068560020, -12723707, -581973493, -6929756, -581973493, -6929756, -581973493, -6929756, -581973493, -6929756, -304246804, -3622770, -304246804, -3622770, -304246804, -3622770, -304246804, -3622770, 542646572, 6461477, 542646572, 6461477, 542646572, 6461477, 542646572, 6461477, -7172803, -85409, -7172803, -85409, -7172803, -85409, -7172803, -85409, -417737898, -4974147, -417737898, -4974147, -417737898, -4974147, -417737898, -4974147, -397539264, -4733635, -397539264, -4733635, -397539264, -4733635, -397539264, -4733635, -711017600, -8466328, -711017600, -8466328, -711017600, -8466328, -711017600, -8466328, 340918639, 4059434, 340918639, 4059434, 340918639, 4059434, 340918639, 4059434, -2971193, -35379, -2971193, -35379, -2971193, -35379, -2971193, -35379, -316030964, -3763088, -316030964, -3763088, -316030964, -3763088, -316030964, -3763088, -980706054, -11677600, -980706054, -11677600, -980706054, -11677600, -980706054, -11677600, -799784280, -9523303, -799784280, -9523303, -799784280, -9523303, -799784280, -9523303, -606599985, -7222992, -606599985, -7222992, -606599985, -7222992, -606599985, -7222992, 988795687, 11773926, 988795687, 11773926, 988795687, 11773926, 988795687, 11773926, -318379767, -3791056, -318379767, -3791056, -318379767, -3791056, -318379767, -3791056, 675788404, 8046842, 675788404, 8046842, 675788404, 8046842, 675788404, 8046842, 719075991, 8562282, 719075991, 8562282, 719075991, 8562282, 719075991, 8562282, -410606666, -4889233, -410606666, -4889233, -410606666, -4889233, -410606666, -4889233, -39398809, -469135, -39398809, -469135, -39398809, -469135, -39398809, -469135, -323375678, -3850544, -323375678, -3850544, -323375678, -3850544, -323375678, -3850544, -616711312, -7343391, -616711312, -7343391, -616711312, -7343391, -616711312, -7343391, 197741568, 2354576, 197741568, 2354576, 197741568, 2354576, 197741568, 2354576, 775336082, 9232190, 775336082, 9232190, 775336082, 9232190, 775336082, 9232190, -135399935, -1612253, -135399935, -1612253, -135399935, -1612253, -135399935, -1612253, 865050664, 10300452, 865050664, 10300452, 865050664, 10300452, 865050664, 10300452, -1004611982, -11962256, -1004611982, -11962256, -1004611982, -11962256, -1004611982, -11962256, -621203079, -7396876, -621203079, -7396876, -621203079, -7396876, -621203079, -7396876, 135583351, 1614437, 135583351, 1614437, 135583351, 1614437, 135583351, 1614437, 530210041, 6313391, 530210041, 6313391, 530210041, 6313391, 530210041, 6313391, -695736773, -8284374, -695736773, -8284374, -695736773, -8284374, -695736773, -8284374, 408717831, 4866742, 408717831, 4866742, 408717831, 4866742, 408717831, 4866742
    };

#endif
