#ifndef PQCLEAN_SNTRUP1013_CLEAN_API_H
#define PQCLEAN_SNTRUP1013_CLEAN_API_H

#include <stdint.h>


#define PQCLEAN_SNTRUP1013_CLEAN_CRYPTO_ALGNAME "sntrup1013"

#define PQCLEAN_SNTRUP1013_CLEAN_CRYPTO_SECRETKEYBYTES 2417
#define PQCLEAN_SNTRUP1013_CLEAN_CRYPTO_PUBLICKEYBYTES 1623
#define PQCLEAN_SNTRUP1013_CLEAN_CRYPTO_CIPHERTEXTBYTES 1455
#define PQCLEAN_SNTRUP1013_CLEAN_CRYPTO_BYTES 32

int PQCLEAN_SNTRUP1013_CLEAN_crypto_kem_keypair(uint8_t *pk, uint8_t *sk);
int PQCLEAN_SNTRUP1013_CLEAN_crypto_kem_enc(uint8_t *c, uint8_t *k, const uint8_t *pk);
int PQCLEAN_SNTRUP1013_CLEAN_crypto_kem_dec(uint8_t *k, const uint8_t *c, const uint8_t *sk);
#endif
