use clap::{Command, Arg};

const VERSION: &'static str = "0.3.0";

pub fn build_cli() -> Command<'static> {
    Command::new("pouf")
    .bin_name("pouf")
    .version(VERSION)
    .author("Ferry Jérémie ferryjeremie@free.fr")
    .about("give fake datas")
    .subcommand(
        Command::new("lorem.word")
        .about("give a fake word")
    )
    .subcommand(
        Command::new("barecode.isbn")
        .about("give an isbn code")
    )
    .subcommand(Command::new("internet.mail")
        .about("give a fake mail")
        .arg(Arg::new("lang")
            .short('l')
            .help("give lang (ie: fr_FR)")
            .takes_value(true)
        )
        .arg(Arg::new("number")
            .short('n')
            .help("number of values")
            .takes_value(true)
        )
    )
    .subcommand(Command::new("internet.ip")
        .about("give a fake IP (Internet Protocol)")
        .arg(Arg::new("ipv4")
            .short('4')
            .long("ipv4")
            .help("give exclusivly IPv4")
        )
        .arg(Arg::new("ipv6")
            .short('6')
            .long("ipv6")
            .help("give exclusivly IPv6")
        )
    )
    .subcommand(Command::new("internet.mac")
        .about("give a fake mac adress")
    )
    .subcommand(Command::new("internet.useragent")
        .about("give a fake user agent")
    )
    .subcommand(Command::new("http.code")
        .about("give a fake HTTP code")
    )
    .subcommand(Command::new("time.time")
        .about("give a fake time")
    )
    .subcommand(Command::new("time.date")
        .about("give a fake date")
    )
    .subcommand(Command::new("filesystem.mimetype")
        .about("give a fake mime-type")
    )
    .subcommand(Command::new("filesystem.semver")
        .about("give a fake semver version")
        .arg(Arg::new("stable")
            .short('s')
            .long("stable")
            .help("give exclusivly stable semver version (X.Y.Z)")
        )
        .arg(Arg::new("unstable")
            .short('u')
            .long("unstable")
            .help("give exclusivly unstable semver version (X-Y-Z-V.W)")
        )
    )
    .subcommand(Command::new("administrative.healthinsurrancecode")
        .about("give a Health insurrance code")
    )
    .subcommand(Command::new("finance.bic")
        .about("give a fake BIC (Business Identifier Code)")
    )
}
