pub mod cartesian;
mod frame;
mod joint;

pub use cartesian::CartesianPose;
pub use frame::Frame;
pub use joint::JointPose;
use serde::{Deserialize, Serialize};

/// 位姿
#[derive(Debug, Clone, Deserialize, Serialize)]
pub enum Pose {
    Cart(CartesianPose, Frame),
    Joint(JointPose),
}

impl Pose {
    pub fn new_cart(pose: CartesianPose, frame: Frame) -> Self {
        Self::Cart(pose, frame)
    }

    pub fn new_joint(pose: JointPose) -> Self {
        Self::Joint(pose)
    }
}
