mod euler;
mod quaternion;

pub use euler::Euler;
use nalgebra::Rotation3;
pub use quaternion::Quaternion;
use serde::{Deserialize, Serialize};

pub type RotationMatrix = Rotation3<f64>;

#[derive(Debug, Clone, Serialize, Deserialize)]
pub enum Rotation {
    Euler(Euler),
    Quaternion(Quaternion),
    Matrix(RotationMatrix),
}
impl Rotation {
    pub fn into_matrix(self) -> RotationMatrix {
        RotationMatrix::from(self)
    }
    pub fn from_matrix(matrix: RotationMatrix) -> Self {
        Self::from(matrix)
    }
}

impl From<Rotation> for RotationMatrix {
    fn from(item: Rotation) -> Self {
        match item {
            Rotation::Euler(rot) => rot.into_matrix(),
            Rotation::Quaternion(rot) => rot.into_matrix(),
            Rotation::Matrix(rot) => rot,
        }
    }
}

impl From<RotationMatrix> for Rotation {
    fn from(item: RotationMatrix) -> Self {
        Self::Matrix(item)
    }
}
