use super::RotationMatrix;
use nalgebra::geometry::Rotation3;
use serde::{Deserialize, Serialize};

#[derive(Debug, Clone, Serialize, Deserialize)]
pub struct Euler {
    pub roll: f64,
    pub pitch: f64,
    pub yaw: f64,
}

impl Euler {
    pub fn new(roll: f64, pitch: f64, yaw: f64) -> Self {
        Self { roll, pitch, yaw }
    }
    pub fn into_matrix(self) -> RotationMatrix {
        RotationMatrix::from(self)
    }
    pub fn from_matrix(matrix: RotationMatrix) -> Self {
        Self::from(matrix)
    }
}

impl From<Euler> for RotationMatrix {
    fn from(item: Euler) -> Self {
        Rotation3::from_euler_angles(item.roll, item.pitch, item.yaw)
    }
}

impl From<RotationMatrix> for Euler {
    fn from(item: RotationMatrix) -> Self {
        let (roll, pitch, yaw) = item.euler_angles();
        Self { roll, pitch, yaw }
    }
}
