
# This file was @generated by crate2nix 0.9.0 with the command:
#   "generate"
# See https://github.com/kolloch/crate2nix for more info.

{ nixpkgs ? <nixpkgs>
, pkgs ? import nixpkgs { config = {}; }
, lib ? pkgs.lib
, stdenv ? pkgs.stdenv
, buildRustCrateForPkgs ? if buildRustCrate != null
    then lib.warn "`buildRustCrate` is deprecated, use `buildRustCrateForPkgs` instead" (_: buildRustCrate)
    else pkgs: pkgs.buildRustCrate
  # Deprecated
, buildRustCrate ? null
  # This is used as the `crateOverrides` argument for `buildRustCrate`.
, defaultCrateOverrides ? pkgs.defaultCrateOverrides
  # The features to enable for the root_crate or the workspace_members.
, rootFeatures ? [ "default" ]
  # If true, throw errors instead of issueing deprecation warnings.
, strictDeprecation ? false
  # Used for conditional compilation based on CPU feature detection.
, targetFeatures ? []
  # Whether to perform release builds: longer compile times, faster binaries.
, release ? true
  # Additional crate2nix configuration if it exists.
, crateConfig
  ? if builtins.pathExists ./crate-config.nix
    then pkgs.callPackage ./crate-config.nix {}
    else {}
}:

rec {
  #
  # "public" attributes that we attempt to keep stable with new versions of crate2nix.
  #

  rootCrate = rec {
    packageId = "postrep";

    # Use this attribute to refer to the derivation building your root crate package.
    # You can override the features with rootCrate.build.override { features = [ "default" "feature1" ... ]; }.
    build = internal.buildRustCrateWithFeatures {
      inherit packageId;
    };

    # Debug support which might change between releases.
    # File a bug if you depend on any for non-debug work!
    debug = internal.debugCrate { inherit packageId; };
  };
  # Refer your crate build derivation by name here.
  # You can override the features with
  # workspaceMembers."${crateName}".build.override { features = [ "default" "feature1" ... ]; }.
  workspaceMembers = {
    "postrep" = rec {
      packageId = "postrep";
      build = internal.buildRustCrateWithFeatures {
        packageId = "postrep";
      };

      # Debug support which might change between releases.
      # File a bug if you depend on any for non-debug work!
      debug = internal.debugCrate { inherit packageId; };
    };
  };

  # A derivation that joins the outputs of all workspace members together.
  allWorkspaceMembers = pkgs.symlinkJoin {
      name = "all-workspace-members";
      paths =
        let members = builtins.attrValues workspaceMembers;
        in builtins.map (m: m.build) members;
  };

  #
  # "internal" ("private") attributes that may change in every new version of crate2nix.
  #

  internal = rec {
    # Build and dependency information for crates.
    # Many of the fields are passed one-to-one to buildRustCrate.
    #
    # Noteworthy:
    # * `dependencies`/`buildDependencies`: similar to the corresponding fields for buildRustCrate.
    #   but with additional information which is used during dependency/feature resolution.
    # * `resolvedDependencies`: the selected default features reported by cargo - only included for debugging.
    # * `devDependencies` as of now not used by `buildRustCrate` but used to
    #   inject test dependencies into the build

    crates = {
      "aho-corasick" = rec {
        crateName = "aho-corasick";
        version = "0.7.18";
        edition = "2018";
        sha256 = "0vv50b3nvkhyy7x7ip19qnsq11bqlnffkmj2yx2xlyk5wzawydqy";
        libName = "aho_corasick";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        dependencies = [
          {
            name = "memchr";
            packageId = "memchr";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "std" ];
          "std" = [ "memchr/std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "ansi_term" = rec {
        crateName = "ansi_term";
        version = "0.11.0";
        edition = "2015";
        sha256 = "16wpvrghvd0353584i1idnsgm0r3vchg8fyrm0x8ayv1rgvbljgf";
        authors = [
          "ogham@bsago.me"
          "Ryan Scheel (Havvy) <ryan.havvy@gmail.com>"
          "Josh Triplett <josh@joshtriplett.org>"
        ];
        dependencies = [
          {
            name = "winapi";
            packageId = "winapi";
            target = { target, features }: (target."os" == "windows");
            features = [ "errhandlingapi" "consoleapi" "processenv" ];
          }
        ];

      };
      "anyhow" = rec {
        crateName = "anyhow";
        version = "1.0.40";
        edition = "2018";
        sha256 = "0fq6qxlzp3bwrjbs3wp4i470k8vsvlkpx3q2wpl79gawvf9cvci8";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "async-stream" = rec {
        crateName = "async-stream";
        version = "0.3.1";
        edition = "2018";
        sha256 = "0pkygfxkv6kswrsxwkgbivs73mck7y2rl6gzvw735pad2x9wn9ha";
        authors = [
          "Carl Lerche <me@carllerche.com>"
        ];
        dependencies = [
          {
            name = "async-stream-impl";
            packageId = "async-stream-impl";
          }
          {
            name = "futures-core";
            packageId = "futures-core";
          }
        ];

      };
      "async-stream-impl" = rec {
        crateName = "async-stream-impl";
        version = "0.3.1";
        edition = "2018";
        sha256 = "0h0kvac5fbhnkjvx858ms0p8fsvdg3wg13ls6brn1h3m4jjln4yv";
        procMacro = true;
        authors = [
          "Carl Lerche <me@carllerche.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
          }
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "syn";
            packageId = "syn";
            features = [ "extra-traits" "full" "visit-mut" ];
          }
        ];

      };
      "async-trait" = rec {
        crateName = "async-trait";
        version = "0.1.50";
        edition = "2018";
        sha256 = "08m7xim7dvcjw5cx2ryz3wndxc0vib2s02qrvabxvg2cpd5yi60b";
        procMacro = true;
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
          }
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "syn";
            packageId = "syn";
            features = [ "full" "visit-mut" ];
          }
        ];

      };
      "atty" = rec {
        crateName = "atty";
        version = "0.2.14";
        edition = "2015";
        sha256 = "1s7yslcs6a28c5vz7jwj63lkfgyx8mx99fdirlhi9lbhhzhrpcyr";
        authors = [
          "softprops <d.tangren@gmail.com>"
        ];
        dependencies = [
          {
            name = "hermit-abi";
            packageId = "hermit-abi";
            target = { target, features }: (target."os" == "hermit");
          }
          {
            name = "libc";
            packageId = "libc";
            usesDefaultFeatures = false;
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "winapi";
            packageId = "winapi";
            target = { target, features }: (target."windows" or false);
            features = [ "consoleapi" "processenv" "minwinbase" "minwindef" "winbase" ];
          }
        ];

      };
      "autocfg" = rec {
        crateName = "autocfg";
        version = "1.0.1";
        edition = "2015";
        sha256 = "0jj6i9zn4gjl03kjvziqdji6rwx8ykz8zk2ngpc331z2g3fk3c6d";
        authors = [
          "Josh Stone <cuviper@gmail.com>"
        ];

      };
      "base64" = rec {
        crateName = "base64";
        version = "0.13.0";
        edition = "2018";
        sha256 = "1z82g23mbzjgijkpcrilc7nljpxpvpf7zxf6iyiapkgka2ngwkch";
        authors = [
          "Alice Maz <alice@alicemaz.com>"
          "Marshall Pierce <marshall@mpierce.org>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "bitflags" = rec {
        crateName = "bitflags";
        version = "1.2.1";
        edition = "2015";
        sha256 = "14qnd5nq8p2almk79m4m8ydqhd413yaxsyjp5xd19g3mikzf47fg";
        authors = [
          "The Rust Project Developers"
        ];
        features = {
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "block-buffer" = rec {
        crateName = "block-buffer";
        version = "0.9.0";
        edition = "2018";
        sha256 = "1r4pf90s7d7lj1wdjhlnqa26vvbm6pnc33z138lxpnp9srpi2lj1";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "generic-array";
            packageId = "generic-array";
          }
        ];

      };
      "byteorder" = rec {
        crateName = "byteorder";
        version = "1.4.3";
        edition = "2018";
        sha256 = "0456lv9xi1a5bcm32arknf33ikv76p3fr9yzki4lb2897p2qkh8l";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "bytes" = rec {
        crateName = "bytes";
        version = "1.0.1";
        edition = "2018";
        sha256 = "0h6h1c8g3yj2b4k8g25gr3246mq985y0kl3z685cs784fr1ww05p";
        authors = [
          "Carl Lerche <me@carllerche.com>"
          "Sean McArthur <sean@seanmonstar.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "cfg-if" = rec {
        crateName = "cfg-if";
        version = "1.0.0";
        edition = "2018";
        sha256 = "1za0vb97n4brpzpv8lsbnzmq5r8f2b0cpqqr0sy8h5bn751xxwds";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        features = {
          "rustc-dep-of-std" = [ "core" "compiler_builtins" ];
        };
      };
      "clap" = rec {
        crateName = "clap";
        version = "2.33.3";
        edition = "2015";
        sha256 = "00i065a58987k1sbzqmlz721rw521zcg08jmsh40gi3khp3qmr9p";
        authors = [
          "Kevin K. <kbknapp@gmail.com>"
        ];
        dependencies = [
          {
            name = "ansi_term";
            packageId = "ansi_term";
            optional = true;
            target = { target, features }: (!(target."windows" or false));
          }
          {
            name = "atty";
            packageId = "atty";
            optional = true;
          }
          {
            name = "bitflags";
            packageId = "bitflags";
          }
          {
            name = "strsim";
            packageId = "strsim";
            optional = true;
          }
          {
            name = "textwrap";
            packageId = "textwrap";
          }
          {
            name = "unicode-width";
            packageId = "unicode-width";
          }
          {
            name = "vec_map";
            packageId = "vec_map";
            optional = true;
          }
        ];
        features = {
          "color" = [ "ansi_term" "atty" ];
          "default" = [ "suggestions" "color" "vec_map" ];
          "doc" = [ "yaml" ];
          "lints" = [ "clippy" ];
          "suggestions" = [ "strsim" ];
          "wrap_help" = [ "term_size" "textwrap/term_size" ];
          "yaml" = [ "yaml-rust" ];
        };
        resolvedDefaultFeatures = [ "ansi_term" "atty" "color" "default" "strsim" "suggestions" "vec_map" ];
      };
      "cpufeatures" = rec {
        crateName = "cpufeatures";
        version = "0.1.0";
        edition = "2018";
        sha256 = "0ajr6qfbs97i0441cyppb2zizqz62l80nqcnjqdfrrqhh9sagmaw";
        authors = [
          "RustCrypto Developers"
        ];

      };
      "crypto-mac" = rec {
        crateName = "crypto-mac";
        version = "0.10.0";
        edition = "2018";
        sha256 = "19iyh7h9qaqrv29dhbd31rm6pq023ry78nw7jwr3qjy3l22zsms8";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "generic-array";
            packageId = "generic-array";
          }
          {
            name = "subtle";
            packageId = "subtle";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "dev" = [ "blobby" ];
        };
      };
      "digest" = rec {
        crateName = "digest";
        version = "0.9.0";
        edition = "2018";
        sha256 = "0rmhvk33rgvd6ll71z8sng91a52rw14p0drjn1da0mqa138n1pfk";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "generic-array";
            packageId = "generic-array";
          }
        ];
        features = {
          "dev" = [ "blobby" ];
          "std" = [ "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" "std" ];
      };
      "either" = rec {
        crateName = "either";
        version = "1.6.1";
        edition = "2015";
        sha256 = "0mwl9vngqf5jvrhmhn9x60kr5hivxyjxbmby2pybncxfqhf4z3g7";
        authors = [
          "bluss"
        ];
        features = {
          "default" = [ "use_std" ];
        };
        resolvedDefaultFeatures = [ "default" "use_std" ];
      };
      "env_logger" = rec {
        crateName = "env_logger";
        version = "0.8.3";
        edition = "2018";
        sha256 = "0gwx1pvbv99fj9wpicknyv4p2vj997xpva8ac5dg03m35q0jlf8p";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "atty";
            packageId = "atty";
            optional = true;
          }
          {
            name = "humantime";
            packageId = "humantime";
            optional = true;
          }
          {
            name = "log";
            packageId = "log";
            features = [ "std" ];
          }
          {
            name = "regex";
            packageId = "regex";
            optional = true;
            usesDefaultFeatures = false;
            features = [ "std" "perf" ];
          }
          {
            name = "termcolor";
            packageId = "termcolor";
            optional = true;
          }
        ];
        features = {
          "default" = [ "termcolor" "atty" "humantime" "regex" ];
        };
        resolvedDefaultFeatures = [ "atty" "default" "humantime" "regex" "termcolor" ];
      };
      "etcd-client" = rec {
        crateName = "etcd-client";
        version = "0.6.3";
        edition = "2018";
        sha256 = "0plz7qc7c2zh7s07jc9bxhy3qg4klvng13ffps0f48768d32k01x";
        authors = [
          "The etcd-client Authors <davidli2010@foxmail.com>"
        ];
        dependencies = [
          {
            name = "http";
            packageId = "http";
          }
          {
            name = "prost";
            packageId = "prost";
          }
          {
            name = "tokio";
            packageId = "tokio";
          }
          {
            name = "tokio-stream";
            packageId = "tokio-stream";
          }
          {
            name = "tonic";
            packageId = "tonic";
          }
        ];
        buildDependencies = [
          {
            name = "tonic-build";
            packageId = "tonic-build";
            usesDefaultFeatures = false;
            features = [ "prost" ];
          }
        ];
        devDependencies = [
          {
            name = "tokio";
            packageId = "tokio";
            features = [ "full" ];
          }
        ];
        features = {
          "tls" = [ "tonic/tls" ];
          "tls-roots" = [ "tls" "tonic/tls-roots" ];
        };
      };
      "fallible-iterator" = rec {
        crateName = "fallible-iterator";
        version = "0.2.0";
        edition = "2018";
        sha256 = "1xq759lsr8gqss7hva42azn3whgrbrs2sd9xpn92c5ickxm1fhs4";
        authors = [
          "Steven Fackler <sfackler@gmail.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "fixedbitset" = rec {
        crateName = "fixedbitset";
        version = "0.2.0";
        edition = "2015";
        sha256 = "0kg03p777wc0dajd9pvlcnsyrwa8dhqwf0sd9r4dw0p82rs39arp";
        authors = [
          "bluss"
        ];
        features = {
          "default" = [ "std" ];
        };
      };
      "fnv" = rec {
        crateName = "fnv";
        version = "1.0.7";
        edition = "2015";
        sha256 = "1hc2mcqha06aibcaza94vbi81j6pr9a1bbxrxjfhc91zin8yr7iz";
        libPath = "lib.rs";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "futures" = rec {
        crateName = "futures";
        version = "0.3.14";
        edition = "2018";
        sha256 = "0lyjglxqdm91wdy646x9qrys9wfpk9g93ydzl4yasng48lsq3md9";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "futures-channel";
            packageId = "futures-channel";
            usesDefaultFeatures = false;
            features = [ "sink" ];
          }
          {
            name = "futures-core";
            packageId = "futures-core";
            usesDefaultFeatures = false;
          }
          {
            name = "futures-executor";
            packageId = "futures-executor";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "futures-io";
            packageId = "futures-io";
            usesDefaultFeatures = false;
          }
          {
            name = "futures-sink";
            packageId = "futures-sink";
            usesDefaultFeatures = false;
          }
          {
            name = "futures-task";
            packageId = "futures-task";
            usesDefaultFeatures = false;
          }
          {
            name = "futures-util";
            packageId = "futures-util";
            usesDefaultFeatures = false;
            features = [ "sink" ];
          }
        ];
        features = {
          "alloc" = [ "futures-core/alloc" "futures-task/alloc" "futures-sink/alloc" "futures-channel/alloc" "futures-util/alloc" ];
          "async-await" = [ "futures-util/async-await" "futures-util/async-await-macro" ];
          "bilock" = [ "futures-util/bilock" ];
          "cfg-target-has-atomic" = [ "futures-core/cfg-target-has-atomic" "futures-task/cfg-target-has-atomic" "futures-channel/cfg-target-has-atomic" "futures-util/cfg-target-has-atomic" ];
          "compat" = [ "std" "futures-util/compat" ];
          "default" = [ "std" "async-await" "executor" ];
          "executor" = [ "std" "futures-executor/std" ];
          "io-compat" = [ "compat" "futures-util/io-compat" ];
          "read-initializer" = [ "futures-io/read-initializer" "futures-util/read-initializer" ];
          "std" = [ "alloc" "futures-core/std" "futures-task/std" "futures-io/std" "futures-sink/std" "futures-util/std" "futures-util/io" "futures-util/channel" ];
          "thread-pool" = [ "executor" "futures-executor/thread-pool" ];
          "unstable" = [ "futures-core/unstable" "futures-task/unstable" "futures-channel/unstable" "futures-io/unstable" "futures-util/unstable" ];
          "write-all-vectored" = [ "futures-util/write-all-vectored" ];
        };
        resolvedDefaultFeatures = [ "alloc" "async-await" "default" "executor" "futures-executor" "std" ];
      };
      "futures-channel" = rec {
        crateName = "futures-channel";
        version = "0.3.14";
        edition = "2018";
        sha256 = "09gc57djz490yljh3ihvgxfwx3v81v7y0q9h06k3g4995ajwcyff";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "futures-core";
            packageId = "futures-core";
            usesDefaultFeatures = false;
          }
          {
            name = "futures-sink";
            packageId = "futures-sink";
            optional = true;
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "alloc" = [ "futures-core/alloc" ];
          "cfg-target-has-atomic" = [ "futures-core/cfg-target-has-atomic" ];
          "default" = [ "std" ];
          "sink" = [ "futures-sink" ];
          "std" = [ "alloc" "futures-core/std" ];
          "unstable" = [ "futures-core/unstable" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "futures-sink" "sink" "std" ];
      };
      "futures-core" = rec {
        crateName = "futures-core";
        version = "0.3.14";
        edition = "2018";
        sha256 = "058qmyvpvhzkw9aykm6ls20k3dsy4jaafdqs1xjh3jm6vp3d3309";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        features = {
          "default" = [ "std" ];
          "std" = [ "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "std" ];
      };
      "futures-executor" = rec {
        crateName = "futures-executor";
        version = "0.3.14";
        edition = "2018";
        sha256 = "17acz5vpbgg850wfn1z5gscl4d5rlh50ilmi9400z87d89qcpxhh";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "futures-core";
            packageId = "futures-core";
            usesDefaultFeatures = false;
          }
          {
            name = "futures-task";
            packageId = "futures-task";
            usesDefaultFeatures = false;
          }
          {
            name = "futures-util";
            packageId = "futures-util";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "std" ];
          "std" = [ "futures-core/std" "futures-task/std" "futures-util/std" ];
          "thread-pool" = [ "std" "num_cpus" ];
        };
        resolvedDefaultFeatures = [ "std" ];
      };
      "futures-io" = rec {
        crateName = "futures-io";
        version = "0.3.14";
        edition = "2018";
        sha256 = "016b6pfcsaavwcpx22psh6n36s13ymc23nqghcxc188fncgilnin";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "std" ];
      };
      "futures-macro" = rec {
        crateName = "futures-macro";
        version = "0.3.14";
        edition = "2018";
        sha256 = "12xvq5rsgi6jyynbxkrvbf1j620jy8xvmrqx9zmpvkc2l4rng336";
        procMacro = true;
        authors = [
          "Taylor Cramer <cramertj@google.com>"
          "Taiki Endo <te316e89@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro-hack";
            packageId = "proc-macro-hack";
          }
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
          }
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "syn";
            packageId = "syn";
            features = [ "full" ];
          }
        ];

      };
      "futures-sink" = rec {
        crateName = "futures-sink";
        version = "0.3.14";
        edition = "2018";
        sha256 = "08vc88majhvizpxpr44h0c240k2ag7is99v153cf6pam7i1jjmjw";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        features = {
          "default" = [ "std" ];
          "std" = [ "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "std" ];
      };
      "futures-task" = rec {
        crateName = "futures-task";
        version = "0.3.14";
        edition = "2018";
        sha256 = "1g41ymlqvfjm7l1x4w2xamgwcpnh9gvh5xx1v6k3nvq7jl8aayms";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        features = {
          "default" = [ "std" ];
          "std" = [ "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" "std" ];
      };
      "futures-util" = rec {
        crateName = "futures-util";
        version = "0.3.14";
        edition = "2018";
        sha256 = "09f0x4nisa9m9rgdcnh09yv7h4i7whbdidm6y0kkkwk09pall51w";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "futures-channel";
            packageId = "futures-channel";
            optional = true;
            usesDefaultFeatures = false;
            features = [ "std" ];
          }
          {
            name = "futures-core";
            packageId = "futures-core";
            usesDefaultFeatures = false;
          }
          {
            name = "futures-io";
            packageId = "futures-io";
            optional = true;
            usesDefaultFeatures = false;
            features = [ "std" ];
          }
          {
            name = "futures-macro";
            packageId = "futures-macro";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "futures-sink";
            packageId = "futures-sink";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "futures-task";
            packageId = "futures-task";
            usesDefaultFeatures = false;
          }
          {
            name = "memchr";
            packageId = "memchr";
            optional = true;
          }
          {
            name = "pin-project-lite";
            packageId = "pin-project-lite";
          }
          {
            name = "pin-utils";
            packageId = "pin-utils";
          }
          {
            name = "proc-macro-hack";
            packageId = "proc-macro-hack";
            optional = true;
          }
          {
            name = "proc-macro-nested";
            packageId = "proc-macro-nested";
            optional = true;
          }
          {
            name = "slab";
            packageId = "slab";
            optional = true;
          }
        ];
        features = {
          "alloc" = [ "futures-core/alloc" "futures-task/alloc" ];
          "async-await-macro" = [ "async-await" "futures-macro" "proc-macro-hack" "proc-macro-nested" ];
          "cfg-target-has-atomic" = [ "futures-core/cfg-target-has-atomic" "futures-task/cfg-target-has-atomic" ];
          "channel" = [ "std" "futures-channel" ];
          "compat" = [ "std" "futures_01" ];
          "default" = [ "std" "async-await" "async-await-macro" ];
          "io" = [ "std" "futures-io" "memchr" ];
          "io-compat" = [ "io" "compat" "tokio-io" ];
          "read-initializer" = [ "io" "futures-io/read-initializer" "futures-io/unstable" ];
          "sink" = [ "futures-sink" ];
          "std" = [ "alloc" "futures-core/std" "futures-task/std" "slab" ];
          "unstable" = [ "futures-core/unstable" "futures-task/unstable" ];
          "write-all-vectored" = [ "io" ];
        };
        resolvedDefaultFeatures = [ "alloc" "async-await" "async-await-macro" "channel" "futures-channel" "futures-io" "futures-macro" "futures-sink" "io" "memchr" "proc-macro-hack" "proc-macro-nested" "sink" "slab" "std" ];
      };
      "generic-array" = rec {
        crateName = "generic-array";
        version = "0.14.4";
        edition = "2015";
        sha256 = "05qqwm9v5asbil9z28wjkmpfvs1c5c99n8n9gwxis3d3r3n6c52h";
        libName = "generic_array";
        authors = [
          "Bartłomiej Kamiński <fizyk20@gmail.com>"
          "Aaron Trent <novacrazy@gmail.com>"
        ];
        dependencies = [
          {
            name = "typenum";
            packageId = "typenum";
          }
        ];
        buildDependencies = [
          {
            name = "version_check";
            packageId = "version_check";
          }
        ];
        features = {
        };
      };
      "getrandom" = rec {
        crateName = "getrandom";
        version = "0.2.2";
        edition = "2018";
        sha256 = "1j1jcwahnkn45kapq9i5nvw2s5hcfmp1zpjx0fzl0wcy4w2mfjf9";
        authors = [
          "The Rand Project Developers"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if";
          }
          {
            name = "libc";
            packageId = "libc";
            usesDefaultFeatures = false;
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "wasi";
            packageId = "wasi";
            target = { target, features }: (target."os" == "wasi");
          }
        ];
        features = {
          "js" = [ "wasm-bindgen" "js-sys" ];
          "rustc-dep-of-std" = [ "compiler_builtins" "core" "libc/rustc-dep-of-std" "wasi/rustc-dep-of-std" ];
        };
        resolvedDefaultFeatures = [ "std" ];
      };
      "h2" = rec {
        crateName = "h2";
        version = "0.3.3";
        edition = "2018";
        sha256 = "09kpwgqpwlk282l9jmwvjwm3dssvvjaz60w93xa3zdphxv246lw2";
        authors = [
          "Carl Lerche <me@carllerche.com>"
          "Sean McArthur <sean@seanmonstar.com>"
        ];
        dependencies = [
          {
            name = "bytes";
            packageId = "bytes";
          }
          {
            name = "fnv";
            packageId = "fnv";
          }
          {
            name = "futures-core";
            packageId = "futures-core";
            usesDefaultFeatures = false;
          }
          {
            name = "futures-sink";
            packageId = "futures-sink";
            usesDefaultFeatures = false;
          }
          {
            name = "futures-util";
            packageId = "futures-util";
            usesDefaultFeatures = false;
          }
          {
            name = "http";
            packageId = "http";
          }
          {
            name = "indexmap";
            packageId = "indexmap";
            features = [ "std" ];
          }
          {
            name = "slab";
            packageId = "slab";
          }
          {
            name = "tokio";
            packageId = "tokio";
            features = [ "io-util" ];
          }
          {
            name = "tokio-util";
            packageId = "tokio-util";
            features = [ "codec" ];
          }
          {
            name = "tracing";
            packageId = "tracing";
            usesDefaultFeatures = false;
            features = [ "std" ];
          }
        ];
        devDependencies = [
          {
            name = "tokio";
            packageId = "tokio";
            features = [ "rt-multi-thread" "macros" "sync" "net" ];
          }
        ];
        features = {
        };
      };
      "hashbrown" = rec {
        crateName = "hashbrown";
        version = "0.9.1";
        edition = "2018";
        sha256 = "016dsm9s4xmxlkw2jfikm54qlz6vyk0qr280gab7kzp342jf9byp";
        authors = [
          "Amanieu d'Antras <amanieu@gmail.com>"
        ];
        features = {
          "ahash-compile-time-rng" = [ "ahash/compile-time-rng" ];
          "default" = [ "ahash" "inline-more" ];
          "rustc-dep-of-std" = [ "nightly" "core" "compiler_builtins" "alloc" "rustc-internal-api" ];
        };
        resolvedDefaultFeatures = [ "raw" ];
      };
      "heck" = rec {
        crateName = "heck";
        version = "0.3.2";
        edition = "2018";
        sha256 = "1b56s2c1ymdd0qmy31bw0ndhm31hcdamnhg3npp7ssrmc1ag9jw7";
        authors = [
          "Without Boats <woboats@gmail.com>"
        ];
        dependencies = [
          {
            name = "unicode-segmentation";
            packageId = "unicode-segmentation";
          }
        ];

      };
      "hermit-abi" = rec {
        crateName = "hermit-abi";
        version = "0.1.18";
        edition = "2018";
        sha256 = "0p6czgbk1izviwxzm6ypy3vz2wqj1yd3ab03wp82xqjng7klsbrj";
        authors = [
          "Stefan Lankes"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "rustc-dep-of-std" = [ "core" "compiler_builtins/rustc-dep-of-std" "libc/rustc-dep-of-std" ];
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "hmac" = rec {
        crateName = "hmac";
        version = "0.10.1";
        edition = "2018";
        sha256 = "058yxq54x7xn0gk2vy9bl51r32c9z7qlcl2b80bjh3lk3rmiqi61";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "crypto-mac";
            packageId = "crypto-mac";
          }
          {
            name = "digest";
            packageId = "digest";
          }
        ];
        devDependencies = [
          {
            name = "crypto-mac";
            packageId = "crypto-mac";
            features = [ "dev" ];
          }
        ];
        features = {
          "std" = [ "crypto-mac/std" ];
        };
      };
      "http" = rec {
        crateName = "http";
        version = "0.2.4";
        edition = "2018";
        sha256 = "04fcnqbnqmrsnphz5lbca2plascsm8bib5csd518bqj7qyd8qzjj";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
          "Carl Lerche <me@carllerche.com>"
          "Sean McArthur <sean@seanmonstar.com>"
        ];
        dependencies = [
          {
            name = "bytes";
            packageId = "bytes";
          }
          {
            name = "fnv";
            packageId = "fnv";
          }
          {
            name = "itoa";
            packageId = "itoa";
          }
        ];

      };
      "http-body" = rec {
        crateName = "http-body";
        version = "0.4.1";
        edition = "2018";
        sha256 = "0dwpakklfqy17y0pgwkdjrzcqja99c5sxbk940mggqml4g0pgysx";
        authors = [
          "Carl Lerche <me@carllerche.com>"
          "Lucio Franco <luciofranco14@gmail.com>"
          "Sean McArthur <sean@seanmonstar.com>"
        ];
        dependencies = [
          {
            name = "bytes";
            packageId = "bytes";
          }
          {
            name = "http";
            packageId = "http";
          }
          {
            name = "pin-project-lite";
            packageId = "pin-project-lite";
          }
        ];

      };
      "httparse" = rec {
        crateName = "httparse";
        version = "1.4.0";
        edition = "2015";
        sha256 = "0ds4grlxbbqnji8c30gr3yhrnhnc7mf31izxqa3lhxn9dw6y872a";
        authors = [
          "Sean McArthur <sean@seanmonstar.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "httpdate" = rec {
        crateName = "httpdate";
        version = "1.0.0";
        edition = "2018";
        sha256 = "1ffllpaayc3vfrxyj4h0ychjr4i60q7wn3h6nz626ar38c6jv105";
        authors = [
          "Pyfisch <pyfisch@posteo.org>"
        ];

      };
      "humantime" = rec {
        crateName = "humantime";
        version = "2.1.0";
        edition = "2018";
        sha256 = "1r55pfkkf5v0ji1x6izrjwdq9v6sc7bv99xj6srywcar37xmnfls";
        authors = [
          "Paul Colomiets <paul@colomiets.name>"
        ];

      };
      "hyper" = rec {
        crateName = "hyper";
        version = "0.14.7";
        edition = "2018";
        sha256 = "0m6g1w40p3ggvg3h9mawi4iidv17kqkhn84ypyivm0a095f10pqy";type = [ "lib" "staticlib" "cdylib" ];
        authors = [
          "Sean McArthur <sean@seanmonstar.com>"
        ];
        dependencies = [
          {
            name = "bytes";
            packageId = "bytes";
          }
          {
            name = "futures-channel";
            packageId = "futures-channel";
          }
          {
            name = "futures-core";
            packageId = "futures-core";
            usesDefaultFeatures = false;
          }
          {
            name = "futures-util";
            packageId = "futures-util";
            usesDefaultFeatures = false;
          }
          {
            name = "h2";
            packageId = "h2";
            optional = true;
          }
          {
            name = "http";
            packageId = "http";
          }
          {
            name = "http-body";
            packageId = "http-body";
          }
          {
            name = "httparse";
            packageId = "httparse";
          }
          {
            name = "httpdate";
            packageId = "httpdate";
          }
          {
            name = "itoa";
            packageId = "itoa";
          }
          {
            name = "pin-project";
            packageId = "pin-project";
          }
          {
            name = "socket2";
            packageId = "socket2";
            optional = true;
          }
          {
            name = "tokio";
            packageId = "tokio";
            features = [ "sync" ];
          }
          {
            name = "tower-service";
            packageId = "tower-service";
          }
          {
            name = "tracing";
            packageId = "tracing";
            usesDefaultFeatures = false;
            features = [ "std" ];
          }
          {
            name = "want";
            packageId = "want";
          }
        ];
        devDependencies = [
          {
            name = "futures-util";
            packageId = "futures-util";
            usesDefaultFeatures = false;
            features = [ "alloc" ];
          }
          {
            name = "tokio";
            packageId = "tokio";
            features = [ "fs" "macros" "io-std" "io-util" "rt" "rt-multi-thread" "sync" "time" "test-util" ];
          }
        ];
        features = {
          "ffi" = [ "libc" ];
          "full" = [ "client" "http1" "http2" "server" "stream" "runtime" ];
          "http2" = [ "h2" ];
          "runtime" = [ "tcp" "tokio/rt" ];
          "tcp" = [ "socket2" "tokio/net" "tokio/rt" "tokio/time" ];
        };
        resolvedDefaultFeatures = [ "client" "default" "full" "h2" "http1" "http2" "runtime" "server" "socket2" "stream" "tcp" ];
      };
      "indexmap" = rec {
        crateName = "indexmap";
        version = "1.6.2";
        edition = "2018";
        sha256 = "1wxfh55zlrlpdxfcvvvj6wwc46f23cnb0j9q71190yl9pyh4aj42";
        authors = [
          "bluss"
          "Josh Stone <cuviper@gmail.com>"
        ];
        dependencies = [
          {
            name = "hashbrown";
            packageId = "hashbrown";
            usesDefaultFeatures = false;
            features = [ "raw" ];
          }
        ];
        buildDependencies = [
          {
            name = "autocfg";
            packageId = "autocfg";
          }
        ];
        features = {
          "serde-1" = [ "serde" ];
        };
        resolvedDefaultFeatures = [ "std" ];
      };
      "instant" = rec {
        crateName = "instant";
        version = "0.1.9";
        edition = "2018";
        sha256 = "1v659qqm55misvjijfbl1p7azjp4yynjbwldan8836ynpgp4w4k1";
        authors = [
          "sebcrozet <developer@crozet.re>"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if";
          }
        ];
        features = {
          "now" = [ "time" ];
          "wasm-bindgen" = [ "js-sys" "wasm-bindgen_rs" "web-sys" ];
        };
      };
      "itertools" = rec {
        crateName = "itertools";
        version = "0.9.0";
        edition = "2018";
        sha256 = "0jyml7ygr7kijkcjdl3fk5f34y5h5jsavclim7l13zjiavw1hkr8";
        authors = [
          "bluss"
        ];
        dependencies = [
          {
            name = "either";
            packageId = "either";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "use_std" ];
        };
        resolvedDefaultFeatures = [ "default" "use_std" ];
      };
      "itoa" = rec {
        crateName = "itoa";
        version = "0.4.7";
        edition = "2015";
        sha256 = "0di7fggbknwfjcw8cgzm1dnm3ik32l2m1f7nmyh8ipmh45h069fx";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "lazy_static" = rec {
        crateName = "lazy_static";
        version = "1.4.0";
        edition = "2015";
        sha256 = "0in6ikhw8mgl33wjv6q6xfrb5b9jr16q8ygjy803fay4zcisvaz2";
        authors = [
          "Marvin Löbel <loebel.marvin@gmail.com>"
        ];
        features = {
          "spin_no_std" = [ "spin" ];
        };
      };
      "libc" = rec {
        crateName = "libc";
        version = "0.2.94";
        edition = "2015";
        sha256 = "0phs3ivwq2hmwgwd9nwy3b5jbqcipbgr6pdmj3vj34xjsn54ly8q";
        authors = [
          "The Rust Project Developers"
        ];
        features = {
          "default" = [ "std" ];
          "rustc-dep-of-std" = [ "align" "rustc-std-workspace-core" ];
          "use_std" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "lock_api" = rec {
        crateName = "lock_api";
        version = "0.4.4";
        edition = "2018";
        sha256 = "1sq7pw7h7jbfvnv5nq3vm912gdwhhv8idi3njifd3xnz0q38i0h3";
        authors = [
          "Amanieu d'Antras <amanieu@gmail.com>"
        ];
        dependencies = [
          {
            name = "scopeguard";
            packageId = "scopeguard";
            usesDefaultFeatures = false;
          }
        ];
        features = {
        };
      };
      "log" = rec {
        crateName = "log";
        version = "0.4.14";
        edition = "2015";
        sha256 = "04175hv0v62shd82qydq58a48k3bjijmk54v38zgqlbxqkkbpfai";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if";
          }
        ];
        features = {
          "kv_unstable" = [ "value-bag" ];
          "kv_unstable_serde" = [ "kv_unstable_std" "value-bag/serde" "serde" ];
          "kv_unstable_std" = [ "std" "kv_unstable" "value-bag/error" ];
          "kv_unstable_sval" = [ "kv_unstable" "value-bag/sval" "sval" ];
        };
        resolvedDefaultFeatures = [ "std" ];
      };
      "matches" = rec {
        crateName = "matches";
        version = "0.1.8";
        edition = "2015";
        sha256 = "020axl4q7rk9vz90phs7f8jas4imxal9y9kxl4z4v7a6719mrz3z";
        libPath = "lib.rs";
        authors = [
          "Simon Sapin <simon.sapin@exyr.org>"
        ];

      };
      "md-5" = rec {
        crateName = "md-5";
        version = "0.9.1";
        edition = "2018";
        sha256 = "059ajjacz1q3cms7vl6cvhdqs4qdw2nnwj9dq99ryzv0p6djfnkv";
        libName = "md5";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "block-buffer";
            packageId = "block-buffer";
          }
          {
            name = "digest";
            packageId = "digest";
          }
          {
            name = "opaque-debug";
            packageId = "opaque-debug";
          }
        ];
        devDependencies = [
          {
            name = "digest";
            packageId = "digest";
            features = [ "dev" ];
          }
        ];
        features = {
          "asm" = [ "md5-asm" ];
          "default" = [ "std" ];
          "std" = [ "digest/std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "memchr" = rec {
        crateName = "memchr";
        version = "2.4.0";
        edition = "2018";
        sha256 = "1p478fqf4nia2ma0kv4npb8x1hli0zz6k16517ikb51jkryx8sxi";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
          "bluss"
        ];
        features = {
          "default" = [ "std" ];
          "use_std" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "mio" = rec {
        crateName = "mio";
        version = "0.7.11";
        edition = "2018";
        sha256 = "0mi9ah60l270761sz6qdhhn0hkn5msc8689b53bhnkmk0glx706g";
        authors = [
          "Carl Lerche <me@carllerche.com>"
          "Thomas de Zeeuw <thomasdezeeuw@gmail.com>"
          "Tokio Contributors <team@tokio.rs>"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "miow";
            packageId = "miow";
            target = { target, features }: (target."windows" or false);
          }
          {
            name = "ntapi";
            packageId = "ntapi";
            target = { target, features }: (target."windows" or false);
          }
          {
            name = "winapi";
            packageId = "winapi";
            target = { target, features }: (target."windows" or false);
            features = [ "winsock2" "mswsock" "mstcpip" ];
          }
        ];
        features = {
          "os-ext" = [ "os-poll" ];
          "os-util" = [ "os-ext" ];
          "pipe" = [ "os-ext" ];
          "tcp" = [ "net" ];
          "udp" = [ "net" ];
          "uds" = [ "net" ];
        };
        resolvedDefaultFeatures = [ "default" "net" "os-ext" "os-poll" "os-util" "tcp" "udp" "uds" ];
      };
      "miow" = rec {
        crateName = "miow";
        version = "0.3.7";
        edition = "2018";
        sha256 = "08afp2xfpxmdw003111lxz6g9jgbj4zi2fpldvv7da6d4nqcbwdr";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
        ];
        dependencies = [
          {
            name = "winapi";
            packageId = "winapi";
            features = [ "std" "fileapi" "handleapi" "ioapiset" "minwindef" "namedpipeapi" "ntdef" "synchapi" "winerror" "winsock2" "ws2def" "ws2ipdef" ];
          }
        ];

      };
      "multimap" = rec {
        crateName = "multimap";
        version = "0.8.3";
        edition = "2015";
        sha256 = "0sicyz4n500vdhgcxn4g8jz97cp1ijir1rnbgph3pmx9ckz4dkp5";
        authors = [
          "Håvar Nøvik <havar.novik@gmail.com>"
        ];
        features = {
          "default" = [ "serde_impl" ];
          "serde_impl" = [ "serde" ];
        };
      };
      "ntapi" = rec {
        crateName = "ntapi";
        version = "0.3.6";
        edition = "2018";
        sha256 = "0i5daj9sr8wyi5jkpwpybln2jqpn59z0mqfc0dpdidipwh1bjsrz";
        authors = [
          "MSxDOS <melcodos@gmail.com>"
        ];
        dependencies = [
          {
            name = "winapi";
            packageId = "winapi";
            features = [ "cfg" "evntrace" "in6addr" "inaddr" "minwinbase" "ntsecapi" "windef" "winioctl" ];
          }
        ];
        features = {
          "default" = [ "user" ];
          "impl-default" = [ "winapi/impl-default" ];
        };
        resolvedDefaultFeatures = [ "default" "user" ];
      };
      "num_cpus" = rec {
        crateName = "num_cpus";
        version = "1.13.0";
        edition = "2015";
        sha256 = "1cv6yxhz2zbnwn8pn1yn8grg7zsnd523947fby41a737aqvryj85";
        authors = [
          "Sean McArthur <sean@seanmonstar.com>"
        ];
        dependencies = [
          {
            name = "hermit-abi";
            packageId = "hermit-abi";
            target = { target, features }: (((target."arch" == "x86_64") || (target."arch" == "aarch64")) && (target."os" == "hermit"));
          }
          {
            name = "libc";
            packageId = "libc";
          }
        ];

      };
      "once_cell" = rec {
        crateName = "once_cell";
        version = "1.7.2";
        edition = "2018";
        sha256 = "18qmpyfigg4ibdhjy5mwcjhzk9adwlgfaqv7nj430ivm86q0i2xg";
        authors = [
          "Aleksey Kladov <aleksey.kladov@gmail.com>"
        ];
        features = {
          "alloc" = [ "race" ];
          "default" = [ "std" ];
          "std" = [ "alloc" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "race" "std" ];
      };
      "opaque-debug" = rec {
        crateName = "opaque-debug";
        version = "0.3.0";
        edition = "2018";
        sha256 = "1m8kzi4nd6shdqimn0mgb24f0hxslhnqd1whakyq06wcqd086jk2";
        authors = [
          "RustCrypto Developers"
        ];

      };
      "parking_lot" = rec {
        crateName = "parking_lot";
        version = "0.11.1";
        edition = "2018";
        sha256 = "1sqmgaia8zfd5fbnqw2w13ijh7crk3lf9vw4cb52vwlx0an48xvd";
        authors = [
          "Amanieu d'Antras <amanieu@gmail.com>"
        ];
        dependencies = [
          {
            name = "instant";
            packageId = "instant";
          }
          {
            name = "lock_api";
            packageId = "lock_api";
          }
          {
            name = "parking_lot_core";
            packageId = "parking_lot_core";
          }
        ];
        features = {
          "deadlock_detection" = [ "parking_lot_core/deadlock_detection" ];
          "nightly" = [ "parking_lot_core/nightly" "lock_api/nightly" ];
          "owning_ref" = [ "lock_api/owning_ref" ];
          "serde" = [ "lock_api/serde" ];
          "stdweb" = [ "instant/stdweb" ];
          "wasm-bindgen" = [ "instant/wasm-bindgen" ];
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "parking_lot_core" = rec {
        crateName = "parking_lot_core";
        version = "0.8.3";
        edition = "2018";
        sha256 = "065hkylji0g0fkh1vqp7kzs74vclhsxcczwhwqzpcig770lphyps";
        authors = [
          "Amanieu d'Antras <amanieu@gmail.com>"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if";
          }
          {
            name = "instant";
            packageId = "instant";
          }
          {
            name = "libc";
            packageId = "libc";
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "redox_syscall";
            packageId = "redox_syscall";
            target = { target, features }: (target."os" == "redox");
          }
          {
            name = "smallvec";
            packageId = "smallvec";
          }
          {
            name = "winapi";
            packageId = "winapi";
            target = { target, features }: (target."windows" or false);
            features = [ "winnt" "ntstatus" "minwindef" "winerror" "winbase" "errhandlingapi" "handleapi" ];
          }
        ];
        features = {
          "deadlock_detection" = [ "petgraph" "thread-id" "backtrace" ];
        };
      };
      "percent-encoding" = rec {
        crateName = "percent-encoding";
        version = "2.1.0";
        edition = "2015";
        sha256 = "0bp3zrsk3kr47fbpipyczidbbx4g54lzxdm77ni1i3qws10mdzfl";
        libPath = "lib.rs";
        authors = [
          "The rust-url developers"
        ];

      };
      "petgraph" = rec {
        crateName = "petgraph";
        version = "0.5.1";
        edition = "2018";
        sha256 = "1dzxda6z17sfxly11m8ja3iargh73pw0s1sdgjyp0qp5dm51cza6";
        authors = [
          "bluss"
          "mitchmindtree"
        ];
        dependencies = [
          {
            name = "fixedbitset";
            packageId = "fixedbitset";
            usesDefaultFeatures = false;
          }
          {
            name = "indexmap";
            packageId = "indexmap";
          }
        ];
        features = {
          "all" = [ "unstable" "quickcheck" "matrix_graph" "stable_graph" "graphmap" ];
          "default" = [ "graphmap" "stable_graph" "matrix_graph" ];
          "serde-1" = [ "serde" "serde_derive" ];
          "unstable" = [ "generate" ];
        };
      };
      "phf" = rec {
        crateName = "phf";
        version = "0.8.0";
        edition = "2018";
        sha256 = "04pyv8bzqvw69rd5dynd5nb85py1hf7wa4ixyhrvdz1l5qin3yrx";
        authors = [
          "Steven Fackler <sfackler@gmail.com>"
        ];
        dependencies = [
          {
            name = "phf_shared";
            packageId = "phf_shared";
          }
        ];
        features = {
          "default" = [ "std" ];
          "macros" = [ "phf_macros" "proc-macro-hack" ];
          "std" = [ "phf_shared/std" ];
          "unicase" = [ "phf_shared/unicase" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "phf_shared" = rec {
        crateName = "phf_shared";
        version = "0.8.0";
        edition = "2018";
        sha256 = "1xssnqrrcn0nr9ayqrnm8xm37ac4xvwcx8pax7jxss7yxawzh360";
        authors = [
          "Steven Fackler <sfackler@gmail.com>"
        ];
        dependencies = [
          {
            name = "siphasher";
            packageId = "siphasher";
          }
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "pin-project" = rec {
        crateName = "pin-project";
        version = "1.0.7";
        edition = "2018";
        sha256 = "1964rh32hiy5v2ircli8wv8fxq9h2nkgfalda6j407040v0rql67";
        authors = [
          "Taiki Endo <te316e89@gmail.com>"
        ];
        dependencies = [
          {
            name = "pin-project-internal";
            packageId = "pin-project-internal";
            usesDefaultFeatures = false;
          }
        ];

      };
      "pin-project-internal" = rec {
        crateName = "pin-project-internal";
        version = "1.0.7";
        edition = "2018";
        sha256 = "0vs289my2262ziwxj60mnzr2k41ibga73z8yddah1dc34l9m1ja8";
        procMacro = true;
        authors = [
          "Taiki Endo <te316e89@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
          }
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "syn";
            packageId = "syn";
            features = [ "full" "visit-mut" ];
          }
        ];

      };
      "pin-project-lite" = rec {
        crateName = "pin-project-lite";
        version = "0.2.6";
        edition = "2018";
        sha256 = "01g96zxghb33s1vsjmjpn9l3a2nxdqj7glf9lhq7q5wjkhjiy3nw";
        authors = [
          "Taiki Endo <te316e89@gmail.com>"
        ];

      };
      "pin-utils" = rec {
        crateName = "pin-utils";
        version = "0.1.0";
        edition = "2018";
        sha256 = "117ir7vslsl2z1a7qzhws4pd01cg2d3338c47swjyvqv2n60v1wb";
        authors = [
          "Josef Brandl <mail@josefbrandl.de>"
        ];

      };
      "postgres-protocol" = rec {
        crateName = "postgres-protocol";
        version = "0.6.1";
        edition = "2018";
        sha256 = "1wxzs78zvz00bh3bhbbp9hnq9hg77f8h5pzjmcy9481fsdq0ygpz";
        authors = [
          "Steven Fackler <sfackler@gmail.com>"
        ];
        dependencies = [
          {
            name = "base64";
            packageId = "base64";
          }
          {
            name = "byteorder";
            packageId = "byteorder";
          }
          {
            name = "bytes";
            packageId = "bytes";
          }
          {
            name = "fallible-iterator";
            packageId = "fallible-iterator";
          }
          {
            name = "hmac";
            packageId = "hmac";
          }
          {
            name = "md-5";
            packageId = "md-5";
          }
          {
            name = "memchr";
            packageId = "memchr";
          }
          {
            name = "rand";
            packageId = "rand";
          }
          {
            name = "sha2";
            packageId = "sha2";
          }
          {
            name = "stringprep";
            packageId = "stringprep";
          }
        ];

      };
      "postgres-types" = rec {
        crateName = "postgres-types";
        version = "0.2.1";
        edition = "2018";
        sha256 = "0brsqkydz0grfy60nc1d0hxa9jbpim0c7c52v467nrdpw4ql23s3";
        authors = [
          "Steven Fackler <sfackler@gmail.com>"
        ];
        dependencies = [
          {
            name = "bytes";
            packageId = "bytes";
          }
          {
            name = "fallible-iterator";
            packageId = "fallible-iterator";
          }
          {
            name = "postgres-protocol";
            packageId = "postgres-protocol";
          }
        ];
        features = {
          "derive" = [ "postgres-derive" ];
          "with-bit-vec-0_6" = [ "bit-vec-06" ];
          "with-chrono-0_4" = [ "chrono-04" ];
          "with-eui48-0_4" = [ "eui48-04" ];
          "with-geo-types-0_6" = [ "geo-types-06" ];
          "with-geo-types-0_7" = [ "geo-types-0_7" ];
          "with-serde_json-1" = [ "serde-1" "serde_json-1" ];
          "with-time-0_2" = [ "time-02" ];
          "with-uuid-0_8" = [ "uuid-08" ];
        };
      };
      "postrep" = rec {
        crateName = "postrep";
        version = "0.1.0";
        edition = "2018";
        crateBin = [
          { name = "postrep"; path = "src/main.rs"; }
        ];
        src = lib.cleanSourceWith { filter = sourceFilter;  src = ./.; };
        authors = [
          "Pierre-Étienne Meunier <pmeunier@mailbox.org>"
        ];
        dependencies = [
          {
            name = "anyhow";
            packageId = "anyhow";
          }
          {
            name = "clap";
            packageId = "clap";
          }
          {
            name = "env_logger";
            packageId = "env_logger";
          }
          {
            name = "etcd-client";
            packageId = "etcd-client";
          }
          {
            name = "futures";
            packageId = "futures";
          }
          {
            name = "hyper";
            packageId = "hyper";
          }
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "tokio";
            packageId = "tokio";
            features = [ "net" "time" "rt-multi-thread" "macros" "io-util" "fs" "sync" "signal" ];
          }
          {
            name = "tokio-postgres";
            packageId = "tokio-postgres";
          }
        ];

      };
      "ppv-lite86" = rec {
        crateName = "ppv-lite86";
        version = "0.2.10";
        edition = "2018";
        sha256 = "0ms8198kclg4h96ggbziixxmsdl847s648kmbx11zlmjsqjccx5c";
        authors = [
          "The CryptoCorrosion Contributors"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "simd" "std" ];
      };
      "proc-macro-hack" = rec {
        crateName = "proc-macro-hack";
        version = "0.5.19";
        edition = "2018";
        sha256 = "1rg0kzsj7lj00qj602d3h77spwfz48vixn1wbjp7a4yrq65w9w6v";
        procMacro = true;
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];

      };
      "proc-macro-nested" = rec {
        crateName = "proc-macro-nested";
        version = "0.1.7";
        edition = "2015";
        sha256 = "11hh1jynh62f3m1ii0f9gf1l3y0fhkwpmr40lz3704v848n1p25w";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];

      };
      "proc-macro2" = rec {
        crateName = "proc-macro2";
        version = "1.0.26";
        edition = "2018";
        sha256 = "1v4w5jchgsssr727iyv986r8jaw6z80bzlhqgrbp78nw2lr02lm1";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "unicode-xid";
            packageId = "unicode-xid";
          }
        ];
        features = {
          "default" = [ "proc-macro" ];
        };
        resolvedDefaultFeatures = [ "default" "proc-macro" ];
      };
      "prost" = rec {
        crateName = "prost";
        version = "0.7.0";
        edition = "2018";
        sha256 = "1cj0x3cfjsbrsy3wjn9z90yhm09615nvb2qb4yyhjc52y7988scy";
        authors = [
          "Dan Burkert <dan@danburkert.com>"
        ];
        dependencies = [
          {
            name = "bytes";
            packageId = "bytes";
            usesDefaultFeatures = false;
          }
          {
            name = "prost-derive";
            packageId = "prost-derive";
            optional = true;
          }
        ];
        features = {
          "default" = [ "prost-derive" "std" ];
        };
        resolvedDefaultFeatures = [ "default" "prost-derive" "std" ];
      };
      "prost-build" = rec {
        crateName = "prost-build";
        version = "0.7.0";
        edition = "2018";
        sha256 = "18szvnc5n6gyqjf728745r28mk4zkxilc8m9ycm9qry2bbbyplrj";
        authors = [
          "Dan Burkert <dan@danburkert.com>"
        ];
        dependencies = [
          {
            name = "bytes";
            packageId = "bytes";
            usesDefaultFeatures = false;
          }
          {
            name = "heck";
            packageId = "heck";
          }
          {
            name = "itertools";
            packageId = "itertools";
          }
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "multimap";
            packageId = "multimap";
            usesDefaultFeatures = false;
          }
          {
            name = "petgraph";
            packageId = "petgraph";
            usesDefaultFeatures = false;
          }
          {
            name = "prost";
            packageId = "prost";
            usesDefaultFeatures = false;
          }
          {
            name = "prost-types";
            packageId = "prost-types";
            usesDefaultFeatures = false;
          }
          {
            name = "tempfile";
            packageId = "tempfile";
          }
        ];
        buildDependencies = [
          {
            name = "which";
            packageId = "which";
            usesDefaultFeatures = false;
          }
        ];

      };
      "prost-derive" = rec {
        crateName = "prost-derive";
        version = "0.7.0";
        edition = "2018";
        sha256 = "1m7m5bamjpnl2yhqgyqcsfv02xhad76pplx7rdh53jwf03rib6hn";
        procMacro = true;
        authors = [
          "Dan Burkert <dan@danburkert.com>"
        ];
        dependencies = [
          {
            name = "anyhow";
            packageId = "anyhow";
          }
          {
            name = "itertools";
            packageId = "itertools";
          }
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
          }
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "syn";
            packageId = "syn";
            features = [ "extra-traits" ];
          }
        ];

      };
      "prost-types" = rec {
        crateName = "prost-types";
        version = "0.7.0";
        edition = "2018";
        sha256 = "1fziv7q5gy9rl7idksfxd333c63pc2dgl1yg488ivarxv76xf65m";
        authors = [
          "Dan Burkert <dan@danburkert.com>"
        ];
        dependencies = [
          {
            name = "bytes";
            packageId = "bytes";
            usesDefaultFeatures = false;
          }
          {
            name = "prost";
            packageId = "prost";
            usesDefaultFeatures = false;
            features = [ "prost-derive" ];
          }
        ];
        features = {
          "default" = [ "std" ];
          "std" = [ "prost/std" ];
        };
      };
      "quote" = rec {
        crateName = "quote";
        version = "1.0.9";
        edition = "2018";
        sha256 = "19rjmfqzk26rxbgxy5j2ckqc2v12sw2xw8l4gi8bzpn2bmsbkl63";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "proc-macro" ];
          "proc-macro" = [ "proc-macro2/proc-macro" ];
        };
        resolvedDefaultFeatures = [ "default" "proc-macro" ];
      };
      "rand" = rec {
        crateName = "rand";
        version = "0.8.3";
        edition = "2018";
        sha256 = "0zldxfx4gi551n2fna4zz9ab22zsnzw1mj5hzi5nfs24dgkfgy8f";
        authors = [
          "The Rand Project Developers"
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
            optional = true;
            usesDefaultFeatures = false;
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "rand_chacha";
            packageId = "rand_chacha";
            optional = true;
            usesDefaultFeatures = false;
            target = { target, features }: (!(target."os" == "emscripten"));
          }
          {
            name = "rand_core";
            packageId = "rand_core";
          }
          {
            name = "rand_hc";
            packageId = "rand_hc";
            optional = true;
            target = { target, features }: (target."os" == "emscripten");
          }
        ];
        devDependencies = [
          {
            name = "rand_hc";
            packageId = "rand_hc";
          }
        ];
        features = {
          "alloc" = [ "rand_core/alloc" ];
          "default" = [ "std" "std_rng" ];
          "getrandom" = [ "rand_core/getrandom" ];
          "serde1" = [ "serde" ];
          "simd_support" = [ "packed_simd" ];
          "std" = [ "rand_core/std" "rand_chacha/std" "alloc" "getrandom" "libc" ];
          "std_rng" = [ "rand_chacha" "rand_hc" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "getrandom" "libc" "rand_chacha" "rand_hc" "small_rng" "std" "std_rng" ];
      };
      "rand_chacha" = rec {
        crateName = "rand_chacha";
        version = "0.3.0";
        edition = "2018";
        sha256 = "03df2xh5nbdvwr17qm3sviaxa95r8yhm1nil2pr0pqf90p7ka9z1";
        authors = [
          "The Rand Project Developers"
          "The Rust Project Developers"
          "The CryptoCorrosion Contributors"
        ];
        dependencies = [
          {
            name = "ppv-lite86";
            packageId = "ppv-lite86";
            usesDefaultFeatures = false;
            features = [ "simd" ];
          }
          {
            name = "rand_core";
            packageId = "rand_core";
          }
        ];
        features = {
          "default" = [ "std" ];
          "std" = [ "ppv-lite86/std" ];
        };
        resolvedDefaultFeatures = [ "std" ];
      };
      "rand_core" = rec {
        crateName = "rand_core";
        version = "0.6.2";
        edition = "2018";
        sha256 = "1rvas1afjvd2827b8mf2ilg78h3ksl9npkrdds3wbw9x33mndkrl";
        authors = [
          "The Rand Project Developers"
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "getrandom";
            packageId = "getrandom";
            optional = true;
          }
        ];
        features = {
          "serde1" = [ "serde" ];
          "std" = [ "alloc" "getrandom" "getrandom/std" ];
        };
        resolvedDefaultFeatures = [ "alloc" "getrandom" "std" ];
      };
      "rand_hc" = rec {
        crateName = "rand_hc";
        version = "0.3.0";
        edition = "2018";
        sha256 = "0wra6ar22zdjkry9dsq1mg620m4h3qb9s8rfykkz4im4crqfz41i";
        authors = [
          "The Rand Project Developers"
        ];
        dependencies = [
          {
            name = "rand_core";
            packageId = "rand_core";
          }
        ];

      };
      "redox_syscall" = rec {
        crateName = "redox_syscall";
        version = "0.2.8";
        edition = "2018";
        sha256 = "1z27f6rzm0lcpszbr2dmfyna7qmpmx4yb98yhzg1956l3kj3j9vl";
        libName = "syscall";
        authors = [
          "Jeremy Soller <jackpot51@gmail.com>"
        ];
        dependencies = [
          {
            name = "bitflags";
            packageId = "bitflags";
          }
        ];

      };
      "regex" = rec {
        crateName = "regex";
        version = "1.5.3";
        edition = "2018";
        sha256 = "0avhjn85naahsz3j21hyk6lah245iv7jyr014vivravlgzmiqpyf";
        authors = [
          "The Rust Project Developers"
        ];
        dependencies = [
          {
            name = "aho-corasick";
            packageId = "aho-corasick";
            optional = true;
          }
          {
            name = "memchr";
            packageId = "memchr";
            optional = true;
          }
          {
            name = "regex-syntax";
            packageId = "regex-syntax";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "std" "perf" "unicode" "regex-syntax/default" ];
          "perf" = [ "perf-cache" "perf-dfa" "perf-inline" "perf-literal" ];
          "perf-literal" = [ "aho-corasick" "memchr" ];
          "unicode" = [ "unicode-age" "unicode-bool" "unicode-case" "unicode-gencat" "unicode-perl" "unicode-script" "unicode-segment" "regex-syntax/unicode" ];
          "unicode-age" = [ "regex-syntax/unicode-age" ];
          "unicode-bool" = [ "regex-syntax/unicode-bool" ];
          "unicode-case" = [ "regex-syntax/unicode-case" ];
          "unicode-gencat" = [ "regex-syntax/unicode-gencat" ];
          "unicode-perl" = [ "regex-syntax/unicode-perl" ];
          "unicode-script" = [ "regex-syntax/unicode-script" ];
          "unicode-segment" = [ "regex-syntax/unicode-segment" ];
          "unstable" = [ "pattern" ];
          "use_std" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "aho-corasick" "memchr" "perf" "perf-cache" "perf-dfa" "perf-inline" "perf-literal" "std" ];
      };
      "regex-syntax" = rec {
        crateName = "regex-syntax";
        version = "0.6.25";
        edition = "2018";
        sha256 = "16y87hz1bxmmz6kk360cxwfm3jnbsxb3x4zw9x1gzz7khic2i5zl";
        authors = [
          "The Rust Project Developers"
        ];
        features = {
          "default" = [ "unicode" ];
          "unicode" = [ "unicode-age" "unicode-bool" "unicode-case" "unicode-gencat" "unicode-perl" "unicode-script" "unicode-segment" ];
        };
      };
      "remove_dir_all" = rec {
        crateName = "remove_dir_all";
        version = "0.5.3";
        edition = "2015";
        sha256 = "1rzqbsgkmr053bxxl04vmvsd1njyz0nxvly97aip6aa2cmb15k9s";
        authors = [
          "Aaronepower <theaaronepower@gmail.com>"
        ];
        dependencies = [
          {
            name = "winapi";
            packageId = "winapi";
            target = { target, features }: (target."windows" or false);
            features = [ "std" "errhandlingapi" "winerror" "fileapi" "winbase" ];
          }
        ];

      };
      "scopeguard" = rec {
        crateName = "scopeguard";
        version = "1.1.0";
        edition = "2015";
        sha256 = "1kbqm85v43rq92vx7hfiay6pmcga03vrjbbfwqpyj3pwsg3b16nj";
        authors = [
          "bluss"
        ];
        features = {
          "default" = [ "use_std" ];
        };
      };
      "sha2" = rec {
        crateName = "sha2";
        version = "0.9.4";
        edition = "2018";
        sha256 = "1wngyrx4i5a1jx5z6k3l0saxzg5qp32brc8dxwmpjssp2xdvgxnq";
        authors = [
          "RustCrypto Developers"
        ];
        dependencies = [
          {
            name = "block-buffer";
            packageId = "block-buffer";
          }
          {
            name = "cfg-if";
            packageId = "cfg-if";
          }
          {
            name = "cpufeatures";
            packageId = "cpufeatures";
            target = { target, features }: ((target."arch" == "x86") || (target."arch" == "x86_64"));
          }
          {
            name = "digest";
            packageId = "digest";
          }
          {
            name = "opaque-debug";
            packageId = "opaque-debug";
          }
        ];
        devDependencies = [
          {
            name = "digest";
            packageId = "digest";
            features = [ "dev" ];
          }
        ];
        features = {
          "asm" = [ "sha2-asm" "libc" ];
          "asm-aarch64" = [ "asm" ];
          "default" = [ "std" ];
          "std" = [ "digest/std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "signal-hook-registry" = rec {
        crateName = "signal-hook-registry";
        version = "1.3.0";
        edition = "2015";
        sha256 = "19hirq0h33jjyh505s8hf9q5dq0ky80ygivkl3vshjv0y7zd1w8n";
        authors = [
          "Michal 'vorner' Vaner <vorner@vorner.cz>"
          "Masaki Hara <ackie.h.gmai@gmail.com>"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
          }
        ];

      };
      "siphasher" = rec {
        crateName = "siphasher";
        version = "0.3.5";
        edition = "2018";
        sha256 = "09zzzdshn4rj1qkhsb9hz9qwp42jx5b6whwi42ba7r670x2nvknb";
        authors = [
          "Frank Denis <github@pureftpd.org>"
        ];
        features = {
          "default" = [ "std" ];
          "serde_no_std" = [ "serde/alloc" ];
          "serde_std" = [ "std" "serde/std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "slab" = rec {
        crateName = "slab";
        version = "0.4.3";
        edition = "2015";
        sha256 = "09v57dmy9gnfcj3c6gywp7wi09zywxf0ppj07w02hfvy38ysqwzi";
        authors = [
          "Carl Lerche <me@carllerche.com>"
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "smallvec" = rec {
        crateName = "smallvec";
        version = "1.6.1";
        edition = "2018";
        sha256 = "0kk08axr0ybfbjzk65a41k84mb6sfhyajmfndaka9igkx34kf3zy";
        authors = [
          "The Servo Project Developers"
        ];
        features = {
        };
      };
      "socket2" = rec {
        crateName = "socket2";
        version = "0.4.0";
        edition = "2018";
        sha256 = "18ny6m1gnf6cwp5ax0b5hr36w6yg16z7faj76b31aq2jghhgqgcy";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
          "Thomas de Zeeuw <thomasdezeeuw@gmail.com>"
        ];
        dependencies = [
          {
            name = "libc";
            packageId = "libc";
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "winapi";
            packageId = "winapi";
            target = { target, features }: (target."windows" or false);
            features = [ "handleapi" "ws2ipdef" "ws2tcpip" ];
          }
        ];
        features = {
        };
      };
      "stringprep" = rec {
        crateName = "stringprep";
        version = "0.1.2";
        edition = "2015";
        sha256 = "1hd1x7s8fnzqwz5fm2pq0jh10n024zvwnldmykzm8x5qfk5liqwf";
        authors = [
          "Steven Fackler <sfackler@gmail.com>"
        ];
        dependencies = [
          {
            name = "unicode-bidi";
            packageId = "unicode-bidi";
          }
          {
            name = "unicode-normalization";
            packageId = "unicode-normalization";
          }
        ];

      };
      "strsim" = rec {
        crateName = "strsim";
        version = "0.8.0";
        edition = "2015";
        sha256 = "0sjsm7hrvjdifz661pjxq5w4hf190hx53fra8dfvamacvff139cf";
        authors = [
          "Danny Guo <dannyguo91@gmail.com>"
        ];

      };
      "subtle" = rec {
        crateName = "subtle";
        version = "2.4.0";
        edition = "2015";
        sha256 = "1hipji54nipkya6szyk9kl7nz07qli570b1isklz78dda44dm08y";
        authors = [
          "Isis Lovecruft <isis@patternsinthevoid.net>"
          "Henry de Valence <hdevalence@hdevalence.ca>"
        ];
        features = {
          "default" = [ "std" "i128" ];
        };
      };
      "syn" = rec {
        crateName = "syn";
        version = "1.0.72";
        edition = "2018";
        sha256 = "10mb1cqmq2vpl5v6qjgqqyvhgs9yf9xv9f0dbskababrzfzcvs51";
        authors = [
          "David Tolnay <dtolnay@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
            usesDefaultFeatures = false;
          }
          {
            name = "quote";
            packageId = "quote";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "unicode-xid";
            packageId = "unicode-xid";
          }
        ];
        features = {
          "default" = [ "derive" "parsing" "printing" "clone-impls" "proc-macro" ];
          "printing" = [ "quote" ];
          "proc-macro" = [ "proc-macro2/proc-macro" "quote/proc-macro" ];
          "test" = [ "syn-test-suite/all-features" ];
        };
        resolvedDefaultFeatures = [ "clone-impls" "default" "derive" "extra-traits" "full" "parsing" "printing" "proc-macro" "quote" "visit" "visit-mut" ];
      };
      "tempfile" = rec {
        crateName = "tempfile";
        version = "3.2.0";
        edition = "2018";
        sha256 = "08pbf3c1i42382dc44dil5bgiawcsi0qk6zdibw10f69rxiwdhfs";
        authors = [
          "Steven Allen <steven@stebalien.com>"
          "The Rust Project Developers"
          "Ashley Mannix <ashleymannix@live.com.au>"
          "Jason White <jasonaw0@gmail.com>"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if";
          }
          {
            name = "libc";
            packageId = "libc";
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "rand";
            packageId = "rand";
          }
          {
            name = "redox_syscall";
            packageId = "redox_syscall";
            target = { target, features }: (target."os" == "redox");
          }
          {
            name = "remove_dir_all";
            packageId = "remove_dir_all";
          }
          {
            name = "winapi";
            packageId = "winapi";
            target = { target, features }: (target."windows" or false);
            features = [ "fileapi" "handleapi" "winbase" ];
          }
        ];

      };
      "termcolor" = rec {
        crateName = "termcolor";
        version = "1.1.2";
        edition = "2018";
        sha256 = "1x65i1ny4m6z1by62ra6wdcrd557p2ysm866x0pg60zby2cxizid";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        dependencies = [
          {
            name = "winapi-util";
            packageId = "winapi-util";
            target = { target, features }: (target."windows" or false);
          }
        ];

      };
      "textwrap" = rec {
        crateName = "textwrap";
        version = "0.11.0";
        edition = "2015";
        sha256 = "0q5hky03ik3y50s9sz25r438bc4nwhqc6dqwynv4wylc807n29nk";
        authors = [
          "Martin Geisler <martin@geisler.net>"
        ];
        dependencies = [
          {
            name = "unicode-width";
            packageId = "unicode-width";
          }
        ];

      };
      "tinyvec" = rec {
        crateName = "tinyvec";
        version = "1.2.0";
        edition = "2018";
        sha256 = "0hn3fkpb9nca9nf9znz2dxlp4ccv37hnbh67aczpzpmpbgq20ljv";
        authors = [
          "Lokathor <zefria@gmail.com>"
        ];
        dependencies = [
          {
            name = "tinyvec_macros";
            packageId = "tinyvec_macros";
            optional = true;
          }
        ];
        features = {
          "alloc" = [ "tinyvec_macros" ];
        };
        resolvedDefaultFeatures = [ "alloc" "default" "tinyvec_macros" ];
      };
      "tinyvec_macros" = rec {
        crateName = "tinyvec_macros";
        version = "0.1.0";
        edition = "2018";
        sha256 = "0p5zvgbas5nh403fbxica819mf3g83n8g2hzpfazfr56w6klv9yd";
        authors = [
          "Soveu <marx.tomasz@gmail.com>"
        ];

      };
      "tokio" = rec {
        crateName = "tokio";
        version = "1.5.0";
        edition = "2018";
        sha256 = "199pf7dy992rjpxygrj6790pzbyhhzvvlm9hcq5vbnmdq3kwiw43";
        authors = [
          "Tokio Contributors <team@tokio.rs>"
        ];
        dependencies = [
          {
            name = "bytes";
            packageId = "bytes";
            optional = true;
          }
          {
            name = "libc";
            packageId = "libc";
            optional = true;
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "memchr";
            packageId = "memchr";
            optional = true;
          }
          {
            name = "mio";
            packageId = "mio";
            optional = true;
          }
          {
            name = "num_cpus";
            packageId = "num_cpus";
            optional = true;
          }
          {
            name = "once_cell";
            packageId = "once_cell";
            optional = true;
          }
          {
            name = "pin-project-lite";
            packageId = "pin-project-lite";
          }
          {
            name = "signal-hook-registry";
            packageId = "signal-hook-registry";
            optional = true;
            target = { target, features }: (target."unix" or false);
          }
          {
            name = "tokio-macros";
            packageId = "tokio-macros";
            optional = true;
          }
          {
            name = "winapi";
            packageId = "winapi";
            optional = true;
            usesDefaultFeatures = false;
            target = { target, features }: (target."windows" or false);
          }
        ];
        buildDependencies = [
          {
            name = "autocfg";
            packageId = "autocfg";
          }
        ];
        devDependencies = [
          {
            name = "libc";
            packageId = "libc";
            target = {target, features}: (target."unix" or false);
          }
        ];
        features = {
          "full" = [ "fs" "io-util" "io-std" "macros" "net" "parking_lot" "process" "rt" "rt-multi-thread" "signal" "sync" "time" ];
          "io-util" = [ "memchr" "bytes" ];
          "macros" = [ "tokio-macros" ];
          "net" = [ "libc" "mio/os-poll" "mio/os-util" "mio/tcp" "mio/udp" "mio/uds" ];
          "process" = [ "bytes" "once_cell" "libc" "mio/os-poll" "mio/os-util" "mio/uds" "signal-hook-registry" "winapi/threadpoollegacyapiset" ];
          "rt-multi-thread" = [ "num_cpus" "rt" ];
          "signal" = [ "once_cell" "libc" "mio/os-poll" "mio/uds" "mio/os-util" "signal-hook-registry" "winapi/consoleapi" ];
        };
        resolvedDefaultFeatures = [ "bytes" "default" "fs" "io-std" "io-util" "libc" "macros" "memchr" "mio" "net" "num_cpus" "once_cell" "rt" "rt-multi-thread" "signal" "signal-hook-registry" "sync" "time" "tokio-macros" "winapi" ];
      };
      "tokio-macros" = rec {
        crateName = "tokio-macros";
        version = "1.1.0";
        edition = "2018";
        sha256 = "0mys5zm2gcdgc0iq8nqipzn703q26x1bpw59m04shikgacdb3xya";
        procMacro = true;
        authors = [
          "Tokio Contributors <team@tokio.rs>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
          }
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "syn";
            packageId = "syn";
            features = [ "full" ];
          }
        ];

      };
      "tokio-postgres" = rec {
        crateName = "tokio-postgres";
        version = "0.7.2";
        edition = "2018";
        sha256 = "12rb390i3af7zb0z2idhaf6l2m6snypwdiwjw84rmyz4qy1i6ard";
        authors = [
          "Steven Fackler <sfackler@gmail.com>"
        ];
        dependencies = [
          {
            name = "async-trait";
            packageId = "async-trait";
          }
          {
            name = "byteorder";
            packageId = "byteorder";
          }
          {
            name = "bytes";
            packageId = "bytes";
          }
          {
            name = "fallible-iterator";
            packageId = "fallible-iterator";
          }
          {
            name = "futures";
            packageId = "futures";
          }
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "parking_lot";
            packageId = "parking_lot";
          }
          {
            name = "percent-encoding";
            packageId = "percent-encoding";
          }
          {
            name = "phf";
            packageId = "phf";
          }
          {
            name = "pin-project-lite";
            packageId = "pin-project-lite";
          }
          {
            name = "postgres-protocol";
            packageId = "postgres-protocol";
          }
          {
            name = "postgres-types";
            packageId = "postgres-types";
          }
          {
            name = "socket2";
            packageId = "socket2";
          }
          {
            name = "tokio";
            packageId = "tokio";
            features = [ "io-util" ];
          }
          {
            name = "tokio-util";
            packageId = "tokio-util";
            features = [ "codec" ];
          }
        ];
        devDependencies = [
          {
            name = "tokio";
            packageId = "tokio";
            features = [ "full" ];
          }
        ];
        features = {
          "default" = [ "runtime" ];
          "runtime" = [ "tokio/net" "tokio/time" ];
          "with-bit-vec-0_6" = [ "postgres-types/with-bit-vec-0_6" ];
          "with-chrono-0_4" = [ "postgres-types/with-chrono-0_4" ];
          "with-eui48-0_4" = [ "postgres-types/with-eui48-0_4" ];
          "with-geo-types-0_6" = [ "postgres-types/with-geo-types-0_6" ];
          "with-geo-types-0_7" = [ "postgres-types/with-geo-types-0_7" ];
          "with-serde_json-1" = [ "postgres-types/with-serde_json-1" ];
          "with-time-0_2" = [ "postgres-types/with-time-0_2" ];
          "with-uuid-0_8" = [ "postgres-types/with-uuid-0_8" ];
        };
        resolvedDefaultFeatures = [ "default" "runtime" ];
      };
      "tokio-stream" = rec {
        crateName = "tokio-stream";
        version = "0.1.5";
        edition = "2018";
        sha256 = "1w0s6s0qqq9zwhwk7ywk5wrn9sbri1ym6n3dpsgdwdmzqgcaaxz1";
        authors = [
          "Tokio Contributors <team@tokio.rs>"
        ];
        dependencies = [
          {
            name = "futures-core";
            packageId = "futures-core";
          }
          {
            name = "pin-project-lite";
            packageId = "pin-project-lite";
          }
          {
            name = "tokio";
            packageId = "tokio";
            features = [ "sync" ];
          }
        ];
        devDependencies = [
          {
            name = "tokio";
            packageId = "tokio";
            features = [ "full" "test-util" ];
          }
        ];
        features = {
          "default" = [ "time" ];
          "fs" = [ "tokio/fs" ];
          "io-util" = [ "tokio/io-util" ];
          "net" = [ "tokio/net" ];
          "signal" = [ "tokio/signal" ];
          "sync" = [ "tokio/sync" "tokio-util" ];
          "time" = [ "tokio/time" ];
        };
        resolvedDefaultFeatures = [ "default" "time" ];
      };
      "tokio-util" = rec {
        crateName = "tokio-util";
        version = "0.6.6";
        edition = "2018";
        sha256 = "13hyc0vm8l9g5h9bfaqh414zwgqqpv0lx84vvnl1xhv5jg4i42ll";
        authors = [
          "Tokio Contributors <team@tokio.rs>"
        ];
        dependencies = [
          {
            name = "bytes";
            packageId = "bytes";
          }
          {
            name = "futures-core";
            packageId = "futures-core";
          }
          {
            name = "futures-sink";
            packageId = "futures-sink";
          }
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "pin-project-lite";
            packageId = "pin-project-lite";
          }
          {
            name = "tokio";
            packageId = "tokio";
            features = [ "sync" ];
          }
        ];
        devDependencies = [
          {
            name = "tokio";
            packageId = "tokio";
            features = [ "full" ];
          }
        ];
        features = {
          "__docs_rs" = [ "futures-util" ];
          "compat" = [ "futures-io" ];
          "full" = [ "codec" "compat" "io" "time" "net" "rt" ];
          "net" = [ "tokio/net" ];
          "rt" = [ "tokio/rt" ];
          "time" = [ "tokio/time" "slab" ];
        };
        resolvedDefaultFeatures = [ "codec" "default" ];
      };
      "tonic" = rec {
        crateName = "tonic";
        version = "0.4.3";
        edition = "2018";
        sha256 = "1q0vnd6x91aymrmgmikfcd2ixqj0al8bzjjvmwwj7gf6gbcjri1a";
        authors = [
          "Lucio Franco <luciofranco14@gmail.com>"
        ];
        dependencies = [
          {
            name = "async-stream";
            packageId = "async-stream";
          }
          {
            name = "async-trait";
            packageId = "async-trait";
            optional = true;
          }
          {
            name = "base64";
            packageId = "base64";
          }
          {
            name = "bytes";
            packageId = "bytes";
          }
          {
            name = "futures-core";
            packageId = "futures-core";
            usesDefaultFeatures = false;
          }
          {
            name = "futures-util";
            packageId = "futures-util";
            usesDefaultFeatures = false;
          }
          {
            name = "h2";
            packageId = "h2";
            optional = true;
          }
          {
            name = "http";
            packageId = "http";
          }
          {
            name = "http-body";
            packageId = "http-body";
          }
          {
            name = "hyper";
            packageId = "hyper";
            optional = true;
            features = [ "full" ];
          }
          {
            name = "percent-encoding";
            packageId = "percent-encoding";
          }
          {
            name = "pin-project";
            packageId = "pin-project";
          }
          {
            name = "prost";
            packageId = "prost";
            rename = "prost1";
            optional = true;
          }
          {
            name = "prost-derive";
            packageId = "prost-derive";
            optional = true;
          }
          {
            name = "tokio";
            packageId = "tokio";
            optional = true;
            features = [ "net" ];
          }
          {
            name = "tokio-stream";
            packageId = "tokio-stream";
          }
          {
            name = "tokio-util";
            packageId = "tokio-util";
            features = [ "codec" ];
          }
          {
            name = "tower";
            packageId = "tower";
            optional = true;
            features = [ "balance" "buffer" "discover" "limit" "load" "make" "timeout" "util" ];
          }
          {
            name = "tower-service";
            packageId = "tower-service";
          }
          {
            name = "tracing";
            packageId = "tracing";
          }
          {
            name = "tracing-futures";
            packageId = "tracing-futures";
            optional = true;
          }
        ];
        devDependencies = [
          {
            name = "tokio";
            packageId = "tokio";
            features = [ "rt" "macros" ];
          }
        ];
        features = {
          "codegen" = [ "async-trait" ];
          "default" = [ "transport" "codegen" "prost" ];
          "prost" = [ "prost1" "prost-derive" ];
          "tls" = [ "transport" "tokio-rustls" ];
          "tls-roots" = [ "tls" "rustls-native-certs" ];
          "transport" = [ "h2" "hyper" "tokio" "tower" "tracing-futures" "tokio/macros" "tokio/time" ];
        };
        resolvedDefaultFeatures = [ "async-trait" "codegen" "default" "h2" "hyper" "prost" "prost-derive" "prost1" "tokio" "tower" "tracing-futures" "transport" ];
      };
      "tonic-build" = rec {
        crateName = "tonic-build";
        version = "0.4.2";
        edition = "2018";
        sha256 = "1kzx489zx06b9a305nix8q2vi30s2dw7276s3lcrfiig60kxx5f6";
        authors = [
          "Lucio Franco <luciofranco14@gmail.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
          }
          {
            name = "prost-build";
            packageId = "prost-build";
            optional = true;
          }
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "syn";
            packageId = "syn";
          }
        ];
        features = {
          "default" = [ "transport" "rustfmt" "prost" ];
          "prost" = [ "prost-build" ];
        };
        resolvedDefaultFeatures = [ "prost" "prost-build" ];
      };
      "tower" = rec {
        crateName = "tower";
        version = "0.4.7";
        edition = "2018";
        sha256 = "11qnclrklpl24214dlgl9nwfw8f1hgxbpnh8cy1c6j4iqbgsc2mz";
        authors = [
          "Tower Maintainers <team@tower-rs.com>"
        ];
        dependencies = [
          {
            name = "futures-core";
            packageId = "futures-core";
          }
          {
            name = "futures-util";
            packageId = "futures-util";
            optional = true;
            usesDefaultFeatures = false;
            features = [ "alloc" ];
          }
          {
            name = "indexmap";
            packageId = "indexmap";
            optional = true;
          }
          {
            name = "pin-project";
            packageId = "pin-project";
          }
          {
            name = "rand";
            packageId = "rand";
            optional = true;
            features = [ "small_rng" ];
          }
          {
            name = "slab";
            packageId = "slab";
            optional = true;
          }
          {
            name = "tokio";
            packageId = "tokio";
            optional = true;
            features = [ "sync" ];
          }
          {
            name = "tokio-stream";
            packageId = "tokio-stream";
            optional = true;
          }
          {
            name = "tokio-util";
            packageId = "tokio-util";
            optional = true;
            usesDefaultFeatures = false;
          }
          {
            name = "tower-layer";
            packageId = "tower-layer";
          }
          {
            name = "tower-service";
            packageId = "tower-service";
          }
          {
            name = "tracing";
            packageId = "tracing";
            optional = true;
          }
        ];
        devDependencies = [
          {
            name = "tokio";
            packageId = "tokio";
            features = [ "macros" "sync" "test-util" "rt-multi-thread" ];
          }
          {
            name = "tokio-stream";
            packageId = "tokio-stream";
          }
        ];
        features = {
          "balance" = [ "discover" "load" "ready-cache" "make" "rand" "slab" "tokio-stream" ];
          "buffer" = [ "tokio/sync" "tokio/rt" "tokio-util" "tracing" ];
          "default" = [ "log" ];
          "filter" = [ "futures-util" ];
          "full" = [ "balance" "buffer" "discover" "filter" "hedge" "limit" "load" "load-shed" "make" "ready-cache" "reconnect" "retry" "spawn-ready" "steer" "timeout" "util" ];
          "hedge" = [ "util" "filter" "futures-util" "hdrhistogram" "tokio/time" "tracing" ];
          "limit" = [ "tokio/time" "tokio/sync" "tokio-util" "tracing" ];
          "load" = [ "tokio/time" "tracing" ];
          "log" = [ "tracing/log" ];
          "make" = [ "tokio/io-std" "futures-util" ];
          "ready-cache" = [ "futures-util" "indexmap" "tokio/sync" "tracing" ];
          "reconnect" = [ "make" "tokio/io-std" "tracing" ];
          "retry" = [ "tokio/time" ];
          "spawn-ready" = [ "futures-util" "tokio/sync" "tokio/rt" "util" "tracing" ];
          "steer" = [ "futures-util" ];
          "timeout" = [ "tokio/time" ];
          "util" = [ "futures-util" ];
        };
        resolvedDefaultFeatures = [ "balance" "buffer" "default" "discover" "futures-util" "indexmap" "limit" "load" "log" "make" "rand" "ready-cache" "slab" "timeout" "tokio" "tokio-stream" "tokio-util" "tracing" "util" ];
      };
      "tower-layer" = rec {
        crateName = "tower-layer";
        version = "0.3.1";
        edition = "2018";
        sha256 = "0qiskpgz6zzy3a894vyr9yzq0i7q142rciggc3wv1rizdm3cjfrl";
        authors = [
          "Tower Maintainers <team@tower-rs.com>"
        ];

      };
      "tower-service" = rec {
        crateName = "tower-service";
        version = "0.3.1";
        edition = "2018";
        sha256 = "1iih764s3f6vlkspfmr72fkrs2lw1v3wiqmc6bd5zq1hdlfzs39n";
        authors = [
          "Tower Maintainers <team@tower-rs.com>"
        ];

      };
      "tracing" = rec {
        crateName = "tracing";
        version = "0.1.26";
        edition = "2018";
        sha256 = "17dqjhixmnbrk0c99ydb3b9pygjnzfb7yhlasb6134s4jy6fpb89";
        authors = [
          "Eliza Weisman <eliza@buoyant.io>"
          "Tokio Contributors <team@tokio.rs>"
        ];
        dependencies = [
          {
            name = "cfg-if";
            packageId = "cfg-if";
          }
          {
            name = "log";
            packageId = "log";
            optional = true;
          }
          {
            name = "pin-project-lite";
            packageId = "pin-project-lite";
          }
          {
            name = "tracing-attributes";
            packageId = "tracing-attributes";
            optional = true;
          }
          {
            name = "tracing-core";
            packageId = "tracing-core";
            usesDefaultFeatures = false;
          }
        ];
        devDependencies = [
          {
            name = "log";
            packageId = "log";
          }
        ];
        features = {
          "attributes" = [ "tracing-attributes" ];
          "default" = [ "std" "attributes" ];
          "log-always" = [ "log" ];
          "std" = [ "tracing-core/std" ];
        };
        resolvedDefaultFeatures = [ "attributes" "default" "log" "std" "tracing-attributes" ];
      };
      "tracing-attributes" = rec {
        crateName = "tracing-attributes";
        version = "0.1.15";
        edition = "2018";
        sha256 = "1qni83p58nrp20i256zm169dnf7cylfchkfd9iza3j076fjnybn4";
        procMacro = true;
        authors = [
          "Tokio Contributors <team@tokio.rs>"
          "Eliza Weisman <eliza@buoyant.io>"
          "David Barsky <dbarsky@amazon.com>"
        ];
        dependencies = [
          {
            name = "proc-macro2";
            packageId = "proc-macro2";
          }
          {
            name = "quote";
            packageId = "quote";
          }
          {
            name = "syn";
            packageId = "syn";
            usesDefaultFeatures = false;
            features = [ "full" "parsing" "printing" "visit" "visit-mut" "clone-impls" "extra-traits" "proc-macro" ];
          }
        ];
        features = {
        };
      };
      "tracing-core" = rec {
        crateName = "tracing-core";
        version = "0.1.18";
        edition = "2018";
        sha256 = "0lm0li6lx75jgbbgxsb45439257sqb0j7828caf2hjqsigwi9zx9";
        authors = [
          "Tokio Contributors <team@tokio.rs>"
        ];
        dependencies = [
          {
            name = "lazy_static";
            packageId = "lazy_static";
            optional = true;
          }
        ];
        features = {
          "default" = [ "std" ];
          "std" = [ "lazy_static" ];
        };
        resolvedDefaultFeatures = [ "lazy_static" "std" ];
      };
      "tracing-futures" = rec {
        crateName = "tracing-futures";
        version = "0.2.5";
        edition = "2018";
        sha256 = "1wimg0iwa2ldq7xv98lvivvf3q9ykfminig8r1bs0ig22np9bl4p";
        authors = [
          "Eliza Weisman <eliza@buoyant.io>"
          "Tokio Contributors <team@tokio.rs>"
        ];
        dependencies = [
          {
            name = "pin-project";
            packageId = "pin-project";
            optional = true;
          }
          {
            name = "tracing";
            packageId = "tracing";
            usesDefaultFeatures = false;
          }
        ];
        features = {
          "default" = [ "std-future" "std" ];
          "futures-01" = [ "futures_01" "std" ];
          "futures-03" = [ "std-future" "futures" "futures-task" "std" ];
          "std" = [ "tracing/std" ];
          "std-future" = [ "pin-project" ];
        };
        resolvedDefaultFeatures = [ "default" "pin-project" "std" "std-future" ];
      };
      "try-lock" = rec {
        crateName = "try-lock";
        version = "0.2.3";
        edition = "2015";
        sha256 = "0hkn1ksmg5hdqgqdw1ahy5qk69f4crh2psf0v61qphyrf777nm2r";
        authors = [
          "Sean McArthur <sean@seanmonstar.com>"
        ];

      };
      "typenum" = rec {
        crateName = "typenum";
        version = "1.13.0";
        edition = "2018";
        sha256 = "01lbbspn4080yg8wp6y7q3xcqih1c1dmkkx4pwax4z1a9436k7w7";
        build = "build/main.rs";
        authors = [
          "Paho Lurie-Gregg <paho@paholg.com>"
          "Andre Bogus <bogusandre@gmail.com>"
        ];
        features = {
        };
      };
      "unicode-bidi" = rec {
        crateName = "unicode-bidi";
        version = "0.3.5";
        edition = "2018";
        sha256 = "1q07h5kp9jszwf0bkrpa1v5wmv04dv920x3w2xy6pjdikchbxf7f";
        libName = "unicode_bidi";
        authors = [
          "The Servo Project Developers"
        ];
        dependencies = [
          {
            name = "matches";
            packageId = "matches";
          }
        ];
        features = {
          "flame_it" = [ "flame" "flamer" ];
          "with_serde" = [ "serde" ];
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "unicode-normalization" = rec {
        crateName = "unicode-normalization";
        version = "0.1.17";
        edition = "2018";
        sha256 = "1vzajca1hk9plka5d3z3426frmnr7229fd2kidz58zd9r3hzryq7";
        authors = [
          "kwantam <kwantam@gmail.com>"
          "Manish Goregaokar <manishsmail@gmail.com>"
        ];
        dependencies = [
          {
            name = "tinyvec";
            packageId = "tinyvec";
            features = [ "alloc" ];
          }
        ];
        features = {
          "default" = [ "std" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "unicode-segmentation" = rec {
        crateName = "unicode-segmentation";
        version = "1.7.1";
        edition = "2015";
        sha256 = "15n736z0pbj30pj44jb9s9rjavzrmx8v8pzdgsl5yfmfwrxjw3dv";
        authors = [
          "kwantam <kwantam@gmail.com>"
          "Manish Goregaokar <manishsmail@gmail.com>"
        ];
        features = {
        };
      };
      "unicode-width" = rec {
        crateName = "unicode-width";
        version = "0.1.8";
        edition = "2015";
        sha256 = "1qxizyi6xbcqyi4z79p523ywvmgsfcgfqb3zv3c8i6x1jcc5jdwk";
        authors = [
          "kwantam <kwantam@gmail.com>"
          "Manish Goregaokar <manishsmail@gmail.com>"
        ];
        features = {
          "rustc-dep-of-std" = [ "std" "core" "compiler_builtins" ];
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "unicode-xid" = rec {
        crateName = "unicode-xid";
        version = "0.2.2";
        edition = "2015";
        sha256 = "1wrkgcw557v311dkdb6n2hrix9dm2qdsb1zpw7pn79l03zb85jwc";
        authors = [
          "erick.tryzelaar <erick.tryzelaar@gmail.com>"
          "kwantam <kwantam@gmail.com>"
          "Manish Goregaokar <manishsmail@gmail.com>"
        ];
        features = {
        };
        resolvedDefaultFeatures = [ "default" ];
      };
      "vec_map" = rec {
        crateName = "vec_map";
        version = "0.8.2";
        edition = "2015";
        sha256 = "1481w9g1dw9rxp3l6snkdqihzyrd2f8vispzqmwjwsdyhw8xzggi";
        authors = [
          "Alex Crichton <alex@alexcrichton.com>"
          "Jorge Aparicio <japaricious@gmail.com>"
          "Alexis Beingessner <a.beingessner@gmail.com>"
          "Brian Anderson <>"
          "tbu- <>"
          "Manish Goregaokar <>"
          "Aaron Turon <aturon@mozilla.com>"
          "Adolfo Ochagavía <>"
          "Niko Matsakis <>"
          "Steven Fackler <>"
          "Chase Southwood <csouth3@illinois.edu>"
          "Eduard Burtescu <>"
          "Florian Wilkens <>"
          "Félix Raimundo <>"
          "Tibor Benke <>"
          "Markus Siemens <markus@m-siemens.de>"
          "Josh Branchaud <jbranchaud@gmail.com>"
          "Huon Wilson <dbau.pp@gmail.com>"
          "Corey Farwell <coref@rwell.org>"
          "Aaron Liblong <>"
          "Nick Cameron <nrc@ncameron.org>"
          "Patrick Walton <pcwalton@mimiga.net>"
          "Felix S Klock II <>"
          "Andrew Paseltiner <apaseltiner@gmail.com>"
          "Sean McArthur <sean.monstar@gmail.com>"
          "Vadim Petrochenkov <>"
        ];
        features = {
          "eders" = [ "serde" ];
        };
      };
      "version_check" = rec {
        crateName = "version_check";
        version = "0.9.3";
        edition = "2015";
        sha256 = "1zmkcgj2m0pq0l4wnhrp1wl1lygf7x2h5p7pvjwc4719lnlxrv2z";
        authors = [
          "Sergio Benitez <sb@sergio.bz>"
        ];

      };
      "want" = rec {
        crateName = "want";
        version = "0.3.0";
        edition = "2018";
        sha256 = "181b2zmwfq389x9n2g1n37cvcvvdand832zz6v8i1l8wrdlaks0w";
        authors = [
          "Sean McArthur <sean@seanmonstar.com>"
        ];
        dependencies = [
          {
            name = "log";
            packageId = "log";
          }
          {
            name = "try-lock";
            packageId = "try-lock";
          }
        ];

      };
      "wasi" = rec {
        crateName = "wasi";
        version = "0.10.2+wasi-snapshot-preview1";
        edition = "2018";
        sha256 = "1ii7nff4y1mpcrxzzvbpgxm7a1nn3szjf1n21jnx37c2g6dbsvzx";
        authors = [
          "The Cranelift Project Developers"
        ];
        features = {
          "default" = [ "std" ];
          "rustc-dep-of-std" = [ "compiler_builtins" "core" "rustc-std-workspace-alloc" ];
        };
        resolvedDefaultFeatures = [ "default" "std" ];
      };
      "which" = rec {
        crateName = "which";
        version = "4.1.0";
        edition = "2018";
        sha256 = "1zixp9631knhnvd8c3si4wn01fldq063s86jxlmwxwmx5kj52mdm";
        authors = [
          "Harry Fei <tiziyuanfang@gmail.com>"
        ];
        dependencies = [
          {
            name = "either";
            packageId = "either";
          }
          {
            name = "libc";
            packageId = "libc";
          }
        ];

      };
      "winapi" = rec {
        crateName = "winapi";
        version = "0.3.9";
        edition = "2015";
        sha256 = "06gl025x418lchw1wxj64ycr7gha83m44cjr5sarhynd9xkrm0sw";
        authors = [
          "Peter Atashian <retep998@gmail.com>"
        ];
        dependencies = [
          {
            name = "winapi-i686-pc-windows-gnu";
            packageId = "winapi-i686-pc-windows-gnu";
            target = { target, features }: (stdenv.hostPlatform.config == "i686-pc-windows-gnu");
          }
          {
            name = "winapi-x86_64-pc-windows-gnu";
            packageId = "winapi-x86_64-pc-windows-gnu";
            target = { target, features }: (stdenv.hostPlatform.config == "x86_64-pc-windows-gnu");
          }
        ];
        features = {
          "debug" = [ "impl-debug" ];
        };
        resolvedDefaultFeatures = [ "cfg" "consoleapi" "errhandlingapi" "evntrace" "fileapi" "handleapi" "in6addr" "inaddr" "ioapiset" "minwinbase" "minwindef" "mstcpip" "mswsock" "namedpipeapi" "ntdef" "ntsecapi" "ntstatus" "processenv" "std" "synchapi" "winbase" "wincon" "windef" "winerror" "winioctl" "winnt" "winsock2" "ws2def" "ws2ipdef" "ws2tcpip" ];
      };
      "winapi-i686-pc-windows-gnu" = rec {
        crateName = "winapi-i686-pc-windows-gnu";
        version = "0.4.0";
        edition = "2015";
        sha256 = "1dmpa6mvcvzz16zg6d5vrfy4bxgg541wxrcip7cnshi06v38ffxc";
        authors = [
          "Peter Atashian <retep998@gmail.com>"
        ];

      };
      "winapi-util" = rec {
        crateName = "winapi-util";
        version = "0.1.5";
        edition = "2018";
        sha256 = "0y71bp7f6d536czj40dhqk0d55wfbbwqfp2ymqf1an5ibgl6rv3h";
        authors = [
          "Andrew Gallant <jamslam@gmail.com>"
        ];
        dependencies = [
          {
            name = "winapi";
            packageId = "winapi";
            target = { target, features }: (target."windows" or false);
            features = [ "std" "consoleapi" "errhandlingapi" "fileapi" "minwindef" "processenv" "winbase" "wincon" "winerror" "winnt" ];
          }
        ];

      };
      "winapi-x86_64-pc-windows-gnu" = rec {
        crateName = "winapi-x86_64-pc-windows-gnu";
        version = "0.4.0";
        edition = "2015";
        sha256 = "0gqq64czqb64kskjryj8isp62m2sgvx25yyj3kpc2myh85w24bki";
        authors = [
          "Peter Atashian <retep998@gmail.com>"
        ];

      };
    };

    #
# crate2nix/default.nix (excerpt start)
#

  /* Target (platform) data for conditional dependencies.
     This corresponds roughly to what buildRustCrate is setting.
  */
  defaultTarget = {
    unix = true;
    windows = false;
    fuchsia = true;
    test = false;

    # This doesn't appear to be officially documented anywhere yet.
    # See https://github.com/rust-lang-nursery/rust-forge/issues/101.
    os =
      if stdenv.hostPlatform.isDarwin
      then "macos"
      else stdenv.hostPlatform.parsed.kernel.name;
    arch = stdenv.hostPlatform.parsed.cpu.name;
    family = "unix";
    env = "gnu";
    endian =
      if stdenv.hostPlatform.parsed.cpu.significantByte.name == "littleEndian"
      then "little" else "big";
    pointer_width = toString stdenv.hostPlatform.parsed.cpu.bits;
    vendor = stdenv.hostPlatform.parsed.vendor.name;
    debug_assertions = false;
  };

  /* Filters common temp files and build files. */
  # TODO(pkolloch): Substitute with gitignore filter
  sourceFilter = name: type:
    let
      baseName = builtins.baseNameOf (builtins.toString name);
    in
      ! (
        # Filter out git
        baseName == ".gitignore"
        || (type == "directory" && baseName == ".git")

        # Filter out build results
        || (
          type == "directory" && (
            baseName == "target"
            || baseName == "_site"
            || baseName == ".sass-cache"
            || baseName == ".jekyll-metadata"
            || baseName == "build-artifacts"
          )
        )

        # Filter out nix-build result symlinks
        || (
          type == "symlink" && lib.hasPrefix "result" baseName
        )

        # Filter out IDE config
        || (
          type == "directory" && (
            baseName == ".idea" || baseName == ".vscode"
          )
        ) || lib.hasSuffix ".iml" baseName

        # Filter out nix build files
        || baseName == "Cargo.nix"

        # Filter out editor backup / swap files.
        || lib.hasSuffix "~" baseName
        || builtins.match "^\\.sw[a-z]$$" baseName != null
        || builtins.match "^\\..*\\.sw[a-z]$$" baseName != null
        || lib.hasSuffix ".tmp" baseName
        || lib.hasSuffix ".bak" baseName
        || baseName == "tests.nix"
      );

  /* Returns a crate which depends on successful test execution
     of crate given as the second argument.

     testCrateFlags: list of flags to pass to the test exectuable
     testInputs: list of packages that should be available during test execution
  */
  crateWithTest = { crate, testCrate, testCrateFlags, testInputs }:
    assert builtins.typeOf testCrateFlags == "list";
    assert builtins.typeOf testInputs == "list";
    let
      # override the `crate` so that it will build and execute tests instead of
      # building the actual lib and bin targets We just have to pass `--test`
      # to rustc and it will do the right thing.  We execute the tests and copy
      # their log and the test executables to $out for later inspection.
      test =
        let
          drv = testCrate.override
            (
              _: {
                buildTests = true;
              }
            );
        in
        pkgs.runCommand "run-tests-${testCrate.name}"
          {
            inherit testCrateFlags;
            buildInputs = testInputs;
          } ''
          set -ex

          export RUST_BACKTRACE=1

          # recreate a file hierarchy as when running tests with cargo

          # the source for test data
          ${pkgs.xorg.lndir}/bin/lndir ${crate.src}

          # build outputs
          testRoot=target/debug
          mkdir -p $testRoot

          # executables of the crate
          # we copy to prevent std::env::current_exe() to resolve to a store location
          for i in ${crate}/bin/*; do
            cp "$i" "$testRoot"
          done
          chmod +w -R .

          # test harness executables are suffixed with a hash, like cargo does
          # this allows to prevent name collision with the main
          # executables of the crate
          hash=$(basename $out)
          for file in ${drv}/tests/*; do
            f=$testRoot/$(basename $file)-$hash
            cp $file $f
            $f $testCrateFlags 2>&1 | tee -a $out
          done
        '';
    in
    pkgs.runCommand "${crate.name}-linked"
      {
        inherit (crate) outputs crateName;
        passthru = (crate.passthru or { }) // {
          inherit test;
        };
      } ''
      echo tested by ${test}
      ${lib.concatMapStringsSep "\n" (output: "ln -s ${crate.${output}} ${"$"}${output}") crate.outputs}
    '';

  /* A restricted overridable version of builtRustCratesWithFeatures. */
  buildRustCrateWithFeatures =
    { packageId
    , features ? rootFeatures
    , crateOverrides ? defaultCrateOverrides
    , buildRustCrateForPkgsFunc ? null
    , runTests ? false
    , testCrateFlags ? [ ]
    , testInputs ? [ ]
    }:
    lib.makeOverridable
      (
        { features
        , crateOverrides
        , runTests
        , testCrateFlags
        , testInputs
        }:
        let
          buildRustCrateForPkgsFuncOverriden =
            if buildRustCrateForPkgsFunc != null
            then buildRustCrateForPkgsFunc
            else
              (
                if crateOverrides == pkgs.defaultCrateOverrides
                then buildRustCrateForPkgs
                else
                  pkgs: (buildRustCrateForPkgs pkgs).override {
                    defaultCrateOverrides = crateOverrides;
                  }
              );
          builtRustCrates = builtRustCratesWithFeatures {
            inherit packageId features;
            buildRustCrateForPkgsFunc = buildRustCrateForPkgsFuncOverriden;
            runTests = false;
          };
          builtTestRustCrates = builtRustCratesWithFeatures {
            inherit packageId features;
            buildRustCrateForPkgsFunc = buildRustCrateForPkgsFuncOverriden;
            runTests = true;
          };
          drv = builtRustCrates.crates.${packageId};
          testDrv = builtTestRustCrates.crates.${packageId};
          derivation =
            if runTests then
              crateWithTest
                {
                  crate = drv;
                  testCrate = testDrv;
                  inherit testCrateFlags testInputs;
                }
            else drv;
        in
        derivation
      )
      { inherit features crateOverrides runTests testCrateFlags testInputs; };

  /* Returns an attr set with packageId mapped to the result of buildRustCrateForPkgsFunc
     for the corresponding crate.
  */
  builtRustCratesWithFeatures =
    { packageId
    , features
    , crateConfigs ? crates
    , buildRustCrateForPkgsFunc
    , runTests
    , target ? defaultTarget
    } @ args:
      assert (builtins.isAttrs crateConfigs);
      assert (builtins.isString packageId);
      assert (builtins.isList features);
      assert (builtins.isAttrs target);
      assert (builtins.isBool runTests);
      let
        rootPackageId = packageId;
        mergedFeatures = mergePackageFeatures
          (
            args // {
              inherit rootPackageId;
              target = target // { test = runTests; };
            }
          );
        # Memoize built packages so that reappearing packages are only built once.
        builtByPackageIdByPkgs = mkBuiltByPackageIdByPkgs pkgs;
        mkBuiltByPackageIdByPkgs = pkgs:
          let
            self = {
              crates = lib.mapAttrs (packageId: value: buildByPackageIdForPkgsImpl self pkgs packageId) crateConfigs;
              build = mkBuiltByPackageIdByPkgs pkgs.buildPackages;
            };
          in
          self;
        buildByPackageIdForPkgsImpl = self: pkgs: packageId:
          let
            features = mergedFeatures."${packageId}" or [ ];
            crateConfig' = crateConfigs."${packageId}";
            crateConfig =
              builtins.removeAttrs crateConfig' [ "resolvedDefaultFeatures" "devDependencies" ];
            devDependencies =
              lib.optionals
                (runTests && packageId == rootPackageId)
                (crateConfig'.devDependencies or [ ]);
            dependencies =
              dependencyDerivations {
                inherit features target;
                buildByPackageId = depPackageId:
                  # proc_macro crates must be compiled for the build architecture
                  if crateConfigs.${depPackageId}.procMacro or false
                  then self.build.crates.${depPackageId}
                  else self.crates.${depPackageId};
                dependencies =
                  (crateConfig.dependencies or [ ])
                  ++ devDependencies;
              };
            buildDependencies =
              dependencyDerivations {
                inherit features target;
                buildByPackageId = depPackageId:
                  self.build.crates.${depPackageId};
                dependencies = crateConfig.buildDependencies or [ ];
              };
            filterEnabledDependenciesForThis = dependencies: filterEnabledDependencies {
              inherit dependencies features target;
            };
            dependenciesWithRenames =
              lib.filter (d: d ? "rename")
                (
                  filterEnabledDependenciesForThis
                    (
                      (crateConfig.buildDependencies or [ ])
                      ++ (crateConfig.dependencies or [ ])
                      ++ devDependencies
                    )
                );
            # Crate renames have the form:
            #
            # {
            #    crate_name = [
            #       { version = "1.2.3"; rename = "crate_name01"; }
            #    ];
            #    # ...
            # }
            crateRenames =
              let
                grouped =
                  lib.groupBy
                    (dependency: dependency.name)
                    dependenciesWithRenames;
                versionAndRename = dep:
                  let
                    package = crateConfigs."${dep.packageId}";
                  in
                  { inherit (dep) rename; version = package.version; };
              in
              lib.mapAttrs (name: choices: builtins.map versionAndRename choices) grouped;
          in
          buildRustCrateForPkgsFunc pkgs
            (
              crateConfig // {
                src = crateConfig.src or (
                  pkgs.fetchurl rec {
                    name = "${crateConfig.crateName}-${crateConfig.version}.tar.gz";
                    # https://www.pietroalbini.org/blog/downloading-crates-io/
                    # Not rate-limited, CDN URL.
                    url = "https://static.crates.io/crates/${crateConfig.crateName}/${crateConfig.crateName}-${crateConfig.version}.crate";
                    sha256 =
                      assert (lib.assertMsg (crateConfig ? sha256) "Missing sha256 for ${name}");
                      crateConfig.sha256;
                  }
                );
                extraRustcOpts = lib.lists.optional (targetFeatures != [ ]) "-C target-feature=${lib.concatMapStringsSep "," (x: "+${x}") targetFeatures}";
                inherit features dependencies buildDependencies crateRenames release;
              }
            );
      in
      builtByPackageIdByPkgs;

  /* Returns the actual derivations for the given dependencies. */
  dependencyDerivations =
    { buildByPackageId
    , features
    , dependencies
    , target
    }:
      assert (builtins.isList features);
      assert (builtins.isList dependencies);
      assert (builtins.isAttrs target);
      let
        enabledDependencies = filterEnabledDependencies {
          inherit dependencies features target;
        };
        depDerivation = dependency: buildByPackageId dependency.packageId;
      in
      map depDerivation enabledDependencies;

  /* Returns a sanitized version of val with all values substituted that cannot
     be serialized as JSON.
  */
  sanitizeForJson = val:
    if builtins.isAttrs val
    then lib.mapAttrs (n: v: sanitizeForJson v) val
    else if builtins.isList val
    then builtins.map sanitizeForJson val
    else if builtins.isFunction val
    then "function"
    else val;

  /* Returns various tools to debug a crate. */
  debugCrate = { packageId, target ? defaultTarget }:
    assert (builtins.isString packageId);
    let
      debug = rec {
        # The built tree as passed to buildRustCrate.
        buildTree = buildRustCrateWithFeatures {
          buildRustCrateForPkgsFunc = _: lib.id;
          inherit packageId;
        };
        sanitizedBuildTree = sanitizeForJson buildTree;
        dependencyTree = sanitizeForJson
          (
            buildRustCrateWithFeatures {
              buildRustCrateForPkgsFunc = _: crate: {
                "01_crateName" = crate.crateName or false;
                "02_features" = crate.features or [ ];
                "03_dependencies" = crate.dependencies or [ ];
              };
              inherit packageId;
            }
          );
        mergedPackageFeatures = mergePackageFeatures {
          features = rootFeatures;
          inherit packageId target;
        };
        diffedDefaultPackageFeatures = diffDefaultPackageFeatures {
          inherit packageId target;
        };
      };
    in
    { internal = debug; };

  /* Returns differences between cargo default features and crate2nix default
     features.

     This is useful for verifying the feature resolution in crate2nix.
  */
  diffDefaultPackageFeatures =
    { crateConfigs ? crates
    , packageId
    , target
    }:
      assert (builtins.isAttrs crateConfigs);
      let
        prefixValues = prefix: lib.mapAttrs (n: v: { "${prefix}" = v; });
        mergedFeatures =
          prefixValues
            "crate2nix"
            (mergePackageFeatures { inherit crateConfigs packageId target; features = [ "default" ]; });
        configs = prefixValues "cargo" crateConfigs;
        combined = lib.foldAttrs (a: b: a // b) { } [ mergedFeatures configs ];
        onlyInCargo =
          builtins.attrNames
            (lib.filterAttrs (n: v: !(v ? "crate2nix") && (v ? "cargo")) combined);
        onlyInCrate2Nix =
          builtins.attrNames
            (lib.filterAttrs (n: v: (v ? "crate2nix") && !(v ? "cargo")) combined);
        differentFeatures = lib.filterAttrs
          (
            n: v:
              (v ? "crate2nix")
              && (v ? "cargo")
              && (v.crate2nix.features or [ ]) != (v."cargo".resolved_default_features or [ ])
          )
          combined;
      in
      builtins.toJSON {
        inherit onlyInCargo onlyInCrate2Nix differentFeatures;
      };

  /* Returns an attrset mapping packageId to the list of enabled features.

     If multiple paths to a dependency enable different features, the
     corresponding feature sets are merged. Features in rust are additive.
  */
  mergePackageFeatures =
    { crateConfigs ? crates
    , packageId
    , rootPackageId ? packageId
    , features ? rootFeatures
    , dependencyPath ? [ crates.${packageId}.crateName ]
    , featuresByPackageId ? { }
    , target
      # Adds devDependencies to the crate with rootPackageId.
    , runTests ? false
    , ...
    } @ args:
      assert (builtins.isAttrs crateConfigs);
      assert (builtins.isString packageId);
      assert (builtins.isString rootPackageId);
      assert (builtins.isList features);
      assert (builtins.isList dependencyPath);
      assert (builtins.isAttrs featuresByPackageId);
      assert (builtins.isAttrs target);
      assert (builtins.isBool runTests);
      let
        crateConfig = crateConfigs."${packageId}" or (builtins.throw "Package not found: ${packageId}");
        expandedFeatures = expandFeatures (crateConfig.features or { }) features;
        depWithResolvedFeatures = dependency:
          let
            packageId = dependency.packageId;
            features = dependencyFeatures expandedFeatures dependency;
          in
          { inherit packageId features; };
        resolveDependencies = cache: path: dependencies:
          assert (builtins.isAttrs cache);
          assert (builtins.isList dependencies);
          let
            enabledDependencies = filterEnabledDependencies {
              inherit dependencies target;
              features = expandedFeatures;
            };
            directDependencies = map depWithResolvedFeatures enabledDependencies;
            foldOverCache = op: lib.foldl op cache directDependencies;
          in
          foldOverCache
            (
              cache: { packageId, features }:
                let
                  cacheFeatures = cache.${packageId} or [ ];
                  combinedFeatures = sortedUnique (cacheFeatures ++ features);
                in
                if cache ? ${packageId} && cache.${packageId} == combinedFeatures
                then cache
                else
                  mergePackageFeatures {
                    features = combinedFeatures;
                    featuresByPackageId = cache;
                    inherit crateConfigs packageId target runTests rootPackageId;
                  }
            );
        cacheWithSelf =
          let
            cacheFeatures = featuresByPackageId.${packageId} or [ ];
            combinedFeatures = sortedUnique (cacheFeatures ++ expandedFeatures);
          in
          featuresByPackageId // {
            "${packageId}" = combinedFeatures;
          };
        cacheWithDependencies =
          resolveDependencies cacheWithSelf "dep"
            (
              crateConfig.dependencies or [ ]
              ++ lib.optionals
                (runTests && packageId == rootPackageId)
                (crateConfig.devDependencies or [ ])
            );
        cacheWithAll =
          resolveDependencies
            cacheWithDependencies "build"
            (crateConfig.buildDependencies or [ ]);
      in
      cacheWithAll;

  /* Returns the enabled dependencies given the enabled features. */
  filterEnabledDependencies = { dependencies, features, target }:
    assert (builtins.isList dependencies);
    assert (builtins.isList features);
    assert (builtins.isAttrs target);

    lib.filter
      (
        dep:
        let
          targetFunc = dep.target or (features: true);
        in
        targetFunc { inherit features target; }
        && (
          !(dep.optional or false)
          || builtins.any (doesFeatureEnableDependency dep) features
        )
      )
      dependencies;

  /* Returns whether the given feature should enable the given dependency. */
  doesFeatureEnableDependency = { name, rename ? null, ... }: feature:
    let
      prefix = "${name}/";
      len = builtins.stringLength prefix;
      startsWithPrefix = builtins.substring 0 len feature == prefix;
    in
    (rename == null && feature == name)
    || (rename != null && rename == feature)
    || startsWithPrefix;

  /* Returns the expanded features for the given inputFeatures by applying the
     rules in featureMap.

     featureMap is an attribute set which maps feature names to lists of further
     feature names to enable in case this feature is selected.
  */
  expandFeatures = featureMap: inputFeatures:
    assert (builtins.isAttrs featureMap);
    assert (builtins.isList inputFeatures);
    let
      expandFeature = feature:
        assert (builtins.isString feature);
        [ feature ] ++ (expandFeatures featureMap (featureMap."${feature}" or [ ]));
      outFeatures = lib.concatMap expandFeature inputFeatures;
    in
    sortedUnique outFeatures;

  /*
     Returns the actual features for the given dependency.

     features: The features of the crate that refers this dependency.
  */
  dependencyFeatures = features: dependency:
    assert (builtins.isList features);
    assert (builtins.isAttrs dependency);
    let
      defaultOrNil =
        if dependency.usesDefaultFeatures or true
        then [ "default" ]
        else [ ];
      explicitFeatures = dependency.features or [ ];
      additionalDependencyFeatures =
        let
          dependencyPrefix = (dependency.rename or dependency.name) + "/";
          dependencyFeatures =
            builtins.filter (f: lib.hasPrefix dependencyPrefix f) features;
        in
        builtins.map (lib.removePrefix dependencyPrefix) dependencyFeatures;
    in
    defaultOrNil ++ explicitFeatures ++ additionalDependencyFeatures;

  /* Sorts and removes duplicates from a list of strings. */
  sortedUnique = features:
    assert (builtins.isList features);
    assert (builtins.all builtins.isString features);
    let
      outFeaturesSet = lib.foldl (set: feature: set // { "${feature}" = 1; }) { } features;
      outFeaturesUnique = builtins.attrNames outFeaturesSet;
    in
    builtins.sort (a: b: a < b) outFeaturesUnique;

  deprecationWarning = message: value:
    if strictDeprecation
    then builtins.throw "strictDeprecation enabled, aborting: ${message}"
    else builtins.trace message value;

  #
  # crate2nix/default.nix (excerpt end)
  #

  };
}