use serde::{Deserialize, Serialize};

#[derive(Serialize, Deserialize)]
pub struct ApiResponse {
    pub collection: Collection,
}

/// Top level layer of a Postman collection
#[derive(Serialize, Deserialize)]
pub struct Collection {
    /// Name and description of the collection
    pub info: Info,
    /// Can be a folder, request or response
    pub item: Vec<Item>,
    /// The authentication method used
    pub auth: Auth,
    pub event: Vec<Event>,
    pub variable: Option<Vec<Variable>>,
}

#[derive(Serialize, Deserialize)]
pub struct Info {
    pub name: String,
    pub description: String,
}

#[derive(Serialize, Deserialize)]
pub struct Item {
    pub description: Option<String>,
    pub name: String,
    pub item: Option<Vec<Item>>,
    pub request: Option<Request>,
    #[serde(rename = "response")]
    pub responses: Option<Vec<Response>>,
}

#[derive(Serialize, Deserialize)]
pub struct Request {
    pub method: String,
    pub header: Vec<Header>,
    pub body: Option<Body>,
    pub description: Option<String>,
    pub url: Option<Url>,
}

#[derive(Serialize, Deserialize)]
pub struct Response {
    pub name: String,
    #[serde(rename = "originalRequest")]
    pub original_request: Request,
    pub status: String,
    pub code: i32,
    #[serde(rename = "_postman_previewlanguage")]
    pub preview_language: String,
    pub header: Vec<Header>,
    pub cookie: Vec<Cookie>,
    pub body: String,
}

#[derive(Serialize, Deserialize)]
pub struct Cookie {
    name: String,
}

#[derive(Serialize, Deserialize)]
pub struct Body {
    pub mode: String,
    pub raw: String,
    pub options: Option<Options>,
}

#[derive(Serialize, Deserialize)]
pub struct Options {
    pub raw: Option<Raw>,
}

#[derive(Serialize, Deserialize)]
pub struct Raw {
    pub language: String,
}

#[derive(Serialize, Deserialize)]
pub struct Header {
    pub description: Option<String>,
    pub key: String,
    pub value: String,
}

#[derive(Serialize, Deserialize)]
pub struct Url {
    pub raw: String,
    pub host: Vec<String>,
    pub path: Vec<String>,
    pub query: Option<Vec<Query>>,
}

#[derive(Serialize, Deserialize)]
pub struct Query {
    pub key: String,
    pub value: String,
}

#[derive(Serialize, Deserialize)]
pub struct Auth {
    #[serde(rename = "type")]
    pub auth_type: String,
    pub bearer: Vec<Bearer>,
}

#[derive(Serialize, Deserialize)]
pub struct Bearer {
    pub key: String,
    pub value: String,
    #[serde(rename = "type")]
    pub bearer_type: String,
}

#[derive(Serialize, Deserialize)]
pub struct Event {
    pub listen: String,
    pub script: Script,
}

#[derive(Serialize, Deserialize)]
pub struct Script {
    #[serde(rename = "type")]
    script_type: String,
    exec: Vec<String>,
}

#[derive(Serialize, Deserialize)]
pub struct Variable {
    pub key: String,
    pub value: String,
}
