use crate::postman::{Item, Request, Response};
use pulldown_cmark::{html, Parser};

fn remove_braces(text: &String) -> String {
    if text.contains("{") {
        let mut fixed_text: String;
        fixed_text = text.replace("{", "");
        fixed_text = fixed_text.replace("}", "");
        fixed_text
    } else {
        text.to_string()
    }
}

fn wrap_literal(text: &String) -> String {
    let mut fixed_text = r#"{`"#.to_string();
    fixed_text.push_str(&text);
    fixed_text.push_str(r#"`}"#);
    fixed_text
}

pub fn folder(folder: &Item, loop_iter: i8) -> (String, String) {
    let mut html_output = "".to_string();
    if let Some(description) = &folder.description {
        let parser = Parser::new(description);
        html::push_html(&mut html_output, parser);
    }

    let folder_markup = format!(
        "<h{} id={}>{}</h{}>\n<div class='p-container'>{}</div>\n",
        loop_iter,
        wrap_literal(&folder.name),
        remove_braces(&folder.name),
        loop_iter,
        html_output,
    );

    let link = format!(
        "<a href='#{}' class='a{}'>{}</a>\n",
        remove_braces(&folder.name),
        loop_iter,
        remove_braces(&folder.name)
    );

    return (folder_markup, link);
}

pub fn rest_header(name: &String) -> String {
    format!(
        "<h3 class='rest-headers' id={}>{}</h3>\n",
        wrap_literal(&name),
        remove_braces(&name)
    )
}

pub fn request(item: &Item, request: &Request) -> String {
    let mut result = rest_header(&item.name);
    // let mut path = String::new();
    // if let Some(url) = &request.url {
    //     if let Some((raw, _)) = url.raw.split_once('?') {
    //         path.push_str(&raw);
    //     } else {
    //         path.push_str(&url.raw);
    //     }
    // }

    if let Some(description) = &request.description {
        let mut html_output = String::new();
        let parser = Parser::new(description);
        html::push_html(&mut html_output, parser);
        result.push_str(&html_output);
    }

    if let Some(body) = &request.body {
        result.push_str(&format!(
            "<pre><code>{}</code></pre>",
            &wrap_literal(&body.raw)
        ));
    }

    result
}

pub fn response(responses: &Vec<Response>) -> String {
    let mut responses_markup = String::new();
    for response in responses {
        let response_markup = format!(
            "<h6>{}</h6>\n<pre><code>{}</code></pre>",
            response.name,
            wrap_literal(&response.body)
        );
        responses_markup.push_str(&response_markup);
    }
    responses_markup
}
