use std::fs;

#[derive(serde::Deserialize)]
pub struct Settings {
    pub collection_from_api: bool,
    pub postman_api_key: String,
    pub collection_id: String,
    pub collection_path: String,
    pub backup_collection: bool,
    pub backup_path: String,
}

pub fn get_configuration() -> Settings {
    let mut path = "./config.yaml".to_string();
    if let Some(dir) = dirs::config_dir() {
        let mut custom_config = dir.to_string_lossy().to_string();
        custom_config.push_str("/postport/config.yaml");
        if fs::metadata(&custom_config).is_ok() {
            path = custom_config;
        }
    }
    serde_yaml::from_str(&fs::read_to_string(path).expect("Unable to read file"))
        .expect("YAML is not well-formatted")
}
