use cqrs_es2::{
    Aggregate,
    AggregateContext,
};

/// Holds context for a pure event store implementation for MemStore
pub struct PostgresStoreAggregateContext<A: Aggregate> {
    /// The aggregate ID of the aggregate instance that has been
    /// loaded.
    pub aggregate_id: String,
    /// The current state of the aggregate instance.
    pub aggregate: A,
    /// The last committed event sequence number for this aggregate
    /// instance.
    pub current_sequence: usize,
}

impl<A: Aggregate> AggregateContext<A>
    for PostgresStoreAggregateContext<A>
{
    fn aggregate(&self) -> &A {
        &self.aggregate
    }
}
