#![forbid(unsafe_code)]
#![deny(missing_docs)]
#![deny(clippy::all)]
// #![warn(clippy::pedantic)]

//! # postgres-es2
//!
//! **A Postgres implementation of the `EventStore` trait in
//! cqrs-es2.**
//!
//! [![Publish](https://github.com/brgirgis/postgres-es2/actions/workflows/crates-io.yml/badge.svg)](https://github.com/brgirgis/postgres-es2/actions/workflows/crates-io.yml)
//! [![Test](https://github.com/brgirgis/postgres-es2/actions/workflows/rust-ci.yml/badge.svg)](https://github.com/brgirgis/postgres-es2/actions/workflows/rust-ci.yml)
//! [![Crates.io](https://img.shields.io/crates/v/postgres-es2)](https://crates.io/crates/postgres-es2)
//! [![docs](https://img.shields.io/badge/API-docs-blue.svg)](https://docs.rs/postgres-es2)
//!
//! ## Installation
//!
//! ```toml
//! [dependencies]
//! cqrs-es2 = "^0.2"
//! serde = { version = "^1.0.127", features = ["derive"] }
//! serde_json = "^1.0.66"
//! postgres-es2 = "0.2.3"
//! postgres = { version = "^0.19.1", features = ["with-serde_json-1"] }
//! ```

pub use crate::{
    aggregates::*,
    framework::*,
    queries::*,
    stores::*,
};

mod aggregates;
mod framework;
mod queries;
mod stores;
