use cqrs_es2::{
    Aggregate,
    CqrsFramework,
    QueryProcessor,
};
use postgres::Client;

use crate::aggregates::{
    PostgresSnapshotStore,
    PostgresSnapshotStoreAggregateContext,
};

/// A convenience type for creating a CqrsFramework backed by
/// PostgresSnapshotStore and using a simple metadata supplier with
/// time of commit.
pub type PostgresSnapshotCqrs<A> = CqrsFramework<
    A,
    PostgresSnapshotStore<A>,
    PostgresSnapshotStoreAggregateContext<A>,
>;

/// A convenience function for creating a CqrsFramework using a
/// snapshot store
pub fn postgres_snapshot_cqrs<A>(
    conn: Client,
    query_processor: Vec<Box<dyn QueryProcessor<A>>>,
) -> PostgresSnapshotCqrs<A>
where
    A: Aggregate, {
    let store = PostgresSnapshotStore::new(conn);
    CqrsFramework::new(store, query_processor)
}
