use postgres::Client;

use cqrs_es2::{
    Aggregate,
    CqrsFramework,
    QueryProcessor,
};

use crate::stores::{
    PostgresStore,
    PostgresStoreAggregateContext,
};

/// A convenience type for creating a CqrsFramework backed by
/// PostgresStore and using a simple metadata supplier with time of
/// commit.
pub type PostgresCqrs<A> = CqrsFramework<
    A,
    PostgresStore<A>,
    PostgresStoreAggregateContext<A>,
>;

/// A convenience function for creating a CqrsFramework
pub fn postgres_cqrs<A>(
    conn: Client,
    query_processor: Vec<Box<dyn QueryProcessor<A>>>,
) -> PostgresCqrs<A>
where
    A: Aggregate, {
    let store = PostgresStore::new(conn);
    CqrsFramework::new(store, query_processor)
}
