use cqrs_es2::{
    Aggregate,
    AggregateContext,
};

/// Holds context for a pure event store implementation for MemStore
pub struct PostgresSnapshotStoreAggregateContext<A>
where
    A: Aggregate, {
    /// The aggregate ID of the aggregate instance that has been
    /// loaded.
    pub aggregate_id: String,
    /// The current state of the aggregate instance.
    aggregate: A,
    /// The last committed event sequence number for this aggregate
    /// instance.
    pub current_sequence: usize,
}

impl<A> AggregateContext<A>
    for PostgresSnapshotStoreAggregateContext<A>
where
    A: Aggregate,
{
    fn aggregate(&self) -> &A {
        &self.aggregate
    }
}

impl<A> PostgresSnapshotStoreAggregateContext<A>
where
    A: Aggregate,
{
    /// creates a new instance
    pub fn new(
        aggregate_id: String,
        aggregate: A,
        current_sequence: usize,
    ) -> PostgresSnapshotStoreAggregateContext<A> {
        PostgresSnapshotStoreAggregateContext {
            aggregate_id,
            aggregate,
            current_sequence,
        }
    }

    pub(crate) fn aggregate_copy(&self) -> A {
        let ser = serde_json::to_value(&self.aggregate).unwrap();
        serde_json::from_value(ser).unwrap()
    }
}
