# postgres-es2

**A Postgres implementation of the `EventStore` trait in cqrs-es2.**

[![Publish](https://github.com/brgirgis/postgres-es2/actions/workflows/crates-io.yml/badge.svg)](https://github.com/brgirgis/postgres-es2/actions/workflows/crates-io.yml)
[![Test](https://github.com/brgirgis/postgres-es2/actions/workflows/rust-ci.yml/badge.svg)](https://github.com/brgirgis/postgres-es2/actions/workflows/rust-ci.yml)
[![Crates.io](https://img.shields.io/crates/v/postgres-es2)](https://crates.io/crates/postgres-es2)
[![docs](https://img.shields.io/badge/API-docs-blue.svg)](https://docs.rs/postgres-es2)

---

## Installation

```toml
[dependencies]
cqrs-es2 = "^0.2"
serde = { version = "^1.0.127", features = ["derive"] }
serde_json = "^1.0.66"
postgres-es2 = "0.2.3"
postgres = { version = "^0.19.1", features = ["with-serde_json-1"] }
```

## Usage

```rust
use postgres::{Client, NoTls};
use postgres_es2::PostgresCqrs;

let connection = Client::connect("postgresql://demo_user:demo_pass@localhost:5432/demo", NoTls).unwrap();
let cqrs = postgres_es2::postgres_cqrs(connection, vec![Box::new(my_query)])
```

## Change log

### `v0.2.3`

- Fix license documentation
- Upgrade dev dependencies

### `v0.2.2`

- Rename Github repo

### `v0.2.1`

- Fix documentation

### `v0.2.0`

- Transfer of ownership
- Upgrade dependencies
- Add GitHub CI support
- Convert to a modular structure
- Automate GitHub deployment

## TODO

- Some additional framework around `GenericQueryRepository` to simplify event replay.

## Demo

A demo application [is available here](https://github.com/brgirgis/cqrs-es2-demo).
