use types as postgis;
use std::fmt::Write;
use std::fmt::Error;


pub trait Wkt {
    fn wkt(&self) -> String;
    fn write_wkt_body<W: Write>(&self, f: &mut W) -> Result<(), Error>;
}


impl Wkt for postgis::Point {    
    fn wkt(&self) -> String {
        let mut ret = "POINT".to_string();
        self.opt_z().map(|_| ret.push_str("Z"));
        self.opt_m().map(|_| ret.push_str("M"));
        ret.push_str(&format!("({} {}", self.x(), self.y()));
        self.opt_z().map(|z| ret.push_str(&format!(" {}", z)));
        self.opt_m().map(|m| ret.push_str(&format!(" {}", m)));
        ret.push_str(")");
        ret
    }
    fn write_wkt_body<W: Write>(&self, f: &mut W) -> Result<(), Error> {
        try!(write!(f, "{} {}", self.x(), self.y()));
        self.opt_z().map(|z| write!(f, " {}", z));
        self.opt_m().map(|m| write!(f, " {}", m));
        try!(write!(f, ")"));
        Ok(())
    }
}

/*
macro_rules! write_wkt {
    ($geotypetrait:ident contains $itemtype:ident) => (
        fn write_wkt_body<W: Write>(&self, f: &mut W) -> Result<(), Error>  {
            try!(w.write_u32::<LittleEndian>(self.geom.$itemname().len() as u32));
            for geom in self.geom.$itemname() {
            }
            Ok(())
        }
    )
}

write_wkt!(LINESTRING contains points);
*/
