#[derive(Debug, Copy, Clone)]
pub struct Ptr(usize);

#[derive(Debug, Copy, Clone)]
pub enum Value {
    Nil,
    Type(Ptr),
    Int(i64),
    UInt(u64),
    Range(u64, u64),
    Float(f64),
    Buf(Ptr, u64, u64),
    BufMut(Ptr),
    Str(Ptr, u64, u64),
    StrMut(Ptr),
    List(Ptr, u64, u64),
    ListMut(Ptr),
    Table(Ptr),
    Func(Ptr),
    Coro(Ptr),
    Fut(Ptr),
    Ptr(Ptr),
}

impl Default for Value {
    #[inline]
    fn default() -> Self {
       Self::Nil 
    }
}
