use crate::vm::Value;

#[derive(Debug, Copy, Clone)]
pub enum OpCode {
    Noop,
    Push,
    Pop,
    Dup,
    Add,
    Sub,
    Mul,
    Div,
    Cast,
    Get,
    Set,
    Call,
}

impl Default for OpCode {
    #[inline]
    fn default() -> Self {
        Self::Noop
    }
}

#[derive(Debug, Copy, Clone)]
pub enum Operation {
    Noop,
    Push(Value),
    Pop,
    Dup(u8),
    Add,
    Sub,
    Mul,
    Div,
    Cast,
    Get,
    Set,
    Call(u8, u8),
}

impl Default for Operation {
    #[inline]
    fn default() -> Self {
        Self::Noop
    }
}
