/*
 * positron - parse and execute boolean expressions
 * Copyright (C) 2021 DevHyperCoder
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

use std::fmt::{self, Display};

#[derive(Debug)]
pub enum Error {
    VariableNotFound(String),
    UnableToParse(String),
}

impl Display for Error {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        let err = match self {
            Error::VariableNotFound(key) => format!("Could not find a value for key: {}", key),
            Error::UnableToParse(err) => format!("Unable to parse given expression\n{}", err),
        };

        write!(f, "{}", err)
    }
}

pub type Result<T> = std::result::Result<T, Error>;
