use anchor_lang::{prelude::{AccountInfo, Pubkey, ProgramError, next_account_info, CpiContext}, solana_program::entrypoint::ProgramResult};
use ntoken_solana_models::error::PortfolioError;

pub fn create_miner_fn( accounts: &[AccountInfo],
    program_id: &Pubkey,
    bump: u8,
    nonce: u8)->ProgramResult{

    let accounts_iter = &mut accounts.iter();
    let create_account_program = next_account_info(accounts_iter)?;
    let authority_ppu = next_account_info(accounts_iter)?;
    let miner_info = next_account_info(accounts_iter)?;
    let quarry_info = next_account_info(accounts_iter)?;
    let system_program_info = next_account_info(accounts_iter)?;
    let payer_info = next_account_info(accounts_iter)?;
    let miner_vault_info = next_account_info(accounts_iter)?;
    let rewarder_info = next_account_info(accounts_iter)?;
    let token_program_info = next_account_info(accounts_iter)?;
    let token_mint_info = next_account_info(accounts_iter)?;
    let quarry_program_id_info = next_account_info(accounts_iter)?;

    /* // Check SPL token program ID.
    check_program_spl(token_program_info)?;

    // Check Quarry mine program id .
    check_program_quarry_mine(quarry_program_id_info)?;
 */
    let expected_allocated_key = Pubkey::create_program_address(
        &[&create_account_program.key.to_bytes()[..32], &[nonce]],
        program_id,
    )?;

    // Allocated key does not match the derived address
    if *authority_ppu.key != expected_allocated_key {
        return Err(ProgramError::InvalidArgument);
    }

    let seeds = &[&create_account_program.key.to_bytes()[..32], &[nonce]];
    let signer_seeds = &[&seeds[..]];
    let cpi_accounts = quarry_mine::cpi::accounts::CreateMiner {
        authority: authority_ppu.clone(),
        miner: miner_info.clone(),
        quarry: quarry_info.clone(),
        rewarder: rewarder_info.clone(),
        system_program: system_program_info.clone(),
        payer: payer_info.clone(),
        token_mint: token_mint_info.clone(),
        miner_vault: miner_vault_info.clone(),
        token_program: token_program_info.clone(),
    }; 

   let cpi_ctx =CpiContext::new_with_signer(quarry_program_id_info.clone(), cpi_accounts, signer_seeds);

    let res = quarry_mine::cpi::create_miner(cpi_ctx, bump);

    // Check the result of function create miner.
    if res.is_err() {
        return Err(PortfolioError::ErrorFromExternalTransaction.into());
    } 
Ok(())
}

