# Token-lending program

A lending protocol for the Token program on the Solana blockchain inspired by Aave and Compound.

Full documentation is available at https://spl.solana.com/token-lending

Web3 bindings are available in the `./js` directory.

### On-Chain Programs

| Cluster | Program Address |
| --- | --- |
| Mainnet Beta | [`Port7uDYB3wk6GJAw4KT1WpTeMtSu9bTcChBHkX2LfR`](https://explorer.solana.com/address/Port7uDYB3wk6GJAw4KT1WpTeMtSu9bTcChBHkX2LfR) |
| Devnet | [`LendZqTs8gn5CTSJU1jWKhKuVpjJGom45nnwPb2AMTi`](https://explorer.solana.com/address/LendZqTs8gn5CTSJU1jWKhKuVpjJGom45nnwPb2AMTi?cluster=devnet) |


## Update program run book
```
solana program set-upgrade-authority Port7uDYB3wk6GJAw4KT1WpTeMtSu9bTcChBHkX2LfR --new-upgrade-authority EsQ179Q8ESroBnnmTDmWEV4rZLkRc3yck32PqMxypE5z --keypair usb://ledger
solana program deploy ./target/deploy/port_finance_variable_rate_lending.so --program-id ../Port7uDYB3wk6GJAw4KT1WpTeMtSu9bTcChBHkX2LfR.json
solana program set-upgrade-authority Port7uDYB3wk6GJAw4KT1WpTeMtSu9bTcChBHkX2LfR --new-upgrade-authority J97XsFfGVkyi1uwy1wBnpJT9mB2KRbF8PZqnd3RihTbr
```

# dev net
fake USDC reserve: `G1CcAWGhfxhHQaivC1Sh5CWVta6P4dc7a5BDSg9ERjV1`
fake SOL reserve: `6FeVStQAGPWvfWijDHF7cTWRCi7He6vTT3ubfNhe9SPt`
