// Generated by gir (https://github.com/gtk-rs/gir @ ee37253c10af)
// from
// from gir-files (https://github.com/gtk-rs/gir-files @ 5264fd0c3183)
// DO NOT EDIT

use poppler_sys::*;
use std::env;
use std::error::Error;
use std::ffi::OsString;
use std::mem::{align_of, size_of};
use std::path::Path;
use std::process::Command;
use std::str;
use tempfile::Builder;

static PACKAGES: &[&str] = &["poppler-glib"];

#[derive(Clone, Debug)]
struct Compiler {
    pub args: Vec<String>,
}

impl Compiler {
    pub fn new() -> Result<Self, Box<dyn Error>> {
        let mut args = get_var("CC", "cc")?;
        args.push("-Wno-deprecated-declarations".to_owned());
        // For _Generic
        args.push("-std=c11".to_owned());
        // For %z support in printf when using MinGW.
        args.push("-D__USE_MINGW_ANSI_STDIO".to_owned());
        args.extend(get_var("CFLAGS", "")?);
        args.extend(get_var("CPPFLAGS", "")?);
        args.extend(pkg_config_cflags(PACKAGES)?);
        Ok(Self { args })
    }

    pub fn compile(&self, src: &Path, out: &Path) -> Result<(), Box<dyn Error>> {
        let mut cmd = self.to_command();
        cmd.arg(src);
        cmd.arg("-o");
        cmd.arg(out);
        let status = cmd.spawn()?.wait()?;
        if !status.success() {
            return Err(format!("compilation command {:?} failed, {}", &cmd, status).into());
        }
        Ok(())
    }

    fn to_command(&self) -> Command {
        let mut cmd = Command::new(&self.args[0]);
        cmd.args(&self.args[1..]);
        cmd
    }
}

fn get_var(name: &str, default: &str) -> Result<Vec<String>, Box<dyn Error>> {
    match env::var(name) {
        Ok(value) => Ok(shell_words::split(&value)?),
        Err(env::VarError::NotPresent) => Ok(shell_words::split(default)?),
        Err(err) => Err(format!("{} {}", name, err).into()),
    }
}

fn pkg_config_cflags(packages: &[&str]) -> Result<Vec<String>, Box<dyn Error>> {
    if packages.is_empty() {
        return Ok(Vec::new());
    }
    let pkg_config = env::var_os("PKG_CONFIG").unwrap_or_else(|| OsString::from("pkg-config"));
    let mut cmd = Command::new(pkg_config);
    cmd.arg("--cflags");
    cmd.args(packages);
    let out = cmd.output()?;
    if !out.status.success() {
        return Err(format!("command {:?} returned {}", &cmd, out.status).into());
    }
    let stdout = str::from_utf8(&out.stdout)?;
    Ok(shell_words::split(stdout.trim())?)
}

#[derive(Copy, Clone, Debug, Eq, PartialEq)]
struct Layout {
    size: usize,
    alignment: usize,
}

#[derive(Copy, Clone, Debug, Default, Eq, PartialEq)]
struct Results {
    /// Number of successfully completed tests.
    passed: usize,
    /// Total number of failed tests (including those that failed to compile).
    failed: usize,
}

impl Results {
    fn record_passed(&mut self) {
        self.passed += 1;
    }
    fn record_failed(&mut self) {
        self.failed += 1;
    }
    fn summary(&self) -> String {
        format!("{} passed; {} failed", self.passed, self.failed)
    }
    fn expect_total_success(&self) {
        if self.failed == 0 {
            println!("OK: {}", self.summary());
        } else {
            panic!("FAILED: {}", self.summary());
        };
    }
}

#[test]
fn cross_validate_constants_with_c() {
    let mut c_constants: Vec<(String, String)> = Vec::new();

    for l in get_c_output("constant").unwrap().lines() {
        let mut words = l.trim().split(';');
        let name = words.next().expect("Failed to parse name").to_owned();
        let value = words
            .next()
            .and_then(|s| s.parse().ok())
            .expect("Failed to parse value");
        c_constants.push((name, value));
    }

    let mut results = Results::default();

    for ((rust_name, rust_value), (c_name, c_value)) in
        RUST_CONSTANTS.iter().zip(c_constants.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {:?}\nC:    {:?}", rust_name, c_name,);
            continue;
        }

        if rust_value != c_value {
            results.record_failed();
            eprintln!(
                "Constant value mismatch for {}\nRust: {:?}\nC:    {:?}",
                rust_name, rust_value, &c_value
            );
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

#[test]
fn cross_validate_layout_with_c() {
    let mut c_layouts = Vec::new();

    for l in get_c_output("layout").unwrap().lines() {
        let mut words = l.trim().split(';');
        let name = words.next().expect("Failed to parse name").to_owned();
        let size = words
            .next()
            .and_then(|s| s.parse().ok())
            .expect("Failed to parse size");
        let alignment = words
            .next()
            .and_then(|s| s.parse().ok())
            .expect("Failed to parse alignment");
        c_layouts.push((name, Layout { size, alignment }));
    }

    let mut results = Results::default();

    for ((rust_name, rust_layout), (c_name, c_layout)) in RUST_LAYOUTS.iter().zip(c_layouts.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {:?}\nC:    {:?}", rust_name, c_name,);
            continue;
        }

        if rust_layout != c_layout {
            results.record_failed();
            eprintln!(
                "Layout mismatch for {}\nRust: {:?}\nC:    {:?}",
                rust_name, rust_layout, &c_layout
            );
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

fn get_c_output(name: &str) -> Result<String, Box<dyn Error>> {
    let tmpdir = Builder::new().prefix("abi").tempdir()?;
    let exe = tmpdir.path().join(name);
    let c_file = Path::new("tests").join(name).with_extension("c");

    let cc = Compiler::new().expect("configured compiler");
    cc.compile(&c_file, &exe)?;

    let mut abi_cmd = Command::new(exe);
    let output = abi_cmd.output()?;
    if !output.status.success() {
        return Err(format!("command {:?} failed, {:?}", &abi_cmd, &output).into());
    }

    Ok(String::from_utf8(output.stdout)?)
}

const RUST_LAYOUTS: &[(&str, Layout)] = &[
    (
        "PopplerAction",
        Layout {
            size: size_of::<PopplerAction>(),
            alignment: align_of::<PopplerAction>(),
        },
    ),
    (
        "PopplerActionAny",
        Layout {
            size: size_of::<PopplerActionAny>(),
            alignment: align_of::<PopplerActionAny>(),
        },
    ),
    (
        "PopplerActionGotoDest",
        Layout {
            size: size_of::<PopplerActionGotoDest>(),
            alignment: align_of::<PopplerActionGotoDest>(),
        },
    ),
    (
        "PopplerActionGotoRemote",
        Layout {
            size: size_of::<PopplerActionGotoRemote>(),
            alignment: align_of::<PopplerActionGotoRemote>(),
        },
    ),
    (
        "PopplerActionJavascript",
        Layout {
            size: size_of::<PopplerActionJavascript>(),
            alignment: align_of::<PopplerActionJavascript>(),
        },
    ),
    (
        "PopplerActionLaunch",
        Layout {
            size: size_of::<PopplerActionLaunch>(),
            alignment: align_of::<PopplerActionLaunch>(),
        },
    ),
    (
        "PopplerActionLayer",
        Layout {
            size: size_of::<PopplerActionLayer>(),
            alignment: align_of::<PopplerActionLayer>(),
        },
    ),
    (
        "PopplerActionLayerAction",
        Layout {
            size: size_of::<PopplerActionLayerAction>(),
            alignment: align_of::<PopplerActionLayerAction>(),
        },
    ),
    (
        "PopplerActionMovie",
        Layout {
            size: size_of::<PopplerActionMovie>(),
            alignment: align_of::<PopplerActionMovie>(),
        },
    ),
    (
        "PopplerActionMovieOperation",
        Layout {
            size: size_of::<PopplerActionMovieOperation>(),
            alignment: align_of::<PopplerActionMovieOperation>(),
        },
    ),
    (
        "PopplerActionNamed",
        Layout {
            size: size_of::<PopplerActionNamed>(),
            alignment: align_of::<PopplerActionNamed>(),
        },
    ),
    (
        "PopplerActionOCGState",
        Layout {
            size: size_of::<PopplerActionOCGState>(),
            alignment: align_of::<PopplerActionOCGState>(),
        },
    ),
    (
        "PopplerActionRendition",
        Layout {
            size: size_of::<PopplerActionRendition>(),
            alignment: align_of::<PopplerActionRendition>(),
        },
    ),
    (
        "PopplerActionResetForm",
        Layout {
            size: size_of::<PopplerActionResetForm>(),
            alignment: align_of::<PopplerActionResetForm>(),
        },
    ),
    (
        "PopplerActionType",
        Layout {
            size: size_of::<PopplerActionType>(),
            alignment: align_of::<PopplerActionType>(),
        },
    ),
    (
        "PopplerActionUri",
        Layout {
            size: size_of::<PopplerActionUri>(),
            alignment: align_of::<PopplerActionUri>(),
        },
    ),
    (
        "PopplerAdditionalActionType",
        Layout {
            size: size_of::<PopplerAdditionalActionType>(),
            alignment: align_of::<PopplerAdditionalActionType>(),
        },
    ),
    (
        "PopplerAnnotCalloutLine",
        Layout {
            size: size_of::<PopplerAnnotCalloutLine>(),
            alignment: align_of::<PopplerAnnotCalloutLine>(),
        },
    ),
    (
        "PopplerAnnotExternalDataType",
        Layout {
            size: size_of::<PopplerAnnotExternalDataType>(),
            alignment: align_of::<PopplerAnnotExternalDataType>(),
        },
    ),
    (
        "PopplerAnnotFlag",
        Layout {
            size: size_of::<PopplerAnnotFlag>(),
            alignment: align_of::<PopplerAnnotFlag>(),
        },
    ),
    (
        "PopplerAnnotFreeTextQuadding",
        Layout {
            size: size_of::<PopplerAnnotFreeTextQuadding>(),
            alignment: align_of::<PopplerAnnotFreeTextQuadding>(),
        },
    ),
    (
        "PopplerAnnotMapping",
        Layout {
            size: size_of::<PopplerAnnotMapping>(),
            alignment: align_of::<PopplerAnnotMapping>(),
        },
    ),
    (
        "PopplerAnnotMarkupReplyType",
        Layout {
            size: size_of::<PopplerAnnotMarkupReplyType>(),
            alignment: align_of::<PopplerAnnotMarkupReplyType>(),
        },
    ),
    (
        "PopplerAnnotTextState",
        Layout {
            size: size_of::<PopplerAnnotTextState>(),
            alignment: align_of::<PopplerAnnotTextState>(),
        },
    ),
    (
        "PopplerAnnotType",
        Layout {
            size: size_of::<PopplerAnnotType>(),
            alignment: align_of::<PopplerAnnotType>(),
        },
    ),
    (
        "PopplerAttachment",
        Layout {
            size: size_of::<PopplerAttachment>(),
            alignment: align_of::<PopplerAttachment>(),
        },
    ),
    (
        "PopplerAttachmentClass",
        Layout {
            size: size_of::<PopplerAttachmentClass>(),
            alignment: align_of::<PopplerAttachmentClass>(),
        },
    ),
    (
        "PopplerBackend",
        Layout {
            size: size_of::<PopplerBackend>(),
            alignment: align_of::<PopplerBackend>(),
        },
    ),
    (
        "PopplerColor",
        Layout {
            size: size_of::<PopplerColor>(),
            alignment: align_of::<PopplerColor>(),
        },
    ),
    (
        "PopplerDestType",
        Layout {
            size: size_of::<PopplerDestType>(),
            alignment: align_of::<PopplerDestType>(),
        },
    ),
    (
        "PopplerError",
        Layout {
            size: size_of::<PopplerError>(),
            alignment: align_of::<PopplerError>(),
        },
    ),
    (
        "PopplerFindFlags",
        Layout {
            size: size_of::<PopplerFindFlags>(),
            alignment: align_of::<PopplerFindFlags>(),
        },
    ),
    (
        "PopplerFontType",
        Layout {
            size: size_of::<PopplerFontType>(),
            alignment: align_of::<PopplerFontType>(),
        },
    ),
    (
        "PopplerFormButtonType",
        Layout {
            size: size_of::<PopplerFormButtonType>(),
            alignment: align_of::<PopplerFormButtonType>(),
        },
    ),
    (
        "PopplerFormChoiceType",
        Layout {
            size: size_of::<PopplerFormChoiceType>(),
            alignment: align_of::<PopplerFormChoiceType>(),
        },
    ),
    (
        "PopplerFormFieldMapping",
        Layout {
            size: size_of::<PopplerFormFieldMapping>(),
            alignment: align_of::<PopplerFormFieldMapping>(),
        },
    ),
    (
        "PopplerFormFieldType",
        Layout {
            size: size_of::<PopplerFormFieldType>(),
            alignment: align_of::<PopplerFormFieldType>(),
        },
    ),
    (
        "PopplerFormTextType",
        Layout {
            size: size_of::<PopplerFormTextType>(),
            alignment: align_of::<PopplerFormTextType>(),
        },
    ),
    (
        "PopplerImageMapping",
        Layout {
            size: size_of::<PopplerImageMapping>(),
            alignment: align_of::<PopplerImageMapping>(),
        },
    ),
    (
        "PopplerLinkMapping",
        Layout {
            size: size_of::<PopplerLinkMapping>(),
            alignment: align_of::<PopplerLinkMapping>(),
        },
    ),
    (
        "PopplerMoviePlayMode",
        Layout {
            size: size_of::<PopplerMoviePlayMode>(),
            alignment: align_of::<PopplerMoviePlayMode>(),
        },
    ),
    (
        "PopplerPDFConformance",
        Layout {
            size: size_of::<PopplerPDFConformance>(),
            alignment: align_of::<PopplerPDFConformance>(),
        },
    ),
    (
        "PopplerPDFPart",
        Layout {
            size: size_of::<PopplerPDFPart>(),
            alignment: align_of::<PopplerPDFPart>(),
        },
    ),
    (
        "PopplerPDFSubtype",
        Layout {
            size: size_of::<PopplerPDFSubtype>(),
            alignment: align_of::<PopplerPDFSubtype>(),
        },
    ),
    (
        "PopplerPageLayout",
        Layout {
            size: size_of::<PopplerPageLayout>(),
            alignment: align_of::<PopplerPageLayout>(),
        },
    ),
    (
        "PopplerPageMode",
        Layout {
            size: size_of::<PopplerPageMode>(),
            alignment: align_of::<PopplerPageMode>(),
        },
    ),
    (
        "PopplerPageRange",
        Layout {
            size: size_of::<PopplerPageRange>(),
            alignment: align_of::<PopplerPageRange>(),
        },
    ),
    (
        "PopplerPageTransition",
        Layout {
            size: size_of::<PopplerPageTransition>(),
            alignment: align_of::<PopplerPageTransition>(),
        },
    ),
    (
        "PopplerPageTransitionAlignment",
        Layout {
            size: size_of::<PopplerPageTransitionAlignment>(),
            alignment: align_of::<PopplerPageTransitionAlignment>(),
        },
    ),
    (
        "PopplerPageTransitionDirection",
        Layout {
            size: size_of::<PopplerPageTransitionDirection>(),
            alignment: align_of::<PopplerPageTransitionDirection>(),
        },
    ),
    (
        "PopplerPageTransitionType",
        Layout {
            size: size_of::<PopplerPageTransitionType>(),
            alignment: align_of::<PopplerPageTransitionType>(),
        },
    ),
    (
        "PopplerPermissions",
        Layout {
            size: size_of::<PopplerPermissions>(),
            alignment: align_of::<PopplerPermissions>(),
        },
    ),
    (
        "PopplerPoint",
        Layout {
            size: size_of::<PopplerPoint>(),
            alignment: align_of::<PopplerPoint>(),
        },
    ),
    (
        "PopplerPrintDuplex",
        Layout {
            size: size_of::<PopplerPrintDuplex>(),
            alignment: align_of::<PopplerPrintDuplex>(),
        },
    ),
    (
        "PopplerPrintFlags",
        Layout {
            size: size_of::<PopplerPrintFlags>(),
            alignment: align_of::<PopplerPrintFlags>(),
        },
    ),
    (
        "PopplerPrintScaling",
        Layout {
            size: size_of::<PopplerPrintScaling>(),
            alignment: align_of::<PopplerPrintScaling>(),
        },
    ),
    (
        "PopplerQuadrilateral",
        Layout {
            size: size_of::<PopplerQuadrilateral>(),
            alignment: align_of::<PopplerQuadrilateral>(),
        },
    ),
    (
        "PopplerRectangle",
        Layout {
            size: size_of::<PopplerRectangle>(),
            alignment: align_of::<PopplerRectangle>(),
        },
    ),
    (
        "PopplerSelectionStyle",
        Layout {
            size: size_of::<PopplerSelectionStyle>(),
            alignment: align_of::<PopplerSelectionStyle>(),
        },
    ),
    (
        "PopplerStructureBlockAlign",
        Layout {
            size: size_of::<PopplerStructureBlockAlign>(),
            alignment: align_of::<PopplerStructureBlockAlign>(),
        },
    ),
    (
        "PopplerStructureBorderStyle",
        Layout {
            size: size_of::<PopplerStructureBorderStyle>(),
            alignment: align_of::<PopplerStructureBorderStyle>(),
        },
    ),
    (
        "PopplerStructureElementKind",
        Layout {
            size: size_of::<PopplerStructureElementKind>(),
            alignment: align_of::<PopplerStructureElementKind>(),
        },
    ),
    (
        "PopplerStructureFormRole",
        Layout {
            size: size_of::<PopplerStructureFormRole>(),
            alignment: align_of::<PopplerStructureFormRole>(),
        },
    ),
    (
        "PopplerStructureFormState",
        Layout {
            size: size_of::<PopplerStructureFormState>(),
            alignment: align_of::<PopplerStructureFormState>(),
        },
    ),
    (
        "PopplerStructureGetTextFlags",
        Layout {
            size: size_of::<PopplerStructureGetTextFlags>(),
            alignment: align_of::<PopplerStructureGetTextFlags>(),
        },
    ),
    (
        "PopplerStructureGlyphOrientation",
        Layout {
            size: size_of::<PopplerStructureGlyphOrientation>(),
            alignment: align_of::<PopplerStructureGlyphOrientation>(),
        },
    ),
    (
        "PopplerStructureInlineAlign",
        Layout {
            size: size_of::<PopplerStructureInlineAlign>(),
            alignment: align_of::<PopplerStructureInlineAlign>(),
        },
    ),
    (
        "PopplerStructureListNumbering",
        Layout {
            size: size_of::<PopplerStructureListNumbering>(),
            alignment: align_of::<PopplerStructureListNumbering>(),
        },
    ),
    (
        "PopplerStructurePlacement",
        Layout {
            size: size_of::<PopplerStructurePlacement>(),
            alignment: align_of::<PopplerStructurePlacement>(),
        },
    ),
    (
        "PopplerStructureRubyAlign",
        Layout {
            size: size_of::<PopplerStructureRubyAlign>(),
            alignment: align_of::<PopplerStructureRubyAlign>(),
        },
    ),
    (
        "PopplerStructureRubyPosition",
        Layout {
            size: size_of::<PopplerStructureRubyPosition>(),
            alignment: align_of::<PopplerStructureRubyPosition>(),
        },
    ),
    (
        "PopplerStructureTableScope",
        Layout {
            size: size_of::<PopplerStructureTableScope>(),
            alignment: align_of::<PopplerStructureTableScope>(),
        },
    ),
    (
        "PopplerStructureTextAlign",
        Layout {
            size: size_of::<PopplerStructureTextAlign>(),
            alignment: align_of::<PopplerStructureTextAlign>(),
        },
    ),
    (
        "PopplerStructureTextDecoration",
        Layout {
            size: size_of::<PopplerStructureTextDecoration>(),
            alignment: align_of::<PopplerStructureTextDecoration>(),
        },
    ),
    (
        "PopplerStructureWritingMode",
        Layout {
            size: size_of::<PopplerStructureWritingMode>(),
            alignment: align_of::<PopplerStructureWritingMode>(),
        },
    ),
    (
        "PopplerTextAttributes",
        Layout {
            size: size_of::<PopplerTextAttributes>(),
            alignment: align_of::<PopplerTextAttributes>(),
        },
    ),
    (
        "PopplerViewerPreferences",
        Layout {
            size: size_of::<PopplerViewerPreferences>(),
            alignment: align_of::<PopplerViewerPreferences>(),
        },
    ),
];

const RUST_CONSTANTS: &[(&str, &str)] = &[
    ("(gint) POPPLER_ACTION_GOTO_DEST", "2"),
    ("(gint) POPPLER_ACTION_GOTO_REMOTE", "3"),
    ("(gint) POPPLER_ACTION_JAVASCRIPT", "10"),
    ("(gint) POPPLER_ACTION_LAUNCH", "4"),
    ("(gint) POPPLER_ACTION_LAYER_OFF", "1"),
    ("(gint) POPPLER_ACTION_LAYER_ON", "0"),
    ("(gint) POPPLER_ACTION_LAYER_TOGGLE", "2"),
    ("(gint) POPPLER_ACTION_MOVIE", "7"),
    ("(gint) POPPLER_ACTION_MOVIE_PAUSE", "1"),
    ("(gint) POPPLER_ACTION_MOVIE_PLAY", "0"),
    ("(gint) POPPLER_ACTION_MOVIE_RESUME", "2"),
    ("(gint) POPPLER_ACTION_MOVIE_STOP", "3"),
    ("(gint) POPPLER_ACTION_NAMED", "6"),
    ("(gint) POPPLER_ACTION_NONE", "1"),
    ("(gint) POPPLER_ACTION_OCG_STATE", "9"),
    ("(gint) POPPLER_ACTION_RENDITION", "8"),
    ("(gint) POPPLER_ACTION_RESET_FORM", "11"),
    ("(gint) POPPLER_ACTION_UNKNOWN", "0"),
    ("(gint) POPPLER_ACTION_URI", "5"),
    ("(gint) POPPLER_ADDITIONAL_ACTION_CALCULATE_FIELD", "3"),
    ("(gint) POPPLER_ADDITIONAL_ACTION_FIELD_MODIFIED", "0"),
    ("(gint) POPPLER_ADDITIONAL_ACTION_FORMAT_FIELD", "1"),
    ("(gint) POPPLER_ADDITIONAL_ACTION_VALIDATE_FIELD", "2"),
    ("(gint) POPPLER_ANNOT_3D", "25"),
    ("(gint) POPPLER_ANNOT_CARET", "14"),
    ("(gint) POPPLER_ANNOT_CIRCLE", "6"),
    ("(gint) POPPLER_ANNOT_EXTERNAL_DATA_MARKUP_3D", "0"),
    ("(gint) POPPLER_ANNOT_EXTERNAL_DATA_MARKUP_UNKNOWN", "1"),
    ("(gint) POPPLER_ANNOT_FILE_ATTACHMENT", "17"),
    ("(guint) POPPLER_ANNOT_FLAG_HIDDEN", "2"),
    ("(guint) POPPLER_ANNOT_FLAG_INVISIBLE", "1"),
    ("(guint) POPPLER_ANNOT_FLAG_LOCKED", "128"),
    ("(guint) POPPLER_ANNOT_FLAG_LOCKED_CONTENTS", "512"),
    ("(guint) POPPLER_ANNOT_FLAG_NO_ROTATE", "16"),
    ("(guint) POPPLER_ANNOT_FLAG_NO_VIEW", "32"),
    ("(guint) POPPLER_ANNOT_FLAG_NO_ZOOM", "8"),
    ("(guint) POPPLER_ANNOT_FLAG_PRINT", "4"),
    ("(guint) POPPLER_ANNOT_FLAG_READ_ONLY", "64"),
    ("(guint) POPPLER_ANNOT_FLAG_TOGGLE_NO_VIEW", "256"),
    ("(guint) POPPLER_ANNOT_FLAG_UNKNOWN", "0"),
    ("(gint) POPPLER_ANNOT_FREE_TEXT", "3"),
    ("(gint) POPPLER_ANNOT_FREE_TEXT_QUADDING_CENTERED", "1"),
    (
        "(gint) POPPLER_ANNOT_FREE_TEXT_QUADDING_LEFT_JUSTIFIED",
        "0",
    ),
    (
        "(gint) POPPLER_ANNOT_FREE_TEXT_QUADDING_RIGHT_JUSTIFIED",
        "2",
    ),
    ("(gint) POPPLER_ANNOT_HIGHLIGHT", "9"),
    ("(gint) POPPLER_ANNOT_INK", "15"),
    ("(gint) POPPLER_ANNOT_LINE", "4"),
    ("(gint) POPPLER_ANNOT_LINK", "2"),
    ("(gint) POPPLER_ANNOT_MARKUP_REPLY_TYPE_GROUP", "1"),
    ("(gint) POPPLER_ANNOT_MARKUP_REPLY_TYPE_R", "0"),
    ("(gint) POPPLER_ANNOT_MOVIE", "19"),
    ("(gint) POPPLER_ANNOT_POLYGON", "7"),
    ("(gint) POPPLER_ANNOT_POLY_LINE", "8"),
    ("(gint) POPPLER_ANNOT_POPUP", "16"),
    ("(gint) POPPLER_ANNOT_PRINTER_MARK", "22"),
    ("(gint) POPPLER_ANNOT_SCREEN", "21"),
    ("(gint) POPPLER_ANNOT_SOUND", "18"),
    ("(gint) POPPLER_ANNOT_SQUARE", "5"),
    ("(gint) POPPLER_ANNOT_SQUIGGLY", "11"),
    ("(gint) POPPLER_ANNOT_STAMP", "13"),
    ("(gint) POPPLER_ANNOT_STRIKE_OUT", "12"),
    ("(gint) POPPLER_ANNOT_TEXT", "1"),
    ("POPPLER_ANNOT_TEXT_ICON_CIRCLE", "Circle"),
    ("POPPLER_ANNOT_TEXT_ICON_COMMENT", "Comment"),
    ("POPPLER_ANNOT_TEXT_ICON_CROSS", "Cross"),
    ("POPPLER_ANNOT_TEXT_ICON_HELP", "Help"),
    ("POPPLER_ANNOT_TEXT_ICON_INSERT", "Insert"),
    ("POPPLER_ANNOT_TEXT_ICON_KEY", "Key"),
    ("POPPLER_ANNOT_TEXT_ICON_NEW_PARAGRAPH", "NewParagraph"),
    ("POPPLER_ANNOT_TEXT_ICON_NOTE", "Note"),
    ("POPPLER_ANNOT_TEXT_ICON_PARAGRAPH", "Paragraph"),
    ("(gint) POPPLER_ANNOT_TEXT_STATE_ACCEPTED", "2"),
    ("(gint) POPPLER_ANNOT_TEXT_STATE_CANCELLED", "4"),
    ("(gint) POPPLER_ANNOT_TEXT_STATE_COMPLETED", "5"),
    ("(gint) POPPLER_ANNOT_TEXT_STATE_MARKED", "0"),
    ("(gint) POPPLER_ANNOT_TEXT_STATE_NONE", "6"),
    ("(gint) POPPLER_ANNOT_TEXT_STATE_REJECTED", "3"),
    ("(gint) POPPLER_ANNOT_TEXT_STATE_UNKNOWN", "7"),
    ("(gint) POPPLER_ANNOT_TEXT_STATE_UNMARKED", "1"),
    ("(gint) POPPLER_ANNOT_TRAP_NET", "23"),
    ("(gint) POPPLER_ANNOT_UNDERLINE", "10"),
    ("(gint) POPPLER_ANNOT_UNKNOWN", "0"),
    ("(gint) POPPLER_ANNOT_WATERMARK", "24"),
    ("(gint) POPPLER_ANNOT_WIDGET", "20"),
    ("(gint) POPPLER_BACKEND_CAIRO", "2"),
    ("(gint) POPPLER_BACKEND_SPLASH", "1"),
    ("(gint) POPPLER_BACKEND_UNKNOWN", "0"),
    ("(gint) POPPLER_DEST_FIT", "2"),
    ("(gint) POPPLER_DEST_FITB", "6"),
    ("(gint) POPPLER_DEST_FITBH", "7"),
    ("(gint) POPPLER_DEST_FITBV", "8"),
    ("(gint) POPPLER_DEST_FITH", "3"),
    ("(gint) POPPLER_DEST_FITR", "5"),
    ("(gint) POPPLER_DEST_FITV", "4"),
    ("(gint) POPPLER_DEST_NAMED", "9"),
    ("(gint) POPPLER_DEST_UNKNOWN", "0"),
    ("(gint) POPPLER_DEST_XYZ", "1"),
    ("(gint) POPPLER_ERROR_BAD_CATALOG", "3"),
    ("(gint) POPPLER_ERROR_DAMAGED", "4"),
    ("(gint) POPPLER_ERROR_ENCRYPTED", "1"),
    ("(gint) POPPLER_ERROR_INVALID", "0"),
    ("(gint) POPPLER_ERROR_OPEN_FILE", "2"),
    ("(guint) POPPLER_FIND_BACKWARDS", "2"),
    ("(guint) POPPLER_FIND_CASE_SENSITIVE", "1"),
    ("(guint) POPPLER_FIND_DEFAULT", "0"),
    ("(guint) POPPLER_FIND_IGNORE_DIACRITICS", "8"),
    ("(guint) POPPLER_FIND_MULTILINE", "16"),
    ("(guint) POPPLER_FIND_WHOLE_WORDS_ONLY", "4"),
    ("(gint) POPPLER_FONT_TYPE_CID_TYPE0", "7"),
    ("(gint) POPPLER_FONT_TYPE_CID_TYPE0C", "8"),
    ("(gint) POPPLER_FONT_TYPE_CID_TYPE0COT", "9"),
    ("(gint) POPPLER_FONT_TYPE_CID_TYPE2", "10"),
    ("(gint) POPPLER_FONT_TYPE_CID_TYPE2OT", "11"),
    ("(gint) POPPLER_FONT_TYPE_TRUETYPE", "5"),
    ("(gint) POPPLER_FONT_TYPE_TRUETYPEOT", "6"),
    ("(gint) POPPLER_FONT_TYPE_TYPE1", "1"),
    ("(gint) POPPLER_FONT_TYPE_TYPE1C", "2"),
    ("(gint) POPPLER_FONT_TYPE_TYPE1COT", "3"),
    ("(gint) POPPLER_FONT_TYPE_TYPE3", "4"),
    ("(gint) POPPLER_FONT_TYPE_UNKNOWN", "0"),
    ("(gint) POPPLER_FORM_BUTTON_CHECK", "1"),
    ("(gint) POPPLER_FORM_BUTTON_PUSH", "0"),
    ("(gint) POPPLER_FORM_BUTTON_RADIO", "2"),
    ("(gint) POPPLER_FORM_CHOICE_COMBO", "0"),
    ("(gint) POPPLER_FORM_CHOICE_LIST", "1"),
    ("(gint) POPPLER_FORM_FIELD_BUTTON", "1"),
    ("(gint) POPPLER_FORM_FIELD_CHOICE", "3"),
    ("(gint) POPPLER_FORM_FIELD_SIGNATURE", "4"),
    ("(gint) POPPLER_FORM_FIELD_TEXT", "2"),
    ("(gint) POPPLER_FORM_FIELD_UNKNOWN", "0"),
    ("(gint) POPPLER_FORM_TEXT_FILE_SELECT", "2"),
    ("(gint) POPPLER_FORM_TEXT_MULTILINE", "1"),
    ("(gint) POPPLER_FORM_TEXT_NORMAL", "0"),
    ("POPPLER_HAS_CAIRO", "1"),
    ("(gint) POPPLER_MOVIE_PLAY_MODE_ONCE", "0"),
    ("(gint) POPPLER_MOVIE_PLAY_MODE_OPEN", "1"),
    ("(gint) POPPLER_MOVIE_PLAY_MODE_PALINDROME", "3"),
    ("(gint) POPPLER_MOVIE_PLAY_MODE_REPEAT", "2"),
    ("(gint) POPPLER_PAGE_LAYOUT_ONE_COLUMN", "2"),
    ("(gint) POPPLER_PAGE_LAYOUT_SINGLE_PAGE", "1"),
    ("(gint) POPPLER_PAGE_LAYOUT_TWO_COLUMN_LEFT", "3"),
    ("(gint) POPPLER_PAGE_LAYOUT_TWO_COLUMN_RIGHT", "4"),
    ("(gint) POPPLER_PAGE_LAYOUT_TWO_PAGE_LEFT", "5"),
    ("(gint) POPPLER_PAGE_LAYOUT_TWO_PAGE_RIGHT", "6"),
    ("(gint) POPPLER_PAGE_LAYOUT_UNSET", "0"),
    ("(gint) POPPLER_PAGE_MODE_FULL_SCREEN", "4"),
    ("(gint) POPPLER_PAGE_MODE_NONE", "1"),
    ("(gint) POPPLER_PAGE_MODE_UNSET", "0"),
    ("(gint) POPPLER_PAGE_MODE_USE_ATTACHMENTS", "6"),
    ("(gint) POPPLER_PAGE_MODE_USE_OC", "5"),
    ("(gint) POPPLER_PAGE_MODE_USE_OUTLINES", "2"),
    ("(gint) POPPLER_PAGE_MODE_USE_THUMBS", "3"),
    ("(gint) POPPLER_PAGE_TRANSITION_BLINDS", "2"),
    ("(gint) POPPLER_PAGE_TRANSITION_BOX", "3"),
    ("(gint) POPPLER_PAGE_TRANSITION_COVER", "9"),
    ("(gint) POPPLER_PAGE_TRANSITION_DISSOLVE", "5"),
    ("(gint) POPPLER_PAGE_TRANSITION_FADE", "11"),
    ("(gint) POPPLER_PAGE_TRANSITION_FLY", "7"),
    ("(gint) POPPLER_PAGE_TRANSITION_GLITTER", "6"),
    ("(gint) POPPLER_PAGE_TRANSITION_HORIZONTAL", "0"),
    ("(gint) POPPLER_PAGE_TRANSITION_INWARD", "0"),
    ("(gint) POPPLER_PAGE_TRANSITION_OUTWARD", "1"),
    ("(gint) POPPLER_PAGE_TRANSITION_PUSH", "8"),
    ("(gint) POPPLER_PAGE_TRANSITION_REPLACE", "0"),
    ("(gint) POPPLER_PAGE_TRANSITION_SPLIT", "1"),
    ("(gint) POPPLER_PAGE_TRANSITION_UNCOVER", "10"),
    ("(gint) POPPLER_PAGE_TRANSITION_VERTICAL", "1"),
    ("(gint) POPPLER_PAGE_TRANSITION_WIPE", "4"),
    ("(gint) POPPLER_PDF_SUBTYPE_CONF_A", "1"),
    ("(gint) POPPLER_PDF_SUBTYPE_CONF_B", "2"),
    ("(gint) POPPLER_PDF_SUBTYPE_CONF_G", "3"),
    ("(gint) POPPLER_PDF_SUBTYPE_CONF_N", "4"),
    ("(gint) POPPLER_PDF_SUBTYPE_CONF_NONE", "8"),
    ("(gint) POPPLER_PDF_SUBTYPE_CONF_P", "5"),
    ("(gint) POPPLER_PDF_SUBTYPE_CONF_PG", "6"),
    ("(gint) POPPLER_PDF_SUBTYPE_CONF_U", "7"),
    ("(gint) POPPLER_PDF_SUBTYPE_CONF_UNSET", "0"),
    ("(gint) POPPLER_PDF_SUBTYPE_NONE", "6"),
    ("(gint) POPPLER_PDF_SUBTYPE_PART_1", "1"),
    ("(gint) POPPLER_PDF_SUBTYPE_PART_2", "2"),
    ("(gint) POPPLER_PDF_SUBTYPE_PART_3", "3"),
    ("(gint) POPPLER_PDF_SUBTYPE_PART_4", "4"),
    ("(gint) POPPLER_PDF_SUBTYPE_PART_5", "5"),
    ("(gint) POPPLER_PDF_SUBTYPE_PART_6", "6"),
    ("(gint) POPPLER_PDF_SUBTYPE_PART_7", "7"),
    ("(gint) POPPLER_PDF_SUBTYPE_PART_8", "8"),
    ("(gint) POPPLER_PDF_SUBTYPE_PART_NONE", "9"),
    ("(gint) POPPLER_PDF_SUBTYPE_PART_UNSET", "0"),
    ("(gint) POPPLER_PDF_SUBTYPE_PDF_A", "1"),
    ("(gint) POPPLER_PDF_SUBTYPE_PDF_E", "2"),
    ("(gint) POPPLER_PDF_SUBTYPE_PDF_UA", "3"),
    ("(gint) POPPLER_PDF_SUBTYPE_PDF_VT", "4"),
    ("(gint) POPPLER_PDF_SUBTYPE_PDF_X", "5"),
    ("(gint) POPPLER_PDF_SUBTYPE_UNSET", "0"),
    ("(guint) POPPLER_PERMISSIONS_FULL", "255"),
    ("(guint) POPPLER_PERMISSIONS_OK_TO_ADD_NOTES", "8"),
    ("(guint) POPPLER_PERMISSIONS_OK_TO_ASSEMBLE", "64"),
    ("(guint) POPPLER_PERMISSIONS_OK_TO_COPY", "4"),
    ("(guint) POPPLER_PERMISSIONS_OK_TO_EXTRACT_CONTENTS", "32"),
    ("(guint) POPPLER_PERMISSIONS_OK_TO_FILL_FORM", "16"),
    ("(guint) POPPLER_PERMISSIONS_OK_TO_MODIFY", "2"),
    ("(guint) POPPLER_PERMISSIONS_OK_TO_PRINT", "1"),
    (
        "(guint) POPPLER_PERMISSIONS_OK_TO_PRINT_HIGH_RESOLUTION",
        "128",
    ),
    ("(guint) POPPLER_PRINT_ALL", "1"),
    ("(guint) POPPLER_PRINT_DOCUMENT", "0"),
    ("(gint) POPPLER_PRINT_DUPLEX_DUPLEX_FLIP_LONG_EDGE", "3"),
    ("(gint) POPPLER_PRINT_DUPLEX_DUPLEX_FLIP_SHORT_EDGE", "2"),
    ("(gint) POPPLER_PRINT_DUPLEX_NONE", "0"),
    ("(gint) POPPLER_PRINT_DUPLEX_SIMPLEX", "1"),
    ("(guint) POPPLER_PRINT_MARKUP_ANNOTS", "1"),
    ("(gint) POPPLER_PRINT_SCALING_APP_DEFAULT", "0"),
    ("(gint) POPPLER_PRINT_SCALING_NONE", "1"),
    ("(guint) POPPLER_PRINT_STAMP_ANNOTS_ONLY", "2"),
    ("(gint) POPPLER_SELECTION_GLYPH", "0"),
    ("(gint) POPPLER_SELECTION_LINE", "2"),
    ("(gint) POPPLER_SELECTION_WORD", "1"),
    ("(gint) POPPLER_STRUCTURE_BLOCK_ALIGN_AFTER", "2"),
    ("(gint) POPPLER_STRUCTURE_BLOCK_ALIGN_BEFORE", "0"),
    ("(gint) POPPLER_STRUCTURE_BLOCK_ALIGN_JUSTIFY", "3"),
    ("(gint) POPPLER_STRUCTURE_BLOCK_ALIGN_MIDDLE", "1"),
    ("(gint) POPPLER_STRUCTURE_BORDER_STYLE_DASHED", "3"),
    ("(gint) POPPLER_STRUCTURE_BORDER_STYLE_DOTTED", "2"),
    ("(gint) POPPLER_STRUCTURE_BORDER_STYLE_DOUBLE", "5"),
    ("(gint) POPPLER_STRUCTURE_BORDER_STYLE_GROOVE", "6"),
    ("(gint) POPPLER_STRUCTURE_BORDER_STYLE_HIDDEN", "1"),
    ("(gint) POPPLER_STRUCTURE_BORDER_STYLE_INSET", "7"),
    ("(gint) POPPLER_STRUCTURE_BORDER_STYLE_NONE", "0"),
    ("(gint) POPPLER_STRUCTURE_BORDER_STYLE_OUTSET", "8"),
    ("(gint) POPPLER_STRUCTURE_BORDER_STYLE_SOLID", "4"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_ANNOT", "14"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_ARTICLE", "4"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_BIBENTRY", "11"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_BLOCKQUOTE", "15"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_CAPTION", "16"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_CODE", "12"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_CONTENT", "0"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_DIV", "6"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_DOCUMENT", "2"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_FIGURE", "48"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_FORM", "50"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_FORMULA", "49"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_HEADING", "23"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_HEADING_1", "24"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_HEADING_2", "25"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_HEADING_3", "26"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_HEADING_4", "27"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_HEADING_5", "28"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_HEADING_6", "29"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_INDEX", "20"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_LINK", "13"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_LIST", "30"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_LIST_BODY", "33"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_LIST_ITEM", "31"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_LIST_LABEL", "32"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_NONSTRUCT", "17"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_NOTE", "9"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_OBJECT_REFERENCE", "1"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_PARAGRAPH", "22"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_PART", "3"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_PRIVATE", "21"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_QUOTE", "8"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_REFERENCE", "10"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_RUBY", "41"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_RUBY_ANNOT_TEXT", "43"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_RUBY_BASE_TEXT", "42"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_RUBY_PUNCTUATION", "44"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_SECTION", "5"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_SPAN", "7"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_TABLE", "34"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_TABLE_BODY", "40"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_TABLE_DATA", "37"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_TABLE_FOOTER", "39"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_TABLE_HEADER", "38"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_TABLE_HEADING", "36"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_TABLE_ROW", "35"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_TOC", "18"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_TOC_ITEM", "19"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_WARICHU", "45"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_WARICHU_PUNCTUATION", "47"),
    ("(gint) POPPLER_STRUCTURE_ELEMENT_WARICHU_TEXT", "46"),
    ("(gint) POPPLER_STRUCTURE_FORM_ROLE_CHECKBOX", "4"),
    ("(gint) POPPLER_STRUCTURE_FORM_ROLE_PUSH_BUTTON", "2"),
    ("(gint) POPPLER_STRUCTURE_FORM_ROLE_RADIO_BUTTON", "1"),
    ("(gint) POPPLER_STRUCTURE_FORM_ROLE_TEXT_VALUE", "3"),
    ("(gint) POPPLER_STRUCTURE_FORM_ROLE_UNDEFINED", "0"),
    ("(gint) POPPLER_STRUCTURE_FORM_STATE_NEUTRAL", "2"),
    ("(gint) POPPLER_STRUCTURE_FORM_STATE_OFF", "1"),
    ("(gint) POPPLER_STRUCTURE_FORM_STATE_ON", "0"),
    ("(guint) POPPLER_STRUCTURE_GET_TEXT_NONE", "0"),
    ("(guint) POPPLER_STRUCTURE_GET_TEXT_RECURSIVE", "1"),
    ("(gint) POPPLER_STRUCTURE_GLYPH_ORIENTATION_0", "0"),
    ("(gint) POPPLER_STRUCTURE_GLYPH_ORIENTATION_180", "2"),
    ("(gint) POPPLER_STRUCTURE_GLYPH_ORIENTATION_270", "3"),
    ("(gint) POPPLER_STRUCTURE_GLYPH_ORIENTATION_90", "1"),
    ("(gint) POPPLER_STRUCTURE_GLYPH_ORIENTATION_AUTO", "0"),
    ("(gint) POPPLER_STRUCTURE_INLINE_ALIGN_CENTER", "1"),
    ("(gint) POPPLER_STRUCTURE_INLINE_ALIGN_END", "2"),
    ("(gint) POPPLER_STRUCTURE_INLINE_ALIGN_START", "0"),
    ("(gint) POPPLER_STRUCTURE_LIST_NUMBERING_CIRCLE", "2"),
    ("(gint) POPPLER_STRUCTURE_LIST_NUMBERING_DECIMAL", "4"),
    ("(gint) POPPLER_STRUCTURE_LIST_NUMBERING_DISC", "1"),
    ("(gint) POPPLER_STRUCTURE_LIST_NUMBERING_LOWER_ALPHA", "8"),
    ("(gint) POPPLER_STRUCTURE_LIST_NUMBERING_LOWER_ROMAN", "6"),
    ("(gint) POPPLER_STRUCTURE_LIST_NUMBERING_NONE", "0"),
    ("(gint) POPPLER_STRUCTURE_LIST_NUMBERING_SQUARE", "3"),
    ("(gint) POPPLER_STRUCTURE_LIST_NUMBERING_UPPER_ALPHA", "7"),
    ("(gint) POPPLER_STRUCTURE_LIST_NUMBERING_UPPER_ROMAN", "5"),
    ("(gint) POPPLER_STRUCTURE_PLACEMENT_BEFORE", "2"),
    ("(gint) POPPLER_STRUCTURE_PLACEMENT_BLOCK", "0"),
    ("(gint) POPPLER_STRUCTURE_PLACEMENT_END", "4"),
    ("(gint) POPPLER_STRUCTURE_PLACEMENT_INLINE", "1"),
    ("(gint) POPPLER_STRUCTURE_PLACEMENT_START", "3"),
    ("(gint) POPPLER_STRUCTURE_RUBY_ALIGN_CENTER", "1"),
    ("(gint) POPPLER_STRUCTURE_RUBY_ALIGN_DISTRIBUTE", "4"),
    ("(gint) POPPLER_STRUCTURE_RUBY_ALIGN_END", "2"),
    ("(gint) POPPLER_STRUCTURE_RUBY_ALIGN_JUSTIFY", "3"),
    ("(gint) POPPLER_STRUCTURE_RUBY_ALIGN_START", "0"),
    ("(gint) POPPLER_STRUCTURE_RUBY_POSITION_AFTER", "1"),
    ("(gint) POPPLER_STRUCTURE_RUBY_POSITION_BEFORE", "0"),
    ("(gint) POPPLER_STRUCTURE_RUBY_POSITION_INLINE", "3"),
    ("(gint) POPPLER_STRUCTURE_RUBY_POSITION_WARICHU", "2"),
    ("(gint) POPPLER_STRUCTURE_TABLE_SCOPE_BOTH", "2"),
    ("(gint) POPPLER_STRUCTURE_TABLE_SCOPE_COLUMN", "1"),
    ("(gint) POPPLER_STRUCTURE_TABLE_SCOPE_ROW", "0"),
    ("(gint) POPPLER_STRUCTURE_TEXT_ALIGN_CENTER", "1"),
    ("(gint) POPPLER_STRUCTURE_TEXT_ALIGN_END", "2"),
    ("(gint) POPPLER_STRUCTURE_TEXT_ALIGN_JUSTIFY", "3"),
    ("(gint) POPPLER_STRUCTURE_TEXT_ALIGN_START", "0"),
    ("(gint) POPPLER_STRUCTURE_TEXT_DECORATION_LINETHROUGH", "3"),
    ("(gint) POPPLER_STRUCTURE_TEXT_DECORATION_NONE", "0"),
    ("(gint) POPPLER_STRUCTURE_TEXT_DECORATION_OVERLINE", "2"),
    ("(gint) POPPLER_STRUCTURE_TEXT_DECORATION_UNDERLINE", "1"),
    ("(gint) POPPLER_STRUCTURE_WRITING_MODE_LR_TB", "0"),
    ("(gint) POPPLER_STRUCTURE_WRITING_MODE_RL_TB", "1"),
    ("(gint) POPPLER_STRUCTURE_WRITING_MODE_TB_RL", "2"),
    ("(guint) POPPLER_VIEWER_PREFERENCES_CENTER_WINDOW", "16"),
    ("(guint) POPPLER_VIEWER_PREFERENCES_DIRECTION_RTL", "64"),
    ("(guint) POPPLER_VIEWER_PREFERENCES_DISPLAY_DOC_TITLE", "32"),
    ("(guint) POPPLER_VIEWER_PREFERENCES_FIT_WINDOW", "8"),
    ("(guint) POPPLER_VIEWER_PREFERENCES_HIDE_MENUBAR", "2"),
    ("(guint) POPPLER_VIEWER_PREFERENCES_HIDE_TOOLBAR", "1"),
    ("(guint) POPPLER_VIEWER_PREFERENCES_HIDE_WINDOWUI", "4"),
    ("(guint) POPPLER_VIEWER_PREFERENCES_UNSET", "0"),
];
