#![cfg_attr(feature = "dox", feature(doc_cfg))]

mod auto;
pub use auto::*;

mod document;
mod movie;
mod page_range;
pub use page_range::PageRange;

use std::ops::{Deref, DerefMut};

use glib::translate::{ToGlibPtr, ToGlibPtrMut};

impl Deref for Rectangle {
    type Target = ffi::PopplerRectangle;

    fn deref(&self) -> &Self::Target {
        unsafe { &*self.to_glib_none().0 }
    }
}

impl DerefMut for Rectangle {
    fn deref_mut(&mut self) -> &mut Self::Target {
        unsafe { &mut *self.to_glib_none_mut().0 }
    }
}

#[cfg(test)]
mod tests {
    #[test]
    fn it_works() {
        let result = 2 + 2;
        assert_eq!(result, 4);
    }
}
