// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use glib::error::ErrorDomain;
use glib::translate::*;
use glib::value::FromValue;
use glib::value::ToValue;
use glib::Quark;
use glib::StaticType;
use glib::Type;
use std::fmt;

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerActionLayerAction")]
pub enum ActionLayerAction {
    #[doc(alias = "POPPLER_ACTION_LAYER_ON")]
    On,
    #[doc(alias = "POPPLER_ACTION_LAYER_OFF")]
    Off,
    #[doc(alias = "POPPLER_ACTION_LAYER_TOGGLE")]
    Toggle,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for ActionLayerAction {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "ActionLayerAction::{}",
            match *self {
                Self::On => "On",
                Self::Off => "Off",
                Self::Toggle => "Toggle",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for ActionLayerAction {
    type GlibType = ffi::PopplerActionLayerAction;

    fn into_glib(self) -> ffi::PopplerActionLayerAction {
        match self {
            Self::On => ffi::POPPLER_ACTION_LAYER_ON,
            Self::Off => ffi::POPPLER_ACTION_LAYER_OFF,
            Self::Toggle => ffi::POPPLER_ACTION_LAYER_TOGGLE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerActionLayerAction> for ActionLayerAction {
    unsafe fn from_glib(value: ffi::PopplerActionLayerAction) -> Self {
        match value {
            ffi::POPPLER_ACTION_LAYER_ON => Self::On,
            ffi::POPPLER_ACTION_LAYER_OFF => Self::Off,
            ffi::POPPLER_ACTION_LAYER_TOGGLE => Self::Toggle,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for ActionLayerAction {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_action_layer_action_get_type()) }
    }
}

impl glib::value::ValueType for ActionLayerAction {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for ActionLayerAction {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ActionLayerAction {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerActionMovieOperation")]
pub enum ActionMovieOperation {
    #[doc(alias = "POPPLER_ACTION_MOVIE_PLAY")]
    Play,
    #[doc(alias = "POPPLER_ACTION_MOVIE_PAUSE")]
    Pause,
    #[doc(alias = "POPPLER_ACTION_MOVIE_RESUME")]
    Resume,
    #[doc(alias = "POPPLER_ACTION_MOVIE_STOP")]
    Stop,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for ActionMovieOperation {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "ActionMovieOperation::{}",
            match *self {
                Self::Play => "Play",
                Self::Pause => "Pause",
                Self::Resume => "Resume",
                Self::Stop => "Stop",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for ActionMovieOperation {
    type GlibType = ffi::PopplerActionMovieOperation;

    fn into_glib(self) -> ffi::PopplerActionMovieOperation {
        match self {
            Self::Play => ffi::POPPLER_ACTION_MOVIE_PLAY,
            Self::Pause => ffi::POPPLER_ACTION_MOVIE_PAUSE,
            Self::Resume => ffi::POPPLER_ACTION_MOVIE_RESUME,
            Self::Stop => ffi::POPPLER_ACTION_MOVIE_STOP,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerActionMovieOperation> for ActionMovieOperation {
    unsafe fn from_glib(value: ffi::PopplerActionMovieOperation) -> Self {
        match value {
            ffi::POPPLER_ACTION_MOVIE_PLAY => Self::Play,
            ffi::POPPLER_ACTION_MOVIE_PAUSE => Self::Pause,
            ffi::POPPLER_ACTION_MOVIE_RESUME => Self::Resume,
            ffi::POPPLER_ACTION_MOVIE_STOP => Self::Stop,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for ActionMovieOperation {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_action_movie_operation_get_type()) }
    }
}

impl glib::value::ValueType for ActionMovieOperation {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for ActionMovieOperation {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ActionMovieOperation {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerActionType")]
pub enum ActionType {
    #[doc(alias = "POPPLER_ACTION_UNKNOWN")]
    Unknown,
    #[doc(alias = "POPPLER_ACTION_NONE")]
    None,
    #[doc(alias = "POPPLER_ACTION_GOTO_DEST")]
    GotoDest,
    #[doc(alias = "POPPLER_ACTION_GOTO_REMOTE")]
    GotoRemote,
    #[doc(alias = "POPPLER_ACTION_LAUNCH")]
    Launch,
    #[doc(alias = "POPPLER_ACTION_URI")]
    Uri,
    #[doc(alias = "POPPLER_ACTION_NAMED")]
    Named,
    #[doc(alias = "POPPLER_ACTION_MOVIE")]
    Movie,
    #[doc(alias = "POPPLER_ACTION_RENDITION")]
    Rendition,
    #[doc(alias = "POPPLER_ACTION_OCG_STATE")]
    OcgState,
    #[doc(alias = "POPPLER_ACTION_JAVASCRIPT")]
    Javascript,
    #[doc(alias = "POPPLER_ACTION_RESET_FORM")]
    ResetForm,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for ActionType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "ActionType::{}",
            match *self {
                Self::Unknown => "Unknown",
                Self::None => "None",
                Self::GotoDest => "GotoDest",
                Self::GotoRemote => "GotoRemote",
                Self::Launch => "Launch",
                Self::Uri => "Uri",
                Self::Named => "Named",
                Self::Movie => "Movie",
                Self::Rendition => "Rendition",
                Self::OcgState => "OcgState",
                Self::Javascript => "Javascript",
                Self::ResetForm => "ResetForm",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for ActionType {
    type GlibType = ffi::PopplerActionType;

    fn into_glib(self) -> ffi::PopplerActionType {
        match self {
            Self::Unknown => ffi::POPPLER_ACTION_UNKNOWN,
            Self::None => ffi::POPPLER_ACTION_NONE,
            Self::GotoDest => ffi::POPPLER_ACTION_GOTO_DEST,
            Self::GotoRemote => ffi::POPPLER_ACTION_GOTO_REMOTE,
            Self::Launch => ffi::POPPLER_ACTION_LAUNCH,
            Self::Uri => ffi::POPPLER_ACTION_URI,
            Self::Named => ffi::POPPLER_ACTION_NAMED,
            Self::Movie => ffi::POPPLER_ACTION_MOVIE,
            Self::Rendition => ffi::POPPLER_ACTION_RENDITION,
            Self::OcgState => ffi::POPPLER_ACTION_OCG_STATE,
            Self::Javascript => ffi::POPPLER_ACTION_JAVASCRIPT,
            Self::ResetForm => ffi::POPPLER_ACTION_RESET_FORM,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerActionType> for ActionType {
    unsafe fn from_glib(value: ffi::PopplerActionType) -> Self {
        match value {
            ffi::POPPLER_ACTION_UNKNOWN => Self::Unknown,
            ffi::POPPLER_ACTION_NONE => Self::None,
            ffi::POPPLER_ACTION_GOTO_DEST => Self::GotoDest,
            ffi::POPPLER_ACTION_GOTO_REMOTE => Self::GotoRemote,
            ffi::POPPLER_ACTION_LAUNCH => Self::Launch,
            ffi::POPPLER_ACTION_URI => Self::Uri,
            ffi::POPPLER_ACTION_NAMED => Self::Named,
            ffi::POPPLER_ACTION_MOVIE => Self::Movie,
            ffi::POPPLER_ACTION_RENDITION => Self::Rendition,
            ffi::POPPLER_ACTION_OCG_STATE => Self::OcgState,
            ffi::POPPLER_ACTION_JAVASCRIPT => Self::Javascript,
            ffi::POPPLER_ACTION_RESET_FORM => Self::ResetForm,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for ActionType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_action_type_get_type()) }
    }
}

impl glib::value::ValueType for ActionType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for ActionType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for ActionType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(any(feature = "v0_72", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_72")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerAdditionalActionType")]
pub enum AdditionalActionType {
    #[doc(alias = "POPPLER_ADDITIONAL_ACTION_FIELD_MODIFIED")]
    FieldModified,
    #[doc(alias = "POPPLER_ADDITIONAL_ACTION_FORMAT_FIELD")]
    FormatField,
    #[doc(alias = "POPPLER_ADDITIONAL_ACTION_VALIDATE_FIELD")]
    ValidateField,
    #[doc(alias = "POPPLER_ADDITIONAL_ACTION_CALCULATE_FIELD")]
    CalculateField,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v0_72", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_72")))]
impl fmt::Display for AdditionalActionType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "AdditionalActionType::{}",
            match *self {
                Self::FieldModified => "FieldModified",
                Self::FormatField => "FormatField",
                Self::ValidateField => "ValidateField",
                Self::CalculateField => "CalculateField",
                _ => "Unknown",
            }
        )
    }
}

#[cfg(any(feature = "v0_72", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_72")))]
#[doc(hidden)]
impl IntoGlib for AdditionalActionType {
    type GlibType = ffi::PopplerAdditionalActionType;

    fn into_glib(self) -> ffi::PopplerAdditionalActionType {
        match self {
            Self::FieldModified => ffi::POPPLER_ADDITIONAL_ACTION_FIELD_MODIFIED,
            Self::FormatField => ffi::POPPLER_ADDITIONAL_ACTION_FORMAT_FIELD,
            Self::ValidateField => ffi::POPPLER_ADDITIONAL_ACTION_VALIDATE_FIELD,
            Self::CalculateField => ffi::POPPLER_ADDITIONAL_ACTION_CALCULATE_FIELD,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(any(feature = "v0_72", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_72")))]
#[doc(hidden)]
impl FromGlib<ffi::PopplerAdditionalActionType> for AdditionalActionType {
    unsafe fn from_glib(value: ffi::PopplerAdditionalActionType) -> Self {
        match value {
            ffi::POPPLER_ADDITIONAL_ACTION_FIELD_MODIFIED => Self::FieldModified,
            ffi::POPPLER_ADDITIONAL_ACTION_FORMAT_FIELD => Self::FormatField,
            ffi::POPPLER_ADDITIONAL_ACTION_VALIDATE_FIELD => Self::ValidateField,
            ffi::POPPLER_ADDITIONAL_ACTION_CALCULATE_FIELD => Self::CalculateField,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(any(feature = "v0_72", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_72")))]
impl StaticType for AdditionalActionType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_additional_action_type_get_type()) }
    }
}

#[cfg(any(feature = "v0_72", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_72")))]
impl glib::value::ValueType for AdditionalActionType {
    type Type = Self;
}

#[cfg(any(feature = "v0_72", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_72")))]
unsafe impl<'a> FromValue<'a> for AdditionalActionType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v0_72", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_72")))]
impl ToValue for AdditionalActionType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerAnnotExternalDataType")]
pub enum AnnotExternalDataType {
    #[doc(alias = "POPPLER_ANNOT_EXTERNAL_DATA_MARKUP_3D")]
    _3d,
    #[doc(alias = "POPPLER_ANNOT_EXTERNAL_DATA_MARKUP_UNKNOWN")]
    Unknown,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for AnnotExternalDataType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "AnnotExternalDataType::{}",
            match *self {
                Self::_3d => "_3d",
                Self::Unknown => "Unknown",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for AnnotExternalDataType {
    type GlibType = ffi::PopplerAnnotExternalDataType;

    fn into_glib(self) -> ffi::PopplerAnnotExternalDataType {
        match self {
            Self::_3d => ffi::POPPLER_ANNOT_EXTERNAL_DATA_MARKUP_3D,
            Self::Unknown => ffi::POPPLER_ANNOT_EXTERNAL_DATA_MARKUP_UNKNOWN,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerAnnotExternalDataType> for AnnotExternalDataType {
    unsafe fn from_glib(value: ffi::PopplerAnnotExternalDataType) -> Self {
        match value {
            ffi::POPPLER_ANNOT_EXTERNAL_DATA_MARKUP_3D => Self::_3d,
            ffi::POPPLER_ANNOT_EXTERNAL_DATA_MARKUP_UNKNOWN => Self::Unknown,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for AnnotExternalDataType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_annot_external_data_type_get_type()) }
    }
}

impl glib::value::ValueType for AnnotExternalDataType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for AnnotExternalDataType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for AnnotExternalDataType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerAnnotFreeTextQuadding")]
pub enum AnnotFreeTextQuadding {
    #[doc(alias = "POPPLER_ANNOT_FREE_TEXT_QUADDING_LEFT_JUSTIFIED")]
    LeftJustified,
    #[doc(alias = "POPPLER_ANNOT_FREE_TEXT_QUADDING_CENTERED")]
    Centered,
    #[doc(alias = "POPPLER_ANNOT_FREE_TEXT_QUADDING_RIGHT_JUSTIFIED")]
    RightJustified,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for AnnotFreeTextQuadding {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "AnnotFreeTextQuadding::{}",
            match *self {
                Self::LeftJustified => "LeftJustified",
                Self::Centered => "Centered",
                Self::RightJustified => "RightJustified",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for AnnotFreeTextQuadding {
    type GlibType = ffi::PopplerAnnotFreeTextQuadding;

    fn into_glib(self) -> ffi::PopplerAnnotFreeTextQuadding {
        match self {
            Self::LeftJustified => ffi::POPPLER_ANNOT_FREE_TEXT_QUADDING_LEFT_JUSTIFIED,
            Self::Centered => ffi::POPPLER_ANNOT_FREE_TEXT_QUADDING_CENTERED,
            Self::RightJustified => ffi::POPPLER_ANNOT_FREE_TEXT_QUADDING_RIGHT_JUSTIFIED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerAnnotFreeTextQuadding> for AnnotFreeTextQuadding {
    unsafe fn from_glib(value: ffi::PopplerAnnotFreeTextQuadding) -> Self {
        match value {
            ffi::POPPLER_ANNOT_FREE_TEXT_QUADDING_LEFT_JUSTIFIED => Self::LeftJustified,
            ffi::POPPLER_ANNOT_FREE_TEXT_QUADDING_CENTERED => Self::Centered,
            ffi::POPPLER_ANNOT_FREE_TEXT_QUADDING_RIGHT_JUSTIFIED => Self::RightJustified,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for AnnotFreeTextQuadding {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_annot_free_text_quadding_get_type()) }
    }
}

impl glib::value::ValueType for AnnotFreeTextQuadding {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for AnnotFreeTextQuadding {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for AnnotFreeTextQuadding {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerAnnotMarkupReplyType")]
pub enum AnnotMarkupReplyType {
    #[doc(alias = "POPPLER_ANNOT_MARKUP_REPLY_TYPE_R")]
    R,
    #[doc(alias = "POPPLER_ANNOT_MARKUP_REPLY_TYPE_GROUP")]
    Group,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for AnnotMarkupReplyType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "AnnotMarkupReplyType::{}",
            match *self {
                Self::R => "R",
                Self::Group => "Group",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for AnnotMarkupReplyType {
    type GlibType = ffi::PopplerAnnotMarkupReplyType;

    fn into_glib(self) -> ffi::PopplerAnnotMarkupReplyType {
        match self {
            Self::R => ffi::POPPLER_ANNOT_MARKUP_REPLY_TYPE_R,
            Self::Group => ffi::POPPLER_ANNOT_MARKUP_REPLY_TYPE_GROUP,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerAnnotMarkupReplyType> for AnnotMarkupReplyType {
    unsafe fn from_glib(value: ffi::PopplerAnnotMarkupReplyType) -> Self {
        match value {
            ffi::POPPLER_ANNOT_MARKUP_REPLY_TYPE_R => Self::R,
            ffi::POPPLER_ANNOT_MARKUP_REPLY_TYPE_GROUP => Self::Group,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for AnnotMarkupReplyType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_annot_markup_reply_type_get_type()) }
    }
}

impl glib::value::ValueType for AnnotMarkupReplyType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for AnnotMarkupReplyType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for AnnotMarkupReplyType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerAnnotTextState")]
pub enum AnnotTextState {
    #[doc(alias = "POPPLER_ANNOT_TEXT_STATE_MARKED")]
    Marked,
    #[doc(alias = "POPPLER_ANNOT_TEXT_STATE_UNMARKED")]
    Unmarked,
    #[doc(alias = "POPPLER_ANNOT_TEXT_STATE_ACCEPTED")]
    Accepted,
    #[doc(alias = "POPPLER_ANNOT_TEXT_STATE_REJECTED")]
    Rejected,
    #[doc(alias = "POPPLER_ANNOT_TEXT_STATE_CANCELLED")]
    Cancelled,
    #[doc(alias = "POPPLER_ANNOT_TEXT_STATE_COMPLETED")]
    Completed,
    #[doc(alias = "POPPLER_ANNOT_TEXT_STATE_NONE")]
    None,
    #[doc(alias = "POPPLER_ANNOT_TEXT_STATE_UNKNOWN")]
    Unknown,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for AnnotTextState {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "AnnotTextState::{}",
            match *self {
                Self::Marked => "Marked",
                Self::Unmarked => "Unmarked",
                Self::Accepted => "Accepted",
                Self::Rejected => "Rejected",
                Self::Cancelled => "Cancelled",
                Self::Completed => "Completed",
                Self::None => "None",
                Self::Unknown => "Unknown",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for AnnotTextState {
    type GlibType = ffi::PopplerAnnotTextState;

    fn into_glib(self) -> ffi::PopplerAnnotTextState {
        match self {
            Self::Marked => ffi::POPPLER_ANNOT_TEXT_STATE_MARKED,
            Self::Unmarked => ffi::POPPLER_ANNOT_TEXT_STATE_UNMARKED,
            Self::Accepted => ffi::POPPLER_ANNOT_TEXT_STATE_ACCEPTED,
            Self::Rejected => ffi::POPPLER_ANNOT_TEXT_STATE_REJECTED,
            Self::Cancelled => ffi::POPPLER_ANNOT_TEXT_STATE_CANCELLED,
            Self::Completed => ffi::POPPLER_ANNOT_TEXT_STATE_COMPLETED,
            Self::None => ffi::POPPLER_ANNOT_TEXT_STATE_NONE,
            Self::Unknown => ffi::POPPLER_ANNOT_TEXT_STATE_UNKNOWN,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerAnnotTextState> for AnnotTextState {
    unsafe fn from_glib(value: ffi::PopplerAnnotTextState) -> Self {
        match value {
            ffi::POPPLER_ANNOT_TEXT_STATE_MARKED => Self::Marked,
            ffi::POPPLER_ANNOT_TEXT_STATE_UNMARKED => Self::Unmarked,
            ffi::POPPLER_ANNOT_TEXT_STATE_ACCEPTED => Self::Accepted,
            ffi::POPPLER_ANNOT_TEXT_STATE_REJECTED => Self::Rejected,
            ffi::POPPLER_ANNOT_TEXT_STATE_CANCELLED => Self::Cancelled,
            ffi::POPPLER_ANNOT_TEXT_STATE_COMPLETED => Self::Completed,
            ffi::POPPLER_ANNOT_TEXT_STATE_NONE => Self::None,
            ffi::POPPLER_ANNOT_TEXT_STATE_UNKNOWN => Self::Unknown,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for AnnotTextState {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_annot_text_state_get_type()) }
    }
}

impl glib::value::ValueType for AnnotTextState {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for AnnotTextState {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for AnnotTextState {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerAnnotType")]
pub enum AnnotType {
    #[doc(alias = "POPPLER_ANNOT_UNKNOWN")]
    Unknown,
    #[doc(alias = "POPPLER_ANNOT_TEXT")]
    Text,
    #[doc(alias = "POPPLER_ANNOT_LINK")]
    Link,
    #[doc(alias = "POPPLER_ANNOT_FREE_TEXT")]
    FreeText,
    #[doc(alias = "POPPLER_ANNOT_LINE")]
    Line,
    #[doc(alias = "POPPLER_ANNOT_SQUARE")]
    Square,
    #[doc(alias = "POPPLER_ANNOT_CIRCLE")]
    Circle,
    #[doc(alias = "POPPLER_ANNOT_POLYGON")]
    Polygon,
    #[doc(alias = "POPPLER_ANNOT_POLY_LINE")]
    PolyLine,
    #[doc(alias = "POPPLER_ANNOT_HIGHLIGHT")]
    Highlight,
    #[doc(alias = "POPPLER_ANNOT_UNDERLINE")]
    Underline,
    #[doc(alias = "POPPLER_ANNOT_SQUIGGLY")]
    Squiggly,
    #[doc(alias = "POPPLER_ANNOT_STRIKE_OUT")]
    StrikeOut,
    #[doc(alias = "POPPLER_ANNOT_STAMP")]
    Stamp,
    #[doc(alias = "POPPLER_ANNOT_CARET")]
    Caret,
    #[doc(alias = "POPPLER_ANNOT_INK")]
    Ink,
    #[doc(alias = "POPPLER_ANNOT_POPUP")]
    Popup,
    #[doc(alias = "POPPLER_ANNOT_FILE_ATTACHMENT")]
    FileAttachment,
    #[doc(alias = "POPPLER_ANNOT_SOUND")]
    Sound,
    #[doc(alias = "POPPLER_ANNOT_MOVIE")]
    Movie,
    #[doc(alias = "POPPLER_ANNOT_WIDGET")]
    Widget,
    #[doc(alias = "POPPLER_ANNOT_SCREEN")]
    Screen,
    #[doc(alias = "POPPLER_ANNOT_PRINTER_MARK")]
    PrinterMark,
    #[doc(alias = "POPPLER_ANNOT_TRAP_NET")]
    TrapNet,
    #[doc(alias = "POPPLER_ANNOT_WATERMARK")]
    Watermark,
    #[doc(alias = "POPPLER_ANNOT_3D")]
    _3d,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for AnnotType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "AnnotType::{}",
            match *self {
                Self::Unknown => "Unknown",
                Self::Text => "Text",
                Self::Link => "Link",
                Self::FreeText => "FreeText",
                Self::Line => "Line",
                Self::Square => "Square",
                Self::Circle => "Circle",
                Self::Polygon => "Polygon",
                Self::PolyLine => "PolyLine",
                Self::Highlight => "Highlight",
                Self::Underline => "Underline",
                Self::Squiggly => "Squiggly",
                Self::StrikeOut => "StrikeOut",
                Self::Stamp => "Stamp",
                Self::Caret => "Caret",
                Self::Ink => "Ink",
                Self::Popup => "Popup",
                Self::FileAttachment => "FileAttachment",
                Self::Sound => "Sound",
                Self::Movie => "Movie",
                Self::Widget => "Widget",
                Self::Screen => "Screen",
                Self::PrinterMark => "PrinterMark",
                Self::TrapNet => "TrapNet",
                Self::Watermark => "Watermark",
                Self::_3d => "_3d",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for AnnotType {
    type GlibType = ffi::PopplerAnnotType;

    fn into_glib(self) -> ffi::PopplerAnnotType {
        match self {
            Self::Unknown => ffi::POPPLER_ANNOT_UNKNOWN,
            Self::Text => ffi::POPPLER_ANNOT_TEXT,
            Self::Link => ffi::POPPLER_ANNOT_LINK,
            Self::FreeText => ffi::POPPLER_ANNOT_FREE_TEXT,
            Self::Line => ffi::POPPLER_ANNOT_LINE,
            Self::Square => ffi::POPPLER_ANNOT_SQUARE,
            Self::Circle => ffi::POPPLER_ANNOT_CIRCLE,
            Self::Polygon => ffi::POPPLER_ANNOT_POLYGON,
            Self::PolyLine => ffi::POPPLER_ANNOT_POLY_LINE,
            Self::Highlight => ffi::POPPLER_ANNOT_HIGHLIGHT,
            Self::Underline => ffi::POPPLER_ANNOT_UNDERLINE,
            Self::Squiggly => ffi::POPPLER_ANNOT_SQUIGGLY,
            Self::StrikeOut => ffi::POPPLER_ANNOT_STRIKE_OUT,
            Self::Stamp => ffi::POPPLER_ANNOT_STAMP,
            Self::Caret => ffi::POPPLER_ANNOT_CARET,
            Self::Ink => ffi::POPPLER_ANNOT_INK,
            Self::Popup => ffi::POPPLER_ANNOT_POPUP,
            Self::FileAttachment => ffi::POPPLER_ANNOT_FILE_ATTACHMENT,
            Self::Sound => ffi::POPPLER_ANNOT_SOUND,
            Self::Movie => ffi::POPPLER_ANNOT_MOVIE,
            Self::Widget => ffi::POPPLER_ANNOT_WIDGET,
            Self::Screen => ffi::POPPLER_ANNOT_SCREEN,
            Self::PrinterMark => ffi::POPPLER_ANNOT_PRINTER_MARK,
            Self::TrapNet => ffi::POPPLER_ANNOT_TRAP_NET,
            Self::Watermark => ffi::POPPLER_ANNOT_WATERMARK,
            Self::_3d => ffi::POPPLER_ANNOT_3D,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerAnnotType> for AnnotType {
    unsafe fn from_glib(value: ffi::PopplerAnnotType) -> Self {
        match value {
            ffi::POPPLER_ANNOT_UNKNOWN => Self::Unknown,
            ffi::POPPLER_ANNOT_TEXT => Self::Text,
            ffi::POPPLER_ANNOT_LINK => Self::Link,
            ffi::POPPLER_ANNOT_FREE_TEXT => Self::FreeText,
            ffi::POPPLER_ANNOT_LINE => Self::Line,
            ffi::POPPLER_ANNOT_SQUARE => Self::Square,
            ffi::POPPLER_ANNOT_CIRCLE => Self::Circle,
            ffi::POPPLER_ANNOT_POLYGON => Self::Polygon,
            ffi::POPPLER_ANNOT_POLY_LINE => Self::PolyLine,
            ffi::POPPLER_ANNOT_HIGHLIGHT => Self::Highlight,
            ffi::POPPLER_ANNOT_UNDERLINE => Self::Underline,
            ffi::POPPLER_ANNOT_SQUIGGLY => Self::Squiggly,
            ffi::POPPLER_ANNOT_STRIKE_OUT => Self::StrikeOut,
            ffi::POPPLER_ANNOT_STAMP => Self::Stamp,
            ffi::POPPLER_ANNOT_CARET => Self::Caret,
            ffi::POPPLER_ANNOT_INK => Self::Ink,
            ffi::POPPLER_ANNOT_POPUP => Self::Popup,
            ffi::POPPLER_ANNOT_FILE_ATTACHMENT => Self::FileAttachment,
            ffi::POPPLER_ANNOT_SOUND => Self::Sound,
            ffi::POPPLER_ANNOT_MOVIE => Self::Movie,
            ffi::POPPLER_ANNOT_WIDGET => Self::Widget,
            ffi::POPPLER_ANNOT_SCREEN => Self::Screen,
            ffi::POPPLER_ANNOT_PRINTER_MARK => Self::PrinterMark,
            ffi::POPPLER_ANNOT_TRAP_NET => Self::TrapNet,
            ffi::POPPLER_ANNOT_WATERMARK => Self::Watermark,
            ffi::POPPLER_ANNOT_3D => Self::_3d,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for AnnotType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_annot_type_get_type()) }
    }
}

impl glib::value::ValueType for AnnotType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for AnnotType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for AnnotType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerBackend")]
pub enum Backend {
    #[doc(alias = "POPPLER_BACKEND_UNKNOWN")]
    Unknown,
    #[doc(alias = "POPPLER_BACKEND_SPLASH")]
    Splash,
    #[doc(alias = "POPPLER_BACKEND_CAIRO")]
    Cairo,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for Backend {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Backend::{}",
            match *self {
                Self::Unknown => "Unknown",
                Self::Splash => "Splash",
                Self::Cairo => "Cairo",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for Backend {
    type GlibType = ffi::PopplerBackend;

    fn into_glib(self) -> ffi::PopplerBackend {
        match self {
            Self::Unknown => ffi::POPPLER_BACKEND_UNKNOWN,
            Self::Splash => ffi::POPPLER_BACKEND_SPLASH,
            Self::Cairo => ffi::POPPLER_BACKEND_CAIRO,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerBackend> for Backend {
    unsafe fn from_glib(value: ffi::PopplerBackend) -> Self {
        match value {
            ffi::POPPLER_BACKEND_UNKNOWN => Self::Unknown,
            ffi::POPPLER_BACKEND_SPLASH => Self::Splash,
            ffi::POPPLER_BACKEND_CAIRO => Self::Cairo,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for Backend {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_backend_get_type()) }
    }
}

impl glib::value::ValueType for Backend {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for Backend {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for Backend {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerDestType")]
pub enum DestType {
    #[doc(alias = "POPPLER_DEST_UNKNOWN")]
    Unknown,
    #[doc(alias = "POPPLER_DEST_XYZ")]
    Xyz,
    #[doc(alias = "POPPLER_DEST_FIT")]
    Fit,
    #[doc(alias = "POPPLER_DEST_FITH")]
    Fith,
    #[doc(alias = "POPPLER_DEST_FITV")]
    Fitv,
    #[doc(alias = "POPPLER_DEST_FITR")]
    Fitr,
    #[doc(alias = "POPPLER_DEST_FITB")]
    Fitb,
    #[doc(alias = "POPPLER_DEST_FITBH")]
    Fitbh,
    #[doc(alias = "POPPLER_DEST_FITBV")]
    Fitbv,
    #[doc(alias = "POPPLER_DEST_NAMED")]
    Named,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for DestType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "DestType::{}",
            match *self {
                Self::Unknown => "Unknown",
                Self::Xyz => "Xyz",
                Self::Fit => "Fit",
                Self::Fith => "Fith",
                Self::Fitv => "Fitv",
                Self::Fitr => "Fitr",
                Self::Fitb => "Fitb",
                Self::Fitbh => "Fitbh",
                Self::Fitbv => "Fitbv",
                Self::Named => "Named",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for DestType {
    type GlibType = ffi::PopplerDestType;

    fn into_glib(self) -> ffi::PopplerDestType {
        match self {
            Self::Unknown => ffi::POPPLER_DEST_UNKNOWN,
            Self::Xyz => ffi::POPPLER_DEST_XYZ,
            Self::Fit => ffi::POPPLER_DEST_FIT,
            Self::Fith => ffi::POPPLER_DEST_FITH,
            Self::Fitv => ffi::POPPLER_DEST_FITV,
            Self::Fitr => ffi::POPPLER_DEST_FITR,
            Self::Fitb => ffi::POPPLER_DEST_FITB,
            Self::Fitbh => ffi::POPPLER_DEST_FITBH,
            Self::Fitbv => ffi::POPPLER_DEST_FITBV,
            Self::Named => ffi::POPPLER_DEST_NAMED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerDestType> for DestType {
    unsafe fn from_glib(value: ffi::PopplerDestType) -> Self {
        match value {
            ffi::POPPLER_DEST_UNKNOWN => Self::Unknown,
            ffi::POPPLER_DEST_XYZ => Self::Xyz,
            ffi::POPPLER_DEST_FIT => Self::Fit,
            ffi::POPPLER_DEST_FITH => Self::Fith,
            ffi::POPPLER_DEST_FITV => Self::Fitv,
            ffi::POPPLER_DEST_FITR => Self::Fitr,
            ffi::POPPLER_DEST_FITB => Self::Fitb,
            ffi::POPPLER_DEST_FITBH => Self::Fitbh,
            ffi::POPPLER_DEST_FITBV => Self::Fitbv,
            ffi::POPPLER_DEST_NAMED => Self::Named,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for DestType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_dest_type_get_type()) }
    }
}

impl glib::value::ValueType for DestType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for DestType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for DestType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerError")]
pub enum Error {
    #[doc(alias = "POPPLER_ERROR_INVALID")]
    Invalid,
    #[doc(alias = "POPPLER_ERROR_ENCRYPTED")]
    Encrypted,
    #[doc(alias = "POPPLER_ERROR_OPEN_FILE")]
    OpenFile,
    #[doc(alias = "POPPLER_ERROR_BAD_CATALOG")]
    BadCatalog,
    #[doc(alias = "POPPLER_ERROR_DAMAGED")]
    Damaged,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for Error {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Error::{}",
            match *self {
                Self::Invalid => "Invalid",
                Self::Encrypted => "Encrypted",
                Self::OpenFile => "OpenFile",
                Self::BadCatalog => "BadCatalog",
                Self::Damaged => "Damaged",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for Error {
    type GlibType = ffi::PopplerError;

    fn into_glib(self) -> ffi::PopplerError {
        match self {
            Self::Invalid => ffi::POPPLER_ERROR_INVALID,
            Self::Encrypted => ffi::POPPLER_ERROR_ENCRYPTED,
            Self::OpenFile => ffi::POPPLER_ERROR_OPEN_FILE,
            Self::BadCatalog => ffi::POPPLER_ERROR_BAD_CATALOG,
            Self::Damaged => ffi::POPPLER_ERROR_DAMAGED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerError> for Error {
    unsafe fn from_glib(value: ffi::PopplerError) -> Self {
        match value {
            ffi::POPPLER_ERROR_INVALID => Self::Invalid,
            ffi::POPPLER_ERROR_ENCRYPTED => Self::Encrypted,
            ffi::POPPLER_ERROR_OPEN_FILE => Self::OpenFile,
            ffi::POPPLER_ERROR_BAD_CATALOG => Self::BadCatalog,
            ffi::POPPLER_ERROR_DAMAGED => Self::Damaged,
            value => Self::__Unknown(value),
        }
    }
}

impl ErrorDomain for Error {
    fn domain() -> Quark {
        unsafe { from_glib(ffi::poppler_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        match code {
            ffi::POPPLER_ERROR_INVALID => Some(Self::Invalid),
            ffi::POPPLER_ERROR_ENCRYPTED => Some(Self::Encrypted),
            ffi::POPPLER_ERROR_OPEN_FILE => Some(Self::OpenFile),
            ffi::POPPLER_ERROR_BAD_CATALOG => Some(Self::BadCatalog),
            ffi::POPPLER_ERROR_DAMAGED => Some(Self::Damaged),
            value => Some(Self::__Unknown(value)),
        }
    }
}

impl StaticType for Error {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_error_get_type()) }
    }
}

impl glib::value::ValueType for Error {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for Error {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for Error {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerFontType")]
pub enum FontType {
    #[doc(alias = "POPPLER_FONT_TYPE_UNKNOWN")]
    Unknown,
    #[doc(alias = "POPPLER_FONT_TYPE_TYPE1")]
    Type1,
    #[doc(alias = "POPPLER_FONT_TYPE_TYPE1C")]
    Type1c,
    #[doc(alias = "POPPLER_FONT_TYPE_TYPE1COT")]
    Type1cot,
    #[doc(alias = "POPPLER_FONT_TYPE_TYPE3")]
    Type3,
    #[doc(alias = "POPPLER_FONT_TYPE_TRUETYPE")]
    Truetype,
    #[doc(alias = "POPPLER_FONT_TYPE_TRUETYPEOT")]
    Truetypeot,
    #[doc(alias = "POPPLER_FONT_TYPE_CID_TYPE0")]
    CidType0,
    #[doc(alias = "POPPLER_FONT_TYPE_CID_TYPE0C")]
    CidType0c,
    #[doc(alias = "POPPLER_FONT_TYPE_CID_TYPE0COT")]
    CidType0cot,
    #[doc(alias = "POPPLER_FONT_TYPE_CID_TYPE2")]
    CidType2,
    #[doc(alias = "POPPLER_FONT_TYPE_CID_TYPE2OT")]
    CidType2ot,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for FontType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "FontType::{}",
            match *self {
                Self::Unknown => "Unknown",
                Self::Type1 => "Type1",
                Self::Type1c => "Type1c",
                Self::Type1cot => "Type1cot",
                Self::Type3 => "Type3",
                Self::Truetype => "Truetype",
                Self::Truetypeot => "Truetypeot",
                Self::CidType0 => "CidType0",
                Self::CidType0c => "CidType0c",
                Self::CidType0cot => "CidType0cot",
                Self::CidType2 => "CidType2",
                Self::CidType2ot => "CidType2ot",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for FontType {
    type GlibType = ffi::PopplerFontType;

    fn into_glib(self) -> ffi::PopplerFontType {
        match self {
            Self::Unknown => ffi::POPPLER_FONT_TYPE_UNKNOWN,
            Self::Type1 => ffi::POPPLER_FONT_TYPE_TYPE1,
            Self::Type1c => ffi::POPPLER_FONT_TYPE_TYPE1C,
            Self::Type1cot => ffi::POPPLER_FONT_TYPE_TYPE1COT,
            Self::Type3 => ffi::POPPLER_FONT_TYPE_TYPE3,
            Self::Truetype => ffi::POPPLER_FONT_TYPE_TRUETYPE,
            Self::Truetypeot => ffi::POPPLER_FONT_TYPE_TRUETYPEOT,
            Self::CidType0 => ffi::POPPLER_FONT_TYPE_CID_TYPE0,
            Self::CidType0c => ffi::POPPLER_FONT_TYPE_CID_TYPE0C,
            Self::CidType0cot => ffi::POPPLER_FONT_TYPE_CID_TYPE0COT,
            Self::CidType2 => ffi::POPPLER_FONT_TYPE_CID_TYPE2,
            Self::CidType2ot => ffi::POPPLER_FONT_TYPE_CID_TYPE2OT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerFontType> for FontType {
    unsafe fn from_glib(value: ffi::PopplerFontType) -> Self {
        match value {
            ffi::POPPLER_FONT_TYPE_UNKNOWN => Self::Unknown,
            ffi::POPPLER_FONT_TYPE_TYPE1 => Self::Type1,
            ffi::POPPLER_FONT_TYPE_TYPE1C => Self::Type1c,
            ffi::POPPLER_FONT_TYPE_TYPE1COT => Self::Type1cot,
            ffi::POPPLER_FONT_TYPE_TYPE3 => Self::Type3,
            ffi::POPPLER_FONT_TYPE_TRUETYPE => Self::Truetype,
            ffi::POPPLER_FONT_TYPE_TRUETYPEOT => Self::Truetypeot,
            ffi::POPPLER_FONT_TYPE_CID_TYPE0 => Self::CidType0,
            ffi::POPPLER_FONT_TYPE_CID_TYPE0C => Self::CidType0c,
            ffi::POPPLER_FONT_TYPE_CID_TYPE0COT => Self::CidType0cot,
            ffi::POPPLER_FONT_TYPE_CID_TYPE2 => Self::CidType2,
            ffi::POPPLER_FONT_TYPE_CID_TYPE2OT => Self::CidType2ot,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for FontType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_font_type_get_type()) }
    }
}

impl glib::value::ValueType for FontType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for FontType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for FontType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerFormButtonType")]
pub enum FormButtonType {
    #[doc(alias = "POPPLER_FORM_BUTTON_PUSH")]
    Push,
    #[doc(alias = "POPPLER_FORM_BUTTON_CHECK")]
    Check,
    #[doc(alias = "POPPLER_FORM_BUTTON_RADIO")]
    Radio,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for FormButtonType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "FormButtonType::{}",
            match *self {
                Self::Push => "Push",
                Self::Check => "Check",
                Self::Radio => "Radio",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for FormButtonType {
    type GlibType = ffi::PopplerFormButtonType;

    fn into_glib(self) -> ffi::PopplerFormButtonType {
        match self {
            Self::Push => ffi::POPPLER_FORM_BUTTON_PUSH,
            Self::Check => ffi::POPPLER_FORM_BUTTON_CHECK,
            Self::Radio => ffi::POPPLER_FORM_BUTTON_RADIO,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerFormButtonType> for FormButtonType {
    unsafe fn from_glib(value: ffi::PopplerFormButtonType) -> Self {
        match value {
            ffi::POPPLER_FORM_BUTTON_PUSH => Self::Push,
            ffi::POPPLER_FORM_BUTTON_CHECK => Self::Check,
            ffi::POPPLER_FORM_BUTTON_RADIO => Self::Radio,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for FormButtonType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_form_button_type_get_type()) }
    }
}

impl glib::value::ValueType for FormButtonType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for FormButtonType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for FormButtonType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerFormChoiceType")]
pub enum FormChoiceType {
    #[doc(alias = "POPPLER_FORM_CHOICE_COMBO")]
    Combo,
    #[doc(alias = "POPPLER_FORM_CHOICE_LIST")]
    List,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for FormChoiceType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "FormChoiceType::{}",
            match *self {
                Self::Combo => "Combo",
                Self::List => "List",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for FormChoiceType {
    type GlibType = ffi::PopplerFormChoiceType;

    fn into_glib(self) -> ffi::PopplerFormChoiceType {
        match self {
            Self::Combo => ffi::POPPLER_FORM_CHOICE_COMBO,
            Self::List => ffi::POPPLER_FORM_CHOICE_LIST,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerFormChoiceType> for FormChoiceType {
    unsafe fn from_glib(value: ffi::PopplerFormChoiceType) -> Self {
        match value {
            ffi::POPPLER_FORM_CHOICE_COMBO => Self::Combo,
            ffi::POPPLER_FORM_CHOICE_LIST => Self::List,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for FormChoiceType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_form_choice_type_get_type()) }
    }
}

impl glib::value::ValueType for FormChoiceType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for FormChoiceType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for FormChoiceType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerFormFieldType")]
pub enum FormFieldType {
    #[doc(alias = "POPPLER_FORM_FIELD_UNKNOWN")]
    Unknown,
    #[doc(alias = "POPPLER_FORM_FIELD_BUTTON")]
    Button,
    #[doc(alias = "POPPLER_FORM_FIELD_TEXT")]
    Text,
    #[doc(alias = "POPPLER_FORM_FIELD_CHOICE")]
    Choice,
    #[doc(alias = "POPPLER_FORM_FIELD_SIGNATURE")]
    Signature,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for FormFieldType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "FormFieldType::{}",
            match *self {
                Self::Unknown => "Unknown",
                Self::Button => "Button",
                Self::Text => "Text",
                Self::Choice => "Choice",
                Self::Signature => "Signature",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for FormFieldType {
    type GlibType = ffi::PopplerFormFieldType;

    fn into_glib(self) -> ffi::PopplerFormFieldType {
        match self {
            Self::Unknown => ffi::POPPLER_FORM_FIELD_UNKNOWN,
            Self::Button => ffi::POPPLER_FORM_FIELD_BUTTON,
            Self::Text => ffi::POPPLER_FORM_FIELD_TEXT,
            Self::Choice => ffi::POPPLER_FORM_FIELD_CHOICE,
            Self::Signature => ffi::POPPLER_FORM_FIELD_SIGNATURE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerFormFieldType> for FormFieldType {
    unsafe fn from_glib(value: ffi::PopplerFormFieldType) -> Self {
        match value {
            ffi::POPPLER_FORM_FIELD_UNKNOWN => Self::Unknown,
            ffi::POPPLER_FORM_FIELD_BUTTON => Self::Button,
            ffi::POPPLER_FORM_FIELD_TEXT => Self::Text,
            ffi::POPPLER_FORM_FIELD_CHOICE => Self::Choice,
            ffi::POPPLER_FORM_FIELD_SIGNATURE => Self::Signature,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for FormFieldType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_form_field_type_get_type()) }
    }
}

impl glib::value::ValueType for FormFieldType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for FormFieldType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for FormFieldType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerFormTextType")]
pub enum FormTextType {
    #[doc(alias = "POPPLER_FORM_TEXT_NORMAL")]
    Normal,
    #[doc(alias = "POPPLER_FORM_TEXT_MULTILINE")]
    Multiline,
    #[doc(alias = "POPPLER_FORM_TEXT_FILE_SELECT")]
    FileSelect,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for FormTextType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "FormTextType::{}",
            match *self {
                Self::Normal => "Normal",
                Self::Multiline => "Multiline",
                Self::FileSelect => "FileSelect",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for FormTextType {
    type GlibType = ffi::PopplerFormTextType;

    fn into_glib(self) -> ffi::PopplerFormTextType {
        match self {
            Self::Normal => ffi::POPPLER_FORM_TEXT_NORMAL,
            Self::Multiline => ffi::POPPLER_FORM_TEXT_MULTILINE,
            Self::FileSelect => ffi::POPPLER_FORM_TEXT_FILE_SELECT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerFormTextType> for FormTextType {
    unsafe fn from_glib(value: ffi::PopplerFormTextType) -> Self {
        match value {
            ffi::POPPLER_FORM_TEXT_NORMAL => Self::Normal,
            ffi::POPPLER_FORM_TEXT_MULTILINE => Self::Multiline,
            ffi::POPPLER_FORM_TEXT_FILE_SELECT => Self::FileSelect,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for FormTextType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_form_text_type_get_type()) }
    }
}

impl glib::value::ValueType for FormTextType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for FormTextType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for FormTextType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerMoviePlayMode")]
pub enum MoviePlayMode {
    #[doc(alias = "POPPLER_MOVIE_PLAY_MODE_ONCE")]
    Once,
    #[doc(alias = "POPPLER_MOVIE_PLAY_MODE_OPEN")]
    Open,
    #[doc(alias = "POPPLER_MOVIE_PLAY_MODE_REPEAT")]
    Repeat,
    #[doc(alias = "POPPLER_MOVIE_PLAY_MODE_PALINDROME")]
    Palindrome,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for MoviePlayMode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "MoviePlayMode::{}",
            match *self {
                Self::Once => "Once",
                Self::Open => "Open",
                Self::Repeat => "Repeat",
                Self::Palindrome => "Palindrome",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for MoviePlayMode {
    type GlibType = ffi::PopplerMoviePlayMode;

    fn into_glib(self) -> ffi::PopplerMoviePlayMode {
        match self {
            Self::Once => ffi::POPPLER_MOVIE_PLAY_MODE_ONCE,
            Self::Open => ffi::POPPLER_MOVIE_PLAY_MODE_OPEN,
            Self::Repeat => ffi::POPPLER_MOVIE_PLAY_MODE_REPEAT,
            Self::Palindrome => ffi::POPPLER_MOVIE_PLAY_MODE_PALINDROME,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerMoviePlayMode> for MoviePlayMode {
    unsafe fn from_glib(value: ffi::PopplerMoviePlayMode) -> Self {
        match value {
            ffi::POPPLER_MOVIE_PLAY_MODE_ONCE => Self::Once,
            ffi::POPPLER_MOVIE_PLAY_MODE_OPEN => Self::Open,
            ffi::POPPLER_MOVIE_PLAY_MODE_REPEAT => Self::Repeat,
            ffi::POPPLER_MOVIE_PLAY_MODE_PALINDROME => Self::Palindrome,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for MoviePlayMode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_movie_play_mode_get_type()) }
    }
}

impl glib::value::ValueType for MoviePlayMode {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for MoviePlayMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for MoviePlayMode {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerPDFConformance")]
pub enum PDFConformance {
    #[doc(alias = "POPPLER_PDF_SUBTYPE_CONF_UNSET")]
    Unset,
    #[doc(alias = "POPPLER_PDF_SUBTYPE_CONF_A")]
    A,
    #[doc(alias = "POPPLER_PDF_SUBTYPE_CONF_B")]
    B,
    #[doc(alias = "POPPLER_PDF_SUBTYPE_CONF_G")]
    G,
    #[doc(alias = "POPPLER_PDF_SUBTYPE_CONF_N")]
    N,
    #[doc(alias = "POPPLER_PDF_SUBTYPE_CONF_P")]
    P,
    #[doc(alias = "POPPLER_PDF_SUBTYPE_CONF_PG")]
    Pg,
    #[doc(alias = "POPPLER_PDF_SUBTYPE_CONF_U")]
    U,
    #[doc(alias = "POPPLER_PDF_SUBTYPE_CONF_NONE")]
    None,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for PDFConformance {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "PDFConformance::{}",
            match *self {
                Self::Unset => "Unset",
                Self::A => "A",
                Self::B => "B",
                Self::G => "G",
                Self::N => "N",
                Self::P => "P",
                Self::Pg => "Pg",
                Self::U => "U",
                Self::None => "None",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for PDFConformance {
    type GlibType = ffi::PopplerPDFConformance;

    fn into_glib(self) -> ffi::PopplerPDFConformance {
        match self {
            Self::Unset => ffi::POPPLER_PDF_SUBTYPE_CONF_UNSET,
            Self::A => ffi::POPPLER_PDF_SUBTYPE_CONF_A,
            Self::B => ffi::POPPLER_PDF_SUBTYPE_CONF_B,
            Self::G => ffi::POPPLER_PDF_SUBTYPE_CONF_G,
            Self::N => ffi::POPPLER_PDF_SUBTYPE_CONF_N,
            Self::P => ffi::POPPLER_PDF_SUBTYPE_CONF_P,
            Self::Pg => ffi::POPPLER_PDF_SUBTYPE_CONF_PG,
            Self::U => ffi::POPPLER_PDF_SUBTYPE_CONF_U,
            Self::None => ffi::POPPLER_PDF_SUBTYPE_CONF_NONE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerPDFConformance> for PDFConformance {
    unsafe fn from_glib(value: ffi::PopplerPDFConformance) -> Self {
        match value {
            ffi::POPPLER_PDF_SUBTYPE_CONF_UNSET => Self::Unset,
            ffi::POPPLER_PDF_SUBTYPE_CONF_A => Self::A,
            ffi::POPPLER_PDF_SUBTYPE_CONF_B => Self::B,
            ffi::POPPLER_PDF_SUBTYPE_CONF_G => Self::G,
            ffi::POPPLER_PDF_SUBTYPE_CONF_N => Self::N,
            ffi::POPPLER_PDF_SUBTYPE_CONF_P => Self::P,
            ffi::POPPLER_PDF_SUBTYPE_CONF_PG => Self::Pg,
            ffi::POPPLER_PDF_SUBTYPE_CONF_U => Self::U,
            ffi::POPPLER_PDF_SUBTYPE_CONF_NONE => Self::None,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for PDFConformance {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_pdf_conformance_get_type()) }
    }
}

impl glib::value::ValueType for PDFConformance {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PDFConformance {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PDFConformance {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerPDFPart")]
pub enum PDFPart {
    #[doc(alias = "POPPLER_PDF_SUBTYPE_PART_UNSET")]
    Unset,
    #[doc(alias = "POPPLER_PDF_SUBTYPE_PART_1")]
    _1,
    #[doc(alias = "POPPLER_PDF_SUBTYPE_PART_2")]
    _2,
    #[doc(alias = "POPPLER_PDF_SUBTYPE_PART_3")]
    _3,
    #[doc(alias = "POPPLER_PDF_SUBTYPE_PART_4")]
    _4,
    #[doc(alias = "POPPLER_PDF_SUBTYPE_PART_5")]
    _5,
    #[doc(alias = "POPPLER_PDF_SUBTYPE_PART_6")]
    _6,
    #[doc(alias = "POPPLER_PDF_SUBTYPE_PART_7")]
    _7,
    #[doc(alias = "POPPLER_PDF_SUBTYPE_PART_8")]
    _8,
    #[doc(alias = "POPPLER_PDF_SUBTYPE_PART_NONE")]
    None,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for PDFPart {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "PDFPart::{}",
            match *self {
                Self::Unset => "Unset",
                Self::_1 => "_1",
                Self::_2 => "_2",
                Self::_3 => "_3",
                Self::_4 => "_4",
                Self::_5 => "_5",
                Self::_6 => "_6",
                Self::_7 => "_7",
                Self::_8 => "_8",
                Self::None => "None",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for PDFPart {
    type GlibType = ffi::PopplerPDFPart;

    fn into_glib(self) -> ffi::PopplerPDFPart {
        match self {
            Self::Unset => ffi::POPPLER_PDF_SUBTYPE_PART_UNSET,
            Self::_1 => ffi::POPPLER_PDF_SUBTYPE_PART_1,
            Self::_2 => ffi::POPPLER_PDF_SUBTYPE_PART_2,
            Self::_3 => ffi::POPPLER_PDF_SUBTYPE_PART_3,
            Self::_4 => ffi::POPPLER_PDF_SUBTYPE_PART_4,
            Self::_5 => ffi::POPPLER_PDF_SUBTYPE_PART_5,
            Self::_6 => ffi::POPPLER_PDF_SUBTYPE_PART_6,
            Self::_7 => ffi::POPPLER_PDF_SUBTYPE_PART_7,
            Self::_8 => ffi::POPPLER_PDF_SUBTYPE_PART_8,
            Self::None => ffi::POPPLER_PDF_SUBTYPE_PART_NONE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerPDFPart> for PDFPart {
    unsafe fn from_glib(value: ffi::PopplerPDFPart) -> Self {
        match value {
            ffi::POPPLER_PDF_SUBTYPE_PART_UNSET => Self::Unset,
            ffi::POPPLER_PDF_SUBTYPE_PART_1 => Self::_1,
            ffi::POPPLER_PDF_SUBTYPE_PART_2 => Self::_2,
            ffi::POPPLER_PDF_SUBTYPE_PART_3 => Self::_3,
            ffi::POPPLER_PDF_SUBTYPE_PART_4 => Self::_4,
            ffi::POPPLER_PDF_SUBTYPE_PART_5 => Self::_5,
            ffi::POPPLER_PDF_SUBTYPE_PART_6 => Self::_6,
            ffi::POPPLER_PDF_SUBTYPE_PART_7 => Self::_7,
            ffi::POPPLER_PDF_SUBTYPE_PART_8 => Self::_8,
            ffi::POPPLER_PDF_SUBTYPE_PART_NONE => Self::None,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for PDFPart {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_pdf_part_get_type()) }
    }
}

impl glib::value::ValueType for PDFPart {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PDFPart {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PDFPart {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerPDFSubtype")]
pub enum PDFSubtype {
    #[doc(alias = "POPPLER_PDF_SUBTYPE_UNSET")]
    Unset,
    #[doc(alias = "POPPLER_PDF_SUBTYPE_PDF_A")]
    PdfA,
    #[doc(alias = "POPPLER_PDF_SUBTYPE_PDF_E")]
    PdfE,
    #[doc(alias = "POPPLER_PDF_SUBTYPE_PDF_UA")]
    PdfUa,
    #[doc(alias = "POPPLER_PDF_SUBTYPE_PDF_VT")]
    PdfVt,
    #[doc(alias = "POPPLER_PDF_SUBTYPE_PDF_X")]
    PdfX,
    #[doc(alias = "POPPLER_PDF_SUBTYPE_NONE")]
    None,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for PDFSubtype {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "PDFSubtype::{}",
            match *self {
                Self::Unset => "Unset",
                Self::PdfA => "PdfA",
                Self::PdfE => "PdfE",
                Self::PdfUa => "PdfUa",
                Self::PdfVt => "PdfVt",
                Self::PdfX => "PdfX",
                Self::None => "None",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for PDFSubtype {
    type GlibType = ffi::PopplerPDFSubtype;

    fn into_glib(self) -> ffi::PopplerPDFSubtype {
        match self {
            Self::Unset => ffi::POPPLER_PDF_SUBTYPE_UNSET,
            Self::PdfA => ffi::POPPLER_PDF_SUBTYPE_PDF_A,
            Self::PdfE => ffi::POPPLER_PDF_SUBTYPE_PDF_E,
            Self::PdfUa => ffi::POPPLER_PDF_SUBTYPE_PDF_UA,
            Self::PdfVt => ffi::POPPLER_PDF_SUBTYPE_PDF_VT,
            Self::PdfX => ffi::POPPLER_PDF_SUBTYPE_PDF_X,
            Self::None => ffi::POPPLER_PDF_SUBTYPE_NONE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerPDFSubtype> for PDFSubtype {
    unsafe fn from_glib(value: ffi::PopplerPDFSubtype) -> Self {
        match value {
            ffi::POPPLER_PDF_SUBTYPE_UNSET => Self::Unset,
            ffi::POPPLER_PDF_SUBTYPE_PDF_A => Self::PdfA,
            ffi::POPPLER_PDF_SUBTYPE_PDF_E => Self::PdfE,
            ffi::POPPLER_PDF_SUBTYPE_PDF_UA => Self::PdfUa,
            ffi::POPPLER_PDF_SUBTYPE_PDF_VT => Self::PdfVt,
            ffi::POPPLER_PDF_SUBTYPE_PDF_X => Self::PdfX,
            ffi::POPPLER_PDF_SUBTYPE_NONE => Self::None,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for PDFSubtype {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_pdf_subtype_get_type()) }
    }
}

impl glib::value::ValueType for PDFSubtype {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PDFSubtype {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PDFSubtype {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerPageLayout")]
pub enum PageLayout {
    #[doc(alias = "POPPLER_PAGE_LAYOUT_UNSET")]
    Unset,
    #[doc(alias = "POPPLER_PAGE_LAYOUT_SINGLE_PAGE")]
    SinglePage,
    #[doc(alias = "POPPLER_PAGE_LAYOUT_ONE_COLUMN")]
    OneColumn,
    #[doc(alias = "POPPLER_PAGE_LAYOUT_TWO_COLUMN_LEFT")]
    TwoColumnLeft,
    #[doc(alias = "POPPLER_PAGE_LAYOUT_TWO_COLUMN_RIGHT")]
    TwoColumnRight,
    #[doc(alias = "POPPLER_PAGE_LAYOUT_TWO_PAGE_LEFT")]
    TwoPageLeft,
    #[doc(alias = "POPPLER_PAGE_LAYOUT_TWO_PAGE_RIGHT")]
    TwoPageRight,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for PageLayout {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "PageLayout::{}",
            match *self {
                Self::Unset => "Unset",
                Self::SinglePage => "SinglePage",
                Self::OneColumn => "OneColumn",
                Self::TwoColumnLeft => "TwoColumnLeft",
                Self::TwoColumnRight => "TwoColumnRight",
                Self::TwoPageLeft => "TwoPageLeft",
                Self::TwoPageRight => "TwoPageRight",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for PageLayout {
    type GlibType = ffi::PopplerPageLayout;

    fn into_glib(self) -> ffi::PopplerPageLayout {
        match self {
            Self::Unset => ffi::POPPLER_PAGE_LAYOUT_UNSET,
            Self::SinglePage => ffi::POPPLER_PAGE_LAYOUT_SINGLE_PAGE,
            Self::OneColumn => ffi::POPPLER_PAGE_LAYOUT_ONE_COLUMN,
            Self::TwoColumnLeft => ffi::POPPLER_PAGE_LAYOUT_TWO_COLUMN_LEFT,
            Self::TwoColumnRight => ffi::POPPLER_PAGE_LAYOUT_TWO_COLUMN_RIGHT,
            Self::TwoPageLeft => ffi::POPPLER_PAGE_LAYOUT_TWO_PAGE_LEFT,
            Self::TwoPageRight => ffi::POPPLER_PAGE_LAYOUT_TWO_PAGE_RIGHT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerPageLayout> for PageLayout {
    unsafe fn from_glib(value: ffi::PopplerPageLayout) -> Self {
        match value {
            ffi::POPPLER_PAGE_LAYOUT_UNSET => Self::Unset,
            ffi::POPPLER_PAGE_LAYOUT_SINGLE_PAGE => Self::SinglePage,
            ffi::POPPLER_PAGE_LAYOUT_ONE_COLUMN => Self::OneColumn,
            ffi::POPPLER_PAGE_LAYOUT_TWO_COLUMN_LEFT => Self::TwoColumnLeft,
            ffi::POPPLER_PAGE_LAYOUT_TWO_COLUMN_RIGHT => Self::TwoColumnRight,
            ffi::POPPLER_PAGE_LAYOUT_TWO_PAGE_LEFT => Self::TwoPageLeft,
            ffi::POPPLER_PAGE_LAYOUT_TWO_PAGE_RIGHT => Self::TwoPageRight,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for PageLayout {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_page_layout_get_type()) }
    }
}

impl glib::value::ValueType for PageLayout {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PageLayout {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PageLayout {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerPageMode")]
pub enum PageMode {
    #[doc(alias = "POPPLER_PAGE_MODE_UNSET")]
    Unset,
    #[doc(alias = "POPPLER_PAGE_MODE_NONE")]
    None,
    #[doc(alias = "POPPLER_PAGE_MODE_USE_OUTLINES")]
    UseOutlines,
    #[doc(alias = "POPPLER_PAGE_MODE_USE_THUMBS")]
    UseThumbs,
    #[doc(alias = "POPPLER_PAGE_MODE_FULL_SCREEN")]
    FullScreen,
    #[doc(alias = "POPPLER_PAGE_MODE_USE_OC")]
    UseOc,
    #[doc(alias = "POPPLER_PAGE_MODE_USE_ATTACHMENTS")]
    UseAttachments,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for PageMode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "PageMode::{}",
            match *self {
                Self::Unset => "Unset",
                Self::None => "None",
                Self::UseOutlines => "UseOutlines",
                Self::UseThumbs => "UseThumbs",
                Self::FullScreen => "FullScreen",
                Self::UseOc => "UseOc",
                Self::UseAttachments => "UseAttachments",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for PageMode {
    type GlibType = ffi::PopplerPageMode;

    fn into_glib(self) -> ffi::PopplerPageMode {
        match self {
            Self::Unset => ffi::POPPLER_PAGE_MODE_UNSET,
            Self::None => ffi::POPPLER_PAGE_MODE_NONE,
            Self::UseOutlines => ffi::POPPLER_PAGE_MODE_USE_OUTLINES,
            Self::UseThumbs => ffi::POPPLER_PAGE_MODE_USE_THUMBS,
            Self::FullScreen => ffi::POPPLER_PAGE_MODE_FULL_SCREEN,
            Self::UseOc => ffi::POPPLER_PAGE_MODE_USE_OC,
            Self::UseAttachments => ffi::POPPLER_PAGE_MODE_USE_ATTACHMENTS,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerPageMode> for PageMode {
    unsafe fn from_glib(value: ffi::PopplerPageMode) -> Self {
        match value {
            ffi::POPPLER_PAGE_MODE_UNSET => Self::Unset,
            ffi::POPPLER_PAGE_MODE_NONE => Self::None,
            ffi::POPPLER_PAGE_MODE_USE_OUTLINES => Self::UseOutlines,
            ffi::POPPLER_PAGE_MODE_USE_THUMBS => Self::UseThumbs,
            ffi::POPPLER_PAGE_MODE_FULL_SCREEN => Self::FullScreen,
            ffi::POPPLER_PAGE_MODE_USE_OC => Self::UseOc,
            ffi::POPPLER_PAGE_MODE_USE_ATTACHMENTS => Self::UseAttachments,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for PageMode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_page_mode_get_type()) }
    }
}

impl glib::value::ValueType for PageMode {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PageMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PageMode {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerPageTransitionAlignment")]
pub enum PageTransitionAlignment {
    #[doc(alias = "POPPLER_PAGE_TRANSITION_HORIZONTAL")]
    Horizontal,
    #[doc(alias = "POPPLER_PAGE_TRANSITION_VERTICAL")]
    Vertical,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for PageTransitionAlignment {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "PageTransitionAlignment::{}",
            match *self {
                Self::Horizontal => "Horizontal",
                Self::Vertical => "Vertical",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for PageTransitionAlignment {
    type GlibType = ffi::PopplerPageTransitionAlignment;

    fn into_glib(self) -> ffi::PopplerPageTransitionAlignment {
        match self {
            Self::Horizontal => ffi::POPPLER_PAGE_TRANSITION_HORIZONTAL,
            Self::Vertical => ffi::POPPLER_PAGE_TRANSITION_VERTICAL,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerPageTransitionAlignment> for PageTransitionAlignment {
    unsafe fn from_glib(value: ffi::PopplerPageTransitionAlignment) -> Self {
        match value {
            ffi::POPPLER_PAGE_TRANSITION_HORIZONTAL => Self::Horizontal,
            ffi::POPPLER_PAGE_TRANSITION_VERTICAL => Self::Vertical,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for PageTransitionAlignment {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_page_transition_alignment_get_type()) }
    }
}

impl glib::value::ValueType for PageTransitionAlignment {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PageTransitionAlignment {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PageTransitionAlignment {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerPageTransitionDirection")]
pub enum PageTransitionDirection {
    #[doc(alias = "POPPLER_PAGE_TRANSITION_INWARD")]
    Inward,
    #[doc(alias = "POPPLER_PAGE_TRANSITION_OUTWARD")]
    Outward,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for PageTransitionDirection {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "PageTransitionDirection::{}",
            match *self {
                Self::Inward => "Inward",
                Self::Outward => "Outward",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for PageTransitionDirection {
    type GlibType = ffi::PopplerPageTransitionDirection;

    fn into_glib(self) -> ffi::PopplerPageTransitionDirection {
        match self {
            Self::Inward => ffi::POPPLER_PAGE_TRANSITION_INWARD,
            Self::Outward => ffi::POPPLER_PAGE_TRANSITION_OUTWARD,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerPageTransitionDirection> for PageTransitionDirection {
    unsafe fn from_glib(value: ffi::PopplerPageTransitionDirection) -> Self {
        match value {
            ffi::POPPLER_PAGE_TRANSITION_INWARD => Self::Inward,
            ffi::POPPLER_PAGE_TRANSITION_OUTWARD => Self::Outward,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for PageTransitionDirection {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_page_transition_direction_get_type()) }
    }
}

impl glib::value::ValueType for PageTransitionDirection {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PageTransitionDirection {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PageTransitionDirection {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerPageTransitionType")]
pub enum PageTransitionType {
    #[doc(alias = "POPPLER_PAGE_TRANSITION_REPLACE")]
    Replace,
    #[doc(alias = "POPPLER_PAGE_TRANSITION_SPLIT")]
    Split,
    #[doc(alias = "POPPLER_PAGE_TRANSITION_BLINDS")]
    Blinds,
    #[doc(alias = "POPPLER_PAGE_TRANSITION_BOX")]
    Box,
    #[doc(alias = "POPPLER_PAGE_TRANSITION_WIPE")]
    Wipe,
    #[doc(alias = "POPPLER_PAGE_TRANSITION_DISSOLVE")]
    Dissolve,
    #[doc(alias = "POPPLER_PAGE_TRANSITION_GLITTER")]
    Glitter,
    #[doc(alias = "POPPLER_PAGE_TRANSITION_FLY")]
    Fly,
    #[doc(alias = "POPPLER_PAGE_TRANSITION_PUSH")]
    Push,
    #[doc(alias = "POPPLER_PAGE_TRANSITION_COVER")]
    Cover,
    #[doc(alias = "POPPLER_PAGE_TRANSITION_UNCOVER")]
    Uncover,
    #[doc(alias = "POPPLER_PAGE_TRANSITION_FADE")]
    Fade,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for PageTransitionType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "PageTransitionType::{}",
            match *self {
                Self::Replace => "Replace",
                Self::Split => "Split",
                Self::Blinds => "Blinds",
                Self::Box => "Box",
                Self::Wipe => "Wipe",
                Self::Dissolve => "Dissolve",
                Self::Glitter => "Glitter",
                Self::Fly => "Fly",
                Self::Push => "Push",
                Self::Cover => "Cover",
                Self::Uncover => "Uncover",
                Self::Fade => "Fade",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for PageTransitionType {
    type GlibType = ffi::PopplerPageTransitionType;

    fn into_glib(self) -> ffi::PopplerPageTransitionType {
        match self {
            Self::Replace => ffi::POPPLER_PAGE_TRANSITION_REPLACE,
            Self::Split => ffi::POPPLER_PAGE_TRANSITION_SPLIT,
            Self::Blinds => ffi::POPPLER_PAGE_TRANSITION_BLINDS,
            Self::Box => ffi::POPPLER_PAGE_TRANSITION_BOX,
            Self::Wipe => ffi::POPPLER_PAGE_TRANSITION_WIPE,
            Self::Dissolve => ffi::POPPLER_PAGE_TRANSITION_DISSOLVE,
            Self::Glitter => ffi::POPPLER_PAGE_TRANSITION_GLITTER,
            Self::Fly => ffi::POPPLER_PAGE_TRANSITION_FLY,
            Self::Push => ffi::POPPLER_PAGE_TRANSITION_PUSH,
            Self::Cover => ffi::POPPLER_PAGE_TRANSITION_COVER,
            Self::Uncover => ffi::POPPLER_PAGE_TRANSITION_UNCOVER,
            Self::Fade => ffi::POPPLER_PAGE_TRANSITION_FADE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerPageTransitionType> for PageTransitionType {
    unsafe fn from_glib(value: ffi::PopplerPageTransitionType) -> Self {
        match value {
            ffi::POPPLER_PAGE_TRANSITION_REPLACE => Self::Replace,
            ffi::POPPLER_PAGE_TRANSITION_SPLIT => Self::Split,
            ffi::POPPLER_PAGE_TRANSITION_BLINDS => Self::Blinds,
            ffi::POPPLER_PAGE_TRANSITION_BOX => Self::Box,
            ffi::POPPLER_PAGE_TRANSITION_WIPE => Self::Wipe,
            ffi::POPPLER_PAGE_TRANSITION_DISSOLVE => Self::Dissolve,
            ffi::POPPLER_PAGE_TRANSITION_GLITTER => Self::Glitter,
            ffi::POPPLER_PAGE_TRANSITION_FLY => Self::Fly,
            ffi::POPPLER_PAGE_TRANSITION_PUSH => Self::Push,
            ffi::POPPLER_PAGE_TRANSITION_COVER => Self::Cover,
            ffi::POPPLER_PAGE_TRANSITION_UNCOVER => Self::Uncover,
            ffi::POPPLER_PAGE_TRANSITION_FADE => Self::Fade,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for PageTransitionType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_page_transition_type_get_type()) }
    }
}

impl glib::value::ValueType for PageTransitionType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PageTransitionType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PageTransitionType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(any(feature = "v0_80", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_80")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerPrintDuplex")]
pub enum PrintDuplex {
    #[doc(alias = "POPPLER_PRINT_DUPLEX_NONE")]
    None,
    #[doc(alias = "POPPLER_PRINT_DUPLEX_SIMPLEX")]
    Simplex,
    #[doc(alias = "POPPLER_PRINT_DUPLEX_DUPLEX_FLIP_SHORT_EDGE")]
    DuplexFlipShortEdge,
    #[doc(alias = "POPPLER_PRINT_DUPLEX_DUPLEX_FLIP_LONG_EDGE")]
    DuplexFlipLongEdge,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v0_80", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_80")))]
impl fmt::Display for PrintDuplex {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "PrintDuplex::{}",
            match *self {
                Self::None => "None",
                Self::Simplex => "Simplex",
                Self::DuplexFlipShortEdge => "DuplexFlipShortEdge",
                Self::DuplexFlipLongEdge => "DuplexFlipLongEdge",
                _ => "Unknown",
            }
        )
    }
}

#[cfg(any(feature = "v0_80", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_80")))]
#[doc(hidden)]
impl IntoGlib for PrintDuplex {
    type GlibType = ffi::PopplerPrintDuplex;

    fn into_glib(self) -> ffi::PopplerPrintDuplex {
        match self {
            Self::None => ffi::POPPLER_PRINT_DUPLEX_NONE,
            Self::Simplex => ffi::POPPLER_PRINT_DUPLEX_SIMPLEX,
            Self::DuplexFlipShortEdge => ffi::POPPLER_PRINT_DUPLEX_DUPLEX_FLIP_SHORT_EDGE,
            Self::DuplexFlipLongEdge => ffi::POPPLER_PRINT_DUPLEX_DUPLEX_FLIP_LONG_EDGE,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(any(feature = "v0_80", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_80")))]
#[doc(hidden)]
impl FromGlib<ffi::PopplerPrintDuplex> for PrintDuplex {
    unsafe fn from_glib(value: ffi::PopplerPrintDuplex) -> Self {
        match value {
            ffi::POPPLER_PRINT_DUPLEX_NONE => Self::None,
            ffi::POPPLER_PRINT_DUPLEX_SIMPLEX => Self::Simplex,
            ffi::POPPLER_PRINT_DUPLEX_DUPLEX_FLIP_SHORT_EDGE => Self::DuplexFlipShortEdge,
            ffi::POPPLER_PRINT_DUPLEX_DUPLEX_FLIP_LONG_EDGE => Self::DuplexFlipLongEdge,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(any(feature = "v0_80", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_80")))]
impl StaticType for PrintDuplex {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_print_duplex_get_type()) }
    }
}

#[cfg(any(feature = "v0_80", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_80")))]
impl glib::value::ValueType for PrintDuplex {
    type Type = Self;
}

#[cfg(any(feature = "v0_80", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_80")))]
unsafe impl<'a> FromValue<'a> for PrintDuplex {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v0_80", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_80")))]
impl ToValue for PrintDuplex {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[cfg(any(feature = "v0_73", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_73")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerPrintScaling")]
pub enum PrintScaling {
    #[doc(alias = "POPPLER_PRINT_SCALING_APP_DEFAULT")]
    AppDefault,
    #[doc(alias = "POPPLER_PRINT_SCALING_NONE")]
    None,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v0_73", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_73")))]
impl fmt::Display for PrintScaling {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "PrintScaling::{}",
            match *self {
                Self::AppDefault => "AppDefault",
                Self::None => "None",
                _ => "Unknown",
            }
        )
    }
}

#[cfg(any(feature = "v0_73", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_73")))]
#[doc(hidden)]
impl IntoGlib for PrintScaling {
    type GlibType = ffi::PopplerPrintScaling;

    fn into_glib(self) -> ffi::PopplerPrintScaling {
        match self {
            Self::AppDefault => ffi::POPPLER_PRINT_SCALING_APP_DEFAULT,
            Self::None => ffi::POPPLER_PRINT_SCALING_NONE,
            Self::__Unknown(value) => value,
        }
    }
}

#[cfg(any(feature = "v0_73", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_73")))]
#[doc(hidden)]
impl FromGlib<ffi::PopplerPrintScaling> for PrintScaling {
    unsafe fn from_glib(value: ffi::PopplerPrintScaling) -> Self {
        match value {
            ffi::POPPLER_PRINT_SCALING_APP_DEFAULT => Self::AppDefault,
            ffi::POPPLER_PRINT_SCALING_NONE => Self::None,
            value => Self::__Unknown(value),
        }
    }
}

#[cfg(any(feature = "v0_73", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_73")))]
impl StaticType for PrintScaling {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_print_scaling_get_type()) }
    }
}

#[cfg(any(feature = "v0_73", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_73")))]
impl glib::value::ValueType for PrintScaling {
    type Type = Self;
}

#[cfg(any(feature = "v0_73", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_73")))]
unsafe impl<'a> FromValue<'a> for PrintScaling {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v0_73", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_73")))]
impl ToValue for PrintScaling {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerSelectionStyle")]
pub enum SelectionStyle {
    #[doc(alias = "POPPLER_SELECTION_GLYPH")]
    Glyph,
    #[doc(alias = "POPPLER_SELECTION_WORD")]
    Word,
    #[doc(alias = "POPPLER_SELECTION_LINE")]
    Line,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for SelectionStyle {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "SelectionStyle::{}",
            match *self {
                Self::Glyph => "Glyph",
                Self::Word => "Word",
                Self::Line => "Line",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for SelectionStyle {
    type GlibType = ffi::PopplerSelectionStyle;

    fn into_glib(self) -> ffi::PopplerSelectionStyle {
        match self {
            Self::Glyph => ffi::POPPLER_SELECTION_GLYPH,
            Self::Word => ffi::POPPLER_SELECTION_WORD,
            Self::Line => ffi::POPPLER_SELECTION_LINE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerSelectionStyle> for SelectionStyle {
    unsafe fn from_glib(value: ffi::PopplerSelectionStyle) -> Self {
        match value {
            ffi::POPPLER_SELECTION_GLYPH => Self::Glyph,
            ffi::POPPLER_SELECTION_WORD => Self::Word,
            ffi::POPPLER_SELECTION_LINE => Self::Line,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for SelectionStyle {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_selection_style_get_type()) }
    }
}

impl glib::value::ValueType for SelectionStyle {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for SelectionStyle {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for SelectionStyle {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerStructureBlockAlign")]
pub enum StructureBlockAlign {
    #[doc(alias = "POPPLER_STRUCTURE_BLOCK_ALIGN_BEFORE")]
    Before,
    #[doc(alias = "POPPLER_STRUCTURE_BLOCK_ALIGN_MIDDLE")]
    Middle,
    #[doc(alias = "POPPLER_STRUCTURE_BLOCK_ALIGN_AFTER")]
    After,
    #[doc(alias = "POPPLER_STRUCTURE_BLOCK_ALIGN_JUSTIFY")]
    Justify,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for StructureBlockAlign {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "StructureBlockAlign::{}",
            match *self {
                Self::Before => "Before",
                Self::Middle => "Middle",
                Self::After => "After",
                Self::Justify => "Justify",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for StructureBlockAlign {
    type GlibType = ffi::PopplerStructureBlockAlign;

    fn into_glib(self) -> ffi::PopplerStructureBlockAlign {
        match self {
            Self::Before => ffi::POPPLER_STRUCTURE_BLOCK_ALIGN_BEFORE,
            Self::Middle => ffi::POPPLER_STRUCTURE_BLOCK_ALIGN_MIDDLE,
            Self::After => ffi::POPPLER_STRUCTURE_BLOCK_ALIGN_AFTER,
            Self::Justify => ffi::POPPLER_STRUCTURE_BLOCK_ALIGN_JUSTIFY,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerStructureBlockAlign> for StructureBlockAlign {
    unsafe fn from_glib(value: ffi::PopplerStructureBlockAlign) -> Self {
        match value {
            ffi::POPPLER_STRUCTURE_BLOCK_ALIGN_BEFORE => Self::Before,
            ffi::POPPLER_STRUCTURE_BLOCK_ALIGN_MIDDLE => Self::Middle,
            ffi::POPPLER_STRUCTURE_BLOCK_ALIGN_AFTER => Self::After,
            ffi::POPPLER_STRUCTURE_BLOCK_ALIGN_JUSTIFY => Self::Justify,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for StructureBlockAlign {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_structure_block_align_get_type()) }
    }
}

impl glib::value::ValueType for StructureBlockAlign {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for StructureBlockAlign {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for StructureBlockAlign {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerStructureBorderStyle")]
pub enum StructureBorderStyle {
    #[doc(alias = "POPPLER_STRUCTURE_BORDER_STYLE_NONE")]
    None,
    #[doc(alias = "POPPLER_STRUCTURE_BORDER_STYLE_HIDDEN")]
    Hidden,
    #[doc(alias = "POPPLER_STRUCTURE_BORDER_STYLE_DOTTED")]
    Dotted,
    #[doc(alias = "POPPLER_STRUCTURE_BORDER_STYLE_DASHED")]
    Dashed,
    #[doc(alias = "POPPLER_STRUCTURE_BORDER_STYLE_SOLID")]
    Solid,
    #[doc(alias = "POPPLER_STRUCTURE_BORDER_STYLE_DOUBLE")]
    Double,
    #[doc(alias = "POPPLER_STRUCTURE_BORDER_STYLE_GROOVE")]
    Groove,
    #[doc(alias = "POPPLER_STRUCTURE_BORDER_STYLE_INSET")]
    Inset,
    #[doc(alias = "POPPLER_STRUCTURE_BORDER_STYLE_OUTSET")]
    Outset,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for StructureBorderStyle {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "StructureBorderStyle::{}",
            match *self {
                Self::None => "None",
                Self::Hidden => "Hidden",
                Self::Dotted => "Dotted",
                Self::Dashed => "Dashed",
                Self::Solid => "Solid",
                Self::Double => "Double",
                Self::Groove => "Groove",
                Self::Inset => "Inset",
                Self::Outset => "Outset",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for StructureBorderStyle {
    type GlibType = ffi::PopplerStructureBorderStyle;

    fn into_glib(self) -> ffi::PopplerStructureBorderStyle {
        match self {
            Self::None => ffi::POPPLER_STRUCTURE_BORDER_STYLE_NONE,
            Self::Hidden => ffi::POPPLER_STRUCTURE_BORDER_STYLE_HIDDEN,
            Self::Dotted => ffi::POPPLER_STRUCTURE_BORDER_STYLE_DOTTED,
            Self::Dashed => ffi::POPPLER_STRUCTURE_BORDER_STYLE_DASHED,
            Self::Solid => ffi::POPPLER_STRUCTURE_BORDER_STYLE_SOLID,
            Self::Double => ffi::POPPLER_STRUCTURE_BORDER_STYLE_DOUBLE,
            Self::Groove => ffi::POPPLER_STRUCTURE_BORDER_STYLE_GROOVE,
            Self::Inset => ffi::POPPLER_STRUCTURE_BORDER_STYLE_INSET,
            Self::Outset => ffi::POPPLER_STRUCTURE_BORDER_STYLE_OUTSET,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerStructureBorderStyle> for StructureBorderStyle {
    unsafe fn from_glib(value: ffi::PopplerStructureBorderStyle) -> Self {
        match value {
            ffi::POPPLER_STRUCTURE_BORDER_STYLE_NONE => Self::None,
            ffi::POPPLER_STRUCTURE_BORDER_STYLE_HIDDEN => Self::Hidden,
            ffi::POPPLER_STRUCTURE_BORDER_STYLE_DOTTED => Self::Dotted,
            ffi::POPPLER_STRUCTURE_BORDER_STYLE_DASHED => Self::Dashed,
            ffi::POPPLER_STRUCTURE_BORDER_STYLE_SOLID => Self::Solid,
            ffi::POPPLER_STRUCTURE_BORDER_STYLE_DOUBLE => Self::Double,
            ffi::POPPLER_STRUCTURE_BORDER_STYLE_GROOVE => Self::Groove,
            ffi::POPPLER_STRUCTURE_BORDER_STYLE_INSET => Self::Inset,
            ffi::POPPLER_STRUCTURE_BORDER_STYLE_OUTSET => Self::Outset,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for StructureBorderStyle {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_structure_border_style_get_type()) }
    }
}

impl glib::value::ValueType for StructureBorderStyle {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for StructureBorderStyle {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for StructureBorderStyle {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerStructureElementKind")]
pub enum StructureElementKind {
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_CONTENT")]
    Content,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_OBJECT_REFERENCE")]
    ObjectReference,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_DOCUMENT")]
    Document,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_PART")]
    Part,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_ARTICLE")]
    Article,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_SECTION")]
    Section,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_DIV")]
    Div,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_SPAN")]
    Span,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_QUOTE")]
    Quote,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_NOTE")]
    Note,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_REFERENCE")]
    Reference,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_BIBENTRY")]
    Bibentry,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_CODE")]
    Code,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_LINK")]
    Link,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_ANNOT")]
    Annot,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_BLOCKQUOTE")]
    Blockquote,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_CAPTION")]
    Caption,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_NONSTRUCT")]
    Nonstruct,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_TOC")]
    Toc,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_TOC_ITEM")]
    TocItem,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_INDEX")]
    Index,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_PRIVATE")]
    Private,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_PARAGRAPH")]
    Paragraph,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_HEADING")]
    Heading,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_HEADING_1")]
    Heading1,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_HEADING_2")]
    Heading2,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_HEADING_3")]
    Heading3,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_HEADING_4")]
    Heading4,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_HEADING_5")]
    Heading5,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_HEADING_6")]
    Heading6,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_LIST")]
    List,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_LIST_ITEM")]
    ListItem,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_LIST_LABEL")]
    ListLabel,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_LIST_BODY")]
    ListBody,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_TABLE")]
    Table,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_TABLE_ROW")]
    TableRow,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_TABLE_HEADING")]
    TableHeading,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_TABLE_DATA")]
    TableData,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_TABLE_HEADER")]
    TableHeader,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_TABLE_FOOTER")]
    TableFooter,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_TABLE_BODY")]
    TableBody,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_RUBY")]
    Ruby,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_RUBY_BASE_TEXT")]
    RubyBaseText,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_RUBY_ANNOT_TEXT")]
    RubyAnnotText,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_RUBY_PUNCTUATION")]
    RubyPunctuation,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_WARICHU")]
    Warichu,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_WARICHU_TEXT")]
    WarichuText,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_WARICHU_PUNCTUATION")]
    WarichuPunctuation,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_FIGURE")]
    Figure,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_FORMULA")]
    Formula,
    #[doc(alias = "POPPLER_STRUCTURE_ELEMENT_FORM")]
    Form,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for StructureElementKind {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "StructureElementKind::{}",
            match *self {
                Self::Content => "Content",
                Self::ObjectReference => "ObjectReference",
                Self::Document => "Document",
                Self::Part => "Part",
                Self::Article => "Article",
                Self::Section => "Section",
                Self::Div => "Div",
                Self::Span => "Span",
                Self::Quote => "Quote",
                Self::Note => "Note",
                Self::Reference => "Reference",
                Self::Bibentry => "Bibentry",
                Self::Code => "Code",
                Self::Link => "Link",
                Self::Annot => "Annot",
                Self::Blockquote => "Blockquote",
                Self::Caption => "Caption",
                Self::Nonstruct => "Nonstruct",
                Self::Toc => "Toc",
                Self::TocItem => "TocItem",
                Self::Index => "Index",
                Self::Private => "Private",
                Self::Paragraph => "Paragraph",
                Self::Heading => "Heading",
                Self::Heading1 => "Heading1",
                Self::Heading2 => "Heading2",
                Self::Heading3 => "Heading3",
                Self::Heading4 => "Heading4",
                Self::Heading5 => "Heading5",
                Self::Heading6 => "Heading6",
                Self::List => "List",
                Self::ListItem => "ListItem",
                Self::ListLabel => "ListLabel",
                Self::ListBody => "ListBody",
                Self::Table => "Table",
                Self::TableRow => "TableRow",
                Self::TableHeading => "TableHeading",
                Self::TableData => "TableData",
                Self::TableHeader => "TableHeader",
                Self::TableFooter => "TableFooter",
                Self::TableBody => "TableBody",
                Self::Ruby => "Ruby",
                Self::RubyBaseText => "RubyBaseText",
                Self::RubyAnnotText => "RubyAnnotText",
                Self::RubyPunctuation => "RubyPunctuation",
                Self::Warichu => "Warichu",
                Self::WarichuText => "WarichuText",
                Self::WarichuPunctuation => "WarichuPunctuation",
                Self::Figure => "Figure",
                Self::Formula => "Formula",
                Self::Form => "Form",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for StructureElementKind {
    type GlibType = ffi::PopplerStructureElementKind;

    fn into_glib(self) -> ffi::PopplerStructureElementKind {
        match self {
            Self::Content => ffi::POPPLER_STRUCTURE_ELEMENT_CONTENT,
            Self::ObjectReference => ffi::POPPLER_STRUCTURE_ELEMENT_OBJECT_REFERENCE,
            Self::Document => ffi::POPPLER_STRUCTURE_ELEMENT_DOCUMENT,
            Self::Part => ffi::POPPLER_STRUCTURE_ELEMENT_PART,
            Self::Article => ffi::POPPLER_STRUCTURE_ELEMENT_ARTICLE,
            Self::Section => ffi::POPPLER_STRUCTURE_ELEMENT_SECTION,
            Self::Div => ffi::POPPLER_STRUCTURE_ELEMENT_DIV,
            Self::Span => ffi::POPPLER_STRUCTURE_ELEMENT_SPAN,
            Self::Quote => ffi::POPPLER_STRUCTURE_ELEMENT_QUOTE,
            Self::Note => ffi::POPPLER_STRUCTURE_ELEMENT_NOTE,
            Self::Reference => ffi::POPPLER_STRUCTURE_ELEMENT_REFERENCE,
            Self::Bibentry => ffi::POPPLER_STRUCTURE_ELEMENT_BIBENTRY,
            Self::Code => ffi::POPPLER_STRUCTURE_ELEMENT_CODE,
            Self::Link => ffi::POPPLER_STRUCTURE_ELEMENT_LINK,
            Self::Annot => ffi::POPPLER_STRUCTURE_ELEMENT_ANNOT,
            Self::Blockquote => ffi::POPPLER_STRUCTURE_ELEMENT_BLOCKQUOTE,
            Self::Caption => ffi::POPPLER_STRUCTURE_ELEMENT_CAPTION,
            Self::Nonstruct => ffi::POPPLER_STRUCTURE_ELEMENT_NONSTRUCT,
            Self::Toc => ffi::POPPLER_STRUCTURE_ELEMENT_TOC,
            Self::TocItem => ffi::POPPLER_STRUCTURE_ELEMENT_TOC_ITEM,
            Self::Index => ffi::POPPLER_STRUCTURE_ELEMENT_INDEX,
            Self::Private => ffi::POPPLER_STRUCTURE_ELEMENT_PRIVATE,
            Self::Paragraph => ffi::POPPLER_STRUCTURE_ELEMENT_PARAGRAPH,
            Self::Heading => ffi::POPPLER_STRUCTURE_ELEMENT_HEADING,
            Self::Heading1 => ffi::POPPLER_STRUCTURE_ELEMENT_HEADING_1,
            Self::Heading2 => ffi::POPPLER_STRUCTURE_ELEMENT_HEADING_2,
            Self::Heading3 => ffi::POPPLER_STRUCTURE_ELEMENT_HEADING_3,
            Self::Heading4 => ffi::POPPLER_STRUCTURE_ELEMENT_HEADING_4,
            Self::Heading5 => ffi::POPPLER_STRUCTURE_ELEMENT_HEADING_5,
            Self::Heading6 => ffi::POPPLER_STRUCTURE_ELEMENT_HEADING_6,
            Self::List => ffi::POPPLER_STRUCTURE_ELEMENT_LIST,
            Self::ListItem => ffi::POPPLER_STRUCTURE_ELEMENT_LIST_ITEM,
            Self::ListLabel => ffi::POPPLER_STRUCTURE_ELEMENT_LIST_LABEL,
            Self::ListBody => ffi::POPPLER_STRUCTURE_ELEMENT_LIST_BODY,
            Self::Table => ffi::POPPLER_STRUCTURE_ELEMENT_TABLE,
            Self::TableRow => ffi::POPPLER_STRUCTURE_ELEMENT_TABLE_ROW,
            Self::TableHeading => ffi::POPPLER_STRUCTURE_ELEMENT_TABLE_HEADING,
            Self::TableData => ffi::POPPLER_STRUCTURE_ELEMENT_TABLE_DATA,
            Self::TableHeader => ffi::POPPLER_STRUCTURE_ELEMENT_TABLE_HEADER,
            Self::TableFooter => ffi::POPPLER_STRUCTURE_ELEMENT_TABLE_FOOTER,
            Self::TableBody => ffi::POPPLER_STRUCTURE_ELEMENT_TABLE_BODY,
            Self::Ruby => ffi::POPPLER_STRUCTURE_ELEMENT_RUBY,
            Self::RubyBaseText => ffi::POPPLER_STRUCTURE_ELEMENT_RUBY_BASE_TEXT,
            Self::RubyAnnotText => ffi::POPPLER_STRUCTURE_ELEMENT_RUBY_ANNOT_TEXT,
            Self::RubyPunctuation => ffi::POPPLER_STRUCTURE_ELEMENT_RUBY_PUNCTUATION,
            Self::Warichu => ffi::POPPLER_STRUCTURE_ELEMENT_WARICHU,
            Self::WarichuText => ffi::POPPLER_STRUCTURE_ELEMENT_WARICHU_TEXT,
            Self::WarichuPunctuation => ffi::POPPLER_STRUCTURE_ELEMENT_WARICHU_PUNCTUATION,
            Self::Figure => ffi::POPPLER_STRUCTURE_ELEMENT_FIGURE,
            Self::Formula => ffi::POPPLER_STRUCTURE_ELEMENT_FORMULA,
            Self::Form => ffi::POPPLER_STRUCTURE_ELEMENT_FORM,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerStructureElementKind> for StructureElementKind {
    unsafe fn from_glib(value: ffi::PopplerStructureElementKind) -> Self {
        match value {
            ffi::POPPLER_STRUCTURE_ELEMENT_CONTENT => Self::Content,
            ffi::POPPLER_STRUCTURE_ELEMENT_OBJECT_REFERENCE => Self::ObjectReference,
            ffi::POPPLER_STRUCTURE_ELEMENT_DOCUMENT => Self::Document,
            ffi::POPPLER_STRUCTURE_ELEMENT_PART => Self::Part,
            ffi::POPPLER_STRUCTURE_ELEMENT_ARTICLE => Self::Article,
            ffi::POPPLER_STRUCTURE_ELEMENT_SECTION => Self::Section,
            ffi::POPPLER_STRUCTURE_ELEMENT_DIV => Self::Div,
            ffi::POPPLER_STRUCTURE_ELEMENT_SPAN => Self::Span,
            ffi::POPPLER_STRUCTURE_ELEMENT_QUOTE => Self::Quote,
            ffi::POPPLER_STRUCTURE_ELEMENT_NOTE => Self::Note,
            ffi::POPPLER_STRUCTURE_ELEMENT_REFERENCE => Self::Reference,
            ffi::POPPLER_STRUCTURE_ELEMENT_BIBENTRY => Self::Bibentry,
            ffi::POPPLER_STRUCTURE_ELEMENT_CODE => Self::Code,
            ffi::POPPLER_STRUCTURE_ELEMENT_LINK => Self::Link,
            ffi::POPPLER_STRUCTURE_ELEMENT_ANNOT => Self::Annot,
            ffi::POPPLER_STRUCTURE_ELEMENT_BLOCKQUOTE => Self::Blockquote,
            ffi::POPPLER_STRUCTURE_ELEMENT_CAPTION => Self::Caption,
            ffi::POPPLER_STRUCTURE_ELEMENT_NONSTRUCT => Self::Nonstruct,
            ffi::POPPLER_STRUCTURE_ELEMENT_TOC => Self::Toc,
            ffi::POPPLER_STRUCTURE_ELEMENT_TOC_ITEM => Self::TocItem,
            ffi::POPPLER_STRUCTURE_ELEMENT_INDEX => Self::Index,
            ffi::POPPLER_STRUCTURE_ELEMENT_PRIVATE => Self::Private,
            ffi::POPPLER_STRUCTURE_ELEMENT_PARAGRAPH => Self::Paragraph,
            ffi::POPPLER_STRUCTURE_ELEMENT_HEADING => Self::Heading,
            ffi::POPPLER_STRUCTURE_ELEMENT_HEADING_1 => Self::Heading1,
            ffi::POPPLER_STRUCTURE_ELEMENT_HEADING_2 => Self::Heading2,
            ffi::POPPLER_STRUCTURE_ELEMENT_HEADING_3 => Self::Heading3,
            ffi::POPPLER_STRUCTURE_ELEMENT_HEADING_4 => Self::Heading4,
            ffi::POPPLER_STRUCTURE_ELEMENT_HEADING_5 => Self::Heading5,
            ffi::POPPLER_STRUCTURE_ELEMENT_HEADING_6 => Self::Heading6,
            ffi::POPPLER_STRUCTURE_ELEMENT_LIST => Self::List,
            ffi::POPPLER_STRUCTURE_ELEMENT_LIST_ITEM => Self::ListItem,
            ffi::POPPLER_STRUCTURE_ELEMENT_LIST_LABEL => Self::ListLabel,
            ffi::POPPLER_STRUCTURE_ELEMENT_LIST_BODY => Self::ListBody,
            ffi::POPPLER_STRUCTURE_ELEMENT_TABLE => Self::Table,
            ffi::POPPLER_STRUCTURE_ELEMENT_TABLE_ROW => Self::TableRow,
            ffi::POPPLER_STRUCTURE_ELEMENT_TABLE_HEADING => Self::TableHeading,
            ffi::POPPLER_STRUCTURE_ELEMENT_TABLE_DATA => Self::TableData,
            ffi::POPPLER_STRUCTURE_ELEMENT_TABLE_HEADER => Self::TableHeader,
            ffi::POPPLER_STRUCTURE_ELEMENT_TABLE_FOOTER => Self::TableFooter,
            ffi::POPPLER_STRUCTURE_ELEMENT_TABLE_BODY => Self::TableBody,
            ffi::POPPLER_STRUCTURE_ELEMENT_RUBY => Self::Ruby,
            ffi::POPPLER_STRUCTURE_ELEMENT_RUBY_BASE_TEXT => Self::RubyBaseText,
            ffi::POPPLER_STRUCTURE_ELEMENT_RUBY_ANNOT_TEXT => Self::RubyAnnotText,
            ffi::POPPLER_STRUCTURE_ELEMENT_RUBY_PUNCTUATION => Self::RubyPunctuation,
            ffi::POPPLER_STRUCTURE_ELEMENT_WARICHU => Self::Warichu,
            ffi::POPPLER_STRUCTURE_ELEMENT_WARICHU_TEXT => Self::WarichuText,
            ffi::POPPLER_STRUCTURE_ELEMENT_WARICHU_PUNCTUATION => Self::WarichuPunctuation,
            ffi::POPPLER_STRUCTURE_ELEMENT_FIGURE => Self::Figure,
            ffi::POPPLER_STRUCTURE_ELEMENT_FORMULA => Self::Formula,
            ffi::POPPLER_STRUCTURE_ELEMENT_FORM => Self::Form,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for StructureElementKind {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_structure_element_kind_get_type()) }
    }
}

impl glib::value::ValueType for StructureElementKind {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for StructureElementKind {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for StructureElementKind {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerStructureFormRole")]
pub enum StructureFormRole {
    #[doc(alias = "POPPLER_STRUCTURE_FORM_ROLE_UNDEFINED")]
    Undefined,
    #[doc(alias = "POPPLER_STRUCTURE_FORM_ROLE_RADIO_BUTTON")]
    RadioButton,
    #[doc(alias = "POPPLER_STRUCTURE_FORM_ROLE_PUSH_BUTTON")]
    PushButton,
    #[doc(alias = "POPPLER_STRUCTURE_FORM_ROLE_TEXT_VALUE")]
    TextValue,
    #[doc(alias = "POPPLER_STRUCTURE_FORM_ROLE_CHECKBOX")]
    Checkbox,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for StructureFormRole {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "StructureFormRole::{}",
            match *self {
                Self::Undefined => "Undefined",
                Self::RadioButton => "RadioButton",
                Self::PushButton => "PushButton",
                Self::TextValue => "TextValue",
                Self::Checkbox => "Checkbox",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for StructureFormRole {
    type GlibType = ffi::PopplerStructureFormRole;

    fn into_glib(self) -> ffi::PopplerStructureFormRole {
        match self {
            Self::Undefined => ffi::POPPLER_STRUCTURE_FORM_ROLE_UNDEFINED,
            Self::RadioButton => ffi::POPPLER_STRUCTURE_FORM_ROLE_RADIO_BUTTON,
            Self::PushButton => ffi::POPPLER_STRUCTURE_FORM_ROLE_PUSH_BUTTON,
            Self::TextValue => ffi::POPPLER_STRUCTURE_FORM_ROLE_TEXT_VALUE,
            Self::Checkbox => ffi::POPPLER_STRUCTURE_FORM_ROLE_CHECKBOX,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerStructureFormRole> for StructureFormRole {
    unsafe fn from_glib(value: ffi::PopplerStructureFormRole) -> Self {
        match value {
            ffi::POPPLER_STRUCTURE_FORM_ROLE_UNDEFINED => Self::Undefined,
            ffi::POPPLER_STRUCTURE_FORM_ROLE_RADIO_BUTTON => Self::RadioButton,
            ffi::POPPLER_STRUCTURE_FORM_ROLE_PUSH_BUTTON => Self::PushButton,
            ffi::POPPLER_STRUCTURE_FORM_ROLE_TEXT_VALUE => Self::TextValue,
            ffi::POPPLER_STRUCTURE_FORM_ROLE_CHECKBOX => Self::Checkbox,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for StructureFormRole {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_structure_form_role_get_type()) }
    }
}

impl glib::value::ValueType for StructureFormRole {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for StructureFormRole {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for StructureFormRole {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerStructureFormState")]
pub enum StructureFormState {
    #[doc(alias = "POPPLER_STRUCTURE_FORM_STATE_ON")]
    On,
    #[doc(alias = "POPPLER_STRUCTURE_FORM_STATE_OFF")]
    Off,
    #[doc(alias = "POPPLER_STRUCTURE_FORM_STATE_NEUTRAL")]
    Neutral,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for StructureFormState {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "StructureFormState::{}",
            match *self {
                Self::On => "On",
                Self::Off => "Off",
                Self::Neutral => "Neutral",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for StructureFormState {
    type GlibType = ffi::PopplerStructureFormState;

    fn into_glib(self) -> ffi::PopplerStructureFormState {
        match self {
            Self::On => ffi::POPPLER_STRUCTURE_FORM_STATE_ON,
            Self::Off => ffi::POPPLER_STRUCTURE_FORM_STATE_OFF,
            Self::Neutral => ffi::POPPLER_STRUCTURE_FORM_STATE_NEUTRAL,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerStructureFormState> for StructureFormState {
    unsafe fn from_glib(value: ffi::PopplerStructureFormState) -> Self {
        match value {
            ffi::POPPLER_STRUCTURE_FORM_STATE_ON => Self::On,
            ffi::POPPLER_STRUCTURE_FORM_STATE_OFF => Self::Off,
            ffi::POPPLER_STRUCTURE_FORM_STATE_NEUTRAL => Self::Neutral,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for StructureFormState {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_structure_form_state_get_type()) }
    }
}

impl glib::value::ValueType for StructureFormState {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for StructureFormState {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for StructureFormState {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerStructureGlyphOrientation")]
pub enum StructureGlyphOrientation {
    #[doc(alias = "POPPLER_STRUCTURE_GLYPH_ORIENTATION_AUTO")]
    Auto,
    #[doc(alias = "POPPLER_STRUCTURE_GLYPH_ORIENTATION_90")]
    _90,
    #[doc(alias = "POPPLER_STRUCTURE_GLYPH_ORIENTATION_180")]
    _180,
    #[doc(alias = "POPPLER_STRUCTURE_GLYPH_ORIENTATION_270")]
    _270,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for StructureGlyphOrientation {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "StructureGlyphOrientation::{}",
            match *self {
                Self::Auto => "Auto",
                Self::_90 => "_90",
                Self::_180 => "_180",
                Self::_270 => "_270",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for StructureGlyphOrientation {
    type GlibType = ffi::PopplerStructureGlyphOrientation;

    fn into_glib(self) -> ffi::PopplerStructureGlyphOrientation {
        match self {
            Self::Auto => ffi::POPPLER_STRUCTURE_GLYPH_ORIENTATION_AUTO,
            Self::_90 => ffi::POPPLER_STRUCTURE_GLYPH_ORIENTATION_90,
            Self::_180 => ffi::POPPLER_STRUCTURE_GLYPH_ORIENTATION_180,
            Self::_270 => ffi::POPPLER_STRUCTURE_GLYPH_ORIENTATION_270,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerStructureGlyphOrientation> for StructureGlyphOrientation {
    unsafe fn from_glib(value: ffi::PopplerStructureGlyphOrientation) -> Self {
        match value {
            ffi::POPPLER_STRUCTURE_GLYPH_ORIENTATION_AUTO => Self::Auto,
            ffi::POPPLER_STRUCTURE_GLYPH_ORIENTATION_90 => Self::_90,
            ffi::POPPLER_STRUCTURE_GLYPH_ORIENTATION_180 => Self::_180,
            ffi::POPPLER_STRUCTURE_GLYPH_ORIENTATION_270 => Self::_270,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for StructureGlyphOrientation {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_structure_glyph_orientation_get_type()) }
    }
}

impl glib::value::ValueType for StructureGlyphOrientation {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for StructureGlyphOrientation {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for StructureGlyphOrientation {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerStructureInlineAlign")]
pub enum StructureInlineAlign {
    #[doc(alias = "POPPLER_STRUCTURE_INLINE_ALIGN_START")]
    Start,
    #[doc(alias = "POPPLER_STRUCTURE_INLINE_ALIGN_CENTER")]
    Center,
    #[doc(alias = "POPPLER_STRUCTURE_INLINE_ALIGN_END")]
    End,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for StructureInlineAlign {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "StructureInlineAlign::{}",
            match *self {
                Self::Start => "Start",
                Self::Center => "Center",
                Self::End => "End",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for StructureInlineAlign {
    type GlibType = ffi::PopplerStructureInlineAlign;

    fn into_glib(self) -> ffi::PopplerStructureInlineAlign {
        match self {
            Self::Start => ffi::POPPLER_STRUCTURE_INLINE_ALIGN_START,
            Self::Center => ffi::POPPLER_STRUCTURE_INLINE_ALIGN_CENTER,
            Self::End => ffi::POPPLER_STRUCTURE_INLINE_ALIGN_END,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerStructureInlineAlign> for StructureInlineAlign {
    unsafe fn from_glib(value: ffi::PopplerStructureInlineAlign) -> Self {
        match value {
            ffi::POPPLER_STRUCTURE_INLINE_ALIGN_START => Self::Start,
            ffi::POPPLER_STRUCTURE_INLINE_ALIGN_CENTER => Self::Center,
            ffi::POPPLER_STRUCTURE_INLINE_ALIGN_END => Self::End,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for StructureInlineAlign {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_structure_inline_align_get_type()) }
    }
}

impl glib::value::ValueType for StructureInlineAlign {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for StructureInlineAlign {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for StructureInlineAlign {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerStructureListNumbering")]
pub enum StructureListNumbering {
    #[doc(alias = "POPPLER_STRUCTURE_LIST_NUMBERING_NONE")]
    None,
    #[doc(alias = "POPPLER_STRUCTURE_LIST_NUMBERING_DISC")]
    Disc,
    #[doc(alias = "POPPLER_STRUCTURE_LIST_NUMBERING_CIRCLE")]
    Circle,
    #[doc(alias = "POPPLER_STRUCTURE_LIST_NUMBERING_SQUARE")]
    Square,
    #[doc(alias = "POPPLER_STRUCTURE_LIST_NUMBERING_DECIMAL")]
    Decimal,
    #[doc(alias = "POPPLER_STRUCTURE_LIST_NUMBERING_UPPER_ROMAN")]
    UpperRoman,
    #[doc(alias = "POPPLER_STRUCTURE_LIST_NUMBERING_LOWER_ROMAN")]
    LowerRoman,
    #[doc(alias = "POPPLER_STRUCTURE_LIST_NUMBERING_UPPER_ALPHA")]
    UpperAlpha,
    #[doc(alias = "POPPLER_STRUCTURE_LIST_NUMBERING_LOWER_ALPHA")]
    LowerAlpha,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for StructureListNumbering {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "StructureListNumbering::{}",
            match *self {
                Self::None => "None",
                Self::Disc => "Disc",
                Self::Circle => "Circle",
                Self::Square => "Square",
                Self::Decimal => "Decimal",
                Self::UpperRoman => "UpperRoman",
                Self::LowerRoman => "LowerRoman",
                Self::UpperAlpha => "UpperAlpha",
                Self::LowerAlpha => "LowerAlpha",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for StructureListNumbering {
    type GlibType = ffi::PopplerStructureListNumbering;

    fn into_glib(self) -> ffi::PopplerStructureListNumbering {
        match self {
            Self::None => ffi::POPPLER_STRUCTURE_LIST_NUMBERING_NONE,
            Self::Disc => ffi::POPPLER_STRUCTURE_LIST_NUMBERING_DISC,
            Self::Circle => ffi::POPPLER_STRUCTURE_LIST_NUMBERING_CIRCLE,
            Self::Square => ffi::POPPLER_STRUCTURE_LIST_NUMBERING_SQUARE,
            Self::Decimal => ffi::POPPLER_STRUCTURE_LIST_NUMBERING_DECIMAL,
            Self::UpperRoman => ffi::POPPLER_STRUCTURE_LIST_NUMBERING_UPPER_ROMAN,
            Self::LowerRoman => ffi::POPPLER_STRUCTURE_LIST_NUMBERING_LOWER_ROMAN,
            Self::UpperAlpha => ffi::POPPLER_STRUCTURE_LIST_NUMBERING_UPPER_ALPHA,
            Self::LowerAlpha => ffi::POPPLER_STRUCTURE_LIST_NUMBERING_LOWER_ALPHA,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerStructureListNumbering> for StructureListNumbering {
    unsafe fn from_glib(value: ffi::PopplerStructureListNumbering) -> Self {
        match value {
            ffi::POPPLER_STRUCTURE_LIST_NUMBERING_NONE => Self::None,
            ffi::POPPLER_STRUCTURE_LIST_NUMBERING_DISC => Self::Disc,
            ffi::POPPLER_STRUCTURE_LIST_NUMBERING_CIRCLE => Self::Circle,
            ffi::POPPLER_STRUCTURE_LIST_NUMBERING_SQUARE => Self::Square,
            ffi::POPPLER_STRUCTURE_LIST_NUMBERING_DECIMAL => Self::Decimal,
            ffi::POPPLER_STRUCTURE_LIST_NUMBERING_UPPER_ROMAN => Self::UpperRoman,
            ffi::POPPLER_STRUCTURE_LIST_NUMBERING_LOWER_ROMAN => Self::LowerRoman,
            ffi::POPPLER_STRUCTURE_LIST_NUMBERING_UPPER_ALPHA => Self::UpperAlpha,
            ffi::POPPLER_STRUCTURE_LIST_NUMBERING_LOWER_ALPHA => Self::LowerAlpha,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for StructureListNumbering {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_structure_list_numbering_get_type()) }
    }
}

impl glib::value::ValueType for StructureListNumbering {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for StructureListNumbering {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for StructureListNumbering {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerStructurePlacement")]
pub enum StructurePlacement {
    #[doc(alias = "POPPLER_STRUCTURE_PLACEMENT_BLOCK")]
    Block,
    #[doc(alias = "POPPLER_STRUCTURE_PLACEMENT_INLINE")]
    Inline,
    #[doc(alias = "POPPLER_STRUCTURE_PLACEMENT_BEFORE")]
    Before,
    #[doc(alias = "POPPLER_STRUCTURE_PLACEMENT_START")]
    Start,
    #[doc(alias = "POPPLER_STRUCTURE_PLACEMENT_END")]
    End,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for StructurePlacement {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "StructurePlacement::{}",
            match *self {
                Self::Block => "Block",
                Self::Inline => "Inline",
                Self::Before => "Before",
                Self::Start => "Start",
                Self::End => "End",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for StructurePlacement {
    type GlibType = ffi::PopplerStructurePlacement;

    fn into_glib(self) -> ffi::PopplerStructurePlacement {
        match self {
            Self::Block => ffi::POPPLER_STRUCTURE_PLACEMENT_BLOCK,
            Self::Inline => ffi::POPPLER_STRUCTURE_PLACEMENT_INLINE,
            Self::Before => ffi::POPPLER_STRUCTURE_PLACEMENT_BEFORE,
            Self::Start => ffi::POPPLER_STRUCTURE_PLACEMENT_START,
            Self::End => ffi::POPPLER_STRUCTURE_PLACEMENT_END,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerStructurePlacement> for StructurePlacement {
    unsafe fn from_glib(value: ffi::PopplerStructurePlacement) -> Self {
        match value {
            ffi::POPPLER_STRUCTURE_PLACEMENT_BLOCK => Self::Block,
            ffi::POPPLER_STRUCTURE_PLACEMENT_INLINE => Self::Inline,
            ffi::POPPLER_STRUCTURE_PLACEMENT_BEFORE => Self::Before,
            ffi::POPPLER_STRUCTURE_PLACEMENT_START => Self::Start,
            ffi::POPPLER_STRUCTURE_PLACEMENT_END => Self::End,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for StructurePlacement {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_structure_placement_get_type()) }
    }
}

impl glib::value::ValueType for StructurePlacement {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for StructurePlacement {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for StructurePlacement {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerStructureRubyAlign")]
pub enum StructureRubyAlign {
    #[doc(alias = "POPPLER_STRUCTURE_RUBY_ALIGN_START")]
    Start,
    #[doc(alias = "POPPLER_STRUCTURE_RUBY_ALIGN_CENTER")]
    Center,
    #[doc(alias = "POPPLER_STRUCTURE_RUBY_ALIGN_END")]
    End,
    #[doc(alias = "POPPLER_STRUCTURE_RUBY_ALIGN_JUSTIFY")]
    Justify,
    #[doc(alias = "POPPLER_STRUCTURE_RUBY_ALIGN_DISTRIBUTE")]
    Distribute,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for StructureRubyAlign {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "StructureRubyAlign::{}",
            match *self {
                Self::Start => "Start",
                Self::Center => "Center",
                Self::End => "End",
                Self::Justify => "Justify",
                Self::Distribute => "Distribute",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for StructureRubyAlign {
    type GlibType = ffi::PopplerStructureRubyAlign;

    fn into_glib(self) -> ffi::PopplerStructureRubyAlign {
        match self {
            Self::Start => ffi::POPPLER_STRUCTURE_RUBY_ALIGN_START,
            Self::Center => ffi::POPPLER_STRUCTURE_RUBY_ALIGN_CENTER,
            Self::End => ffi::POPPLER_STRUCTURE_RUBY_ALIGN_END,
            Self::Justify => ffi::POPPLER_STRUCTURE_RUBY_ALIGN_JUSTIFY,
            Self::Distribute => ffi::POPPLER_STRUCTURE_RUBY_ALIGN_DISTRIBUTE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerStructureRubyAlign> for StructureRubyAlign {
    unsafe fn from_glib(value: ffi::PopplerStructureRubyAlign) -> Self {
        match value {
            ffi::POPPLER_STRUCTURE_RUBY_ALIGN_START => Self::Start,
            ffi::POPPLER_STRUCTURE_RUBY_ALIGN_CENTER => Self::Center,
            ffi::POPPLER_STRUCTURE_RUBY_ALIGN_END => Self::End,
            ffi::POPPLER_STRUCTURE_RUBY_ALIGN_JUSTIFY => Self::Justify,
            ffi::POPPLER_STRUCTURE_RUBY_ALIGN_DISTRIBUTE => Self::Distribute,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for StructureRubyAlign {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_structure_ruby_align_get_type()) }
    }
}

impl glib::value::ValueType for StructureRubyAlign {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for StructureRubyAlign {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for StructureRubyAlign {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerStructureRubyPosition")]
pub enum StructureRubyPosition {
    #[doc(alias = "POPPLER_STRUCTURE_RUBY_POSITION_BEFORE")]
    Before,
    #[doc(alias = "POPPLER_STRUCTURE_RUBY_POSITION_AFTER")]
    After,
    #[doc(alias = "POPPLER_STRUCTURE_RUBY_POSITION_WARICHU")]
    Warichu,
    #[doc(alias = "POPPLER_STRUCTURE_RUBY_POSITION_INLINE")]
    Inline,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for StructureRubyPosition {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "StructureRubyPosition::{}",
            match *self {
                Self::Before => "Before",
                Self::After => "After",
                Self::Warichu => "Warichu",
                Self::Inline => "Inline",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for StructureRubyPosition {
    type GlibType = ffi::PopplerStructureRubyPosition;

    fn into_glib(self) -> ffi::PopplerStructureRubyPosition {
        match self {
            Self::Before => ffi::POPPLER_STRUCTURE_RUBY_POSITION_BEFORE,
            Self::After => ffi::POPPLER_STRUCTURE_RUBY_POSITION_AFTER,
            Self::Warichu => ffi::POPPLER_STRUCTURE_RUBY_POSITION_WARICHU,
            Self::Inline => ffi::POPPLER_STRUCTURE_RUBY_POSITION_INLINE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerStructureRubyPosition> for StructureRubyPosition {
    unsafe fn from_glib(value: ffi::PopplerStructureRubyPosition) -> Self {
        match value {
            ffi::POPPLER_STRUCTURE_RUBY_POSITION_BEFORE => Self::Before,
            ffi::POPPLER_STRUCTURE_RUBY_POSITION_AFTER => Self::After,
            ffi::POPPLER_STRUCTURE_RUBY_POSITION_WARICHU => Self::Warichu,
            ffi::POPPLER_STRUCTURE_RUBY_POSITION_INLINE => Self::Inline,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for StructureRubyPosition {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_structure_ruby_position_get_type()) }
    }
}

impl glib::value::ValueType for StructureRubyPosition {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for StructureRubyPosition {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for StructureRubyPosition {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerStructureTableScope")]
pub enum StructureTableScope {
    #[doc(alias = "POPPLER_STRUCTURE_TABLE_SCOPE_ROW")]
    Row,
    #[doc(alias = "POPPLER_STRUCTURE_TABLE_SCOPE_COLUMN")]
    Column,
    #[doc(alias = "POPPLER_STRUCTURE_TABLE_SCOPE_BOTH")]
    Both,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for StructureTableScope {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "StructureTableScope::{}",
            match *self {
                Self::Row => "Row",
                Self::Column => "Column",
                Self::Both => "Both",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for StructureTableScope {
    type GlibType = ffi::PopplerStructureTableScope;

    fn into_glib(self) -> ffi::PopplerStructureTableScope {
        match self {
            Self::Row => ffi::POPPLER_STRUCTURE_TABLE_SCOPE_ROW,
            Self::Column => ffi::POPPLER_STRUCTURE_TABLE_SCOPE_COLUMN,
            Self::Both => ffi::POPPLER_STRUCTURE_TABLE_SCOPE_BOTH,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerStructureTableScope> for StructureTableScope {
    unsafe fn from_glib(value: ffi::PopplerStructureTableScope) -> Self {
        match value {
            ffi::POPPLER_STRUCTURE_TABLE_SCOPE_ROW => Self::Row,
            ffi::POPPLER_STRUCTURE_TABLE_SCOPE_COLUMN => Self::Column,
            ffi::POPPLER_STRUCTURE_TABLE_SCOPE_BOTH => Self::Both,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for StructureTableScope {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_structure_table_scope_get_type()) }
    }
}

impl glib::value::ValueType for StructureTableScope {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for StructureTableScope {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for StructureTableScope {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerStructureTextAlign")]
pub enum StructureTextAlign {
    #[doc(alias = "POPPLER_STRUCTURE_TEXT_ALIGN_START")]
    Start,
    #[doc(alias = "POPPLER_STRUCTURE_TEXT_ALIGN_CENTER")]
    Center,
    #[doc(alias = "POPPLER_STRUCTURE_TEXT_ALIGN_END")]
    End,
    #[doc(alias = "POPPLER_STRUCTURE_TEXT_ALIGN_JUSTIFY")]
    Justify,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for StructureTextAlign {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "StructureTextAlign::{}",
            match *self {
                Self::Start => "Start",
                Self::Center => "Center",
                Self::End => "End",
                Self::Justify => "Justify",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for StructureTextAlign {
    type GlibType = ffi::PopplerStructureTextAlign;

    fn into_glib(self) -> ffi::PopplerStructureTextAlign {
        match self {
            Self::Start => ffi::POPPLER_STRUCTURE_TEXT_ALIGN_START,
            Self::Center => ffi::POPPLER_STRUCTURE_TEXT_ALIGN_CENTER,
            Self::End => ffi::POPPLER_STRUCTURE_TEXT_ALIGN_END,
            Self::Justify => ffi::POPPLER_STRUCTURE_TEXT_ALIGN_JUSTIFY,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerStructureTextAlign> for StructureTextAlign {
    unsafe fn from_glib(value: ffi::PopplerStructureTextAlign) -> Self {
        match value {
            ffi::POPPLER_STRUCTURE_TEXT_ALIGN_START => Self::Start,
            ffi::POPPLER_STRUCTURE_TEXT_ALIGN_CENTER => Self::Center,
            ffi::POPPLER_STRUCTURE_TEXT_ALIGN_END => Self::End,
            ffi::POPPLER_STRUCTURE_TEXT_ALIGN_JUSTIFY => Self::Justify,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for StructureTextAlign {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_structure_text_align_get_type()) }
    }
}

impl glib::value::ValueType for StructureTextAlign {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for StructureTextAlign {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for StructureTextAlign {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerStructureTextDecoration")]
pub enum StructureTextDecoration {
    #[doc(alias = "POPPLER_STRUCTURE_TEXT_DECORATION_NONE")]
    None,
    #[doc(alias = "POPPLER_STRUCTURE_TEXT_DECORATION_UNDERLINE")]
    Underline,
    #[doc(alias = "POPPLER_STRUCTURE_TEXT_DECORATION_OVERLINE")]
    Overline,
    #[doc(alias = "POPPLER_STRUCTURE_TEXT_DECORATION_LINETHROUGH")]
    Linethrough,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for StructureTextDecoration {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "StructureTextDecoration::{}",
            match *self {
                Self::None => "None",
                Self::Underline => "Underline",
                Self::Overline => "Overline",
                Self::Linethrough => "Linethrough",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for StructureTextDecoration {
    type GlibType = ffi::PopplerStructureTextDecoration;

    fn into_glib(self) -> ffi::PopplerStructureTextDecoration {
        match self {
            Self::None => ffi::POPPLER_STRUCTURE_TEXT_DECORATION_NONE,
            Self::Underline => ffi::POPPLER_STRUCTURE_TEXT_DECORATION_UNDERLINE,
            Self::Overline => ffi::POPPLER_STRUCTURE_TEXT_DECORATION_OVERLINE,
            Self::Linethrough => ffi::POPPLER_STRUCTURE_TEXT_DECORATION_LINETHROUGH,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerStructureTextDecoration> for StructureTextDecoration {
    unsafe fn from_glib(value: ffi::PopplerStructureTextDecoration) -> Self {
        match value {
            ffi::POPPLER_STRUCTURE_TEXT_DECORATION_NONE => Self::None,
            ffi::POPPLER_STRUCTURE_TEXT_DECORATION_UNDERLINE => Self::Underline,
            ffi::POPPLER_STRUCTURE_TEXT_DECORATION_OVERLINE => Self::Overline,
            ffi::POPPLER_STRUCTURE_TEXT_DECORATION_LINETHROUGH => Self::Linethrough,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for StructureTextDecoration {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_structure_text_decoration_get_type()) }
    }
}

impl glib::value::ValueType for StructureTextDecoration {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for StructureTextDecoration {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for StructureTextDecoration {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "PopplerStructureWritingMode")]
pub enum StructureWritingMode {
    #[doc(alias = "POPPLER_STRUCTURE_WRITING_MODE_LR_TB")]
    LrTb,
    #[doc(alias = "POPPLER_STRUCTURE_WRITING_MODE_RL_TB")]
    RlTb,
    #[doc(alias = "POPPLER_STRUCTURE_WRITING_MODE_TB_RL")]
    TbRl,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for StructureWritingMode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "StructureWritingMode::{}",
            match *self {
                Self::LrTb => "LrTb",
                Self::RlTb => "RlTb",
                Self::TbRl => "TbRl",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for StructureWritingMode {
    type GlibType = ffi::PopplerStructureWritingMode;

    fn into_glib(self) -> ffi::PopplerStructureWritingMode {
        match self {
            Self::LrTb => ffi::POPPLER_STRUCTURE_WRITING_MODE_LR_TB,
            Self::RlTb => ffi::POPPLER_STRUCTURE_WRITING_MODE_RL_TB,
            Self::TbRl => ffi::POPPLER_STRUCTURE_WRITING_MODE_TB_RL,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::PopplerStructureWritingMode> for StructureWritingMode {
    unsafe fn from_glib(value: ffi::PopplerStructureWritingMode) -> Self {
        match value {
            ffi::POPPLER_STRUCTURE_WRITING_MODE_LR_TB => Self::LrTb,
            ffi::POPPLER_STRUCTURE_WRITING_MODE_RL_TB => Self::RlTb,
            ffi::POPPLER_STRUCTURE_WRITING_MODE_TB_RL => Self::TbRl,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for StructureWritingMode {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::poppler_structure_writing_mode_get_type()) }
    }
}

impl glib::value::ValueType for StructureWritingMode {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for StructureWritingMode {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for StructureWritingMode {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}
