// This file was generated by gir (https://github.com/gtk-rs/gir)
// from ../../gir-files
// from ../gir-files
// DO NOT EDIT

use crate::Page;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem;
use std::mem::transmute;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "PopplerDocument")]
    pub struct Document(Object<ffi::PopplerDocument>);

    match fn {
        type_ => || ffi::poppler_document_get_type(),
    }
}

impl Document {
    #[cfg(any(feature = "v0_82", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_82")))]
    #[doc(alias = "poppler_document_new_from_bytes")]
    #[doc(alias = "new_from_bytes")]
    pub fn from_bytes(bytes: &glib::Bytes, password: Option<&str>) -> Result<Document, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::poppler_document_new_from_bytes(bytes.to_glib_none().0, password.to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    #[cfg_attr(feature = "v0_82", deprecated = "Since 0.82")]
    #[doc(alias = "poppler_document_new_from_data")]
    #[doc(alias = "new_from_data")]
    pub fn from_data(data: &[u8], password: Option<&str>) -> Result<Document, glib::Error> {
        let length = data.len() as i32;
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::poppler_document_new_from_data(data.to_glib_none().0, length, password.to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    #[cfg(any(feature = "v21_12", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v21_12")))]
    #[doc(alias = "poppler_document_new_from_fd")]
    #[doc(alias = "new_from_fd")]
    pub fn from_fd(fd: i32, password: Option<&str>) -> Result<Document, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::poppler_document_new_from_fd(fd, password.to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    #[doc(alias = "poppler_document_new_from_file")]
    #[doc(alias = "new_from_file")]
    pub fn from_file(uri: &str, password: Option<&str>) -> Result<Document, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::poppler_document_new_from_file(uri.to_glib_none().0, password.to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    //#[doc(alias = "poppler_document_new_from_gfile")]
    //#[doc(alias = "new_from_gfile")]
    //pub fn from_gfile(file: /*Ignored*/&gio::File, password: Option<&str>, cancellable: /*Ignored*/Option<&gio::Cancellable>) -> Result<Document, glib::Error> {
    //    unsafe { TODO: call ffi:poppler_document_new_from_gfile() }
    //}

    //#[doc(alias = "poppler_document_new_from_stream")]
    //#[doc(alias = "new_from_stream")]
    //pub fn from_stream(stream: /*Ignored*/&gio::InputStream, length: i64, password: Option<&str>, cancellable: /*Ignored*/Option<&gio::Cancellable>) -> Result<Document, glib::Error> {
    //    unsafe { TODO: call ffi:poppler_document_new_from_stream() }
    //}

    //#[cfg(any(feature = "v0_78", feature = "dox"))]
    //#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_78")))]
    //#[doc(alias = "poppler_document_create_dests_tree")]
    //pub fn create_dests_tree(&self) -> /*Ignored*/Option<glib::Tree> {
    //    unsafe { TODO: call ffi:poppler_document_create_dests_tree() }
    //}

    //#[doc(alias = "poppler_document_find_dest")]
    //pub fn find_dest(&self, link_name: &str) -> /*Ignored*/Option<Dest> {
    //    unsafe { TODO: call ffi:poppler_document_find_dest() }
    //}

    //#[doc(alias = "poppler_document_get_attachments")]
    //#[doc(alias = "get_attachments")]
    //pub fn attachments(&self) -> /*Ignored*/Vec<Attachment> {
    //    unsafe { TODO: call ffi:poppler_document_get_attachments() }
    //}

    #[doc(alias = "poppler_document_get_author")]
    #[doc(alias = "get_author")]
    pub fn author(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::poppler_document_get_author(self.to_glib_none().0))
        }
    }

    #[doc(alias = "poppler_document_get_creation_date")]
    #[doc(alias = "get_creation_date")]
    pub fn creation_date(&self) -> libc::c_long {
        unsafe {
            ffi::poppler_document_get_creation_date(self.to_glib_none().0)
        }
    }

    #[cfg(any(feature = "v20_9", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v20_9")))]
    #[doc(alias = "poppler_document_get_creation_date_time")]
    #[doc(alias = "get_creation_date_time")]
    pub fn creation_date_time(&self) -> Option<glib::DateTime> {
        unsafe {
            from_glib_full(ffi::poppler_document_get_creation_date_time(self.to_glib_none().0))
        }
    }

    #[doc(alias = "poppler_document_get_creator")]
    #[doc(alias = "get_creator")]
    pub fn creator(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::poppler_document_get_creator(self.to_glib_none().0))
        }
    }

    //#[doc(alias = "poppler_document_get_form_field")]
    //#[doc(alias = "get_form_field")]
    //pub fn form_field(&self, id: i32) -> /*Ignored*/Option<FormField> {
    //    unsafe { TODO: call ffi:poppler_document_get_form_field() }
    //}

    #[doc(alias = "poppler_document_get_id")]
    #[doc(alias = "get_id")]
    pub fn id(&self) -> Option<(glib::GString, glib::GString)> {
        unsafe {
            let mut permanent_id = ptr::null_mut();
            let mut update_id = ptr::null_mut();
            let ret = from_glib(ffi::poppler_document_get_id(self.to_glib_none().0, &mut permanent_id, &mut update_id));
            if ret { Some((from_glib_full(permanent_id), from_glib_full(update_id))) } else { None }
        }
    }

    #[doc(alias = "poppler_document_get_keywords")]
    #[doc(alias = "get_keywords")]
    pub fn keywords(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::poppler_document_get_keywords(self.to_glib_none().0))
        }
    }

    #[doc(alias = "poppler_document_get_metadata")]
    #[doc(alias = "get_metadata")]
    pub fn metadata(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::poppler_document_get_metadata(self.to_glib_none().0))
        }
    }

    #[doc(alias = "poppler_document_get_modification_date")]
    #[doc(alias = "get_modification_date")]
    pub fn modification_date(&self) -> libc::c_long {
        unsafe {
            ffi::poppler_document_get_modification_date(self.to_glib_none().0)
        }
    }

    #[cfg(any(feature = "v20_9", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v20_9")))]
    #[doc(alias = "poppler_document_get_modification_date_time")]
    #[doc(alias = "get_modification_date_time")]
    pub fn modification_date_time(&self) -> Option<glib::DateTime> {
        unsafe {
            from_glib_full(ffi::poppler_document_get_modification_date_time(self.to_glib_none().0))
        }
    }

    #[doc(alias = "poppler_document_get_n_attachments")]
    #[doc(alias = "get_n_attachments")]
    pub fn n_attachments(&self) -> u32 {
        unsafe {
            ffi::poppler_document_get_n_attachments(self.to_glib_none().0)
        }
    }

    #[doc(alias = "poppler_document_get_n_pages")]
    #[doc(alias = "get_n_pages")]
    pub fn n_pages(&self) -> i32 {
        unsafe {
            ffi::poppler_document_get_n_pages(self.to_glib_none().0)
        }
    }

    #[doc(alias = "poppler_document_get_page")]
    #[doc(alias = "get_page")]
    pub fn page(&self, index: i32) -> Option<Page> {
        unsafe {
            from_glib_full(ffi::poppler_document_get_page(self.to_glib_none().0, index))
        }
    }

    #[doc(alias = "poppler_document_get_page_by_label")]
    #[doc(alias = "get_page_by_label")]
    pub fn page_by_label(&self, label: &str) -> Option<Page> {
        unsafe {
            from_glib_full(ffi::poppler_document_get_page_by_label(self.to_glib_none().0, label.to_glib_none().0))
        }
    }

    //#[doc(alias = "poppler_document_get_page_layout")]
    //#[doc(alias = "get_page_layout")]
    //pub fn page_layout(&self) -> /*Ignored*/PageLayout {
    //    unsafe { TODO: call ffi:poppler_document_get_page_layout() }
    //}

    //#[doc(alias = "poppler_document_get_page_mode")]
    //#[doc(alias = "get_page_mode")]
    //pub fn page_mode(&self) -> /*Ignored*/PageMode {
    //    unsafe { TODO: call ffi:poppler_document_get_page_mode() }
    //}

    //#[doc(alias = "poppler_document_get_pdf_conformance")]
    //#[doc(alias = "get_pdf_conformance")]
    //pub fn pdf_conformance(&self) -> /*Ignored*/PDFConformance {
    //    unsafe { TODO: call ffi:poppler_document_get_pdf_conformance() }
    //}

    //#[doc(alias = "poppler_document_get_pdf_part")]
    //#[doc(alias = "get_pdf_part")]
    //pub fn pdf_part(&self) -> /*Ignored*/PDFPart {
    //    unsafe { TODO: call ffi:poppler_document_get_pdf_part() }
    //}

    //#[doc(alias = "poppler_document_get_pdf_subtype")]
    //#[doc(alias = "get_pdf_subtype")]
    //pub fn pdf_subtype(&self) -> /*Ignored*/PDFSubtype {
    //    unsafe { TODO: call ffi:poppler_document_get_pdf_subtype() }
    //}

    #[doc(alias = "poppler_document_get_pdf_subtype_string")]
    #[doc(alias = "get_pdf_subtype_string")]
    pub fn pdf_subtype_string(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::poppler_document_get_pdf_subtype_string(self.to_glib_none().0))
        }
    }

    #[doc(alias = "poppler_document_get_pdf_version")]
    #[doc(alias = "get_pdf_version")]
    pub fn pdf_version(&self) -> (u32, u32) {
        unsafe {
            let mut major_version = mem::MaybeUninit::uninit();
            let mut minor_version = mem::MaybeUninit::uninit();
            ffi::poppler_document_get_pdf_version(self.to_glib_none().0, major_version.as_mut_ptr(), minor_version.as_mut_ptr());
            let major_version = major_version.assume_init();
            let minor_version = minor_version.assume_init();
            (major_version, minor_version)
        }
    }

    #[doc(alias = "poppler_document_get_pdf_version_string")]
    #[doc(alias = "get_pdf_version_string")]
    pub fn pdf_version_string(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::poppler_document_get_pdf_version_string(self.to_glib_none().0))
        }
    }

    //#[doc(alias = "poppler_document_get_permissions")]
    //#[doc(alias = "get_permissions")]
    //pub fn permissions(&self) -> /*Ignored*/Permissions {
    //    unsafe { TODO: call ffi:poppler_document_get_permissions() }
    //}

    //#[cfg(any(feature = "v0_80", feature = "dox"))]
    //#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_80")))]
    //#[doc(alias = "poppler_document_get_print_duplex")]
    //#[doc(alias = "get_print_duplex")]
    //pub fn print_duplex(&self) -> /*Ignored*/PrintDuplex {
    //    unsafe { TODO: call ffi:poppler_document_get_print_duplex() }
    //}

    #[cfg(any(feature = "v0_80", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_80")))]
    #[doc(alias = "poppler_document_get_print_n_copies")]
    #[doc(alias = "get_print_n_copies")]
    pub fn print_n_copies(&self) -> i32 {
        unsafe {
            ffi::poppler_document_get_print_n_copies(self.to_glib_none().0)
        }
    }

    //#[cfg(any(feature = "v0_80", feature = "dox"))]
    //#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_80")))]
    //#[doc(alias = "poppler_document_get_print_page_ranges")]
    //#[doc(alias = "get_print_page_ranges")]
    //pub fn print_page_ranges(&self) -> /*Ignored*/Vec<PageRange> {
    //    unsafe { TODO: call ffi:poppler_document_get_print_page_ranges() }
    //}

    //#[cfg(any(feature = "v0_73", feature = "dox"))]
    //#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_73")))]
    //#[doc(alias = "poppler_document_get_print_scaling")]
    //#[doc(alias = "get_print_scaling")]
    //pub fn print_scaling(&self) -> /*Ignored*/PrintScaling {
    //    unsafe { TODO: call ffi:poppler_document_get_print_scaling() }
    //}

    #[doc(alias = "poppler_document_get_producer")]
    #[doc(alias = "get_producer")]
    pub fn producer(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::poppler_document_get_producer(self.to_glib_none().0))
        }
    }

    #[doc(alias = "poppler_document_get_subject")]
    #[doc(alias = "get_subject")]
    pub fn subject(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::poppler_document_get_subject(self.to_glib_none().0))
        }
    }

    #[doc(alias = "poppler_document_get_title")]
    #[doc(alias = "get_title")]
    pub fn title(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::poppler_document_get_title(self.to_glib_none().0))
        }
    }

    #[doc(alias = "poppler_document_has_attachments")]
    pub fn has_attachments(&self) -> bool {
        unsafe {
            from_glib(ffi::poppler_document_has_attachments(self.to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v0_90", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_90")))]
    #[doc(alias = "poppler_document_has_javascript")]
    pub fn has_javascript(&self) -> bool {
        unsafe {
            from_glib(ffi::poppler_document_has_javascript(self.to_glib_none().0))
        }
    }

    #[doc(alias = "poppler_document_is_linearized")]
    pub fn is_linearized(&self) -> bool {
        unsafe {
            from_glib(ffi::poppler_document_is_linearized(self.to_glib_none().0))
        }
    }

    //#[cfg(any(feature = "v0_90", feature = "dox"))]
    //#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_90")))]
    //#[doc(alias = "poppler_document_reset_form")]
    //pub fn reset_form(&self, fields: /*Unimplemented*/&[&Fundamental: Pointer], exclude_fields: bool) {
    //    unsafe { TODO: call ffi:poppler_document_reset_form() }
    //}

    #[doc(alias = "poppler_document_save")]
    pub fn save(&self, uri: &str) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::poppler_document_save(self.to_glib_none().0, uri.to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    #[doc(alias = "poppler_document_save_a_copy")]
    pub fn save_a_copy(&self, uri: &str) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::poppler_document_save_a_copy(self.to_glib_none().0, uri.to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    #[cfg(any(feature = "v21_12", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v21_12")))]
    #[doc(alias = "poppler_document_save_to_fd")]
    pub fn save_to_fd(&self, fd: i32, include_changes: bool) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::poppler_document_save_to_fd(self.to_glib_none().0, fd, include_changes.into_glib(), &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    #[doc(alias = "poppler_document_set_author")]
    pub fn set_author(&self, author: &str) {
        unsafe {
            ffi::poppler_document_set_author(self.to_glib_none().0, author.to_glib_none().0);
        }
    }

    #[doc(alias = "poppler_document_set_creation_date")]
    pub fn set_creation_date(&self, creation_date: libc::c_long) {
        unsafe {
            ffi::poppler_document_set_creation_date(self.to_glib_none().0, creation_date);
        }
    }

    #[cfg(any(feature = "v20_9", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v20_9")))]
    #[doc(alias = "poppler_document_set_creation_date_time")]
    pub fn set_creation_date_time(&self, creation_datetime: Option<&glib::DateTime>) {
        unsafe {
            ffi::poppler_document_set_creation_date_time(self.to_glib_none().0, creation_datetime.to_glib_none().0);
        }
    }

    #[doc(alias = "poppler_document_set_creator")]
    pub fn set_creator(&self, creator: &str) {
        unsafe {
            ffi::poppler_document_set_creator(self.to_glib_none().0, creator.to_glib_none().0);
        }
    }

    #[doc(alias = "poppler_document_set_keywords")]
    pub fn set_keywords(&self, keywords: &str) {
        unsafe {
            ffi::poppler_document_set_keywords(self.to_glib_none().0, keywords.to_glib_none().0);
        }
    }

    #[doc(alias = "poppler_document_set_modification_date")]
    pub fn set_modification_date(&self, modification_date: libc::c_long) {
        unsafe {
            ffi::poppler_document_set_modification_date(self.to_glib_none().0, modification_date);
        }
    }

    #[cfg(any(feature = "v20_9", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v20_9")))]
    #[doc(alias = "poppler_document_set_modification_date_time")]
    pub fn set_modification_date_time(&self, modification_datetime: Option<&glib::DateTime>) {
        unsafe {
            ffi::poppler_document_set_modification_date_time(self.to_glib_none().0, modification_datetime.to_glib_none().0);
        }
    }

    #[doc(alias = "poppler_document_set_producer")]
    pub fn set_producer(&self, producer: &str) {
        unsafe {
            ffi::poppler_document_set_producer(self.to_glib_none().0, producer.to_glib_none().0);
        }
    }

    #[doc(alias = "poppler_document_set_subject")]
    pub fn set_subject(&self, subject: &str) {
        unsafe {
            ffi::poppler_document_set_subject(self.to_glib_none().0, subject.to_glib_none().0);
        }
    }

    #[doc(alias = "poppler_document_set_title")]
    pub fn set_title(&self, title: &str) {
        unsafe {
            ffi::poppler_document_set_title(self.to_glib_none().0, title.to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v20_9", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v20_9")))]
    #[doc(alias = "creation-datetime")]
    pub fn creation_datetime(&self) -> Option<glib::DateTime> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::DateTime as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.as_ptr() as *mut glib::gobject_ffi::GObject, b"creation-datetime\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `creation-datetime` getter")
        }
    }

    #[cfg(any(feature = "v20_9", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v20_9")))]
    #[doc(alias = "creation-datetime")]
    pub fn set_creation_datetime(&self, creation_datetime: Option<&glib::DateTime>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(self.as_ptr() as *mut glib::gobject_ffi::GObject, b"creation-datetime\0".as_ptr() as *const _, creation_datetime.to_value().to_glib_none().0);
        }
    }

    pub fn format(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.as_ptr() as *mut glib::gobject_ffi::GObject, b"format\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `format` getter")
        }
    }

    #[doc(alias = "format-major")]
    pub fn format_major(&self) -> u32 {
        unsafe {
            let mut value = glib::Value::from_type(<u32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.as_ptr() as *mut glib::gobject_ffi::GObject, b"format-major\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `format-major` getter")
        }
    }

    #[doc(alias = "format-minor")]
    pub fn format_minor(&self) -> u32 {
        unsafe {
            let mut value = glib::Value::from_type(<u32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.as_ptr() as *mut glib::gobject_ffi::GObject, b"format-minor\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `format-minor` getter")
        }
    }

    #[cfg_attr(feature = "v20_9", deprecated = "Since 20.9")]
    #[doc(alias = "mod-date")]
    pub fn mod_date(&self) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.as_ptr() as *mut glib::gobject_ffi::GObject, b"mod-date\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `mod-date` getter")
        }
    }

    #[cfg_attr(feature = "v20_9", deprecated = "Since 20.9")]
    #[doc(alias = "mod-date")]
    pub fn set_mod_date(&self, mod_date: i32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(self.as_ptr() as *mut glib::gobject_ffi::GObject, b"mod-date\0".as_ptr() as *const _, mod_date.to_value().to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v20_9", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v20_9")))]
    #[doc(alias = "mod-datetime")]
    pub fn mod_datetime(&self) -> Option<glib::DateTime> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::DateTime as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.as_ptr() as *mut glib::gobject_ffi::GObject, b"mod-datetime\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `mod-datetime` getter")
        }
    }

    #[cfg(any(feature = "v20_9", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v20_9")))]
    #[doc(alias = "mod-datetime")]
    pub fn set_mod_datetime(&self, mod_datetime: Option<&glib::DateTime>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(self.as_ptr() as *mut glib::gobject_ffi::GObject, b"mod-datetime\0".as_ptr() as *const _, mod_datetime.to_value().to_glib_none().0);
        }
    }

    //pub fn subtype(&self) -> /*Ignored*/PDFSubtype {
    //    unsafe {
    //        let mut value = glib::Value::from_type(</*Unknown type*/ as StaticType>::static_type());
    //        glib::gobject_ffi::g_object_get_property(self.as_ptr() as *mut glib::gobject_ffi::GObject, b"subtype\0".as_ptr() as *const _, value.to_glib_none_mut().0);
    //        value.get().expect("Return Value for property `subtype` getter")
    //    }
    //}

    //#[doc(alias = "subtype-conformance")]
    //pub fn subtype_conformance(&self) -> /*Ignored*/PDFConformance {
    //    unsafe {
    //        let mut value = glib::Value::from_type(</*Unknown type*/ as StaticType>::static_type());
    //        glib::gobject_ffi::g_object_get_property(self.as_ptr() as *mut glib::gobject_ffi::GObject, b"subtype-conformance\0".as_ptr() as *const _, value.to_glib_none_mut().0);
    //        value.get().expect("Return Value for property `subtype-conformance` getter")
    //    }
    //}

    //#[doc(alias = "subtype-part")]
    //pub fn subtype_part(&self) -> /*Ignored*/PDFPart {
    //    unsafe {
    //        let mut value = glib::Value::from_type(</*Unknown type*/ as StaticType>::static_type());
    //        glib::gobject_ffi::g_object_get_property(self.as_ptr() as *mut glib::gobject_ffi::GObject, b"subtype-part\0".as_ptr() as *const _, value.to_glib_none_mut().0);
    //        value.get().expect("Return Value for property `subtype-part` getter")
    //    }
    //}

    #[doc(alias = "subtype-string")]
    pub fn subtype_string(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.as_ptr() as *mut glib::gobject_ffi::GObject, b"subtype-string\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `subtype-string` getter")
        }
    }

    //#[doc(alias = "viewer-preferences")]
    //pub fn viewer_preferences(&self) -> /*Ignored*/ViewerPreferences {
    //    unsafe {
    //        let mut value = glib::Value::from_type(</*Unknown type*/ as StaticType>::static_type());
    //        glib::gobject_ffi::g_object_get_property(self.as_ptr() as *mut glib::gobject_ffi::GObject, b"viewer-preferences\0".as_ptr() as *const _, value.to_glib_none_mut().0);
    //        value.get().expect("Return Value for property `viewer-preferences` getter")
    //    }
    //}

    #[doc(alias = "author")]
    pub fn connect_author_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_author_trampoline<F: Fn(&Document) + 'static>(this: *mut ffi::PopplerDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::author\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_author_trampoline::<F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg_attr(feature = "v20_9", deprecated = "Since 20.9")]
    #[doc(alias = "creation-date")]
    pub fn connect_creation_date_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_creation_date_trampoline<F: Fn(&Document) + 'static>(this: *mut ffi::PopplerDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::creation-date\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_creation_date_trampoline::<F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v20_9", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v20_9")))]
    #[doc(alias = "creation-datetime")]
    pub fn connect_creation_datetime_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_creation_datetime_trampoline<F: Fn(&Document) + 'static>(this: *mut ffi::PopplerDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::creation-datetime\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_creation_datetime_trampoline::<F> as *const ())), Box_::into_raw(f))
        }
    }

    #[doc(alias = "creator")]
    pub fn connect_creator_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_creator_trampoline<F: Fn(&Document) + 'static>(this: *mut ffi::PopplerDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::creator\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_creator_trampoline::<F> as *const ())), Box_::into_raw(f))
        }
    }

    #[doc(alias = "format")]
    pub fn connect_format_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_format_trampoline<F: Fn(&Document) + 'static>(this: *mut ffi::PopplerDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::format\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_format_trampoline::<F> as *const ())), Box_::into_raw(f))
        }
    }

    #[doc(alias = "format-major")]
    pub fn connect_format_major_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_format_major_trampoline<F: Fn(&Document) + 'static>(this: *mut ffi::PopplerDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::format-major\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_format_major_trampoline::<F> as *const ())), Box_::into_raw(f))
        }
    }

    #[doc(alias = "format-minor")]
    pub fn connect_format_minor_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_format_minor_trampoline<F: Fn(&Document) + 'static>(this: *mut ffi::PopplerDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::format-minor\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_format_minor_trampoline::<F> as *const ())), Box_::into_raw(f))
        }
    }

    #[doc(alias = "keywords")]
    pub fn connect_keywords_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_keywords_trampoline<F: Fn(&Document) + 'static>(this: *mut ffi::PopplerDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::keywords\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_keywords_trampoline::<F> as *const ())), Box_::into_raw(f))
        }
    }

    #[doc(alias = "linearized")]
    pub fn connect_linearized_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_linearized_trampoline<F: Fn(&Document) + 'static>(this: *mut ffi::PopplerDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::linearized\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_linearized_trampoline::<F> as *const ())), Box_::into_raw(f))
        }
    }

    #[doc(alias = "metadata")]
    pub fn connect_metadata_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_metadata_trampoline<F: Fn(&Document) + 'static>(this: *mut ffi::PopplerDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::metadata\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_metadata_trampoline::<F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg_attr(feature = "v20_9", deprecated = "Since 20.9")]
    #[doc(alias = "mod-date")]
    pub fn connect_mod_date_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_mod_date_trampoline<F: Fn(&Document) + 'static>(this: *mut ffi::PopplerDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::mod-date\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_mod_date_trampoline::<F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v20_9", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v20_9")))]
    #[doc(alias = "mod-datetime")]
    pub fn connect_mod_datetime_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_mod_datetime_trampoline<F: Fn(&Document) + 'static>(this: *mut ffi::PopplerDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::mod-datetime\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_mod_datetime_trampoline::<F> as *const ())), Box_::into_raw(f))
        }
    }

    #[doc(alias = "page-layout")]
    pub fn connect_page_layout_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_page_layout_trampoline<F: Fn(&Document) + 'static>(this: *mut ffi::PopplerDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::page-layout\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_page_layout_trampoline::<F> as *const ())), Box_::into_raw(f))
        }
    }

    #[doc(alias = "page-mode")]
    pub fn connect_page_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_page_mode_trampoline<F: Fn(&Document) + 'static>(this: *mut ffi::PopplerDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::page-mode\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_page_mode_trampoline::<F> as *const ())), Box_::into_raw(f))
        }
    }

    #[doc(alias = "permissions")]
    pub fn connect_permissions_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_permissions_trampoline<F: Fn(&Document) + 'static>(this: *mut ffi::PopplerDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::permissions\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_permissions_trampoline::<F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v0_80", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_80")))]
    #[doc(alias = "print-duplex")]
    pub fn connect_print_duplex_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_print_duplex_trampoline<F: Fn(&Document) + 'static>(this: *mut ffi::PopplerDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::print-duplex\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_print_duplex_trampoline::<F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v0_80", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_80")))]
    #[doc(alias = "print-n-copies")]
    pub fn connect_print_n_copies_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_print_n_copies_trampoline<F: Fn(&Document) + 'static>(this: *mut ffi::PopplerDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::print-n-copies\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_print_n_copies_trampoline::<F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v0_73", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_73")))]
    #[doc(alias = "print-scaling")]
    pub fn connect_print_scaling_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_print_scaling_trampoline<F: Fn(&Document) + 'static>(this: *mut ffi::PopplerDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::print-scaling\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_print_scaling_trampoline::<F> as *const ())), Box_::into_raw(f))
        }
    }

    #[doc(alias = "producer")]
    pub fn connect_producer_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_producer_trampoline<F: Fn(&Document) + 'static>(this: *mut ffi::PopplerDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::producer\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_producer_trampoline::<F> as *const ())), Box_::into_raw(f))
        }
    }

    #[doc(alias = "subject")]
    pub fn connect_subject_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_subject_trampoline<F: Fn(&Document) + 'static>(this: *mut ffi::PopplerDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::subject\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_subject_trampoline::<F> as *const ())), Box_::into_raw(f))
        }
    }

    #[doc(alias = "subtype")]
    pub fn connect_subtype_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_subtype_trampoline<F: Fn(&Document) + 'static>(this: *mut ffi::PopplerDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::subtype\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_subtype_trampoline::<F> as *const ())), Box_::into_raw(f))
        }
    }

    #[doc(alias = "subtype-conformance")]
    pub fn connect_subtype_conformance_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_subtype_conformance_trampoline<F: Fn(&Document) + 'static>(this: *mut ffi::PopplerDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::subtype-conformance\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_subtype_conformance_trampoline::<F> as *const ())), Box_::into_raw(f))
        }
    }

    #[doc(alias = "subtype-part")]
    pub fn connect_subtype_part_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_subtype_part_trampoline<F: Fn(&Document) + 'static>(this: *mut ffi::PopplerDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::subtype-part\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_subtype_part_trampoline::<F> as *const ())), Box_::into_raw(f))
        }
    }

    #[doc(alias = "subtype-string")]
    pub fn connect_subtype_string_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_subtype_string_trampoline<F: Fn(&Document) + 'static>(this: *mut ffi::PopplerDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::subtype-string\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_subtype_string_trampoline::<F> as *const ())), Box_::into_raw(f))
        }
    }

    #[doc(alias = "title")]
    pub fn connect_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_title_trampoline<F: Fn(&Document) + 'static>(this: *mut ffi::PopplerDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::title\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_title_trampoline::<F> as *const ())), Box_::into_raw(f))
        }
    }

    #[doc(alias = "viewer-preferences")]
    pub fn connect_viewer_preferences_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_viewer_preferences_trampoline<F: Fn(&Document) + 'static>(this: *mut ffi::PopplerDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::viewer-preferences\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_viewer_preferences_trampoline::<F> as *const ())), Box_::into_raw(f))
        }
    }
}

impl fmt::Display for Document {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Document")
    }
}
