use github_rs::client::Github;

use super::auth::validate_token;

pub async fn get_client(token: &str) -> Option<Github> {
    match validate_token(token).await {
        Some(token) => Some(Github::new(token).unwrap()),
        None => None
    }
}

