mod cmds;
mod misc;
mod pollapo_yml;
mod util;

use clap::Command;

#[tokio::main]
async fn main() {
    let matches = Command::new("pollapo")
        .about("protobuf package manager")
        .version("0.0.1")
        .subcommand_required(true)
        .arg_required_else_help(true)
        .subcommand(cmds::add::command())
        .subcommand(cmds::install::command())
        .subcommand(cmds::login::command())
        .subcommand(cmds::remove::command())
        .subcommand(cmds::why::command())
        .get_matches();

    match matches.subcommand() {
        Some(("add", add_matches)) => cmds::add::run(add_matches).await,
        Some(("install", install_matches)) => cmds::install::run(install_matches).await,
        Some(("login", _)) => cmds::login::run().await,
        Some(("remove", remove_matches)) => cmds::remove::run(remove_matches).await,
        Some(("why", why_matches)) => cmds::why::run(why_matches).await,
        _ => unreachable!(),
    }
}
