use clap::{arg, Arg, ArgMatches, Command};

pub fn command() -> Command<'static> {
    Command::new("why")
        .about("Show information about why dependency is installed")
        .arg_required_else_help(true)
        .args(&[
            arg!(<targets> ...),
            Arg::new("depth")
                .short('d')
                .long("depth")
                .default_value("3")
                .help("Maximum depth of dependency tree to display"),
        ])
}

pub async fn run(arg_matches: &ArgMatches) {
    println!("why {:?}", arg_matches);
}
