use clap::Command;
use colored::*;
use dialoguer;
use open;
use std::io::{self, stdout, Write};

use crate::misc::github::{
    auth::{poll_token, request_code},
    get_token, write_token,
};

pub fn command() -> Command<'static> {
    Command::new("login").about("Sign in with Github account")
}

pub async fn run() {
    println!("{}", "Pollapo login".bold());
    println!("");

    match get_token() {
        Some(_) => {
            let confirmed: bool = match dialoguer::Confirm::new()
                .with_prompt(
                    "You're already logged into github.com. Do you want to re-authenticate?",
                )
                .interact()
            {
                Ok(result) => result,
                Err(_) => false,
            };

            if !confirmed {
                return;
            }
        }
        None => {}
    };

    let code = request_code().await.unwrap();
    println!(
        "{} First copy your one-time code: {}",
        "!".yellow(),
        code.user_code.bold()
    );
    print!(
        "{} to open github.com in your borwser... ",
        "Press Enter".bold()
    );
    let _ = stdout().flush();
    io::stdin().read_line(&mut String::new()).unwrap();

    match open::that(&code.verification_uri) {
        Ok(_) => {}
        Err(_) => {
            println!(
                "Failed opening a browser. Please try entering the URL in your browser manually."
            );
            println!("{}", code.verification_uri);
        }
    }

    let access_token = poll_token(&code).await.unwrap();
    write_token(access_token.access_token).unwrap();
    println!("You are all set!");
}
