use clap::{Arg, ArgMatches, Command};

pub fn command() -> Command<'static> {
    Command::new("install")
        .about("Install dependencies")
        .arg_required_else_help(true)
        .args(&[
            Arg::new("clean")
                .short('c')
                .long("clean")
                .help("Don't use cache"),
            Arg::new("outdir")
                .short('o')
                .long("out-dir")
                .help("Out directory"),
            Arg::new("token")
                .short('t')
                .long("token")
                .help("Github OAuth token"),
            Arg::new("config")
                .short('C')
                .long("config")
                .default_value("pollapo.yml")
                .help("Pollapo config"),
        ])
}

pub async fn run(arg_matches: &ArgMatches) {
    println!("install {:?}", arg_matches);
}
