//! Endpoint related types.

mod after;
mod and_then;
mod around;
mod before;
#[allow(clippy::module_inception)]
mod endpoint;
#[cfg(feature = "staticfiles")]
mod files;
mod map_err;
mod map_ok;
mod map_to_response;
mod map_to_result;
#[cfg(feature = "prometheus")]
mod prometheus_exporter;
#[cfg(feature = "tower-compat")]
mod tower_compat;

pub use after::After;
pub use and_then::AndThen;
pub use around::Around;
pub use before::Before;
pub use endpoint::{make, make_sync, BoxEndpoint, Endpoint, EndpointExt, IntoEndpoint};
#[cfg(feature = "staticfiles")]
pub use files::Files;
pub use map_err::MapErr;
pub use map_ok::MapOk;
pub use map_to_response::MapToResponse;
pub use map_to_result::MapToResult;
#[cfg(feature = "prometheus")]
pub use prometheus_exporter::PrometheusExporter;
#[cfg(feature = "tower-compat")]
pub use tower_compat::TowerCompatExt;
