use super::*;

// General {{{
#[tokio::test]
async fn get_currencies() {
	let client = Client::new("Scourge").unwrap();
	let currencies = client.get_currencies().await.unwrap();
	assert!(currencies.len() > 0);
	for currency in currencies {
		println!("{} buy={:?} sell={:?}", currency.name, currency.pay.map(|v| v.value), currency.receive.map(|v| v.value));
	}
}

#[tokio::test]
async fn get_fragments() {
	let client = Client::new("Scourge").unwrap();
	let fragments = client.get_fragments().await.unwrap();
	assert!(fragments.len() > 0);
	for fragment in fragments {
		println!("{} buy={:?} sell={:?}", fragment.name, fragment.pay.map(|v| v.value), fragment.receive.map(|v| v.value));
	}
}

#[tokio::test]
async fn get_divination_cards() {
	let client = Client::new("Scourge").unwrap();
	let divination_cards = client.get_divination_cards().await.unwrap();
	assert!(divination_cards.len() > 0);
	for divination_card in divination_cards {
		println!("{} chaos={} exalted={}", divination_card.name, divination_card.chaos_value, divination_card.exalted_value);
	}
}

#[tokio::test]
async fn get_artifacts() {
	let client = Client::new("Scourge").unwrap();
	let artifacts = client.get_artifacts().await.unwrap();
	assert!(artifacts.len() > 0);
	for artifact in artifacts {
		println!("{} chaos={} exalted={}", artifact.name, artifact.chaos_value, artifact.exalted_value);
	}
}

#[tokio::test]
async fn get_prophecies() {
	let client = Client::new("Scourge").unwrap();
	let prophecies = client.get_prophecies().await.unwrap();
	assert!(prophecies.len() > 0);
	for prophecy in prophecies {
		println!("{} chaos={} exalted={}", prophecy.name, prophecy.chaos_value, prophecy.exalted_value);
	}
}

#[tokio::test]
async fn get_oils() {
	let client = Client::new("Scourge").unwrap();
	let oils = client.get_oils().await.unwrap();
	assert!(oils.len() > 0);
	for oil in oils {
		println!("{} chaos={} exalted={}", oil.name, oil.chaos_value, oil.exalted_value);
	}
}

#[tokio::test]
async fn get_incubators() {
	let client = Client::new("Scourge").unwrap();
	let incubators = client.get_incubators().await.unwrap();
	assert!(incubators.len() > 0);
	for incubator in incubators {
		println!("{} chaos={} exalted={}", incubator.name, incubator.chaos_value, incubator.exalted_value);
	}
}
// }}}

// Equipment & Gems {{{
#[tokio::test]
async fn get_unique_weapons() {
	let client = Client::new("Scourge").unwrap();
	let unique_weapons = client.get_unique_weapons().await.unwrap();
	assert!(unique_weapons.len() > 0);
	for unique_weapon in unique_weapons {
		println!("{} chaos={} exalted={}", unique_weapon.name, unique_weapon.chaos_value, unique_weapon.exalted_value);
	}
}

#[tokio::test]
async fn get_unique_armors() {
	let client = Client::new("Scourge").unwrap();
	let unique_armors = client.get_unique_armors().await.unwrap();
	assert!(unique_armors.len() > 0);
	for unique_armor in unique_armors {
		println!("{} chaos={} exalted={}", unique_armor.name, unique_armor.chaos_value, unique_armor.exalted_value);
	}
}

#[tokio::test]
async fn get_unique_accessories() {
	let client = Client::new("Scourge").unwrap();
	let unique_accessories = client.get_unique_accessories().await.unwrap();
	assert!(unique_accessories.len() > 0);
	for unique_accessory in unique_accessories {
		println!("{} chaos={} exalted={}", unique_accessory.name, unique_accessory.chaos_value, unique_accessory.exalted_value);
	}
}

#[tokio::test]
async fn get_unique_flasks() {
	let client = Client::new("Scourge").unwrap();
	let unique_flasks = client.get_unique_flasks().await.unwrap();
	assert!(unique_flasks.len() > 0);
	for unique_flask in unique_flasks {
		println!("{} chaos={} exalted={}", unique_flask.name, unique_flask.chaos_value, unique_flask.exalted_value);
	}
}

#[tokio::test]
async fn get_unique_jewels() {
	let client = Client::new("Scourge").unwrap();
	let unique_jewels = client.get_unique_jewels().await.unwrap();
	assert!(unique_jewels.len() > 0);
	for unique_jewel in unique_jewels {
		println!("{} chaos={} exalted={}", unique_jewel.name, unique_jewel.chaos_value, unique_jewel.exalted_value);
	}
}

#[tokio::test]
async fn get_skill_gems() {
	let client = Client::new("Scourge").unwrap();
	let skill_gems = client.get_skill_gems().await.unwrap();
	assert!(skill_gems.len() > 0);
	for skill_gem in skill_gems {
		println!("{} chaos={} exalted={}", skill_gem.name, skill_gem.chaos_value, skill_gem.exalted_value);
	}
}

#[tokio::test]
async fn get_cluster_jewels() {
	let client = Client::new("Scourge").unwrap();
	let cluster_jewels = client.get_cluster_jewels().await.unwrap();
	assert!(cluster_jewels.len() > 0);
	for cluster_jewel in cluster_jewels {
		println!("{} chaos={} exalted={}", cluster_jewel.name, cluster_jewel.chaos_value, cluster_jewel.exalted_value);
	}
}
// }}}

// Atlas {{{
#[tokio::test]
async fn get_maps() {
	let client = Client::new("Scourge").unwrap();
	let maps = client.get_maps().await.unwrap();
	assert!(maps.len() > 0);
	for map in maps {
		println!("{} chaos={} exalted={}", map.name, map.chaos_value, map.exalted_value);
	}
}

#[tokio::test]
async fn get_blighted_maps() {
	let client = Client::new("Scourge").unwrap();
	let blighted_maps = client.get_blighted_maps().await.unwrap();
	assert!(blighted_maps.len() > 0);
	for blighted_map in blighted_maps {
		println!("{} chaos={} exalted={}", blighted_map.name, blighted_map.chaos_value, blighted_map.exalted_value);
	}
}

#[tokio::test]
async fn get_unique_maps() {
	let client = Client::new("Scourge").unwrap();
	let unique_maps = client.get_unique_maps().await.unwrap();
	assert!(unique_maps.len() > 0);
	for unique_map in unique_maps {
		println!("{} chaos={} exalted={}", unique_map.name, unique_map.chaos_value, unique_map.exalted_value);
	}
}

#[tokio::test]
async fn get_delirium_orbs() {
	let client = Client::new("Scourge").unwrap();
	let delirium_orbs = client.get_delirium_orbs().await.unwrap();
	assert!(delirium_orbs.len() > 0);
	for delirium_orb in delirium_orbs {
		println!("{} chaos={} exalted={}", delirium_orb.name, delirium_orb.chaos_value, delirium_orb.exalted_value);
	}
}

#[tokio::test]
async fn get_invitations() {
	let client = Client::new("Scourge").unwrap();
	let invitations = client.get_invitations().await.unwrap();
	assert!(invitations.len() > 0);
	for invitation in invitations {
		println!("{} chaos={} exalted={}", invitation.name, invitation.chaos_value, invitation.exalted_value);
	}
}

#[tokio::test]
async fn get_scarabs() {
	let client = Client::new("Scourge").unwrap();
	let scarabs = client.get_scarabs().await.unwrap();
	assert!(scarabs.len() > 0);
	for scarab in scarabs {
		println!("{} chaos={} exalted={}", scarab.name, scarab.chaos_value, scarab.exalted_value);
	}
}

#[tokio::test]
async fn get_watchstones() {
	let client = Client::new("Scourge").unwrap();
	let watchstones = client.get_watchstones().await.unwrap();
	assert!(watchstones.len() > 0);
	for watchstone in watchstones {
		println!("{} chaos={} exalted={}", watchstone.name, watchstone.chaos_value, watchstone.exalted_value);
	}
}
// }}}

// Crafting {{{
#[tokio::test]
async fn get_base_types() {
	let client = Client::new("Scourge").unwrap();
	let base_types = client.get_base_types().await.unwrap();
	assert!(base_types.len() > 0);
	for base_type in base_types {
		println!("{} chaos={} exalted={}", base_type.name, base_type.chaos_value, base_type.exalted_value);
	}
}

#[tokio::test]
async fn get_fossils() {
	let client = Client::new("Scourge").unwrap();
	let fossils = client.get_fossils().await.unwrap();
	assert!(fossils.len() > 0);
	for fossil in fossils {
		println!("{} chaos={} exalted={}", fossil.name, fossil.chaos_value, fossil.exalted_value);
	}
}

#[tokio::test]
async fn get_resonators() {
	let client = Client::new("Scourge").unwrap();
	let resonators = client.get_resonators().await.unwrap();
	assert!(resonators.len() > 0);
	for resonator in resonators {
		println!("{} chaos={} exalted={}", resonator.name, resonator.chaos_value, resonator.exalted_value);
	}
}

#[tokio::test]
async fn get_helmet_enchants() {
	let client = Client::new("Scourge").unwrap();
	let helmet_enchants = client.get_helmet_enchants().await.unwrap();
	assert!(helmet_enchants.len() > 0);
	for helmet_enchant in helmet_enchants {
		println!("{} chaos={} exalted={}", helmet_enchant.name, helmet_enchant.chaos_value, helmet_enchant.exalted_value);
	}
}

#[tokio::test]
async fn get_beasts() {
	let client = Client::new("Scourge").unwrap();
	let beasts = client.get_beasts().await.unwrap();
	assert!(beasts.len() > 0);
	for beast in beasts {
		println!("{} chaos={} exalted={}", beast.name, beast.chaos_value, beast.exalted_value);
	}
}

#[tokio::test]
async fn get_essences() {
	let client = Client::new("Scourge").unwrap();
	let essences = client.get_essences().await.unwrap();
	assert!(essences.len() > 0);
	for essence in essences {
		println!("{} chaos={} exalted={}", essence.name, essence.chaos_value, essence.exalted_value);
	}
}

#[tokio::test]
async fn get_vials() {
	let client = Client::new("Scourge").unwrap();
	let vials = client.get_vials().await.unwrap();
	assert!(vials.len() > 0);
	for vial in vials {
		println!("{} chaos={} exalted={}", vial.name, vial.chaos_value, vial.exalted_value);
	}
}
// }}}

