#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <errno.h>

#include "../pns.h"

void localTests() {
    PnsNet net;
    pnsCreateNet(&net);
    uint32_t pid_tmp = pnsNet_addPlace(&net);
    pnsNet_removePlace(&net, pid_tmp);
    printf("Current place count: %i\n", net.place_count);
    uint32_t pid1 = pnsNet_addPlace(&net);
    uint32_t pid2 = pnsNet_addPlace(&net);
    uint32_t tid = pnsNet_addConnectedTransition(&net, 1, &pid1);
    pnsNet_connectOut(&net, tid, pid2);
    pnsNet_removePlace(&net, pid1);
    pnsNet_removePlace(&net, pid2);
    pnsDestroyNet(&net);
}

int main(int argc, char** argv) {
    localTests();

    PnsNet net;

    struct stat st; 

    if (stat("examples/example.pns", &st) != 0) {
        fprintf(stderr, "Cannot determine size of net file\n");
        exit(EXIT_FAILURE);
    }

    uint32_t size = (st.st_size + 3) / 4;
    uint32_t values[size];

    FILE* loadFile = fopen("examples/example.pns", "rb");
    fread(values, sizeof(uint32_t), size, loadFile);
    
    fclose(loadFile);

    if (!pnsLoadNet(&net, size, values)) {
        fprintf(stderr, "Failed loading of net\n");
        exit(EXIT_FAILURE);
    }

    if (argc >= 2) {
        if (!strncmp(argv[1], "net", 3)) {
            FILE* saveFile = fopen("examples/example.pns", "wb");

            if (!saveFile) {
                printf("Saving failed\n");
                exit(EXIT_FAILURE);
            } else {
                uint32_t count = pnsNet_serializeSize(&net);
                uint32_t elements[count];
                pnsNet_serialize(&net, elements);

                fwrite(elements, sizeof(uint32_t), count, saveFile);

                fclose(saveFile);

                printf("Saving successful\n");
                exit(EXIT_SUCCESS);
            }
        }
    }
    PnsNet net_clone;
    pnsCloneNet(&net_clone, &net);
    pnsDestroyNet(&net);
    net = net_clone;
    PnsState state;
    if (argc >= 2) {
        if (!strncmp(argv[1], "load", 4)) {
            struct stat st; 

            if (stat("examples/example.pns", &st) != 0) {
                fprintf(stderr, "Cannot determine size of state file\n");
                exit(EXIT_FAILURE);
            }

            uint32_t size = (st.st_size + 3) / 4;
            uint32_t values[size];

            FILE *loadFile = fopen("examples/example.pnsl", "rb");
            if (!loadFile) {
                fprintf(stderr, "Opening state file for loading failed\n");
                exit(EXIT_FAILURE);
            }

            fread(values, sizeof(uint32_t), size, loadFile);

            bool result = pnsLoadState(&state, &net, size, values);
            if (!result) {
                fprintf(stderr, "State initialization failed\n");
                exit(EXIT_FAILURE);
            }
        }
    } else {
        pnsCreateState(&state, &net);
    }
    PnsState state_clone;
    pnsCloneState(&state_clone, &state, &net);
    pnsDestroyState(&state);
    state = state_clone;

    size_t MAX_COUNT = 64;
    char names[MAX_COUNT * net.transition_count];

    FILE *file =
        fopen("examples/example.pnk","r");
    for (size_t i = 0; i < net.transition_count; ++i) {
        char* name = &names[i * MAX_COUNT];
        getline(&name, &MAX_COUNT, file);
    }
    fclose(file);

    bool forward = true;

loop: {
        uint32_t count;
        void (*state_transitions) (PnsState* state, uint32_t* count, uint32_t* transitions);
        void (*state_fire) (PnsState* state, const PnsNet* net, uint32_t tid);
        if (forward) {
            state_transitions = pnsState_transitions;
            state_fire = pnsState_fire;
        } else {
            state_transitions = pnsState_transitions_backwards;
            state_fire = pnsState_fire_backwards;
        }
        state_transitions(&state, &count, NULL);
        if (count == 0) goto reverse;
        uint32_t transitions[count];
        state_transitions(&state, &count, transitions);
        printf("Choose a transition:\n");
        for(uint32_t i = 0; i < count; ++i) {
            printf("%u: %s", i + 1, &names[transitions[i] * MAX_COUNT]);
        }
        char num[8];
        char* n = num;
        size_t bytes = 7;
        getline(&n, &bytes, stdin);
        if (*n == 10) goto loop;
        switch (*n) {
        case 'r':
            goto reverse;
        case 'e':
            goto end;
        case 's':
            {
                FILE *saveFile = fopen("examples/example.pnsl", "wb");
                if (!saveFile) {
                    fprintf(stderr, "Opening state file for saving\n");
                    exit(EXIT_FAILURE);
                }

                if (count != fwrite(state.call_counts, sizeof(uint32_t), net.transition_count, saveFile)) {
                    fprintf(stderr, "Saving state failed\n");
                    exit(EXIT_FAILURE);
                }

                fclose(file);
            }

            printf("Saving state successful\n");

            goto loop;
        }
        uint32_t select = atoi(num);
        if (select != 0 && select <= count) {
            state_fire(&state, &net, transitions[select - 1]);
        } else {
            printf("You have to input a valid number from 1 to %u\n", count);
            printf("You can also stop by writing \"e\", reverse by writing \"r\" or save by writing \"s\"\n");
        }
    }
    goto loop;

reverse:
    forward = !forward;
    printf("Reverse play direction!\n");
    goto loop;

end:
    pnsDestroyState(&state);
    pnsDestroyNet(&net);
    return EXIT_SUCCESS;
}

