/// A node of a petri net; stores the indices to the next and previous nodes.
#[derive(Debug)]
#[repr(C)]
pub struct Node {
    /// The count of following nodes of a node.c
    pub next_count: u32,
    next_size: u32,
    pub(crate) next: *mut u32,
    /// The count of preceding nodes of a node.
    pub prev_count: u32,
    prev_size: u32,
    pub(crate) prev: *mut u32,
}

#[repr(C)]
pub struct IndexList {
    pub(crate) index: u32,
    next: *mut IndexList,
}

/// A type representing a petri net. It only stores the initial state, not the state used for simulatoin.
#[derive(Debug)]
#[repr(C)]
pub struct Net {
    /// The count of transitions of the petri net
    pub transition_count: u32,
    transitions_size: u32,
    pub(crate) transitions: *mut Node,
    pub(crate) reusable_transitions: *mut IndexList,
    /// The count of places of the petri net
    pub place_count: u32,
    places_size: u32,
    pub(crate) places: *mut Node,
    pub(crate) initial_token_counts: *mut u32,
    pub(crate) reusable_places: *mut IndexList,
    dirt: *mut IndexList,
    reverse_dirt: *mut IndexList,
}

#[repr(C)]
struct FireChanges {
    count: u32,
    added_count: u32,
    removed_count: u32,
    active: *mut IndexList,
    added: *mut IndexList,
    removed: *mut IndexList,
}

/// The state of the petri net used for simulation.
#[repr(C)]
pub struct State {
    places_size: u32,
    pub(crate) token_counts: *mut u32,
    transitions_size: u32,
    pub(crate) call_counts: *mut u32,
    fire: FireChanges,
    unfire: FireChanges,
}
