use super::types::*;
extern "C" {
    pub(crate) fn pnsCreateNet(net: *mut Net);
    pub(crate) fn pnsCloneNet(net_clone: *mut Net, net: *const Net);
    pub(crate) fn pnsLoadNet(net: *mut Net, filename: *const ::std::os::raw::c_char) -> bool;
    pub(crate) fn pnsDestroyNet(net: *mut Net);
    pub(crate) fn pnsNet_save(net: *const Net, filename: *const ::std::os::raw::c_char) -> bool;

    pub(crate) fn pnsNet_addPlace(net: *mut Net) -> u32;
    pub(crate) fn pnsNet_addTransition(net: *mut Net) -> u32;
    pub(crate) fn pnsNet_addConnectedTransition(
        net: *mut Net,
        place_count: u32,
        place: *const u32,
    ) -> u32;

    pub(crate) fn pnsNet_removePlace(net: *mut Net, pid: u32);
    pub(crate) fn pnsNet_removeTransition_unsafe(net: *mut Net, tid: u32);

    pub(crate) fn pnsNet_connectIn_unsafe(net: *mut Net, tid: u32, pid: u32) -> bool;
    pub(crate) fn pnsNet_connectOut(net: *mut Net, tid: u32, pid: u32) -> bool;
    pub(crate) fn pnsNet_disconnectIn(net: *mut Net, tid: u32, pid: u32);
    pub(crate) fn pnsNet_disconnectOut_unsafe(net: *mut Net, tid: u32, pid: u32);

    pub(crate) fn pnsNet_duplicateTransition(net: *mut Net, tid: u32) -> u32;
    pub(crate) fn pnsNet_duplicatePlace(net: *mut Net, pid: u32) -> u32;
    pub(crate) fn pnsNet_start(net: *mut Net, pid: u32, count: u32) -> u32;

    pub(crate) fn pnsNet_clearEdits(net: *mut Net);

    pub(crate) fn pnsCreateState(state: *mut State, net: *const Net);
    pub(crate) fn pnsCloneState(state_clone: *mut State, state: *const State, net: *const Net);
    pub(crate) fn pnsLoadState(
        state: *mut State,
        net: *const Net,
        filename: *const ::std::os::raw::c_char,
    ) -> bool;
    pub(crate) fn pnsDestroyState(state: *mut State);
    pub(crate) fn pnsState_save(
        state: *const State,
        net: *const Net,
        filename: *const ::std::os::raw::c_char,
    ) -> bool;

    pub(crate) fn pnsState_transitions(state: *mut State, count: *mut u32, transitions: *mut u32);
    pub(crate) fn pnsState_transitions_backwards(
        state: *mut State,
        count: *mut u32,
        transitions: *mut u32,
    );
    pub(crate) fn pnsState_addedTransitions(
        state: *mut State,
        count: *mut u32,
        transitions: *mut u32,
    );
    pub(crate) fn pnsState_addedTransitions_backwards(
        state: *mut State,
        count: *mut u32,
        transitions: *mut u32,
    );
    pub(crate) fn pnsState_removedTransitions(
        state: *mut State,
        count: *mut u32,
        transitions: *mut u32,
    );
    pub(crate) fn pnsState_removedTransitions_backwards(
        state: *mut State,
        count: *mut u32,
        transitions: *mut u32,
    );
    pub(crate) fn pnsState_cleanChanges(state: *mut State);
    pub(crate) fn pnsState_cleanChanges_backwards(state: *mut State);

    pub(crate) fn pnsState_fire(state: *mut State, net: *const Net, tid: u32);
    pub(crate) fn pnsState_fire_backwards(state: *mut State, net: *const Net, tid: u32);

    pub(crate) fn pnsState_updateEdits(state: *mut State, net: *const Net);
}
