mod input;
mod renderer;

use femtovg::{renderer::OpenGl, Canvas};
use glutin::ContextBuilder;
use pn_editor_core::Editor;
use resource::resource;
use winit::{event_loop::EventLoop, window::WindowBuilder};

use input::InputContext;
use renderer::NetRenderer;

fn main() {
    let w = 16 * 80;
    let h = 9 * 80;
    let mut args = std::env::args();
    args.next();

    let mut editor = Editor::new(w, h, Default::default());
    if let Some(arg) = args.next() {
        editor.load_net(arg);
    }

    let event_loop = EventLoop::new();

    let (renderer, windowed_context) = {
        let window_builder = WindowBuilder::new()
            .with_inner_size(winit::dpi::PhysicalSize::new(w, h))
            .with_title("Petri Netidor");

        let windowed_context = ContextBuilder::new()
            .with_vsync(false)
            .build_windowed(window_builder, &event_loop)
            .unwrap();
        let windowed_context = unsafe { windowed_context.make_current().unwrap() };

        let renderer = OpenGl::new(|s| windowed_context.get_proc_address(s) as *const _)
            .expect("Cannot create renderer");

        (renderer, windowed_context)
    };

    let mut canvas = Canvas::new(renderer).expect("Cannot create canvas");

    let font = canvas
        .add_font_mem(&resource!("resources/FreeMono.ttf"))
        .expect("Cannot add font");

    gapp_winit::run(
        editor,
        event_loop,
        60,
        windowed_context,
        InputContext::new(),
        NetRenderer::new(canvas, font),
    );
}
