use pns::State;
use rfd::FileDialog;

pub struct StateInfo {
    pub state_path: Option<String>,
    pub changes: bool,
    pub callables: Vec<(bool, bool)>,
}

impl StateInfo {
    pub fn update_state(&mut self, state: &mut State) {
        for added in state.added_transitions().iter() {
            self.callables[*added as usize].0 = true;
        }
        for removed in state.removed_transitions().iter() {
            self.callables[*removed as usize].0 = false;
        }
        for added in state.added_transitions_backwards().iter() {
            self.callables[*added as usize].1 = true;
        }
        for removed in state.removed_transitions_backwards().iter() {
            self.callables[*removed as usize].1 = false;
        }
    }

    pub fn file_dialog(&self) -> FileDialog {
        let dialog = FileDialog::new().add_filter("Petri net interactive files", &["pni"]);

        if let Some(path) = &self.state_path {
            dialog.set_directory(path)
        } else {
            dialog
        }
    }
}
