/// Settings for the sizes of the nodes.
pub struct NodeSettings {
    /// The radius used for drawing places.
    pub radius: f32,
    /// The width used for drawing transitions.
    pub width: f32,
    /// The height used for drawing transitions.
    pub height: f32,
}

impl Default for NodeSettings {
    fn default() -> Self {
        Self {
            radius: 16.0,
            height: 32.0,
            width: 128.0,
        }
    }
}
