use nalgebra::Vector2;
use text_editing::TextLine;

pub struct Node {
    pub positions: Vec<Vector2<f32>>,
    pub name: TextLine,
    pub name_cursor: usize,
    pub content: Vec<TextLine>,
    pub content_line: usize,
    pub content_cursor: usize,
    pub content_offset: usize,
}

impl Node {
    pub fn new(positions: &[Vector2<f32>], name: String) -> Node {
        let name_cursor = name.len();
        Node {
            positions: positions.iter().cloned().collect::<Vec<_>>(),
            name: TextLine::from_string(name.chars().collect()),
            name_cursor,
            content: vec![TextLine::new()],
            content_line: 0,
            content_cursor: 0,
            content_offset: 0,
        }
    }
}
