use serde_json::{json,Value};

pub struct Api {
    token: String
}

type DefaultReturn = Result<Value, Box<dyn std::error::Error>>;


impl Api {
    pub fn new(token: String) -> Self {
        Api{token}
    }
    pub fn hisse_ver(self,sembol: &str) -> DefaultReturn {
        let istek = istek_at(&self.token, "hisse", sembol)?;
        if istek["code"] == json!(200) {
            Ok(istek["data"].clone())
        } else {
            Ok(return_err(&self.token, istek))
        }
    }
    pub fn hisse_sepet(self) -> DefaultReturn {
        let istek = istek_at(&self.token, "hisse/sepet", "")?;
        if istek["code"] == json!(200) {
            Ok(istek["data"].clone())
        } else {
            Ok(return_err(&self.token, istek))
        }
    }
    pub fn kripto_ver(self,sembol: &str) -> DefaultReturn {
        let istek = istek_at(&self.token, "kripto", sembol)?;
        if istek["code"] == json!(200) {
            Ok(istek["data"].clone())
        } else {
            Ok(return_err(&self.token, istek))
        }
    }
    pub fn kripto_haber(self) -> DefaultReturn {
        let istek = istek_at(&self.token, "kripto/haber", "")?;
        if istek["code"] == json!(200) {
            Ok(istek["data"].clone())
        } else {
            Ok(return_err(&self.token, istek))
        }
    }
    pub fn kripto_sepet(self) -> DefaultReturn {
        let istek = istek_at(&self.token, "kripto/sepet", "")?;
        if istek["code"] == json!(200) {
            Ok(istek["data"].clone())
        } else {
            Ok(return_err(&self.token, istek))
        }
    }
}



fn istek_at(token: &String,endpoint: &str,sembol: &str) -> DefaultReturn {
    let url;
    if sembol.is_empty() {
        url = format!("https://plusapi.org/api/{}?token={}",endpoint,token);
    } else {
        url = format!("https://plusapi.org/api/{}?token={}&sembol={}",endpoint,token,sembol.to_uppercase());
    }
    let client = reqwest::blocking::Client::new();
    let resp = client.get(url)
        .header("Content-Type","application/x-www-form-urlencoded")
        .header("User-Agent","Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.86 Safari/537.36")
        .send()?
        .json::<Value>()?;
    Ok(resp)
}


fn return_err(token: &String, resp: Value) -> Value {
    let hata = format!(r#"{{"token": {}, "hata": {}}}"#,token,resp["text"].to_string().as_str());
    let ret = json!(hata);
    ret
}