/// Irregular rules
pub(crate) const IRREGULAR_RULES: &'static [[&str; 2]] = &[
    // Pronouns.
    ["I", "we"],
    ["me", "us"],
    ["he", "they"],
    ["she", "they"],
    ["them", "them"],
    ["myself", "ourselves"],
    ["yourself", "yourselves"],
    ["itself", "themselves"],
    ["herself", "themselves"],
    ["himself", "themselves"],
    ["themself", "themselves"],
    ["is", "are"],
    ["was", "were"],
    ["has", "have"],
    ["this", "these"],
    ["that", "those"],
    ["my", "our"],
    ["its", "their"],
    ["his", "their"],
    ["her", "their"],
    // Words ending in with a consonant and `o`.
    ["echo", "echoes"],
    ["dingo", "dingoes"],
    ["volcano", "volcanoes"],
    ["tornado", "tornadoes"],
    ["torpedo", "torpedoes"],
    // Ends with `us`.
    ["genus", "genera"],
    ["viscus", "viscera"],
    // Ends with `ma`.
    ["stigma", "stigmata"],
    ["stoma", "stomata"],
    ["dogma", "dogmata"],
    ["lemma", "lemmata"],
    ["schema", "schemata"],
    ["anathema", "anathemata"],
    // Other irregular rules.
    ["ox", "oxen"],
    ["axe", "axes"],
    ["die", "dice"],
    ["yes", "yeses"],
    ["foot", "feet"],
    ["eave", "eaves"],
    ["goose", "geese"],
    ["tooth", "teeth"],
    ["quiz", "quizzes"],
    ["human", "humans"],
    ["proof", "proofs"],
    ["carve", "carves"],
    ["valve", "valves"],
    ["looey", "looies"],
    ["thief", "thieves"],
    ["groove", "grooves"],
    ["pickaxe", "pickaxes"],
    ["passerby", "passersby"],
    ["canvas", "canvases"],
];

/// Pluralization rules
pub(crate) const PLURAL_RULES: &'static [[&str; 2]] = &[
    [r"(?i)s?$", "s"],
    [r"(?i)[^\u0000-\u007F]$", "$0"],
    [r"(?i)([^aeiou]ese)$", "$1"],
    [r"(?i)(ax|test)is$", "$1es"],
    [r"(?i)(alias|[^aou]us|t[lm]as|gas|ris)$", "$1es"],
    [r"(?i)(e[mn]u)s?$", "$1s"],
    [r"(?i)([^l]ias|[aeiou]las|[ejzr]as|[iu]am)$", "$1"],
    [r"(?i)(alumn|syllab|vir|radi|nucle|fung|cact|stimul|termin|bacill|foc|uter|loc|strat)(?:us|i)$", "$1i"],
    [r"(?i)(alumn|alg|vertebr)(?:a|ae)$", "$1ae"],
    [r"(?i)(seraph|cherub)(?:im)?$", "$1im"],
    [r"(?i)(her|at|gr)o$", "$1oes"],
    [r"(?i)(agend|addend|millenni|dat|extrem|bacteri|desiderat|strat|candelabr|errat|ov|symposi|curricul|automat|quor)(?:a|um)$", "$1a"],
    [r"(?i)(apheli|hyperbat|periheli|asyndet|noumen|phenomen|criteri|organ|prolegomen|hedr|automat)(?:a|on)$", "$1a"],
    [r"(?i)sis$", "ses"],
    [r"(?i)(?:(kni|wi|li)fe|(ar|l|ea|eo|oa|hoo)f)$", "$1$2ves"],
    [r"(?i)([^aeiouy]|qu)y$", "$1ies"],
    [r"(?i)([^ch][ieo][ln])ey$", "$1ies"],
    [r"(?i)(x|ch|ss|sh|zz)$", "$1es"],
    [r"(?i)(matr|cod|mur|sil|vert|ind|append)(?:ix|ex)$", "$1ices"],
    [r"(?i)\b((?:tit)?m|l)(?:ice|ouse)$", "$1ice"],
    [r"(?i)(pe)(?:rson|ople)$", "$1ople"],
    [r"(?i)(child)(?:ren)?$", "$1ren"],
    [r"(?i)eaux$", "$0"],
    [r"(?i)m[ae]n$", "men"],
    [r"(?i)^thou$", "you"],
];

/// Singularization rules
pub(crate) const SINGULAR_RULES: &'static [[&str; 2]] = &[
    ["(?i)s$", ""],
    ["(?i)(ss)$", "$1"],
    ["(?i)(wi|kni|(?:after|half|high|low|mid|non|night|[^\\w]|^)li)ves$", "$1fe"],
    ["(?i)(ar|(?:wo|[ae])l|[eo][ao])ves$", "$1f"],
    ["(?i)ies$", "y"],
    ["(?i)(dg|ss|ois|lk|ok|wn|mb|th|ch|ec|oal|is|ck|ix|sser|ts|wb)ies$", "$1ie"],
    ["(?i)\\b(l|(?:neck|cross|hog|aun)?t|coll|faer|food|gen|goon|group|hipp|junk|vegg|(?:pork)?p|charl|calor|cut)ies$", "$1ie"],
    ["(?i)\\b(mon|smil)ies$", "$1ey"],
    ["(?i)\\b((?:tit)?m|l)ice$", "$1ouse"],
    ["(?i)(seraph|cherub)im$", "$1"],
    ["(?i)(x|ch|ss|sh|zz|tto|go|cho|alias|[^aou]us|t[lm]as|gas|(?:her|at|gr)o|[aeiou]ris)(?:es)?$", "$1"],
    ["(?i)(analy|diagno|parenthe|progno|synop|the|empha|cri|ne)(?:sis|ses)$", "$1sis"],
    ["(?i)(movie|twelve|abuse|e[mn]u)s$", "$1"],
    ["(?i)(test)(?:is|es)$", "$1is"],
    ["(?i)(alumn|syllab|vir|radi|nucle|fung|cact|stimul|termin|bacill|foc|uter|loc|strat)(?:us|i)$", "$1us"],
    ["(?i)(agend|addend|millenni|dat|extrem|bacteri|desiderat|strat|candelabr|errat|ov|symposi|curricul|quor)a$", "$1um"],
    ["(?i)(apheli|hyperbat|periheli|asyndet|noumen|phenomen|criteri|organ|prolegomen|hedr|automat)a$", "$1on"],
    ["(?i)(alumn|alg|vertebr)ae$", "$1a"],
    ["(?i)(cod|mur|sil|vert|ind)ices$", "$1ex"],
    ["(?i)(matr|append)ices$", "$1ix"],
    ["(?i)(pe)(rson|ople)$", "$1rson"],
    ["(?i)(child)ren$", "$1"],
    ["(?i)(eau)x?$", "$1"],
    ["(?i)men$", "man"]
];

pub(crate) const UNCOUNTABLE_RULES: &'static [&str] = &[
    // Singular words with no plurals.
    "adulthood",
    "advice",
    "agenda",
    "aid",
    "aircraft",
    "alcohol",
    "ammo",
    "analytics",
    "anime",
    "athletics",
    "audio",
    "bison",
    "blood",
    "bream",
    "buffalo",
    "butter",
    "carp",
    "cash",
    "chassis",
    "chess",
    "clothing",
    "cod",
    "commerce",
    "cooperation",
    "corps",
    "debris",
    "diabetes",
    "digestion",
    "elk",
    "energy",
    "equipment",
    "excretion",
    "expertise",
    "firmware",
    "flounder",
    "fun",
    "gallows",
    "garbage",
    "graffiti",
    "hardware",
    "headquarters",
    "health",
    "herpes",
    "highjinks",
    "homework",
    "housework",
    "information",
    "jeans",
    "justice",
    "kudos",
    "labour",
    "literature",
    "machinery",
    "mackerel",
    "mail",
    "media",
    "mews",
    "moose",
    "music",
    "mud",
    "manga",
    "news",
    "only",
    "personnel",
    "pike",
    "plankton",
    "pliers",
    "police",
    "pollution",
    "premises",
    "rain",
    "research",
    "rice",
    "salmon",
    "scissors",
    "series",
    "sewage",
    "shambles",
    "shrimp",
    "software",
    "staff",
    "swine",
    "tennis",
    "traffic",
    "transportation",
    "trout",
    "tuna",
    "wealth",
    "welfare",
    "whiting",
    "wildebeest",
    "wildlife",
    "you",
    "(?i)pok[eé]mon$",
    // Regexes.
    "(?i)[^aeiou]ese$", // "chinese", "japanese"
    "(?i)deer$",        // "deer", "reindeer"
    "(?i)fish$",        // "fish", "blowfish", "angelfish"
    "(?i)measles$",
    "(?i)o[iu]s$", // "carnivorous"
    "(?i)pox$",    // "chickpox", "smallpox"
    "(?i)sheep$",
];
