# Changelog

All notable changes to this project will be documented in this file with the power of `git-cliff` changelog generation.

## [0.1.3] - 2022-04-28

### Bug Fixes

- Git cliff tag matching now locates existing tags

## [0.1.2] - 2022-04-28

### Bug Fixes

- Set cargo metadata categories

## [0.1.0] - 2022-04-28

### Bug Fixes

- Fixed axis scales to accurately mark data points
- Legend element now laign correctly
- More reliably calculate the pixels making up the circle symbol
- Recalculate legend position and how it occupies space on the canvas
- X-axis scale markers now sit outside the axis in whitespace when negative y range is dominant
- Reposition y axis scale markers to avoid graph overlap and make use of free whitespace
- Axis scale text no longer overlays where negative and positive axes meet

### Documentation

- Added module documentation where it was lacking
- Main crate docs

### Features

- Big bang
- Added pipelines
- Added second example to test large canvas sizes with graph positioning
- New ron scatter data structure
- Font size is dynamically calculated based on canvas size
- Read and parse csv from DataSets into data points
- Split canvas.rs into multiple sub-modules
- Plots cross symbols onto canvas
- Ron config sets axis resolution for drawing data labels along the scale
- Ron config sets axis resolution for drawing data labels along the scale
- Positions of all graph elements are trul dynamic and determined from canvas size
- Added legend
- Added error bar plotting
- Added multidata example extracting sets from different files
- Added square symbol
- Added triangle symbol
- Added mini-markers to sit between axis scales. The number of mini-markers is auto generated based on the amount of pixel space available between the main scale markers
- Added linear best fit plotting
- Added quadratic, cubic, exponential, sinusoidal and cosinusoial best fit curves
- Added Generic Polynomial best fit line
- Added example for each best fit curve type
- Prototype generating relevant quadrants to build based on x-y ranges in csv data
- All quadrants drawn in various combinations
- Added gaussian distribution best fit type
- Support for negative axes

### Miscellaneous Tasks

- Workflow runs examples with trace logging

### Refactor

- Split axes functions into modules for easier readability
- Reduced number of match arms for finding label positions as some quadrants make use of the same positions
- Make clippy happy

<!-- generated by git-cliff -->
