// The code in `set_equal_axes` is based on:
// https://stackoverflow.com/questions/13685386/matplotlib-equal-unit-length-with-equal-aspect-ratio-z-axis-is-not-equal-to
//
// It needs Matplotlib version at least 3.3.0 (Jul 16, 2020)
// https://github.com/matplotlib/matplotlib/blob/f6e0ee49c598f59c6e6cf4eefe473e4dc634a58a/doc/users/prev_whats_new/whats_new_3.3.0.rst

pub const PYTHON_HEADER: &str = "### file generated by plotpy
import numpy as np
import matplotlib.pyplot as plt
import matplotlib.ticker as tck
import matplotlib.patches as pat
import matplotlib.path as pth
import matplotlib.patheffects as pff
import matplotlib.lines as lns
import matplotlib.transforms as tra
import mpl_toolkits.mplot3d as m3d
NaN = np.NaN
EXTRA_ARTISTS = []
def addToEA(obj):
    if obj!=None: EXTRA_ARTISTS.append(obj)
COLORMAPS = [plt.cm.bwr, plt.cm.RdBu, plt.cm.hsv, plt.cm.jet, plt.cm.terrain, plt.cm.pink, plt.cm.Greys]
def getColormap(idx): return COLORMAPS[idx % len(COLORMAPS)]
AX3D = None
def maybeCreateAX3D():
    global AX3D
    if AX3D == None:
        AX3D = plt.gcf().add_subplot(111, projection='3d')
        AX3D.set_xlabel('x')
        AX3D.set_ylabel('y')
        AX3D.set_zlabel('z')
        addToEA(AX3D)
def dataToAxis(coords):
    plt.axis() # must call this first
    return plt.gca().transLimits.transform(coords)
def axisToData(coords):
    plt.axis() # must call this first
    return plt.gca().transLimits.inverted().transform(coords)
def set_equal_axes():
    ax = plt.gca()
    if AX3D == None:
        ax.axes.set_aspect('equal')
        return
    try:
        ax.set_box_aspect([1,1,1])
        limits = np.array([ax.get_xlim3d(), ax.get_ylim3d(), ax.get_zlim3d()])
        origin = np.mean(limits, axis=1)
        radius = 0.5 * np.max(np.abs(limits[:, 1] - limits[:, 0]))
        x, y, z = origin
        ax.set_xlim3d([x - radius, x + radius])
        ax.set_ylim3d([y - radius, y + radius])
        ax.set_zlim3d([z - radius, z + radius])
    except:
        import matplotlib
        print('VERSION of MATPLOTLIB = {}'.format(matplotlib.__version__))
        print('ERROR: set_box_aspect is missing in this version of Matplotlib')
";

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#[cfg(test)]
mod tests {
    use super::PYTHON_HEADER;

    #[test]
    fn constants_are_correct() {
        assert_eq!(PYTHON_HEADER.len(), 1757);
    }
}
