pub const PYTHON_HEADER: &str = "### file generated by plotpy
import numpy as np
import matplotlib.pyplot as plt
import matplotlib.ticker as tck
import matplotlib.patches as pat
import matplotlib.path as pth
import matplotlib.patheffects as pff
import matplotlib.lines as lns
import matplotlib.transforms as tra
import mpl_toolkits.mplot3d as m3d
NaN = np.NaN
EXTRA_ARTISTS = []
def addToEA(obj):
    if obj!=None: EXTRA_ARTISTS.append(obj)
COLORMAPS = [plt.cm.bwr, plt.cm.RdBu, plt.cm.hsv, plt.cm.jet, plt.cm.terrain, plt.cm.pink, plt.cm.Greys]
def getColormap(idx): return COLORMAPS[idx % len(COLORMAPS)]
AX3D = None
def maybeCreateAX3D():
    global AX3D
    if AX3D == None:
        AX3D = plt.gcf().add_subplot(111, projection='3d')
        AX3D.set_xlabel('x')
        AX3D.set_ylabel('y')
        AX3D.set_zlabel('z')
        addToEA(AX3D)
def setEqualAspect():
    x,y=(plt.gca().get_xscale(),plt.gca().get_yscale())
    if (x=='linear' and y=='linear') or (x=='log' and y=='log'):
        plt.gca().axes.set_aspect('equal')
def dataToAxis(coords):
    plt.axis() # must call this first
    return plt.gca().transLimits.transform(coords)
def axisToData(coords):
    plt.axis() # must call this first
    return plt.gca().transLimits.inverted().transform(coords)

";

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#[cfg(test)]
mod tests {
    use super::PYTHON_HEADER;

    #[test]
    fn constants_are_correct() {
        assert_eq!(PYTHON_HEADER.len(), 1238);
    }
}
