pub const ERROR_LOG: &str = "Can't log to stderr";

#[allow(clippy::ptr_arg)]
// Impossible to use `&mut str`.
// Function `String::push_str` is needed when `datetime` feature is enabled
pub fn datetime(_input: &mut String) {
    #[cfg(any(feature = "date", feature = "time"))]
    {
        use chrono::Local;

        let formatter = match (cfg!(feature = "date"), cfg!(feature = "time")) {
            (true, true) => " on %Y-%m-%d %H:%M:%S",
            (true, false) => " on %Y-%m-%d",
            (false, true) => " on %H:%M:%S",
            (_, _) => "",
        };

        let datetime = Local::now().format(formatter);
        _input.push_str(&datetime.to_string());
    }
}

#[macro_export]
macro_rules! context {
    ($input:tt) => {
        #[cfg(feature = "context")]
        {
            $input.push_str(&format!(" at {}:{}", file!(), line!()))
        }
    };
}

#[macro_export]
macro_rules! core_log {
    ($color:tt, $prefix:tt, $($args:tt)+) => {{
        let mut prefix = String::from($prefix);
        plog::macros::datetime(&mut prefix);
        plog::context!(prefix);
        plog::log(#[cfg(feature = "colored")] crossterm::style::Color::$color, &prefix, format!($($args)+))
            .expect(plog::macros::ERROR_LOG)
    }}
}

#[macro_export]
macro_rules! debug {
    ($($args:tt)+) => {{
        plog::core_log!(Grey, "DEBG", $($args)+)
    }}
}

#[macro_export]
macro_rules! info {
    ($($args:tt)+) => {{
        plog::core_log!(White, "INFO", $($args)+)
    }}
}

#[macro_export]
macro_rules! warn {
    ($($args:tt)+) => {{
        plog::core_log!(Yellow, "WARN", $($args)+)
    }}
}

#[macro_export]
macro_rules! error {
    ($($args:tt)+) => {{
        plog::core_log!(Red, "ERRO", $($args)+)
    }}
}

#[macro_export]
macro_rules! ok {
    ($($args:tt)+) => {
        plog::core_log!(Green, "OKAY", $($args)+)
    }
}
