xflags::xflags! {
    src "./src/flags.rs"

    cmd plex-cli {
        default cmd help {
            /// Print help information.
            optional -h, --help
        }

        cmd wait {
            /// Delay between attempts
            optional -d, --delay seconds: u32

            /// Server URL, e.g. http://192.168.1.1:32400. Default is http://127.0.0.1:32400.
            optional -s, --server url: String

            /// Authentication token, if needed. Mandatory for the claimed server.
            optional -t, --token token: String

            /// How long to wait for the success.
            optional --timeout seconds: u32
        }
    }
}

// generated start
// The following code is generated by `xflags` macro.
// Run `env UPDATE_XFLAGS=1 cargo build` to regenerate.
#[derive(Debug)]
pub struct PlexCli {
    pub subcommand: PlexCliCmd,
}

#[derive(Debug)]
pub enum PlexCliCmd {
    Help(Help),
    Wait(Wait),
}

#[derive(Debug)]
pub struct Help {
    pub help: bool,
}

#[derive(Debug)]
pub struct Wait {
    pub delay: Option<u32>,
    pub server: Option<String>,
    pub token: Option<String>,
    pub timeout: Option<u32>,
}

impl PlexCli {
    pub const HELP: &'static str = Self::HELP_;

    #[allow(dead_code)]
    pub fn from_env() -> xflags::Result<Self> {
        Self::from_env_()
    }

    #[allow(dead_code)]
    pub fn from_vec(args: Vec<std::ffi::OsString>) -> xflags::Result<Self> {
        Self::from_vec_(args)
    }
}
// generated end

impl Help {
    pub(crate) fn run(self) -> anyhow::Result<()> {
        println!("{}", PlexCli::HELP);
        Ok(())
    }
}
