use crate::types;
use cfg_if::cfg_if;

cfg_if! {
  if #[cfg(target_os = "windows")] {
    pub const OS: types::OS = types::OS::Windows;
  } else if #[cfg(target_os = "macos")] {
    pub const OS: types::OS = types::OS::MacOS;
  } else {
    pub const OS: types::OS = types::OS::Linux;
  }
}

cfg_if! {
  if #[cfg(target_arch = "x86_64")] {
    pub const ARCH: types::Arch = types::Arch::X64;
  } else if #[cfg(target_arch = "aarch64")] {
    pub const ARCH: types::Arch = types::Arch::Arm64;
  }else if #[cfg(target_arch = "arm")] {
    pub const ARCH: types::Arch = types::Arch::Arm;
  } else {
    pub const ARCH: types::Arch = types::Arch::Unsupported;
  }
}

cfg_if! {
  if #[cfg(target_os = "windows")] {
    pub const BINARY_TYPE: types::BinaryType = types::BinaryType::Windows;
  } else if #[cfg(target_os = "macos")] {
    pub const BINARY_TYPE: types::BinaryType = types::BinaryType::MacOS;
  } else if #[cfg(any(
    target_os = "linux",
    target_os = "freebsd",
    target_os = "dragonfly",
    target_os = "openbsd",
    target_os = "netbsd"
  ))] {
    cfg_if! {
      if #[cfg(target_arch = "aarch64")] {
        pub const BINARY_TYPE: types::BinaryType = types::BinaryType::Arm64;
      } else if #[cfg(target_arch = "arm")] {
        pub const BINARY_TYPE: types::BinaryType = types::BinaryType::Arm;
      } else if #[cfg(target_arch = "x86_64")] {
        pub const BINARY_TYPE: types::BinaryType = types::BinaryType::Linux;
      } else {
        pub const BINARY_TYPE: types::BinaryType = types::BinaryType::Unsupported;
      }
    }
  }
}

pub const VERSION: &str = "0.4.7";
