use crate::*;
use std::fs::OpenOptions;
use std::io::Read;
use std::io::Write;
use std::net::TcpListener;
use std::thread::sleep;
use std::thread::Builder;
use std::time::Duration;
use std::time::Instant;

#[test]
fn start() {
  Builder::new().name(String::from("Test Web Server")).spawn(|| {
    let listener = TcpListener::bind("127.0.0.1:4567");

    if listener.is_err() {
      return;
    }

    let response = "HTTP/1.1 200 OK\r\nContent-Length: 72\r\n\r\n<h1>It Works!</h1><br/><p>If You're Reading This, Then PlayIt Works!</p>".as_bytes();

    for stream in listener.unwrap().incoming() {
      let mut stream = stream.unwrap();

      stream.write(response).ok();
      stream.flush().ok();
    }
  }).ok();
  let mut playit = PlayIt::new(None).unwrap();

  let tunnel = playit.create_tunnel(4567, Prototype::Tcp, None);

  let time = Instant::now();
  print!("\n\n");
  println!("Architexture: {:#?}", playit.arch);
  println!("Operating System: {:#?}", playit.os);
  println!(
    "PlayIt Tunnel: http://{}",
    tunnel.connect_address.as_ref().unwrap()
  );
  println!("PlayIt Config File: {}", playit.config_file.display());
  println!("PlayIt Binary: {}", playit.binary.display());
  println!("PlayIt Version: {}", playit.version);
  println!("PlayIt Agent Key: {}", playit.agent_key);
  println!("PlayIt Server: {}", playit.server);
  println!("PlayIt Output: \n{}\n", {
    let mut command_stderr = [0; 5000];
    let mut command_stdout = [0; 5000];

    playit
      .playit
      .stderr
      .as_mut()
      .unwrap()
      .read(&mut command_stderr)
      .ok();

    playit
      .playit
      .stdout
      .as_mut()
      .unwrap()
      .read(&mut command_stdout)
      .ok();

    String::from_utf8_lossy(&[command_stdout, command_stderr].concat())
  });

  loop {
    let res = playit
      .req_client
      .get(format!(
        "http://{}",
        tunnel.connect_address.as_ref().unwrap()
      ))
      .send();

    if res.is_ok() && res.unwrap().text().unwrap().contains("It Works!") {
      let elapsed = format!("{:.2}", time.elapsed().as_secs_f32());
      println!("Tunnel Is Active In {} Seconds!", elapsed);
      OpenOptions::new()
        .create(true)
        .append(true)
        .open(playit.dir.join("activation-times.txt"))
        .unwrap()
        .write(&(elapsed + "\n").into_bytes())
        .ok();
      break;
    }
  }

  sleep(Duration::from_secs(30));
}
